/*  Saper Game.
    Copyright (C) 2007 - Pawel Bednarek
    <bednarek.pawel@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/> 
 */
package saper;

import java.util.Random;


/**
 * Klasa pomocnicza
 */
class SaperUtils {
    
    /**
     * Testuje czy pole minowe ma prawidlowy rozmiar, czy punkt x,y znajduje
     * sie na nim, zwraca dwuwymiarowa tablice int[] z szerokoscia i wysokoscia pola 
     * @param mineField
     * @param x
     * @param y
     * @return
     */
    private static final int[] testMineField(int[][] mineField, int x, int y){
        int width = mineField.length;
        if(width == 0) throw new IllegalArgumentException("Illegal size of mine field");
        int height = mineField[0].length;
        if(height == 0) throw new IllegalArgumentException("Illegal size of mine field");
        
        if(x < 0 || y < 0 || x >= width || y >= height) throw new IllegalArgumentException("The point is not on the mine field");

        return new int[]{width,height};
    }
    
    /**
     * Metoda tworzaca pole minowe.
     * @param width
     * @param height
     * @param countMines
     * @return
     */
    public static final int[][] generateManeField(int width, int height, int countMines){
        if(width <=0 || height <= 0 || width * height <= countMines || countMines <= 0)
            throw new IllegalArgumentException("Illegal parameters to create mine field!");

        int[][] mineField = new int[width][height];
        
        // ulozenie min na polu minowym
        Random random = new Random();
        for(int i = 0; i < countMines; i++){
            while(true){
	            int x = random.nextInt(width);
	            int y = random.nextInt(height);
	            if(mineField[x][y] != SaperGame.MINE){ // sprawdzamy, czy juz na tym miejscu nie ma miny
	                mineField[x][y] = SaperGame.MINE;
	                break; // while
	            }
            }
        }
        
        // sprawdzenie sasiednich pol
        describeFieldsAtMineField(mineField);
        
        return mineField;
    }
    
    /**
     * Metoda obliczajaca ilosc min na polach sasiadujacych, tak, aby nie trzeba bylo tego
     * obliczac za kazdym razem w czasie gry.
     * @param mineField
     */
    private static void describeFieldsAtMineField(int[][] mineField){
        for (int x = 0; x < mineField.length; x++) {
            for (int y = 0; y < mineField[x].length; y++) {
                mineField[x][y] = count(x,y,mineField);
            }
        }
    }
    /**
     * Oblicza ile jest pol z minami dookola zasdanego pola 
     * @param x
     * @param y
     * @param mineField
     * @return
     */
    private static final int count(int x, int y, int[][] mineField){

        int[] wh = testMineField(mineField,x,y);
        int width = wh[0];
        int height = wh[1];
        
        if(mineField[x][y] == SaperGame.MINE) return SaperGame.MINE;
        
        int count = 0;
        for(int i = x - 1; i <= x + 1; i++){
            if(i < 0 || i == width) continue; // jesli poza polem minowym
            for(int j = y - 1; j <= y + 1; j++){
                if(j < 0 || j == height) continue; // jesli poza polem minowym
                if(mineField[i][j] == SaperGame.MINE){
                    count ++;
                }
            }
        }
        return count;
    }
    
}
