/*
 * Decompiled with CFR 0.152.
 */
package org.demarchi.jpeces.principal;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import org.demarchi.jpeces.comuns.Configuracio;
import org.demarchi.jpeces.comuns.Constants;
import org.demarchi.jpeces.comuns.RecordsPersonals;
import org.demarchi.jpeces.principal.Rellotge;

public final class PanellMarcadors
extends JPanel
implements Constants {
    private Configuracio configPanellMarcadors;
    private JLabel lblRellotge;
    private JLabel lblNumFiguresResoltes;
    public int numFiguresResoltes;
    public int punts;
    private JLabel lblPuntuacio;
    public Rellotge rellotgeMarcador;
    private static ResourceBundle i18n = null;

    public PanellMarcadors(Configuracio config) {
        this.configPanellMarcadors = config;
        this.setSize(new Dimension(180, 120));
        this.setPreferredSize(new Dimension(180, 120));
        this.setMinimumSize(this.getPreferredSize());
        this.setBackground(Color.WHITE);
        if (i18n == null) {
            i18n = ResourceBundle.getBundle("org.demarchi.jpeces.locales.figures");
        }
        this.lblRellotge = new JLabel();
        this.lblRellotge.setSize(50, 100);
        this.lblRellotge.setBorder(BorderFactory.createEtchedBorder());
        this.lblRellotge.setForeground(Color.BLUE);
        this.lblRellotge.setText(i18n.getString("Temps"));
        this.lblRellotge.setHorizontalTextPosition(0);
        Font lletra = new Font(null, 0, 19);
        this.lblRellotge.setFont(lletra);
        this.lblNumFiguresResoltes = new JLabel();
        this.lblPuntuacio = new JLabel();
        this.rellotgeMarcador = new Rellotge(this.lblRellotge, this.comprovaTempsAnterior(this.configPanellMarcadors));
        GridLayout experimentLayout = new GridLayout(3, 1);
        this.setLayout(experimentLayout);
        this.add(this.lblRellotge);
        this.lblRellotge.setHorizontalAlignment(0);
        this.add(this.lblNumFiguresResoltes);
        this.lblNumFiguresResoltes.setHorizontalAlignment(0);
        this.add(this.lblPuntuacio);
        this.lblPuntuacio.setHorizontalAlignment(0);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setVisible(true);
    }

    public String comprovaTempsAnterior(Configuracio config) {
        String temps;
        int recordAnterior = config.configuracioJoc.comprovaRecordPersonal();
        if (recordAnterior > -1) {
            RecordsPersonals rec = (RecordsPersonals)config.configuracioJoc.recordsPersonals.get(recordAnterior);
            temps = rec.temps;
            if (this.rellotgeMarcador != null) {
                this.rellotgeMarcador.carregaTemps(temps);
            }
            this.numFiguresResoltes = rec.numFiguresResoltes;
            this.punts = rec.puntuacio;
            this.actualitzaLabels();
        } else {
            temps = null;
            if (this.rellotgeMarcador != null) {
                this.rellotgeMarcador.carregaTemps(temps);
            }
            this.numFiguresResoltes = 0;
            this.punts = 0;
            this.actualitzaLabels();
        }
        return temps;
    }

    public int augmentaNumeroFiguresResoltes(int puntuacio) {
        ++this.numFiguresResoltes;
        this.punts += puntuacio;
        this.actualitzaLabels();
        return this.numFiguresResoltes;
    }

    public void reiniciaMarcadors() {
        this.rellotgeMarcador.posaAZero();
    }

    public void actualitzaLabels() {
        this.lblNumFiguresResoltes.setText(i18n.getString("Figures") + " " + this.numFiguresResoltes);
        this.lblPuntuacio.setText(i18n.getString("Punts") + " " + this.punts);
    }

    public void construeix(RootPaneContainer contenidorArrel) {
        Container contenidor = contenidorArrel.getContentPane();
        contenidor.add(this);
    }
}

