/*
 * Decompiled with CFR 0.152.
 */
package datarep.common;

import datarep.common.CloseListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.ScrollPane;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.StringTokenizer;

public class WrapLabel
extends Component
implements AdjustmentListener {
    public static final int SIZE_TO_LONGEST_LINE = -1;
    private String text;
    private int width = -1;

    public WrapLabel() {
        this.text = "";
    }

    public WrapLabel(String string) {
        this.text = string;
    }

    public WrapLabel(String string, int n) {
        this.text = string;
        this.width = n;
    }

    public String getText() {
        return this.text;
    }

    public synchronized void setText(String string) {
        this.text = string;
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public int getPreferredWidth() {
        return this.width;
    }

    public synchronized void setPreferredWidth(int n) {
        this.width = n;
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n;
        Font font = this.getFont();
        if (font == null) {
            font = new Font("Dialog", 0, 12);
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Dimension dimension = this.getSize();
        graphics.setFont(this.getFont());
        graphics.setColor(this.getForeground());
        int n2 = fontMetrics.getHeight();
        int n3 = n = fontMetrics.stringWidth(" ");
        int n4 = dimension.width - n;
        int n5 = n + fontMetrics.getAscent();
        int n6 = n3;
        int n7 = n5;
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\n ", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals("\n")) {
                n6 = n3;
                n7 += n2;
                continue;
            }
            if (string.equals(" ")) continue;
            int n8 = fontMetrics.stringWidth(string);
            if (n6 + n8 > n4) {
                n6 = n3;
                n7 += n2;
            }
            graphics.drawString(string, n6, n7);
            n6 += n8 + n;
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        int n;
        Font font = this.getFont();
        if (font == null) {
            font = new Font("Dialog", 0, 12);
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Dimension dimension = new Dimension(0, 0);
        if (this.width < 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\n", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.equals("\n")) {
                    dimension.height += fontMetrics.getHeight();
                    continue;
                }
                int n2 = fontMetrics.stringWidth(string);
                if (n2 <= dimension.width) continue;
                dimension.width = n2;
            }
            dimension.height += 2 * fontMetrics.stringWidth(" ") + fontMetrics.getHeight();
            dimension.width += 2 * fontMetrics.stringWidth(" ");
            return dimension;
        }
        dimension.width = this.width == 0 ? this.getToolkit().getScreenSize().width / 3 : this.width;
        int n3 = n = fontMetrics.stringWidth(" ");
        int n4 = dimension.width - n;
        int n5 = n;
        int n6 = n3;
        int n7 = n5;
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\n ", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals("\n")) {
                n6 = n3;
                n7 += fontMetrics.getHeight();
                continue;
            }
            if (string.equals(" ")) continue;
            int n8 = fontMetrics.stringWidth(string);
            if (n6 + n8 > n4) {
                n6 = n3;
                n7 += fontMetrics.getHeight();
            }
            n6 += n8 + n;
        }
        dimension.height = n7 + fontMetrics.getHeight() + n;
        return dimension;
    }

    public void addNotify() {
        super.addNotify();
        Component component = this;
        while (component != null) {
            if (!((component = component.getParent()) instanceof ScrollPane)) continue;
            ((ScrollPane)component).getHAdjustable().addAdjustmentListener(this);
            ((ScrollPane)component).getVAdjustable().addAdjustmentListener(this);
        }
    }

    public void removeNotify() {
        Component component = this;
        while (component != null) {
            if (!((component = component.getParent()) instanceof ScrollPane)) continue;
            ((ScrollPane)component).getHAdjustable().removeAdjustmentListener(this);
            ((ScrollPane)component).getVAdjustable().removeAdjustmentListener(this);
        }
        super.removeNotify();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.repaint();
    }

    public static void main(String[] stringArray) {
        String string = "Hello There!\nThis is the second line.\n\nThis is the fourth.";
        Frame frame = new Frame("Test of WrapLabel");
        frame.add(new WrapLabel(string));
        frame.addWindowListener(new CloseListener());
        frame.pack();
        frame.show();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " text=" + this.text;
    }
}

