/*
 * Decompiled with CFR 0.152.
 */
package datarep.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;

public class AbsoluteLayout
implements LayoutManager2,
Serializable {
    protected Dimension size;
    protected boolean scaleh;
    protected boolean scalev;
    protected boolean autosize;
    protected Hashtable compTable;

    public AbsoluteLayout() {
        this(new Dimension(400, 200), false, false);
    }

    public AbsoluteLayout(int n, int n2) {
        this(new Dimension(n, n2), false, false);
    }

    public AbsoluteLayout(int n, int n2, boolean bl, boolean bl2) {
        this(new Dimension(n, n2), bl, bl2);
    }

    public AbsoluteLayout(Dimension dimension, boolean bl, boolean bl2) {
        this.size = dimension;
        this.scaleh = bl;
        this.scalev = bl2;
        this.compTable = new Hashtable();
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof Rectangle) {
            this.setConstraints(component, (Rectangle)object);
            return;
        }
        throw new IllegalArgumentException("cannot add to layout: constraint must be a Rectangle");
    }

    public void setConstraints(Component component, Rectangle rectangle) {
        this.compTable.put(component, rectangle);
    }

    public void setHorizontalScaling(boolean bl) {
        this.scaleh = bl;
    }

    public void setVerticalScaling(boolean bl) {
        this.scalev = bl;
    }

    public void setAutoSize(boolean bl) {
        this.autosize = bl;
    }

    public boolean isHorizontalScaling() {
        return this.scaleh;
    }

    public boolean isVerticalScaling() {
        return this.scalev;
    }

    public void removeLayoutComponent(Component component) {
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void setSize(Dimension dimension) {
        this.size = dimension;
    }

    public void setSize(int n, int n2) {
        this.size = new Dimension(n, n2);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.size;
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.size;
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void layoutContainer(Container container) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Rectangle rectangle = new Rectangle((Rectangle)this.compTable.get(componentArray[n]));
            if (this.autosize) {
                componentArray[n].setBounds(new Rectangle(new Point(rectangle.x, rectangle.y), componentArray[n].getPreferredSize()));
            } else {
                if (this.scaleh) {
                    rectangle.x = (int)((float)container.getSize().width / (float)this.size.width * (float)rectangle.x);
                    rectangle.width = (int)((float)container.getSize().width / (float)this.size.width * (float)rectangle.width);
                }
                if (this.scalev) {
                    rectangle.y = (int)((float)container.getSize().height / (float)this.size.height * (float)rectangle.y);
                    rectangle.height = (int)((float)container.getSize().height / (float)this.size.height * (float)rectangle.height);
                }
                componentArray[n].setBounds(rectangle);
            }
            ++n;
        }
    }
}

