/*
 * Decompiled with CFR 0.152.
 */
package puzzle.sound;

import java.io.IOException;
import java.net.URL;
import java.util.Random;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.log4j.Logger;
import puzzle.GameCommander;
import puzzle.gameevent.GameEvent;
import puzzle.sound.AbstractSoundPlayer;

public class SoundPlayer
implements AbstractSoundPlayer {
    private static final Logger logger = Logger.getLogger(SoundPlayer.class);
    private String[] waves = new String[]{"/audio/applause.wav", "/audio/winner.wav", "/audio/win.wav", "/audio/pop.wav", "/audio/clickstop.wav", "/audio/fngrsnap.wav.wav"};
    private ThreadPlayer[] player = new ThreadPlayer[5];
    private Random rng = new Random();

    public SoundPlayer() {
        for (int i = 0; i < this.player.length; ++i) {
            this.player[i] = new ThreadPlayer(this.getClass().getResource(this.waves[i]));
        }
    }

    @Override
    public void playSnap() {
        this.play(3);
    }

    @Override
    public void playTurn() {
        this.play(4);
    }

    @Override
    public void playWon() {
        int n = this.rng.nextInt(3);
        this.play(n);
    }

    private void play(int n) {
        boolean bl = GameCommander.getInstance().getPreferences().isSound();
        if (!bl) {
            return;
        }
        this.player[n].start();
        this.player[n] = new ThreadPlayer(this.getClass().getResource(this.waves[n]));
    }

    @Override
    public void eventHappened(GameEvent gameEvent) {
        switch (gameEvent.getType()) {
            case START_GAME: 
            case LOAD_GAME: {
                break;
            }
            case END_GAME: {
                this.playWon();
                break;
            }
            case MOVE_PIECE: {
                break;
            }
            case PREPARE_TO_SNAP_PIECE: {
                this.playSnap();
                break;
            }
            case TURN_PIECE: {
                this.playTurn();
            }
        }
    }

    static class ThreadPlayer
    extends Thread {
        private AudioInputStream stream = null;
        private SourceDataLine sl = null;
        private byte[] buffer = null;
        private int numBytesRead = 0;
        private boolean error = false;

        ThreadPlayer(URL uRL) {
            try {
                this.stream = AudioSystem.getAudioInputStream(uRL);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.stream.getFormat());
                this.sl = (SourceDataLine)AudioSystem.getLine(info);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                unsupportedAudioFileException.printStackTrace();
                this.error = true;
                logger.error("exception in SoundPlayer" + unsupportedAudioFileException);
            }
            catch (LineUnavailableException lineUnavailableException) {
                lineUnavailableException.printStackTrace();
                this.error = true;
                logger.error("exception in SoundPlayer" + lineUnavailableException);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.error = true;
                logger.error("exception in SoundPlayer" + iOException);
            }
        }

        @Override
        public void run() {
            if (this.error) {
                return;
            }
            try {
                this.sl.open();
            }
            catch (LineUnavailableException lineUnavailableException) {
                lineUnavailableException.printStackTrace();
                logger.error("exception in SoundPlayer" + lineUnavailableException);
                return;
            }
            this.sl.start();
            this.buffer = new byte[256];
            while (true) {
                try {
                    this.numBytesRead = this.stream.read(this.buffer, 0, 256);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    logger.error("exception in SoundPlayer" + iOException);
                }
                if (this.numBytesRead == -1) break;
                this.sl.write(this.buffer, 0, this.buffer.length);
            }
            this.sl.drain();
            this.sl.stop();
            this.sl.close();
        }
    }
}

