/*
 * Decompiled with CFR 0.152.
 */
package puzzle.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import puzzle.GameCommander;
import puzzle.GamePreferences;
import puzzle.PuzzleProperties;
import puzzle.gameevent.GameEvent;
import puzzle.gameevent.GameEventListener;
import puzzle.storeage.JigsawPuzzleException;
import puzzle.storeage.LoadGameException;
import puzzle.storeage.SaveGameException;
import puzzle.storeage.StorageUtil;
import puzzle.storeage.Storeable;
import puzzle.ui.GamePanel;
import puzzle.ui.GameStartDialog;
import puzzle.ui.LoadSaveFileChooser;
import puzzle.ui.PreviewDialog;

public class GameMainWindow
extends JFrame
implements GameEventListener,
Storeable {
    private static final Logger logger = Logger.getLogger(GameMainWindow.class);
    private static GameMainWindow This;
    private GameStartDialog startDialog;
    private PreviewDialog previewDialog;
    private LoadSaveFileChooser fileChooser;
    private JMenuBar menuBar;
    private JMenu gameMenu;
    private JMenuItem gameNew;
    private JMenuItem gameReset;
    private JMenuItem gameLoad;
    private JMenuItem gameSave;
    private JMenuItem gameExit;
    private JMenu viewMenu;
    private JMenuItem preview;
    private JMenu optionMenu;
    private JCheckBoxMenuItem outlineCheck;
    private JCheckBoxMenuItem shadowCheck;
    private JCheckBoxMenuItem highlightCheck;
    private JCheckBoxMenuItem antiAliasingCheck;
    private JCheckBoxMenuItem soundCheck;
    private GamePanel gamePanel;
    private JScrollPane gamePanelScroll;
    private JPanel statusPanel;
    private JLabel statusInformation;
    private int startingPieceCount;
    private int actualPieceCount;

    public static GameMainWindow getInstance() {
        return This;
    }

    public static void startUI() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                This = new GameMainWindow();
                This.setVisible(true);
            }
        });
    }

    private GameMainWindow() {
        this.setIconImage(new ImageIcon(this.getClass().getResource("/pics/puzzle.gif")).getImage());
        String string = PuzzleProperties.getLocalized("gameHeader");
        this.setTitle(string + " " + "1.5.4 build 10. Juli 2010");
        this.setExtendedState(6);
        this.setMinimumSize(new Dimension(400, 300));
        this.setDefaultCloseOperation(3);
        this.initComponents();
        this.fileChooser = new LoadSaveFileChooser(this);
        this.previewDialog = new PreviewDialog(this);
        this.createBufferStrategy(2);
        GameCommander.getInstance().addListener(this);
    }

    public GamePanel getGamePanel() {
        return this.gamePanel;
    }

    private void initComponents() {
        this.gamePanel = new GamePanel();
        this.addKeyListener(this.gamePanel.getInputListener());
        this.gamePanelScroll = new JScrollPane(this.gamePanel);
        this.gamePanelScroll.getViewport().add(this.gamePanel);
        this.menuBar = new JMenuBar();
        this.gameMenu = new JMenu();
        this.gameMenu.setText(PuzzleProperties.getLocalized("gameMenu"));
        this.gameNew = new JMenuItem(PuzzleProperties.getLocalized("gameMenuNewGame"));
        this.gameNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GameMainWindow.this.clickedNewGame();
            }
        });
        this.gameReset = new JMenuItem(PuzzleProperties.getLocalized("gameMenuResetGame"));
        this.gameReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    GameMainWindow.this.clickedResetGame();
                }
                catch (JigsawPuzzleException jigsawPuzzleException) {
                    logger.error("reset game error" + jigsawPuzzleException.toString());
                }
            }
        });
        this.gameLoad = new JMenuItem(PuzzleProperties.getLocalized("gameMenuLoadGame"));
        this.gameLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GameMainWindow.this.clickedLoadGame();
            }
        });
        this.gameSave = new JMenuItem(PuzzleProperties.getLocalized("gameMenuSaveGame"));
        this.gameSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GameMainWindow.this.clickedSaveGame();
            }
        });
        this.gameExit = new JMenuItem(PuzzleProperties.getLocalized("gameMenuExitGame"));
        this.gameExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GameMainWindow.this.clickedExitGame();
            }
        });
        this.viewMenu = new JMenu();
        this.viewMenu.setText(PuzzleProperties.getLocalized("viewMenu"));
        this.preview = new JMenuItem();
        this.preview.setText(PuzzleProperties.getLocalized("viewMenuPreview"));
        this.preview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GameMainWindow.this.clickedPreview();
            }
        });
        this.optionMenu = new JMenu();
        this.optionMenu.setText(PuzzleProperties.getLocalized("options"));
        this.outlineCheck = new JCheckBoxMenuItem();
        this.outlineCheck.setText(PuzzleProperties.getLocalized("optionShowOutline"));
        this.outlineCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = GameMainWindow.this.outlineCheck.getState();
                GameCommander.getInstance().getPreferences().setShowOutline(bl);
                try {
                    GameMainWindow.this.gamePanel.reRender();
                }
                catch (JigsawPuzzleException jigsawPuzzleException) {
                    logger.error("error in rerendering" + jigsawPuzzleException.toString());
                }
            }
        });
        this.shadowCheck = new JCheckBoxMenuItem();
        this.shadowCheck.setText(PuzzleProperties.getLocalized("optionShowShadow"));
        this.shadowCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = GameMainWindow.this.shadowCheck.getState();
                GameCommander.getInstance().getPreferences().setShowShadow(bl);
                try {
                    GameMainWindow.this.gamePanel.reRender();
                }
                catch (JigsawPuzzleException jigsawPuzzleException) {
                    logger.error("error in rerendering" + jigsawPuzzleException.toString());
                }
            }
        });
        this.highlightCheck = new JCheckBoxMenuItem();
        this.highlightCheck.setText(PuzzleProperties.getLocalized("optionHighlight"));
        this.highlightCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = GameMainWindow.this.highlightCheck.getState();
                GameCommander.getInstance().getPreferences().setHighlight(bl);
                try {
                    GameMainWindow.this.gamePanel.reRender();
                }
                catch (JigsawPuzzleException jigsawPuzzleException) {
                    logger.error("error in rerendering" + jigsawPuzzleException.toString());
                }
            }
        });
        this.antiAliasingCheck = new JCheckBoxMenuItem();
        this.antiAliasingCheck.setText(PuzzleProperties.getLocalized("viewMenuAntiAliasing"));
        this.antiAliasingCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = GameMainWindow.this.antiAliasingCheck.getState();
                GameCommander.getInstance().getPreferences().setAntiAliasing(bl);
                try {
                    GameMainWindow.this.gamePanel.repaint();
                    GameMainWindow.this.gamePanel.reRender();
                }
                catch (JigsawPuzzleException jigsawPuzzleException) {
                    logger.error("error in rerendering" + jigsawPuzzleException.toString());
                }
            }
        });
        this.soundCheck = new JCheckBoxMenuItem();
        this.soundCheck.setText(PuzzleProperties.getLocalized("optionSoundOn"));
        this.soundCheck.setState(true);
        this.soundCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = GameMainWindow.this.soundCheck.getState();
                GameCommander.getInstance().getPreferences().setSound(bl);
            }
        });
        this.enableOptions(false);
        this.gameMenu.add(this.gameNew);
        this.gameMenu.add(this.gameReset);
        this.gameMenu.add(new JSeparator());
        this.gameMenu.add(this.gameLoad);
        this.gameMenu.add(this.gameSave);
        this.gameMenu.add(new JSeparator());
        this.gameMenu.add(this.gameExit);
        this.viewMenu.add(this.preview);
        this.viewMenu.add(this.antiAliasingCheck);
        this.optionMenu.add(this.outlineCheck);
        this.optionMenu.add(this.shadowCheck);
        this.optionMenu.add(this.highlightCheck);
        this.optionMenu.add(this.soundCheck);
        this.menuBar.add(this.gameMenu);
        this.menuBar.add(this.optionMenu);
        this.menuBar.add(this.viewMenu);
        this.statusPanel = new JPanel();
        this.statusInformation = new JLabel();
        this.statusPanel.add(this.statusInformation);
        this.initUI();
        this.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.gamePanelScroll, "Center");
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    protected void clickedExitGame() {
        System.exit(0);
    }

    private void clickedNewGame() {
        if (this.startDialog == null) {
            this.startDialog = new GameStartDialog(this);
        }
        this.startDialog.setVisible(true);
    }

    private void clickedPreview() {
        this.previewDialog.setVisible(true);
    }

    private void clickedResetGame() throws JigsawPuzzleException {
        GameCommander.getInstance().resetGame();
        this.reset();
    }

    private void clickedSaveGame() {
        File file = this.fileChooser.openSaveDialog();
        if (file == null) {
            return;
        }
        try {
            GameCommander.getInstance().saveGame(file);
        }
        catch (SaveGameException saveGameException) {
            saveGameException.printStackTrace();
            this.showErrorMessage(PuzzleProperties.getLocalized("storeSaveErrorTitle"), PuzzleProperties.getLocalized("storeSaveErrorMessage"));
        }
    }

    private void clickedLoadGame() {
        File file = this.fileChooser.openLoadDialog();
        if (file == null) {
            return;
        }
        try {
            GameCommander.getInstance().loadGame(file);
        }
        catch (LoadGameException loadGameException) {
            loadGameException.printStackTrace();
            this.showErrorMessage(PuzzleProperties.getLocalized("storeLoadErrorTitle"), PuzzleProperties.getLocalized("storeLoadErrorMessage"));
        }
    }

    private void reset() throws JigsawPuzzleException {
        this.initUI();
        this.enableOptions(false);
        this.gamePanel.reRender();
        this.previewDialog.unloadImage();
    }

    private void enableOptions(boolean bl) {
        this.outlineCheck.setEnabled(bl);
        this.shadowCheck.setEnabled(bl);
        this.highlightCheck.setEnabled(bl);
        this.antiAliasingCheck.setEnabled(bl);
        this.soundCheck.setEnabled(bl);
        this.gameSave.setEnabled(bl);
    }

    private void initUI() {
        this.statusInformation.setText(PuzzleProperties.getLocalized("puzzlePieces"));
    }

    private void showErrorMessage(String string, String string2) {
        JOptionPane.showMessageDialog(this, string, string2, 0);
    }

    public void setBoundaries(int n, int n2) {
        GamePreferences gamePreferences = GameCommander.getInstance().getPreferences();
        Dimension dimension = new Dimension(n + gamePreferences.getSideLength(), n2 + gamePreferences.getSideLength());
        Dimension dimension2 = this.gamePanel.getSize();
        int n3 = dimension.width > dimension2.width ? dimension.width : dimension2.width;
        int n4 = dimension.height > dimension2.height ? dimension.height : dimension2.height;
        Dimension dimension3 = new Dimension(n3, n4);
        this.gamePanel.setPreferredSize(dimension3);
        this.gamePanel.setSize(dimension3);
    }

    public void setPieceCount(int n) {
        this.actualPieceCount = n;
        String string = PuzzleProperties.getLocalized("puzzlePieces");
        this.statusInformation.setText(string + " " + this.actualPieceCount + "/" + this.startingPieceCount);
    }

    public void startGame(GamePreferences gamePreferences) throws JigsawPuzzleException {
        this.previewDialog.loadImage(gamePreferences.getImage().getImage());
        this.enableOptions(true);
        this.outlineCheck.setState(gamePreferences.isShowOutline());
        this.shadowCheck.setState(gamePreferences.isShowShadow());
        this.highlightCheck.setState(gamePreferences.isHighlight());
        this.antiAliasingCheck.setState(gamePreferences.isAntiAliasing());
        this.soundCheck.setState(gamePreferences.isSound());
        this.gamePanel.reRender();
        this.repaint();
    }

    @Override
    public void eventHappened(GameEvent gameEvent) throws JigsawPuzzleException {
        switch (gameEvent.getType()) {
            case START_GAME: {
                GamePreferences gamePreferences = (GamePreferences)gameEvent.getInfo();
                this.startingPieceCount = gamePreferences.getInitialPieces();
                this.setPieceCount(this.startingPieceCount);
                this.startGame(gamePreferences);
                break;
            }
            case LOAD_GAME: {
                GamePreferences gamePreferences = (GamePreferences)gameEvent.getInfo();
                this.startGame(gamePreferences);
                break;
            }
            case SNAP_PIECE: {
                int n = (Integer)gameEvent.getInfo();
                this.setPieceCount(n);
            }
        }
    }

    @Override
    public void restore(Node node) throws LoadGameException {
        Node node2 = StorageUtil.findDirectChildNode(node, "GameMainWindow");
        NamedNodeMap namedNodeMap = node2.getAttributes();
        Node node3 = namedNodeMap.getNamedItem("SizeWidth");
        int n = Integer.parseInt(node3.getNodeValue());
        Node node4 = namedNodeMap.getNamedItem("SizeHeight");
        int n2 = Integer.parseInt(node4.getNodeValue());
        this.setBoundaries(n, n2);
        Node node5 = namedNodeMap.getNamedItem("InitialPieceCount");
        this.startingPieceCount = Integer.parseInt(node5.getNodeValue());
        Node node6 = namedNodeMap.getNamedItem("PieceCount");
        this.setPieceCount(Integer.parseInt(node6.getNodeValue()));
    }

    @Override
    public void store(Node node) throws SaveGameException {
        Document document = node.getOwnerDocument();
        Element element = document.createElement("GameMainWindow");
        Dimension dimension = this.gamePanel.getPreferredSize();
        element.setAttribute("SizeWidth", "" + dimension.width);
        element.setAttribute("SizeHeight", "" + dimension.height);
        element.setAttribute("InitialPieceCount", "" + this.startingPieceCount);
        element.setAttribute("PieceCount", "" + this.actualPieceCount);
        node.appendChild(element);
    }
}

