/*
 * Decompiled with CFR 0.152.
 */
package puzzle.edge;

import java.awt.Point;
import java.awt.Shape;
import java.util.Random;
import puzzle.storeage.JigsawPuzzleException;

public abstract class AbstractEdgeProducer {
    protected static final Random rand = new Random();
    protected Point[] actualPoints;
    protected boolean isBubble;
    protected Shape[] twoShapes;
    protected int sideLength;

    public void init(int n) {
        this.sideLength = n;
        this.isBubble = rand.nextBoolean();
        this._init();
    }

    protected abstract void _init();

    public abstract void produce() throws JigsawPuzzleException;

    public Shape[] getBothShapes() {
        return this.twoShapes;
    }

    protected void recalculate() {
        if (!this.isBubble) {
            for (Point point : this.actualPoints) {
                point.y *= -1;
            }
        }
    }
}

