/*
 * Decompiled with CFR 0.152.
 */
package puzzle;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import puzzle.GamePreferences;
import puzzle.PuzzleBuilder;
import puzzle.PuzzleProperties;
import puzzle.edge.EdgeDisposer;
import puzzle.gameevent.GameEvent;
import puzzle.gameevent.GameEventListener;
import puzzle.gameevent.GameState;
import puzzle.pieces.PuzzlePieceDisposer;
import puzzle.sound.AbstractSoundPlayer;
import puzzle.sound.SoundPlayer;
import puzzle.storeage.JigsawPuzzleException;
import puzzle.storeage.LoadGameException;
import puzzle.storeage.SaveGameException;
import puzzle.storeage.StorageUtil;
import puzzle.storeage.Storeable;
import puzzle.ui.GameMainWindow;

public class GameCommander
extends GameState
implements GameEventListener,
Storeable {
    private static Logger logger = Logger.getLogger(GameCommander.class);
    private static GameCommander This;
    private PuzzleBuilder builder;
    private final AbstractSoundPlayer soundPlayer;
    private final PuzzlePieceDisposer pieceDisposer;
    private EdgeDisposer edgeDisposer;
    private GamePreferences preferences;
    private boolean gameRunning;

    public boolean isGameRunning() {
        return this.gameRunning;
    }

    private GameCommander() {
        this.addListener(this);
        This = this;
        this.builder = new PuzzleBuilder();
        this.soundPlayer = new SoundPlayer();
        this.addListener(this.soundPlayer);
        this.pieceDisposer = new PuzzlePieceDisposer();
        this.edgeDisposer = new EdgeDisposer();
        this.gameRunning = false;
    }

    public void testForGameEnd() throws JigsawPuzzleException {
        if (this.pieceDisposer.ends()) {
            String string = PuzzleProperties.getLocalized("gameWonMessage");
            String string2 = PuzzleProperties.getLocalized("gameWonHeader");
            GameEvent gameEvent = new GameEvent(GameEvent.State.END_GAME, null);
            this.deliverEvent(gameEvent);
            JOptionPane.showMessageDialog(GameMainWindow.getInstance(), string, string2, 1);
        }
    }

    @Override
    public void deliverEvent(GameEvent gameEvent) throws JigsawPuzzleException {
        if (this.gameRunning) {
            super.deliverEvent(gameEvent);
        }
    }

    public void resetGame() {
        this.builder = new PuzzleBuilder();
        this.pieceDisposer.reset();
        this.edgeDisposer.reset();
    }

    public void newGame(GamePreferences gamePreferences) throws JigsawPuzzleException {
        this.preferences = gamePreferences;
        this.resetGame();
        int n = gamePreferences.getColumns();
        int n2 = gamePreferences.getRows();
        this.builder.makePieces(n, n2);
        this.gameRunning = true;
        GameEvent gameEvent = new GameEvent(GameEvent.State.START_GAME, this.preferences);
        this.deliverEvent(gameEvent);
    }

    public void loadGame(File file) throws LoadGameException {
        this.resetGame();
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            this.restore(document);
            GameEvent gameEvent = new GameEvent(GameEvent.State.LOAD_GAME, this.preferences);
            this.deliverEvent(gameEvent);
            System.gc();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new LoadGameException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new LoadGameException(sAXException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LoadGameException(iOException);
        }
        catch (JigsawPuzzleException jigsawPuzzleException) {
            jigsawPuzzleException.printStackTrace();
            throw new LoadGameException(jigsawPuzzleException);
        }
    }

    public void saveGame(File file) throws SaveGameException {
        Document document = StorageUtil.createDOMDocument();
        this.store(document);
        StorageUtil.saveAsXML(document, file);
        System.gc();
    }

    public static GameCommander getInstance() {
        if (This == null) {
            This = new GameCommander();
        }
        return This;
    }

    public GamePreferences getPreferences() {
        return this.preferences;
    }

    public EdgeDisposer getEdgeDisposer() {
        return this.edgeDisposer;
    }

    public PuzzlePieceDisposer getPieceDisposer() {
        return this.pieceDisposer;
    }

    @Override
    public void eventHappened(GameEvent gameEvent) throws JigsawPuzzleException {
        switch (gameEvent.getType()) {
            case SNAP_PIECE: {
                this.testForGameEnd();
                break;
            }
        }
    }

    @Override
    public void restore(Node node) throws LoadGameException {
        Node node2 = StorageUtil.findDirectChildNode(node, "PuzzleGameState");
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = namedNodeMap.getNamedItem("version").getNodeValue();
        if (!string.equals("1.5")) {
            logger.warn("current version: 1.5 but found a stored game version: " + string);
            throw new LoadGameException("wrong version");
        }
        this.preferences = new GamePreferences();
        this.preferences.restore(node2);
        this.pieceDisposer.reset();
        this.pieceDisposer.restore(node2);
        GameMainWindow.getInstance().restore(node2);
    }

    @Override
    public void store(Node node) throws SaveGameException {
        Document document = (Document)node;
        Element element = document.createElement("PuzzleGameState");
        element.setAttribute("version", "1.5");
        this.preferences.store(element);
        this.pieceDisposer.store(element);
        GameMainWindow.getInstance().store(element);
        document.appendChild(element);
    }
}

