/*
 * Decompiled with CFR 0.152.
 */
package puzzle.ui;

import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import puzzle.GameCommander;
import puzzle.Offset;
import puzzle.gameevent.GameEvent;
import puzzle.pieces.PuzzlePiece;
import puzzle.storeage.JigsawPuzzleException;

public class PuzzleInputListener
extends KeyAdapter
implements MouseMotionListener,
MouseListener {
    private static Logger logger = Logger.getLogger(PuzzleInputListener.class);
    private GameCommander gC = GameCommander.getInstance();
    private PuzzlePiece selectedPiece;
    private Point lastPoint;
    private Point actPoint;
    private boolean dragging;
    private Point currentPoint;
    private PuzzlePiece lastHighlighted = null;

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 70) {
            if (this.dragging) {
                this.dragged(this.currentPoint);
            } else {
                this.prepareDragging(this.currentPoint);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragging) {
            this.dragging(mouseEvent.getPoint());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this.dragging) {
                this.dragging(mouseEvent.getPoint());
            } else {
                this.prepareDragging(mouseEvent.getPoint());
            }
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            if (this.gC.getPreferences().isAllowTurn() && !this.dragging) {
                this.turnPiece(mouseEvent.getPoint());
            }
        } else if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            if (this.dragging) {
                this.dragged(mouseEvent.getPoint());
            } else {
                this.prepareDragging(mouseEvent.getPoint());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.dragged(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.currentPoint = mouseEvent.getPoint();
        if (this.dragging) {
            this.dragging(mouseEvent.getPoint());
        } else {
            this.mouseHighlight(this.gC.getPieceDisposer().findbyPoint(mouseEvent.getPoint()));
        }
    }

    private void turnPiece(Point point) {
        try {
            this.actPoint = point;
            this.selectedPiece = this.gC.getPieceDisposer().findbyPoint(this.actPoint);
            if (this.selectedPiece == null) {
                return;
            }
            GameEvent gameEvent = new GameEvent(GameEvent.State.PREPARE_TO_TURN_PIECE, this.selectedPiece);
            this.gC.deliverEvent(gameEvent);
            this.selectedPiece.turnDegrees(this.actPoint, 90);
            GameEvent gameEvent2 = new GameEvent(GameEvent.State.TURN_PIECE, this.selectedPiece);
            this.gC.deliverEvent(gameEvent2);
        }
        catch (JigsawPuzzleException jigsawPuzzleException) {
            logger.error("while turning piece" + jigsawPuzzleException.toString());
        }
    }

    private void mouseHighlight(PuzzlePiece puzzlePiece) {
        if (puzzlePiece == this.lastHighlighted) {
            return;
        }
        try {
            GameEvent gameEvent;
            GameEvent gameEvent2;
            if (this.lastHighlighted != null) {
                gameEvent2 = new GameEvent(GameEvent.State.PREPARE_TO_HIGHLIGHT_PIECE, this.lastHighlighted);
                this.gC.deliverEvent(gameEvent2);
                this.lastHighlighted.unhighlight();
                gameEvent = new GameEvent(GameEvent.State.HIGHLIGHT_PIECE, this.lastHighlighted);
                this.gC.deliverEvent(gameEvent);
                this.lastHighlighted = null;
            }
            if (puzzlePiece != null) {
                gameEvent2 = new GameEvent(GameEvent.State.PREPARE_TO_HIGHLIGHT_PIECE, puzzlePiece);
                this.gC.deliverEvent(gameEvent2);
                puzzlePiece.highlight();
                gameEvent = new GameEvent(GameEvent.State.HIGHLIGHT_PIECE, puzzlePiece);
                this.gC.deliverEvent(gameEvent);
                this.lastHighlighted = puzzlePiece;
            }
        }
        catch (JigsawPuzzleException jigsawPuzzleException) {
            logger.error("while highlighting piece" + jigsawPuzzleException.toString());
        }
    }

    private void dragging(Point point) {
        try {
            this.lastPoint = this.actPoint;
            this.actPoint = point;
            Offset offset = new Offset(this.actPoint.x - this.lastPoint.x, this.actPoint.y - this.lastPoint.y);
            GameEvent gameEvent = new GameEvent(GameEvent.State.PREPARE_TO_MOVE_PIECE, this.selectedPiece);
            this.gC.deliverEvent(gameEvent);
            this.selectedPiece.move(offset);
            GameEvent gameEvent2 = new GameEvent(GameEvent.State.MOVE_PIECE, this.selectedPiece);
            this.gC.deliverEvent(gameEvent2);
        }
        catch (JigsawPuzzleException jigsawPuzzleException) {
            logger.error("while dragging " + jigsawPuzzleException.toString());
        }
    }

    private void prepareDragging(Point point) {
        PuzzlePiece puzzlePiece = this.gC.getPieceDisposer().findbyPoint(point);
        if (puzzlePiece != null) {
            this.actPoint = point;
            this.lastPoint = null;
            this.selectedPiece = puzzlePiece;
            this.dragging = true;
        }
    }

    private void dragged(Point point) {
        if (this.selectedPiece == null) {
            return;
        }
        try {
            this.lastPoint = this.actPoint;
            this.actPoint = point;
            GameEvent gameEvent = new GameEvent(GameEvent.State.PREPARE_TO_MOVE_PIECE, this.selectedPiece);
            this.gC.deliverEvent(gameEvent);
            GameEvent gameEvent2 = null;
            GameEvent gameEvent3 = null;
            PuzzlePiece puzzlePiece = null;
            puzzlePiece = this.selectedPiece.snap();
            if (puzzlePiece != null) {
                int n = this.gC.getPieceDisposer().getPieceCount();
                GameEvent gameEvent4 = new GameEvent(GameEvent.State.PREPARE_TO_SNAP_PIECE, n);
                this.gC.deliverEvent(gameEvent4);
                gameEvent2 = new GameEvent(GameEvent.State.SNAP_PIECE, n);
                gameEvent3 = new GameEvent(GameEvent.State.MOVE_PIECE, puzzlePiece);
            } else {
                gameEvent3 = new GameEvent(GameEvent.State.MOVE_PIECE, this.selectedPiece);
            }
            this.gC.deliverEvent(gameEvent3);
            if (gameEvent2 != null) {
                this.gC.deliverEvent(gameEvent2);
            }
            this.selectedPiece = null;
            this.actPoint = null;
            this.lastPoint = null;
            this.dragging = false;
        }
        catch (JigsawPuzzleException jigsawPuzzleException) {
            logger.error("while drag ended" + jigsawPuzzleException.toString());
        }
    }
}

