/*
 * Decompiled with CFR 0.152.
 */
package puzzle.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.apache.log4j.Logger;
import puzzle.GameCommander;
import puzzle.GamePreferences;
import puzzle.PuzzleProperties;
import puzzle.edge.AbstractEdgeProducer;
import puzzle.edge.FlatEdgeProducer;
import puzzle.edge.ModernEdgeProducer;
import puzzle.edge.StandardEdgeProducer;
import puzzle.storeage.JigsawPuzzleException;
import puzzle.ui.PuzzleImage;
import puzzle.ui.extensions.ExtensionFileFilter;
import puzzle.ui.extensions.ImagePreview;

public class GameStartDialog
extends JDialog {
    private static final Logger logger = Logger.getLogger(GameStartDialog.class);
    private final Dimension previewPanelSize = new Dimension(160, 200);
    private JRadioButton side20Pixel;
    private JRadioButton side30Pixel;
    private JRadioButton side40Pixel;
    private JRadioButton side50Pixel;
    private JRadioButton side60Pixel;
    private JCheckBox allowTurn;
    private JLabel imageInfo;
    private PreviewPanel previewPanel;
    private JButton findFileButton;
    private JButton cancelButton;
    private JButton startButton;
    private JRadioButton standardEdge;
    private JRadioButton flatEdge;
    private JRadioButton modernEdge;
    private JFileChooser imgFileChoo;
    private File currentFile;
    private PuzzleImage image;
    private int puzzlePieceSize;
    private ExtensionFileFilter eff;

    public GameStartDialog(Frame frame) {
        super(frame, true);
        this.setTitle(PuzzleProperties.getLocalized("newGameDialogHeader"));
        this.setLocationByPlatform(true);
        this.setResizable(true);
        this.initInteractive();
        this.initComponents();
        this.doPreferences();
    }

    private void showErrorMessage(String string, String string2) {
        JOptionPane.showMessageDialog(this.getOwner(), string, string2, 0);
    }

    private void doPreferences() {
        this.side20Pixel.setSelected(true);
        this.puzzlePieceSize = 20;
        this.standardEdge.setSelected(true);
    }

    private void initInteractive() {
        this.side20Pixel = new JRadioButton(PuzzleProperties.getLocalized("size20px"));
        this.side20Pixel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GameStartDialog.this.puzzlePieceSize = 20;
                GameStartDialog.this.retrieveAndShowImageInfo();
            }
        });
        this.side30Pixel = new JRadioButton(PuzzleProperties.getLocalized("size30px"));
        this.side30Pixel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GameStartDialog.this.puzzlePieceSize = 30;
                GameStartDialog.this.retrieveAndShowImageInfo();
            }
        });
        this.side40Pixel = new JRadioButton(PuzzleProperties.getLocalized("size40px"));
        this.side40Pixel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GameStartDialog.this.puzzlePieceSize = 40;
                GameStartDialog.this.retrieveAndShowImageInfo();
            }
        });
        this.side50Pixel = new JRadioButton(PuzzleProperties.getLocalized("size50px"));
        this.side50Pixel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GameStartDialog.this.puzzlePieceSize = 50;
                GameStartDialog.this.retrieveAndShowImageInfo();
            }
        });
        this.side60Pixel = new JRadioButton(PuzzleProperties.getLocalized("size60px"));
        this.side60Pixel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GameStartDialog.this.puzzlePieceSize = 60;
                GameStartDialog.this.retrieveAndShowImageInfo();
            }
        });
        this.allowTurn = new JCheckBox(PuzzleProperties.getLocalized("optionAllowTurn"));
        this.startButton = new JButton(PuzzleProperties.getLocalized("newGameDialogStart"));
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GameStartDialog.this.startClicked();
            }
        });
        this.cancelButton = new JButton(PuzzleProperties.getLocalized("newGameDialogCancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GameStartDialog.this.cancelClicked();
            }
        });
        this.findFileButton = new JButton(PuzzleProperties.getLocalized("newGameDialogFindFile"));
        this.findFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    GameStartDialog.this.findFileClicked();
                }
                catch (JigsawPuzzleException jigsawPuzzleException) {
                    logger.error("couldn't load image: " + jigsawPuzzleException.toString());
                    GameStartDialog.this.showErrorMessage(PuzzleProperties.getLocalized("loadImageErrorTitle"), PuzzleProperties.getLocalized("loadImageErrorMessage"));
                }
            }
        });
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.side20Pixel);
        buttonGroup.add(this.side30Pixel);
        buttonGroup.add(this.side40Pixel);
        buttonGroup.add(this.side50Pixel);
        buttonGroup.add(this.side60Pixel);
        JLabel jLabel = new JLabel(PuzzleProperties.getLocalized("newGameDialogPieceSize"));
        JLabel jLabel2 = new JLabel(PuzzleProperties.getLocalized("newGameDialogOptions"));
        this.previewPanel = new PreviewPanel();
        this.previewPanel.setPreferredSize(this.previewPanelSize);
        this.previewPanel.setSize(this.previewPanelSize);
        this.imageInfo = new JLabel(PuzzleProperties.getLocalized("newGameDialogImageInfo"));
        JLabel jLabel3 = new JLabel(PuzzleProperties.getLocalized("newGameDialogEdges"));
        this.standardEdge = new JRadioButton(PuzzleProperties.getLocalized("edgeStandard"));
        this.flatEdge = new JRadioButton(PuzzleProperties.getLocalized("edgeFlat"));
        this.modernEdge = new JRadioButton(PuzzleProperties.getLocalized("edgeModern"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.standardEdge);
        buttonGroup2.add(this.flatEdge);
        buttonGroup2.add(this.modernEdge);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 3));
        jPanel3.add(this.previewPanel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 3));
        jPanel4.add(jLabel);
        jPanel4.add(this.side20Pixel);
        jPanel4.add(this.side30Pixel);
        jPanel4.add(this.side40Pixel);
        jPanel4.add(this.side50Pixel);
        jPanel4.add(this.side60Pixel);
        jPanel4.add(new JSeparator());
        jPanel4.add(jLabel2);
        jPanel4.add(this.allowTurn);
        jPanel4.add(jLabel3);
        jPanel4.add(this.standardEdge);
        jPanel4.add(this.flatEdge);
        jPanel4.add(this.modernEdge);
        jPanel4.add(new JSeparator());
        jPanel4.add(this.imageInfo);
        jPanel4.add(this.findFileButton);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel2.add(this.startButton);
        jPanel2.add(this.cancelButton);
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
        this.pack();
    }

    private void startClicked() {
        if (this.image == null) {
            return;
        }
        int n = this.getPuzzlePieceSize();
        boolean bl = this.image.isResizableToGoodQuality(n);
        if (!bl) {
            String string = PuzzleProperties.getLocalized("noGoodQualityMessage");
            String string2 = PuzzleProperties.getLocalized("noGoodQualityHeader");
            JOptionPane.showConfirmDialog(this, string, string2, 0);
            return;
        }
        this.image.resize();
        boolean bl2 = this.allowTurn.isSelected();
        AbstractEdgeProducer abstractEdgeProducer = this.getEdgeProducer();
        GamePreferences gamePreferences = new GamePreferences(n, this.image, bl2, false, false, false, true, abstractEdgeProducer);
        gamePreferences.calcDeducedAttributes();
        gamePreferences.calcInitialPieces();
        try {
            GameCommander.getInstance().newGame(gamePreferences);
        }
        catch (JigsawPuzzleException jigsawPuzzleException) {
            logger.error("could not instantiate new game: " + jigsawPuzzleException.toString());
            this.showErrorMessage(PuzzleProperties.getLocalized("newGameDialogNewGameErrorTitle"), PuzzleProperties.getLocalized("newGameDialogNewGameErrorMessage"));
        }
        this.setVisible(false);
    }

    private int getPuzzlePieceSize() {
        return this.puzzlePieceSize;
    }

    private AbstractEdgeProducer getEdgeProducer() {
        if (this.standardEdge.isSelected()) {
            return new StandardEdgeProducer();
        }
        if (this.flatEdge.isSelected()) {
            return new FlatEdgeProducer();
        }
        if (this.modernEdge.isSelected()) {
            return new ModernEdgeProducer();
        }
        return null;
    }

    private void cancelClicked() {
        this.setVisible(false);
    }

    private void findFileClicked() throws JigsawPuzzleException {
        if (this.imgFileChoo == null) {
            this.initDialog();
        }
        this.imgFileChoo.setVisible(true);
        if (this.imgFileChoo.showDialog(this, PuzzleProperties.getLocalized("loadImageFile")) == 0) {
            this.currentFile = this.imgFileChoo.getSelectedFile();
            this.image = new PuzzleImage(this.currentFile);
            Image image = this.image.resizeToFit(this.previewPanel.getSize());
            this.retrieveAndShowImageInfo();
            this.previewPanel.loadImage(image);
        }
        this.repaint();
        this.imgFileChoo.setVisible(false);
    }

    private void retrieveAndShowImageInfo() {
        if (this.image == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.image.isResizableToGoodQuality(this.getPuzzlePieceSize());
        Dimension dimension = this.image.getResampleSize();
        int n = dimension.height / this.puzzlePieceSize * (dimension.width / this.puzzlePieceSize);
        stringBuffer.append(PuzzleProperties.getLocalized("puzzlePieces"));
        stringBuffer.append(" " + n);
        if (!bl) {
            stringBuffer.append(" " + PuzzleProperties.getLocalized("newGameDialogImageInfoProblem"));
        }
        this.imageInfo.setText(stringBuffer.toString());
        this.repaint();
    }

    private void initDialog() {
        this.imgFileChoo = new JFileChooser();
        this.imgFileChoo.setDialogTitle(PuzzleProperties.getLocalized("loadingImageFile"));
        this.imgFileChoo.setMultiSelectionEnabled(false);
        this.eff = new ExtensionFileFilter();
        this.eff.addExtension("jpg");
        this.eff.addExtension("gif");
        this.eff.setDirectoryAccept(true);
        this.imgFileChoo.setFileFilter(this.eff);
        this.imgFileChoo.setAccessory(new ImagePreview(this.imgFileChoo));
    }

    private final class PreviewPanel
    extends JPanel {
        private final Border border = BorderFactory.createEtchedBorder(0);
        private JLabel label;

        PreviewPanel() {
            GameStartDialog.this.setResizable(false);
            this.setLayout(new BorderLayout());
            this.setBorder(this.border);
            this.label = new JLabel();
            this.label.setText(PuzzleProperties.getLocalized("noImagePresent"));
            this.add((Component)this.label, "Center");
        }

        void loadImage(Image image) {
            this.label.setIcon(new ImageIcon(image));
            this.setPreferredSize(GameStartDialog.this.previewPanelSize);
            this.repaint();
        }

        void unloadImage() {
            this.label.setText(PuzzleProperties.getLocalized("noImagePresent"));
        }
    }
}

