/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

final class JetrisMessageBar
extends JPanel
implements ActionListener,
MouseListener {
    private JLabel message;
    private Clock clock;
    private JPopupMenu popup;

    JetrisMessageBar() {
        this.setLayout(new BorderLayout());
        this.addMouseListener(this);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new EtchedBorder(1), new EmptyBorder(2, 5, 2, 5));
        this.message = new JLabel("Welcome to Jetris");
        this.message.setBorder(compoundBorder);
        this.add(this.message);
        this.clock = new Clock();
        this.clock.setVisible(Jetris.getConfig().readKey("clockisvisible", false));
        this.add((Component)this.clock, "East");
        this.popup = new JPopupMenu();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show clock", this.clock.isVisible());
        jCheckBoxMenuItem.setActionCommand("showclock");
        jCheckBoxMenuItem.addActionListener(this);
        this.popup.add(jCheckBoxMenuItem);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.setPreferredSize(new Dimension(this.getSize().width, fontMetrics.getHeight() + fontMetrics.getHeight() / 2));
    }

    public void setMessage(String string) {
        this.message.setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("showclock")) {
            this.clock.setVisible(!this.clock.isVisible());
            Jetris.getConfig().writeKey("clockisvisible", this.clock.isVisible());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

