/*
 * Decompiled with CFR 0.152.
 */
package arcus.model;

import arcus.Main;
import java.awt.Color;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import javax.swing.UIManager;

public class Preferences
implements Serializable,
Cloneable {
    public static Preferences instance = new Preferences(true);
    public static Preferences backup = (Preferences)instance.clone();
    private HashMap<String, Object> data = new HashMap();

    public Preferences(boolean bl) {
        if (bl) {
            this.restoreFactoryData();
            this.load();
        }
    }

    public Object clone() {
        Preferences preferences = new Preferences(false);
        Set<String> set = this.data.keySet();
        for (String string : set) {
            preferences.data.put(string, this.data.get(string));
        }
        return preferences;
    }

    public Object set(String string, Object object) {
        return this.data.put(string, object);
    }

    public Object get(String string) {
        return this.data.get(string);
    }

    public int getInt(String string) {
        return (Integer)this.data.get(string);
    }

    public double getDouble(String string) {
        return (Double)this.data.get(string);
    }

    public boolean getBoolean(String string) {
        return (Boolean)this.data.get(string);
    }

    public void save() {
        if (Main.preferences == null) {
            return;
        }
        try {
            XMLEncoder xMLEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(Main.preferences)));
            xMLEncoder.writeObject(this.data);
            xMLEncoder.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Preferences.java: save failed. " + fileNotFoundException);
        }
    }

    public void load() {
        if (Main.preferences == null) {
            return;
        }
        try {
            XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(Main.preferences)));
            HashMap hashMap = (HashMap)xMLDecoder.readObject();
            xMLDecoder.close();
            Set set = hashMap.keySet();
            for (String string : set) {
                this.data.put(string, hashMap.get(string));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.restoreFactoryData();
        }
    }

    public void restoreFactoryData() {
        this.data.put("blackOut", new Double(0.5));
        this.data.put("faceletColor0", new Color(0.9f, 0.9f, 0.0f));
        this.data.put("faceletColor1", new Color(0.0f, 0.5f, 0.0f));
        this.data.put("faceletColor2", new Color(0.5f, 0.0f, 0.0f));
        this.data.put("faceletColor3", new Color(0.0f, 0.0f, 0.5f));
        this.data.put("faceletColor4", new Color(1.0f, 0.5f, 0.0f));
        this.data.put("faceletColor5", new Color(0.9f, 0.9f, 0.9f));
        this.data.put("allowDistortion", new Boolean(false));
        this.data.put("varyAngularVelocity", new Boolean(true));
        this.data.put("mouseButtonRotXY", new Integer(1));
        this.data.put("mouseButtonRotZ", new Integer(2));
        this.data.put("mouseButtonTurn", new Integer(3));
        this.data.put("animationSteps", new Integer(15));
        this.data.put("animationTime", new Integer(500));
        this.data.put("F", new String("F"));
        this.data.put("B", new String("B"));
        this.data.put("D", new String("D"));
        this.data.put("U", new String("U"));
        this.data.put("R", new String("R"));
        this.data.put("L", new String("L"));
        this.data.put("cwise", new String(""));
        this.data.put("ccwise", new String("'"));
        this.data.put("twice", new String("2"));
        this.data.put("outer", new String(""));
        this.data.put("inner", new String("i"));
        this.data.put("par", new String("p"));
        this.data.put("all", new String("a"));
        this.data.put("lookAndFeel", UIManager.getSystemLookAndFeelClassName());
        this.data.put("frameDecoration", new Boolean(true));
        this.data.put("browser", new String(""));
        this.data.put("enableToolTips", new Boolean(true));
        try {
            this.data.put("patternStorePath", System.getProperty("user.dir"));
            this.data.put("sessionPath", System.getProperty("user.home"));
        }
        catch (Exception exception) {
            this.data.put("patternStorePath", "");
            this.data.put("sessionPath", "");
        }
    }
}

