/*
 * Decompiled with CFR 0.152.
 */
package arcus.gui.ext;

import arcus.gui.Images;
import arcus.gui.ext.XFrame;
import arcus.gui.ext.XImageButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

class XTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final Image IMG_DETACH = Images.getImage("x");
    private static final Image IMG_DETACH_OVER = Images.getImage("x_over");
    private static final Image IMG_DETACH_PRESS = Images.getImage("x_press");
    private String frameTitle;
    private HashMap<Component, XFrame> detachedFrames = new HashMap();
    private ArrayList<XImageButton> detachButtons = new ArrayList();

    public XTabbedPaneUI(String string) {
        this.frameTitle = string;
    }

    public void remove(Component component) {
        XFrame xFrame = this.detachedFrames.remove(component);
        if (xFrame != null) {
            xFrame.dispose();
        }
    }

    public void detach(Component component) {
        this.detachButtons.get(this.tabPane.indexOfComponent(component)).doClick();
    }

    protected LayoutManager createLayoutManager() {
        return new XTabbedPaneLayout();
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = new Rectangle();
        rectangle2 = this.getTabBounds(n2, rectangle2);
        graphics.setColor(Color.BLACK);
        graphics.drawString(string, rectangle2.x + 5, rectangle2.y + rectangle2.height / 2 + graphics.getFontMetrics().getAscent() / 2);
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
    }

    protected Insets getTabInsets(int n, int n2) {
        Insets insets = (Insets)super.getTabInsets(n, n2).clone();
        insets.right += 25;
        insets.top += 4;
        insets.bottom += 4;
        return insets;
    }

    class XTabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        XTabbedPaneLayout() {
            super(XTabbedPaneUI.this);
        }

        public void layoutContainer(Container container) {
            int n;
            super.layoutContainer(container);
            while (XTabbedPaneUI.this.tabPane.getTabCount() > XTabbedPaneUI.this.detachButtons.size()) {
                XTabbedPaneUI.this.detachButtons.add(new DetachButton(XTabbedPaneUI.this.detachButtons.size()));
            }
            Rectangle rectangle = new Rectangle();
            for (n = 0; n < XTabbedPaneUI.this.tabPane.getTabCount(); ++n) {
                rectangle = XTabbedPaneUI.this.getTabBounds(n, rectangle);
                XImageButton xImageButton = (XImageButton)XTabbedPaneUI.this.detachButtons.get(n);
                xImageButton.setLocation(rectangle.x + rectangle.width - 20, rectangle.y + rectangle.height / 2 - 7);
                xImageButton.setSize(14, 14);
                XTabbedPaneUI.this.tabPane.add(xImageButton);
            }
            while (n < XTabbedPaneUI.this.detachButtons.size()) {
                XTabbedPaneUI.this.tabPane.remove((Component)XTabbedPaneUI.this.detachButtons.get(n));
                ++n;
            }
        }

        class DetachButton
        extends XImageButton
        implements UIResource {
            public DetachButton(final int n) {
                super(IMG_DETACH, IMG_DETACH_OVER, IMG_DETACH_PRESS);
                this.addPropertyChangeListener("click", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        final XFrame xFrame = new XFrame();
                        final Component component = XTabbedPaneUI.this.tabPane.getComponentAt(n);
                        Window window = SwingUtilities.windowForComponent(XTabbedPaneUI.this.tabPane);
                        xFrame.setName("COMPONENT_HOLDER");
                        xFrame.setTitle(XTabbedPaneUI.this.frameTitle + '@' + XTabbedPaneUI.this.tabPane.getTitleAt(n));
                        XTabbedPaneUI.this.tabPane.remove(n);
                        if (XTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                            XTabbedPaneUI.this.tabPane.firePropertyChange("zero_tab_count", 1, 0);
                        }
                        xFrame.add(component);
                        xFrame.setSize(component.getSize());
                        xFrame.setLocation(window.getLocation());
                        xFrame.setVisible(true);
                        xFrame.addWindowListener(new WindowAdapter(){

                            public void windowClosing(WindowEvent windowEvent) {
                                String string = xFrame.getTitle();
                                xFrame.dispose();
                                if (XTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                                    XTabbedPaneUI.this.tabPane.firePropertyChange("nonzero_tab_count", 0, 1);
                                }
                                XTabbedPaneUI.this.tabPane.insertTab(string.replaceFirst("^[^@]*@", ""), null, component, null, Math.min(n, XTabbedPaneUI.this.tabPane.getTabCount()));
                                XTabbedPaneUI.this.tabPane.setSelectedComponent(component);
                                XTabbedPaneUI.this.detachedFrames.remove(component);
                            }
                        });
                        XTabbedPaneUI.this.detachedFrames.put(component, xFrame);
                    }
                });
            }
        }
    }
}

