/*
 * Decompiled with CFR 0.152.
 */
package arcus.gui;

import arcus.gui.BasicGraphicsEngine;
import arcus.model.CubeEvent;
import arcus.model.CubeInstance;
import arcus.model.Notifiable;
import arcus.model.Preferences;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public class TurnableGraphicsEngine
extends BasicGraphicsEngine
implements Cloneable {
    private boolean drawLabels = false;
    private CubeInstance instance = null;
    private Timer timer;
    private String F = (String)Preferences.instance.get("F");
    private String B = (String)Preferences.instance.get("B");
    private String D = (String)Preferences.instance.get("D");
    private String U = (String)Preferences.instance.get("U");
    private String R = (String)Preferences.instance.get("R");
    private String L = (String)Preferences.instance.get("L");
    private int[] cubieBegin = null;
    private int[] normalBegin = null;
    private int[] cubieEnd = null;
    private int[] normalEnd = null;

    public TurnableGraphicsEngine() {
        this.highlight = true;
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "labels");
        this.getActionMap().put("labels", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TurnableGraphicsEngine.this.drawLabels = !TurnableGraphicsEngine.this.drawLabels;
                TurnableGraphicsEngine.this.repaint();
            }
        });
    }

    public void setInstance(CubeInstance cubeInstance) {
        this.instance = cubeInstance;
    }

    public Object clone() {
        TurnableGraphicsEngine turnableGraphicsEngine = new TurnableGraphicsEngine();
        turnableGraphicsEngine.setGraphicsDescriptor(this.getGraphicsDescriptor());
        return turnableGraphicsEngine;
    }

    public void turn(CubeEvent cubeEvent, Notifiable notifiable) {
        this.axisOfTurn = cubeEvent.axis;
        if (Preferences.instance.getBoolean("varyAngularVelocity")) {
            this.turnVaryAngularVelocity(cubeEvent, notifiable);
        } else {
            this.turnConstAngularVelocity(cubeEvent, notifiable);
        }
    }

    public void turnVaryAngularVelocity(final CubeEvent cubeEvent, final Notifiable notifiable) {
        final int n = Preferences.instance.getInt("animationSteps");
        this.timer = new Timer(Preferences.instance.getInt("animationTime") / n, new AbstractAction(){
            double D = n > 1 ? Math.PI / (double)(n - 1) : Math.PI;
            double sum = 0.0;
            double A;
            int sgn = 1;
            int cnt;
            int step = 0;
            {
                if (cubeEvent.dir < 0) {
                    this.sgn = -1;
                } else if (cubeEvent.dir == 0 && Math.random() < 0.5) {
                    this.sgn = -1;
                }
                for (int i = 0; i < n; ++i) {
                    this.sum += Math.sin((double)i * this.D);
                }
                this.cnt = cubeEvent.dir == -1 || cubeEvent.dir == 1 ? n : 2 * n;
                this.A = 1.5707963267948966 / ((double)n + 2.0 * this.sum);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n2;
                double d = (double)this.sgn * this.A * (1.0 + 2.0 * Math.sin((double)(this.step % n) * this.D));
                block10: for (n2 = 0; n2 < 27; ++n2) {
                    if (TurnableGraphicsEngine.this.cubies[n2].coord[cubeEvent.axis] != cubeEvent.layer) continue;
                    switch (cubeEvent.axis) {
                        case 0: {
                            TurnableGraphicsEngine.this.cubies[n2].rotX(d);
                            continue block10;
                        }
                        case 1: {
                            TurnableGraphicsEngine.this.cubies[n2].rotY(d);
                            continue block10;
                        }
                        case 2: {
                            TurnableGraphicsEngine.this.cubies[n2].rotZ(d);
                        }
                    }
                }
                TurnableGraphicsEngine.this.repaint();
                if (++this.step == this.cnt) {
                    TurnableGraphicsEngine.this.timer.stop();
                    block11: for (n2 = 0; n2 < 27; ++n2) {
                        if (TurnableGraphicsEngine.this.cubies[n2].coord[cubeEvent.axis] != cubeEvent.layer) continue;
                        switch (cubeEvent.axis) {
                            case 0: {
                                TurnableGraphicsEngine.this.cubies[n2].turnX(cubeEvent.dir);
                                continue block11;
                            }
                            case 1: {
                                TurnableGraphicsEngine.this.cubies[n2].turnY(cubeEvent.dir);
                                continue block11;
                            }
                            case 2: {
                                TurnableGraphicsEngine.this.cubies[n2].turnZ(cubeEvent.dir);
                            }
                        }
                    }
                    if (notifiable != null) {
                        notifiable.graphicsEngineReadyNotification();
                    }
                }
            }
        });
        this.timer.start();
    }

    public void turnConstAngularVelocity(final CubeEvent cubeEvent, final Notifiable notifiable) {
        final int n = Preferences.instance.getInt("animationSteps");
        this.timer = new Timer(Preferences.instance.getInt("animationTime") / n, new AbstractAction(){
            int cnt;
            double a;
            {
                switch (cubeEvent.dir) {
                    case -1: {
                        this.cnt = n;
                        this.a = -1.5707963267948966 / (double)n;
                        break;
                    }
                    case -2: {
                        this.cnt = 2 * n;
                        this.a = -1.5707963267948966 / (double)n;
                        break;
                    }
                    case 0: {
                        this.cnt = 2 * n;
                        if (Math.random() < 0.5) {
                            this.a = 1.5707963267948966 / (double)n;
                            break;
                        }
                        this.a = -1.5707963267948966 / (double)n;
                        break;
                    }
                    case 2: {
                        this.cnt = 2 * n;
                        this.a = 1.5707963267948966 / (double)n;
                        break;
                    }
                    case 1: {
                        this.cnt = n;
                        this.a = 1.5707963267948966 / (double)n;
                    }
                }
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n2;
                block10: for (n2 = 0; n2 < 27; ++n2) {
                    if (TurnableGraphicsEngine.this.cubies[n2].coord[cubeEvent.axis] != cubeEvent.layer) continue;
                    switch (cubeEvent.axis) {
                        case 0: {
                            TurnableGraphicsEngine.this.cubies[n2].rotX(this.a);
                            continue block10;
                        }
                        case 1: {
                            TurnableGraphicsEngine.this.cubies[n2].rotY(this.a);
                            continue block10;
                        }
                        case 2: {
                            TurnableGraphicsEngine.this.cubies[n2].rotZ(this.a);
                        }
                    }
                }
                TurnableGraphicsEngine.this.repaint();
                if (--this.cnt == 0) {
                    TurnableGraphicsEngine.this.timer.stop();
                    block11: for (n2 = 0; n2 < 27; ++n2) {
                        if (TurnableGraphicsEngine.this.cubies[n2].coord[cubeEvent.axis] != cubeEvent.layer) continue;
                        switch (cubeEvent.axis) {
                            case 0: {
                                TurnableGraphicsEngine.this.cubies[n2].turnX(cubeEvent.dir);
                                continue block11;
                            }
                            case 1: {
                                TurnableGraphicsEngine.this.cubies[n2].turnY(cubeEvent.dir);
                                continue block11;
                            }
                            case 2: {
                                TurnableGraphicsEngine.this.cubies[n2].turnZ(cubeEvent.dir);
                            }
                        }
                    }
                    if (notifiable != null) {
                        notifiable.graphicsEngineReadyNotification();
                    }
                }
            }
        });
        this.timer.start();
    }

    public void jump(CubeEvent cubeEvent, Notifiable notifiable) {
        this.axisOfTurn = cubeEvent.axis;
        double d = 0.0;
        switch (cubeEvent.dir) {
            case -1: {
                d = -1.5707963267948966;
                break;
            }
            case -2: 
            case 0: 
            case 2: {
                d = Math.PI;
                break;
            }
            case 1: {
                d = 1.5707963267948966;
            }
        }
        int n = cubeEvent.axis;
        int n2 = cubeEvent.layer;
        int n3 = cubeEvent.dir;
        block10: for (int i = 0; i < 27; ++i) {
            if (this.cubies[i].coord[n] != n2) continue;
            switch (n) {
                case 0: {
                    this.cubies[i].turnX(n3);
                    this.cubies[i].rotX(d);
                    continue block10;
                }
                case 1: {
                    this.cubies[i].turnY(n3);
                    this.cubies[i].rotY(d);
                    continue block10;
                }
                case 2: {
                    this.cubies[i].turnZ(n3);
                    this.cubies[i].rotZ(d);
                }
            }
        }
        if (notifiable != null) {
            notifiable.graphicsEngineReadyNotification();
        }
    }

    public boolean isBusy() {
        return this.timer != null && this.timer.isRunning();
    }

    public void consolePrefChanged() {
        this.F = (String)Preferences.instance.get("F");
        this.B = (String)Preferences.instance.get("B");
        this.D = (String)Preferences.instance.get("D");
        this.U = (String)Preferences.instance.get("U");
        this.R = (String)Preferences.instance.get("R");
        this.L = (String)Preferences.instance.get("L");
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        Shape shape;
        float f;
        float f2;
        TextLayout textLayout;
        this.highlight = this.instance.getState() == 0;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(Color.GRAY);
        graphics2D.drawLine(0, 0, this.dim.width, 0);
        if (!this.drawLabels) {
            return;
        }
        graphics2D.setStroke(new BasicStroke(2.0f, 1, 1));
        Font font = new Font("Sans", 1, (int)(Math.sqrt(this.ratioX * this.ratioY) * 12.0 / 100.0));
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        if (this.axis[0][2] > 0.0) {
            textLayout = new TextLayout(this.R, font, fontRenderContext);
            f2 = (float)textLayout.getBounds().getWidth();
            f = (float)textLayout.getBounds().getHeight();
            shape = textLayout.getOutline(AffineTransform.getTranslateInstance((double)this.centerX + (this.ratioX * this.axis[0][0] - (double)f2) / 2.0, (double)this.centerY + (this.ratioY * this.axis[0][1] + (double)f) / 2.0));
            graphics2D.setColor(Color.BLACK);
            graphics2D.draw(shape);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(shape);
        }
        if (-this.axis[0][2] > 0.0) {
            textLayout = new TextLayout(this.L, font, fontRenderContext);
            f2 = (float)textLayout.getBounds().getWidth();
            f = (float)textLayout.getBounds().getHeight();
            shape = textLayout.getOutline(AffineTransform.getTranslateInstance((double)this.centerX - (this.ratioX * this.axis[0][0] + (double)f2) / 2.0, (double)this.centerY - (this.ratioY * this.axis[0][1] - (double)f) / 2.0));
            graphics2D.setColor(Color.BLACK);
            graphics2D.draw(shape);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(shape);
        }
        if (this.axis[1][2] > 0.0) {
            textLayout = new TextLayout(this.U, font, fontRenderContext);
            f2 = (float)textLayout.getBounds().getWidth();
            f = (float)textLayout.getBounds().getHeight();
            shape = textLayout.getOutline(AffineTransform.getTranslateInstance((double)this.centerX + (this.ratioX * this.axis[1][0] - (double)f2) / 2.0, (double)this.centerY + (this.ratioY * this.axis[1][1] + (double)f) / 2.0));
            graphics2D.setColor(Color.BLACK);
            graphics2D.draw(shape);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(shape);
        }
        if (-this.axis[1][2] > 0.0) {
            textLayout = new TextLayout(this.D, font, fontRenderContext);
            f2 = (float)textLayout.getBounds().getWidth();
            f = (float)textLayout.getBounds().getHeight();
            shape = textLayout.getOutline(AffineTransform.getTranslateInstance((double)this.centerX - (this.ratioX * this.axis[1][0] + (double)f2) / 2.0, (double)this.centerY - (this.ratioY * this.axis[1][1] - (double)f) / 2.0));
            graphics2D.setColor(Color.BLACK);
            graphics2D.draw(shape);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(shape);
        }
        if (this.axis[2][2] > 0.0) {
            textLayout = new TextLayout(this.F, font, fontRenderContext);
            f2 = (float)textLayout.getBounds().getWidth();
            f = (float)textLayout.getBounds().getHeight();
            shape = textLayout.getOutline(AffineTransform.getTranslateInstance((double)this.centerX + (this.ratioX * this.axis[2][0] - (double)f2) / 2.0, (double)this.centerY + (this.ratioY * this.axis[2][1] + (double)f) / 2.0));
            graphics2D.setColor(Color.BLACK);
            graphics2D.draw(shape);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(shape);
        }
        if (-this.axis[2][2] > 0.0) {
            textLayout = new TextLayout(this.B, font, fontRenderContext);
            f2 = (float)textLayout.getBounds().getWidth();
            f = (float)textLayout.getBounds().getHeight();
            shape = textLayout.getOutline(AffineTransform.getTranslateInstance((double)this.centerX - (this.ratioX * this.axis[2][0] + (double)f2) / 2.0, (double)this.centerY - (this.ratioY * this.axis[2][1] - (double)f) / 2.0));
            graphics2D.setColor(Color.BLACK);
            graphics2D.draw(shape);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(shape);
        }
    }

    public float getEntropy() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        HashSet<Integer> hashSet3 = new HashSet<Integer>();
        HashSet<Integer> hashSet4 = new HashSet<Integer>();
        HashSet<Integer> hashSet5 = new HashSet<Integer>();
        HashSet<Integer> hashSet6 = new HashSet<Integer>();
        for (int i = 0; i < 27; ++i) {
            hashSet.add(new Integer(this.cubies[i].colorAtNormal(0, 1, 0)));
            hashSet2.add(new Integer(this.cubies[i].colorAtNormal(0, -1, 0)));
            hashSet3.add(new Integer(this.cubies[i].colorAtNormal(0, 0, 1)));
            hashSet4.add(new Integer(this.cubies[i].colorAtNormal(0, 0, -1)));
            hashSet5.add(new Integer(this.cubies[i].colorAtNormal(-1, 0, 0)));
            hashSet6.add(new Integer(this.cubies[i].colorAtNormal(1, 0, 0)));
        }
        hashSet.remove(-1);
        hashSet2.remove(-1);
        hashSet3.remove(-1);
        hashSet4.remove(-1);
        hashSet5.remove(-1);
        hashSet6.remove(-1);
        return (float)(hashSet.size() + hashSet2.size() + hashSet3.size() + hashSet4.size() + hashSet5.size() + hashSet6.size()) / 6.0f;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        block5: {
            block4: {
                super.mousePressed(mouseEvent);
                this.repaint();
                if (this.mouseButton != Preferences.instance.getInt("mouseButtonTurn")) break block4;
                if (this.instance.getState() == 0) break block5;
            }
            return;
        }
        this.cubieBegin = null;
        this.cubieEnd = null;
        this.normalBegin = null;
        this.normalEnd = null;
        for (int i = 0; i < 27; ++i) {
            for (int j = 0; j < 6; ++j) {
                int[] nArray;
                double d = this.cubies[i].normal[j][0] * this.axis[0][2] + this.cubies[i].normal[j][1] * this.axis[1][2] + this.cubies[i].normal[j][2] * this.axis[2][2];
                if (d <= 0.0) continue;
                int[] nArray2 = new int[]{this.cubies[i].transformX(this.cubies[i].vertex[vtxOfSide[j][0]]), this.cubies[i].transformX(this.cubies[i].vertex[vtxOfSide[j][1]]), this.cubies[i].transformX(this.cubies[i].vertex[vtxOfSide[j][2]]), this.cubies[i].transformX(this.cubies[i].vertex[vtxOfSide[j][3]])};
                if (!this.cubies[i].contains(nArray2, nArray = new int[]{this.cubies[i].transformY(this.cubies[i].vertex[vtxOfSide[j][0]]), this.cubies[i].transformY(this.cubies[i].vertex[vtxOfSide[j][1]]), this.cubies[i].transformY(this.cubies[i].vertex[vtxOfSide[j][2]]), this.cubies[i].transformY(this.cubies[i].vertex[vtxOfSide[j][3]])}, this.mouseX, this.mouseY) || this.cubies[i].colors[j] == -1) continue;
                this.cubieBegin = this.cubies[i].coord;
                this.normalBegin = new int[3];
                this.normalBegin[0] = (int)Math.round(this.cubies[i].normal[j][0]);
                this.normalBegin[1] = (int)Math.round(this.cubies[i].normal[j][1]);
                this.normalBegin[2] = (int)Math.round(this.cubies[i].normal[j][2]);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        block25: {
            int n;
            int n2;
            block26: {
                super.mouseReleased(mouseEvent);
                this.mouseButton = 0;
                this.repaint();
                if (mouseEvent.getButton() != Preferences.instance.getInt("mouseButtonTurn") || this.instance.getState() != 0) {
                    return;
                }
                for (n2 = 0; n2 < 27; ++n2) {
                    for (n = 0; n < 6; ++n) {
                        int[] nArray;
                        double d = this.cubies[n2].normal[n][0] * this.axis[0][2] + this.cubies[n2].normal[n][1] * this.axis[1][2] + this.cubies[n2].normal[n][2] * this.axis[2][2];
                        if (d <= 0.0) continue;
                        int[] nArray2 = new int[]{this.cubies[n2].transformX(this.cubies[n2].vertex[vtxOfSide[n][0]]), this.cubies[n2].transformX(this.cubies[n2].vertex[vtxOfSide[n][1]]), this.cubies[n2].transformX(this.cubies[n2].vertex[vtxOfSide[n][2]]), this.cubies[n2].transformX(this.cubies[n2].vertex[vtxOfSide[n][3]])};
                        if (!this.cubies[n2].contains(nArray2, nArray = new int[]{this.cubies[n2].transformY(this.cubies[n2].vertex[vtxOfSide[n][0]]), this.cubies[n2].transformY(this.cubies[n2].vertex[vtxOfSide[n][1]]), this.cubies[n2].transformY(this.cubies[n2].vertex[vtxOfSide[n][2]]), this.cubies[n2].transformY(this.cubies[n2].vertex[vtxOfSide[n][3]])}, this.mouseX, this.mouseY) || this.cubies[n2].colors[n] == -1) continue;
                        this.cubieEnd = this.cubies[n2].coord;
                        this.normalEnd = new int[3];
                        this.normalEnd[0] = (int)Math.round(this.cubies[n2].normal[n][0]);
                        this.normalEnd[1] = (int)Math.round(this.cubies[n2].normal[n][1]);
                        this.normalEnd[2] = (int)Math.round(this.cubies[n2].normal[n][2]);
                    }
                }
                if (this.cubieBegin == null || this.cubieEnd == null) break block25;
                if (!Arrays.equals(this.normalBegin, this.normalEnd)) break block26;
                if (Arrays.equals(this.cubieBegin, this.cubieEnd)) {
                    return;
                }
                n2 = 0;
                for (n2 = 0; n2 < 3 && this.normalBegin[n2] == 0; ++n2) {
                }
                n = 0;
                for (n = 0; n < 3 && (n2 == n || this.cubieBegin[n] != this.cubieEnd[n]); ++n) {
                }
                if (n == 3) {
                    return;
                }
                int[] nArray = new int[]{this.cubieEnd[0] - this.cubieBegin[0], this.cubieEnd[1] - this.cubieBegin[1], this.cubieEnd[2] - this.cubieBegin[2]};
                if (nArray[0] != 0) {
                    if (this.normalBegin[1] > 0) {
                        this.instance.addEvent(new CubeEvent(n, this.cubieBegin[n], -nArray[0], 0, true));
                    }
                    if (this.normalBegin[1] < 0) {
                        this.instance.addEvent(new CubeEvent(n, this.cubieBegin[n], nArray[0], 0, true));
                    }
                    if (this.normalBegin[2] > 0) {
                        this.instance.addEvent(new CubeEvent(n, this.cubieBegin[n], nArray[0], 0, true));
                    }
                    if (this.normalBegin[2] < 0) {
                        this.instance.addEvent(new CubeEvent(n, this.cubieBegin[n], -nArray[0], 0, true));
                    }
                }
                if (nArray[1] != 0) {
                    if (this.normalBegin[0] > 0) {
                        this.instance.addEvent(new CubeEvent(n, this.cubieBegin[n], nArray[1], 0, true));
                    }
                    if (this.normalBegin[0] < 0) {
                        this.instance.addEvent(new CubeEvent(n, this.cubieBegin[n], -nArray[1], 0, true));
                    }
                    if (this.normalBegin[2] > 0) {
                        this.instance.addEvent(new CubeEvent(n, this.cubieBegin[n], -nArray[1], 0, true));
                    }
                    if (this.normalBegin[2] < 0) {
                        this.instance.addEvent(new CubeEvent(n, this.cubieBegin[n], nArray[1], 0, true));
                    }
                }
                if (nArray[2] == 0) break block25;
                if (this.normalBegin[0] > 0) {
                    this.instance.addEvent(new CubeEvent(n, this.cubieBegin[n], -nArray[2], 0, true));
                }
                if (this.normalBegin[0] < 0) {
                    this.instance.addEvent(new CubeEvent(n, this.cubieBegin[n], nArray[2], 0, true));
                }
                if (this.normalBegin[1] > 0) {
                    this.instance.addEvent(new CubeEvent(n, this.cubieBegin[n], nArray[2], 0, true));
                }
                if (this.normalBegin[1] >= 0) break block25;
                this.instance.addEvent(new CubeEvent(n, this.cubieBegin[n], -nArray[2], 0, true));
                break block25;
            }
            for (n2 = 0; n2 < 3; ++n2) {
                if (this.normalBegin[n2] != this.normalEnd[n2]) continue;
                n = 0;
                if (n2 == 0) {
                    n = this.normalBegin[1] == this.normalEnd[2] && this.normalBegin[2] == -this.normalEnd[1] ? 1 : -1;
                }
                if (n2 == 1) {
                    n = this.normalBegin[0] == -this.normalEnd[2] && this.normalBegin[2] == this.normalEnd[0] ? 1 : -1;
                }
                if (n2 == 2) {
                    n = this.normalBegin[0] == this.normalEnd[1] && this.normalBegin[1] == -this.normalEnd[0] ? 1 : -1;
                }
                if (!this.cubieBegin.equals(this.cubieEnd)) {
                    n *= 2;
                }
                this.instance.addEvent(new CubeEvent(n2, this.cubieBegin[n2], n, 0, true));
            }
        }
    }
}

