/*
 * Decompiled with CFR 0.152.
 */
package arcus.gui;

import arcus.I18N;
import arcus.gui.BasicGraphicsEngine;
import arcus.gui.Images;
import arcus.model.GraphicsDescriptor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PatternGrabber
extends JDialog {
    public static PatternGrabber instance = new PatternGrabber();
    private BasicGraphicsEngine graphicsEngine = new BasicGraphicsEngine();
    private Action cancelAction = null;
    private JButton okButton;
    private boolean active = false;

    public PatternGrabber() {
        this.setTitle(I18N.get("PatternGrabber.title"));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel();
        this.okButton = new JButton();
        jPanel.add(this.okButton);
        jPanel.add(new JButton(new AbstractAction(I18N.get("Button.cancel"), Images.getImageIcon("cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                PatternGrabber.this.active = false;
                PatternGrabber.this.setVisible(false);
                if (PatternGrabber.this.cancelAction != null) {
                    PatternGrabber.this.cancelAction.actionPerformed(null);
                }
            }
        }));
        this.graphicsEngine.setPreferredSize(new Dimension(200, 200));
        this.graphicsEngine.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        JLabel jLabel = new JLabel(I18N.get("PatternGrabber.selected") + ":");
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.add((Component)jLabel, "First");
        this.add((Component)this.graphicsEngine, "Center");
        this.add((Component)jPanel, "Last");
        this.pack();
    }

    public void activate(Action action, Action action2) {
        this.okButton.setAction(action);
        this.cancelAction = action2;
        this.pack();
        this.active = true;
    }

    public boolean getActive() {
        return this.active;
    }

    public void delete() {
        this.setVisible(false);
        this.active = false;
    }

    public void grab(GraphicsDescriptor graphicsDescriptor) {
        this.graphicsEngine.setGraphicsDescriptor(graphicsDescriptor);
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    public boolean isValid() {
        return this.graphicsEngine.verifyPattern();
    }

    public GraphicsDescriptor getGraphicsDescriptor() {
        return this.graphicsEngine.getGraphicsDescriptor();
    }
}

