/*
 * Decompiled with CFR 0.152.
 */
package arcus.gui;

import arcus.I18N;
import arcus.gui.Images;
import arcus.gui.PrefUI;
import arcus.model.CubeEvent;
import arcus.model.CubeInstance;
import arcus.model.CubeStateDescriptor;
import arcus.model.GraphDataDescriptor;
import arcus.model.Notifiable;
import arcus.model.PrefListener;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;

public class History
extends JPanel
implements Cloneable,
PrefListener {
    private JLabel cursorPosLabel;
    private JLabel cursorValLabel;
    private JLabel progBarLabel;
    private JProgressBar progBar = new JProgressBar();
    private JScrollPane scrollPane;
    private BoundedRangeModel scrollBarModel;
    private Graph graph;
    private RowHeader rowHeader;
    private CubeInstance instance = null;
    private Vector<CubeStateDescriptor> elements = new Vector();
    private int cursorPos = 0;
    private boolean stop = false;
    private boolean drawGrid = false;
    private static final float MAX = 6.0f;
    private int HEAD = 20;
    private int FOOT = 20;
    private int DATAW = 8;
    private int GAP = 3;
    private static final Color gridColor = new Color(0.8f, 0.8f, 0.8f);

    public History() {
        super(new BorderLayout());
        PrefUI.instance.addConsolePrefListener(this);
        JButton jButton = new JButton(new AbstractAction(null, Images.getImageIcon("zoom_in")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (History.this.DATAW >= 32) {
                    return;
                }
                int n = History.this.scrollBarModel.getValue() / (History.this.DATAW + History.this.GAP);
                History.this.DATAW += 4;
                History.this.scrollPane.getHorizontalScrollBar().setUnitIncrement(History.this.DATAW + History.this.GAP);
                History.this.scrollPane.getHorizontalScrollBar().setBlockIncrement(10 * (History.this.DATAW + History.this.GAP));
                History.this.scrollBarModel.setValue(n * (History.this.DATAW + History.this.GAP));
                History.this.graph.repaint();
                History.this.graph.revalidate();
            }
        }){
            {
                this.setToolTipText(I18N.get("History.zoom.in"));
            }
        };
        JButton jButton2 = new JButton(new AbstractAction(null, Images.getImageIcon("zoom_out")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (History.this.DATAW - 4 <= 0) {
                    return;
                }
                int n = History.this.scrollBarModel.getValue() / (History.this.DATAW + History.this.GAP);
                History.this.DATAW -= 4;
                History.this.scrollPane.getHorizontalScrollBar().setUnitIncrement(History.this.DATAW + History.this.GAP);
                History.this.scrollPane.getHorizontalScrollBar().setBlockIncrement(10 * (History.this.DATAW + History.this.GAP));
                History.this.scrollBarModel.setValue(n * (History.this.DATAW + History.this.GAP));
                History.this.graph.repaint();
                History.this.graph.revalidate();
            }
        }){
            {
                this.setToolTipText(I18N.get("History.zoom.out"));
            }
        };
        JToggleButton jToggleButton = new JToggleButton(new AbstractAction(null, Images.getImageIcon("grid")){

            public void actionPerformed(ActionEvent actionEvent) {
                History.this.drawGrid = !History.this.drawGrid;
                History.this.rowHeader.repaint();
                History.this.graph.repaint();
            }
        }){
            {
                this.setToolTipText(I18N.get("History.toggle.grid"));
            }
        };
        JButton jButton3 = new JButton(new AbstractAction(null, Images.getImageIcon("cut")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (History.this.elements.size() > History.this.cursorPos + 1) {
                    History.this.instance.setModified(true);
                }
                while (History.this.elements.size() > History.this.cursorPos + 1) {
                    History.this.elements.removeElementAt(History.this.elements.size() - 1);
                }
                History.this.graph.revalidate();
                History.this.graph.repaint();
            }
        }){
            {
                this.setToolTipText(I18N.get("History.trim"));
            }
        };
        JButton jButton4 = new JButton(new NextAction()){
            {
                this.setToolTipText(I18N.get("History.next"));
            }
        };
        JButton jButton5 = new JButton(new PrevAction()){
            {
                this.setToolTipText(I18N.get("History.prev"));
            }
        };
        JButton jButton6 = new JButton(new PlayFwdAction()){
            {
                this.setToolTipText(I18N.get("History.play.fwd"));
            }
        };
        JButton jButton7 = new JButton(new PlayBwdAction()){
            {
                this.setToolTipText(I18N.get("History.play.bwd"));
            }
        };
        JButton jButton8 = new JButton(new AbstractAction(null, Images.getImageIcon("stop")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (History.this.instance.getState() == 1 && History.this.instance.isCurrentEventNull()) {
                    History.this.stop = true;
                }
                History.this.instance.stop();
            }
        }){
            {
                this.setToolTipText(I18N.get("History.stop"));
            }
        };
        this.cursorPosLabel = new JLabel("0", 0);
        this.cursorPosLabel.setFont(new Font("Sans", 0, 16));
        this.cursorPosLabel.setMaximumSize(new Dimension(50, 28));
        this.cursorPosLabel.setPreferredSize(new Dimension(50, 28));
        this.cursorPosLabel.setMinimumSize(new Dimension(50, 28));
        this.cursorPosLabel.setBorder(BorderFactory.createEtchedBorder(1));
        this.cursorPosLabel.setToolTipText(I18N.get("History.cursorpos"));
        this.cursorValLabel = new JLabel("0", 0);
        this.cursorValLabel.setFont(new Font("Sans", 0, 16));
        this.cursorValLabel.setMaximumSize(new Dimension(50, 28));
        this.cursorValLabel.setPreferredSize(new Dimension(50, 28));
        this.cursorValLabel.setMinimumSize(new Dimension(50, 28));
        this.cursorValLabel.setBorder(BorderFactory.createEtchedBorder(1));
        this.cursorValLabel.setToolTipText(I18N.get("History.turn"));
        JToolBar jToolBar = new JToolBar(I18N.get("History.toolbar.nav"));
        jToolBar.add(jButton);
        jToolBar.add(jButton2);
        jToolBar.add(jToggleButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton3);
        jToolBar.addSeparator();
        jToolBar.add(this.cursorPosLabel);
        jToolBar.add(this.cursorValLabel);
        jToolBar.addSeparator();
        jToolBar.add(new JButton(new AbstractAction(null, Images.getImageIcon("first")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (History.this.instance.getState() == 1) {
                    return;
                }
                History.this.cursorPos = 0;
                History.this.selectState(History.this.cursorPos);
                History.this.scrollBarModel.setValue(0);
                History.this.graph.repaint();
            }
        }){
            {
                this.setToolTipText(I18N.get("History.entry.first"));
            }
        });
        jToolBar.add(new JButton(new AbstractAction(null, Images.getImageIcon("last")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (History.this.instance.getState() == 1) {
                    return;
                }
                History.this.cursorPos = History.this.elements.size() - 1;
                History.this.selectState(History.this.cursorPos);
                History.this.scrollBarModel.setValue(Integer.MAX_VALUE);
                History.this.graph.repaint();
            }
        }){
            {
                this.setToolTipText(I18N.get("History.entry.last"));
            }
        });
        jToolBar.addSeparator();
        jToolBar.add(jButton5);
        jToolBar.add(jButton7);
        jToolBar.add(jButton8);
        jToolBar.add(jButton6);
        jToolBar.add(jButton4);
        this.add((Component)jToolBar, "First");
        JButton jButton9 = new JButton(new AbstractAction(null, Images.getImageIcon("delete")){

            public void actionPerformed(ActionEvent actionEvent) {
                History.this.instance.removeAllEvents();
                History.this.updateProgBar(0);
            }
        }){
            {
                this.setToolTipText(I18N.get("History.buffer.delete"));
            }
        };
        JButton jButton10 = new JButton(new AbstractAction(null, Images.getImageIcon("flush")){

            public void actionPerformed(ActionEvent actionEvent) {
                History.this.instance.flush();
            }
        }){
            {
                this.setToolTipText(I18N.get("History.buffer.flush"));
            }
        };
        jButton9.setText("");
        jButton10.setText("");
        this.progBarLabel = new JLabel("0", 0);
        this.progBarLabel.setFont(new Font("Sans", 0, 16));
        this.progBarLabel.setMaximumSize(new Dimension(50, 28));
        this.progBarLabel.setPreferredSize(new Dimension(50, 28));
        this.progBarLabel.setMinimumSize(new Dimension(50, 28));
        this.progBarLabel.setBorder(BorderFactory.createEtchedBorder(1));
        this.progBarLabel.setToolTipText(I18N.get("History.buffer.size"));
        JToolBar jToolBar2 = new JToolBar(I18N.get("History.toolbar.buffer"));
        jToolBar2.add(this.progBar);
        jToolBar2.addSeparator();
        jToolBar2.add(this.progBarLabel);
        jToolBar2.addSeparator();
        jToolBar2.add(jButton9);
        jToolBar2.add(jButton10);
        this.add((Component)jToolBar2, "Last");
        this.graph = new Graph();
        this.rowHeader = new RowHeader();
        this.scrollPane = new JScrollPane(this.graph);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setRowHeaderView(this.rowHeader);
        this.scrollPane.setCorner("LOWER_LEFT_CORNER", new JButton(new AbstractAction(null, Images.getImageIcon("show_cursor")){

            public void actionPerformed(ActionEvent actionEvent) {
                History.this.scrollBarModel.setValue(History.this.cursorPos * (History.this.DATAW + History.this.GAP) - (History.this.scrollBarModel.getExtent() - History.this.DATAW - History.this.GAP) / 2);
                History.this.graph.repaint();
                History.this.graph.revalidate();
            }
        }){
            {
                this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 1, Color.GRAY));
                this.setToolTipText(I18N.get("History.scroll.to.cursor"));
            }
        });
        this.scrollBarModel = this.scrollPane.getHorizontalScrollBar().getModel();
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(this.DATAW + this.GAP);
        this.scrollPane.getHorizontalScrollBar().setBlockIncrement(10 * (this.DATAW + this.GAP));
        this.add((Component)this.scrollPane, "Center");
        this.setPreferredSize(new Dimension(500, 300));
    }

    public void init() {
        CubeStateDescriptor cubeStateDescriptor = new CubeStateDescriptor();
        cubeStateDescriptor.graphDataDesc = new GraphDataDescriptor(1.0f);
        cubeStateDescriptor.graphicsDesc = this.instance.graphicsEngine.getGraphicsDescriptor();
        cubeStateDescriptor.event = new CubeEvent(0, 0, 0, -1, false){

            public String toString() {
                return " ";
            }
        };
        this.addElement(cubeStateDescriptor);
    }

    public Object clone() {
        History history = new History();
        history.elements = (Vector)this.elements.clone();
        history.cursorPos = this.cursorPos;
        history.HEAD = this.HEAD;
        history.FOOT = this.FOOT;
        history.DATAW = this.DATAW;
        history.GAP = this.GAP;
        return history;
    }

    public void setInstance(CubeInstance cubeInstance) {
        this.instance = cubeInstance;
    }

    public boolean isCursorAtEnd() {
        return this.cursorPos == this.elements.size() - 1;
    }

    public void seekToEnd() {
        this.cursorPos = this.elements.size() - 1;
        this.selectState(this.cursorPos);
    }

    public void addElement(CubeStateDescriptor cubeStateDescriptor) {
        this.elements.add(cubeStateDescriptor);
        this.cursorPos = this.elements.size() - 1;
        this.updateCursorLabel(cubeStateDescriptor.event.toString());
        this.updateProgBar(this.instance.getBufferSize());
        this.graph.revalidate();
        this.scrollBarModel.setValue(Integer.MAX_VALUE);
        this.instance.setModified(true);
    }

    public void setBufferSize(int n) {
        this.progBar.setMaximum(n);
        this.updateProgBar(n);
    }

    private void updateCursorLabel(String string) {
        this.cursorPosLabel.setText(new Integer(this.cursorPos).toString());
        this.cursorValLabel.setText(string);
    }

    private void updateProgBar(int n) {
        this.progBar.setValue(n);
        this.progBarLabel.setText(new Integer(n).toString());
    }

    private void selectState(int n) {
        CubeStateDescriptor cubeStateDescriptor = this.elements.get(n);
        this.updateCursorLabel(cubeStateDescriptor.event.toString());
        this.instance.graphicsEngine.setGraphicsDescriptor(cubeStateDescriptor.graphicsDesc);
    }

    public void displayPrefChanged() {
    }

    public void consolePrefChanged() {
        this.graph.repaint();
        this.updateCursorLabel(this.elements.get((int)this.cursorPos).event.toString());
    }

    public void save(XMLEncoder xMLEncoder) {
        xMLEncoder.setPersistenceDelegate(CubeEvent.class, CubeEvent.getPersistenceDelegate());
        xMLEncoder.writeObject(new Integer(this.elements.size() - 1));
        for (int i = 1; i < this.elements.size(); ++i) {
            xMLEncoder.writeObject(this.elements.get((int)i).event);
        }
    }

    public void load(XMLDecoder xMLDecoder) {
        int n = (Integer)xMLDecoder.readObject();
        for (int i = 0; i < n; ++i) {
            this.instance.storeEvent((CubeEvent)xMLDecoder.readObject());
        }
        this.instance.flushEventQueue();
    }

    private class Graph
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private final Color paintHand1 = new Color(0.25f, 1.0f, 0.25f);
        private final Color paintHand2 = new Color(0.1f, 0.25f, 0.1f);
        private final Color paintScramble1 = new Color(1.0f, 0.25f, 0.25f);
        private final Color paintScramble2 = new Color(0.25f, 0.1f, 0.1f);
        private final Color paintSolve1 = new Color(0.25f, 0.25f, 1.0f);
        private final Color paintSolve2 = new Color(0.1f, 0.1f, 0.25f);
        private final Color paintConsole1 = new Color(1.0f, 0.5f, 0.0f);
        private final Color paintConsole2 = new Color(0.5f, 0.25f, 0.0f);
        private final Color paintDefault1 = new Color(1.0f, 1.0f, 1.0f);
        private final Color paintDefault2 = new Color(0.5f, 0.5f, 0.5f);
        private final Color cursorColor = new Color(0.7f, 0.7f, 0.7f, 0.5f);
        private final Font font = new Font("Sans", 0, 9);

        public Graph() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setOpaque(true);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public Dimension getPreferredSize() {
            return new Dimension((History.this.DATAW + History.this.GAP) * (History.this.elements.size() + 1), History.this.HEAD + History.this.FOOT);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() / (History.this.DATAW + History.this.GAP);
            if (n > 0 && n < History.this.elements.size()) {
                return n + "  " + ((CubeStateDescriptor)((History)History.this).elements.get((int)n)).event;
            }
            return null;
        }

        public void paintComponent(Graphics graphics) {
            int n;
            int n2;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
            graphics2D.translate(2, 0);
            Rectangle rectangle = graphics2D.getClipBounds();
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fill(rectangle);
            if (History.this.drawGrid) {
                graphics2D.setPaint(gridColor);
                n2 = 0;
                while ((float)n2 <= 6.0f) {
                    graphics2D.drawLine(rectangle.x, History.this.HEAD + (int)((float)(this.getSize().height - History.this.HEAD - History.this.FOOT) / 6.0f * (float)n2), rectangle.x + rectangle.width, History.this.HEAD + (int)((float)(this.getSize().height - History.this.HEAD - History.this.FOOT) / 6.0f * (float)n2));
                    ++n2;
                }
            }
            for (n2 = 0; n2 < History.this.elements.size(); ++n2) {
                if (n2 * (History.this.DATAW + History.this.GAP) > rectangle.x + rectangle.width || n2 * (History.this.DATAW + History.this.GAP) + History.this.DATAW < rectangle.x) continue;
                switch (((CubeStateDescriptor)((History)History.this).elements.get((int)n2)).event.type) {
                    case 0: {
                        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.paintHand1, 0.0f, this.getSize().height, this.paintHand2));
                        break;
                    }
                    case 1: {
                        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.paintScramble1, 0.0f, this.getSize().height, this.paintScramble2));
                        break;
                    }
                    case 2: {
                        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.paintSolve1, 0.0f, this.getSize().height, this.paintSolve2));
                        break;
                    }
                    case 3: {
                        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.paintConsole1, 0.0f, this.getSize().height, this.paintConsole2));
                        break;
                    }
                    default: {
                        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.paintDefault1, 0.0f, this.getSize().height, this.paintDefault2));
                    }
                }
                graphics2D.fillRoundRect(n2 * (History.this.DATAW + History.this.GAP), History.this.HEAD + (int)((double)(this.getSize().height - History.this.HEAD - History.this.FOOT) * (1.0 - (double)(((CubeStateDescriptor)((History)History.this).elements.get((int)n2)).graphDataDesc.value / 6.0f))), History.this.DATAW, (int)((float)(this.getSize().height - History.this.HEAD - History.this.FOOT) * (((CubeStateDescriptor)((History)History.this).elements.get((int)n2)).graphDataDesc.value / 6.0f)) + 1, 5, 5);
            }
            graphics2D.setPaint(this.cursorColor);
            graphics2D.fillRect((History.this.DATAW + History.this.GAP) * History.this.cursorPos - History.this.GAP / 2, 1, History.this.DATAW + History.this.GAP - 1, this.getSize().height - History.this.FOOT);
            graphics2D.setPaint(gridColor);
            graphics2D.drawRoundRect((History.this.DATAW + History.this.GAP) * History.this.cursorPos - 1 - History.this.GAP / 2, 1, History.this.DATAW + History.this.GAP, this.getSize().height - History.this.FOOT, 5, 5);
            for (n = 0; n < History.this.elements.size(); ++n) {
                if (n * (History.this.DATAW + History.this.GAP) > rectangle.x + rectangle.width || n * (History.this.DATAW + History.this.GAP) + History.this.DATAW < rectangle.x) continue;
                if (n == History.this.cursorPos) {
                    graphics2D.setPaint(Color.BLUE);
                } else {
                    graphics2D.setPaint(Color.BLACK);
                }
                try {
                    TextLayout textLayout = new TextLayout(((CubeStateDescriptor)((History)History.this).elements.get((int)n)).event.toString(), this.font, graphics2D.getFontRenderContext());
                    textLayout.draw(graphics2D, (float)((double)(n * (History.this.DATAW + History.this.GAP) + History.this.DATAW / 2) - textLayout.getBounds().getWidth() / 2.0 - 1.0), (float)History.this.HEAD - 5.0f);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            n = 1;
            for (int i = 0; i < History.this.elements.size(); i += n) {
                double d = 2.0 + new TextLayout(new Integer(i + n).toString(), this.font, graphics2D.getFontRenderContext()).getBounds().getWidth();
                n = (int)(d / (double)(History.this.DATAW + History.this.GAP)) + 1;
                if ((double)(i * (History.this.DATAW + History.this.GAP) + History.this.DATAW / 2) - d / 2.0 > (double)(rectangle.x + rectangle.width) || (double)(i * (History.this.DATAW + History.this.GAP) + History.this.DATAW / 2) + d / 2.0 < (double)rectangle.x) continue;
                if (i == History.this.cursorPos) {
                    graphics2D.setPaint(Color.BLUE);
                } else {
                    graphics2D.setPaint(Color.BLACK);
                }
                try {
                    TextLayout textLayout = new TextLayout(new Integer(i).toString(), this.font, graphics2D.getFontRenderContext());
                    textLayout.draw(graphics2D, (float)((double)(i * (History.this.DATAW + History.this.GAP) + History.this.DATAW / 2) - textLayout.getBounds().getWidth() / 2.0 - 1.0), (float)this.getSize().height - 5.0f);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (History.this.instance.getState() == 1) {
                return;
            }
            int n = mouseEvent.getX() / (History.this.DATAW + History.this.GAP);
            if (n >= 0 && n < History.this.elements.size()) {
                History.this.cursorPos = n;
                History.this.selectState(History.this.cursorPos);
                this.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (History.this.instance.getState() == 1) {
                return;
            }
            int n = mouseEvent.getX() / (History.this.DATAW + History.this.GAP);
            if (mouseEvent.getX() < History.this.scrollBarModel.getValue()) {
                JScrollBar jScrollBar = History.this.scrollPane.getHorizontalScrollBar();
                jScrollBar.setValue(jScrollBar.getValue() - jScrollBar.getUnitIncrement(1));
            } else if (mouseEvent.getX() >= History.this.scrollBarModel.getValue() + History.this.scrollBarModel.getExtent()) {
                JScrollBar jScrollBar = History.this.scrollPane.getHorizontalScrollBar();
                jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getUnitIncrement(1));
            }
            if (n >= 0 && n < History.this.elements.size()) {
                History.this.cursorPos = mouseEvent.getX() / (History.this.DATAW + History.this.GAP);
                History.this.selectState(History.this.cursorPos);
                this.repaint();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class RowHeader
    extends JComponent {
        public RowHeader() {
            this.setOpaque(true);
        }

        public Dimension getPreferredSize() {
            return new Dimension(20, History.this.HEAD + History.this.FOOT);
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
            graphics2D.setPaint(gridColor);
            graphics2D.drawLine(this.getSize().width - 5, 0, this.getSize().width - 5, this.getSize().height);
            graphics2D.setPaint(Color.BLACK);
            int n = 0;
            while ((float)n <= 6.0f) {
                graphics2D.drawString(new Integer(6 - n).toString(), 3, History.this.HEAD + (int)((float)(this.getSize().height - History.this.HEAD - History.this.FOOT) / 6.0f * (float)n) + 4);
                ++n;
            }
            if (History.this.drawGrid) {
                graphics2D.setPaint(gridColor);
                n = 0;
                while ((float)n <= 6.0f) {
                    graphics2D.drawLine(this.getSize().width - 5, History.this.HEAD + (int)((float)(this.getSize().height - History.this.HEAD - History.this.FOOT) / 6.0f * (float)n), this.getSize().width, History.this.HEAD + (int)((float)(this.getSize().height - History.this.HEAD - History.this.FOOT) / 6.0f * (float)n));
                    ++n;
                }
            }
        }
    }

    private class PlayBwdAction
    extends AbstractAction
    implements Notifiable {
        public PlayBwdAction() {
            super(null, Images.getImageIcon("play_bwd"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (History.this.instance.getState() == 1) {
                return;
            }
            if (History.this.cursorPos > 0) {
                CubeStateDescriptor cubeStateDescriptor = (CubeStateDescriptor)History.this.elements.get(History.this.cursorPos);
                ((History)History.this).instance.graphicsEngine.turn(cubeStateDescriptor.event.invert(), this);
            }
        }

        public void graphicsEngineReadyNotification() {
            History.this.cursorPos--;
            History.this.graph.repaint();
            History.this.graph.revalidate();
            History.this.updateCursorLabel(((CubeStateDescriptor)((History)History.this).elements.get((int)((History)History.this).cursorPos)).event.toString());
            if (History.this.stop) {
                History.this.stop = false;
                return;
            }
            if (History.this.cursorPos > 0) {
                CubeStateDescriptor cubeStateDescriptor = (CubeStateDescriptor)History.this.elements.get(History.this.cursorPos);
                ((History)History.this).instance.graphicsEngine.turn(cubeStateDescriptor.event.invert(), this);
            }
        }
    }

    private class PlayFwdAction
    extends AbstractAction
    implements Notifiable {
        public PlayFwdAction() {
            super(null, Images.getImageIcon("play_fwd"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (History.this.instance.getState() == 1) {
                return;
            }
            this.graphicsEngineReadyNotification();
        }

        public void graphicsEngineReadyNotification() {
            if (History.this.stop) {
                History.this.stop = false;
                return;
            }
            if (History.this.cursorPos < History.this.elements.size() - 1) {
                CubeStateDescriptor cubeStateDescriptor = (CubeStateDescriptor)History.this.elements.get(History.this.cursorPos + 1);
                ((History)History.this).instance.graphicsEngine.turn(cubeStateDescriptor.event, this);
                History.this.cursorPos++;
                History.this.graph.repaint();
                History.this.graph.revalidate();
                History.this.updateCursorLabel(cubeStateDescriptor.event.toString());
            } else {
                History.this.instance.dispatchNextEvent();
            }
        }
    }

    private class PrevAction
    extends AbstractAction
    implements Notifiable {
        public PrevAction() {
            super(null, Images.getImageIcon("prev"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (History.this.instance.getState() == 1) {
                return;
            }
            if (History.this.cursorPos > 0) {
                CubeStateDescriptor cubeStateDescriptor = (CubeStateDescriptor)History.this.elements.get(History.this.cursorPos);
                ((History)History.this).instance.graphicsEngine.turn(cubeStateDescriptor.event.invert(), this);
            }
        }

        public void graphicsEngineReadyNotification() {
            History.this.stop = false;
            History.this.cursorPos--;
            History.this.graph.repaint();
            History.this.graph.revalidate();
            History.this.updateCursorLabel(((CubeStateDescriptor)((History)History.this).elements.get((int)((History)History.this).cursorPos)).event.toString());
        }
    }

    private class NextAction
    extends AbstractAction
    implements Notifiable {
        public NextAction() {
            super(null, Images.getImageIcon("next"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (History.this.instance.getState() == 1) {
                return;
            }
            if (History.this.cursorPos < History.this.elements.size() - 1) {
                CubeStateDescriptor cubeStateDescriptor = (CubeStateDescriptor)History.this.elements.get(History.this.cursorPos + 1);
                ((History)History.this).instance.graphicsEngine.turn(cubeStateDescriptor.event, this);
                History.this.cursorPos++;
                History.this.graph.repaint();
                History.this.graph.revalidate();
                History.this.updateCursorLabel(cubeStateDescriptor.event.toString());
            } else {
                History.this.instance.dispatchNextEvent();
                History.this.instance.stop();
            }
        }

        public void graphicsEngineReadyNotification() {
            History.this.stop = false;
        }
    }
}

