/*
 * Decompiled with CFR 0.152.
 */
package arcus.gui;

import arcus.Main;
import arcus.gui.PatternGrabber;
import arcus.gui.PrefUI;
import arcus.gui.TurnableGraphicsEngine;
import arcus.gui.ext.XColor;
import arcus.model.GraphicsDescriptor;
import arcus.model.PrefListener;
import arcus.model.Preferences;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public class BasicGraphicsEngine
extends JComponent
implements MouseListener,
MouseMotionListener,
ComponentListener,
Cloneable,
PrefListener {
    protected static final double GAP = 0.03;
    protected static final double[] BDR = new double[]{-0.47, -0.15666666666666665, 0.15666666666666665, 0.47};
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    protected XColor colorBg = new XColor(200, 221, 242);
    protected XColor colorBdr = new XColor(0.1f, 0.1f, 0.1f);
    protected XColor colorBlank = new XColor(0.0f, 0.0f, 0.0f);
    public static final XColor[] faceletColors = new XColor[]{new XColor((Color)Preferences.instance.get("faceletColor0")), new XColor((Color)Preferences.instance.get("faceletColor1")), new XColor((Color)Preferences.instance.get("faceletColor2")), new XColor((Color)Preferences.instance.get("faceletColor3")), new XColor((Color)Preferences.instance.get("faceletColor4")), new XColor((Color)Preferences.instance.get("faceletColor5"))};
    protected boolean highlight = false;
    protected Cubie[] cubies = new Cubie[27];
    public static Vector<double[][]> positions = null;
    private int position = 0;
    private boolean drawPosition = false;
    private Timer posTimer = new Timer(1500, new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            BasicGraphicsEngine.this.drawPosition = false;
            BasicGraphicsEngine.this.repaint();
        }
    }){
        {
            this.setRepeats(false);
        }
    };
    protected double[][] axis = new double[][]{{1.0 / Math.sqrt(2.0), 0.5, 0.5}, {0.0, -1.0 / Math.sqrt(2.0), 1.0 / Math.sqrt(2.0)}, {-1.0 / Math.sqrt(2.0), 0.5, 0.5}};
    private static double[][] defaultAxis = new double[][]{{1.0 / Math.sqrt(2.0), 0.5, 0.5}, {0.0, -1.0 / Math.sqrt(2.0), 1.0 / Math.sqrt(2.0)}, {-1.0 / Math.sqrt(2.0), 0.5, 0.5}};
    protected int axisOfTurn = 0;
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected int mouseButton = 0;
    protected Dimension dim = new Dimension(0, 0);
    protected int centerX;
    protected int centerY;
    protected double ratioX;
    protected double ratioY;
    protected final int border = 5;
    protected static final int[][] vtxOfSide = new int[][]{{0, 1, 2, 3}, {0, 1, 5, 4}, {1, 2, 6, 5}, {2, 3, 7, 6}, {3, 0, 4, 7}, {4, 5, 6, 7}};
    private static int[][] colorIdx = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8}, {0, 1, 2, 9, 10, 11, 18, 19, 20}, {2, 5, 8, 11, 14, 17, 20, 23, 26}, {6, 7, 8, 15, 16, 17, 24, 25, 26}, {0, 3, 6, 9, 12, 15, 18, 21, 24}, {18, 19, 20, 21, 22, 23, 24, 25, 26}};

    private static void savePositions() {
        if (Main.positions == null) {
            return;
        }
        try {
            XMLEncoder xMLEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(Main.positions)));
            xMLEncoder.writeObject(positions);
            xMLEncoder.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("BasicGraphicsEngine.java: save failed. " + fileNotFoundException);
        }
    }

    public static void loadPositions() {
        if (Main.positions == null) {
            return;
        }
        try {
            XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(Main.positions)));
            positions = (Vector)xMLDecoder.readObject();
            xMLDecoder.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public BasicGraphicsEngine() {
        int n = 0;
        while (n < 27) {
            this.cubies[n] = new Cubie(n++);
        }
        if (positions == null) {
            positions = new Vector();
            for (n = 0; n < 10; ++n) {
                double[][] dArrayArray = new double[][]{{1.0 / Math.sqrt(2.0), 0.5, 0.5}, {0.0, -1.0 / Math.sqrt(2.0), 1.0 / Math.sqrt(2.0)}, {-1.0 / Math.sqrt(2.0), 0.5, 0.5}};
                positions.add(dArrayArray);
            }
        }
        this.setFocusTraversalKeysEnabled(false);
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
        PrefUI.instance.addDisplayPrefListener(this);
        PrefUI.instance.addConsolePrefListener(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '?') {
                    BasicGraphicsEngine.this.drawPosition = true;
                    BasicGraphicsEngine.this.posTimer.setDelay(1500);
                    if (BasicGraphicsEngine.this.posTimer.isRunning()) {
                        BasicGraphicsEngine.this.posTimer.restart();
                    } else {
                        BasicGraphicsEngine.this.posTimer.start();
                    }
                    BasicGraphicsEngine.this.repaint();
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "align axis");
        this.getActionMap().put("align axis", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < 3; ++i) {
                    System.arraycopy(positions.get(BasicGraphicsEngine.this.position)[i], 0, BasicGraphicsEngine.this.axis[i], 0, 3);
                }
                BasicGraphicsEngine.this.repaint();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "reset axis");
        this.getActionMap().put("reset axis", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!BasicGraphicsEngine.this.posTimer.isRunning()) {
                    return;
                }
                for (int i = 0; i < 3; ++i) {
                    System.arraycopy(defaultAxis[i], 0, positions.get(BasicGraphicsEngine.this.position)[i], 0, 3);
                    System.arraycopy(defaultAxis[i], 0, BasicGraphicsEngine.this.axis[i], 0, 3);
                }
                BasicGraphicsEngine.savePositions();
                BasicGraphicsEngine.this.repaint();
            }
        });
        for (n = 0; n < 10; ++n) {
            final int n2 = n;
            this.getInputMap().put(KeyStroke.getKeyStroke(48 + n, 2), "store_pos" + n);
            this.getActionMap().put("store_pos" + n, new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BasicGraphicsEngine.this.position = n2;
                    BasicGraphicsEngine.this.drawPosition = true;
                    BasicGraphicsEngine.this.posTimer.setDelay(1500);
                    if (BasicGraphicsEngine.this.posTimer.isRunning()) {
                        BasicGraphicsEngine.this.posTimer.restart();
                    } else {
                        BasicGraphicsEngine.this.posTimer.start();
                    }
                    BasicGraphicsEngine.this.repaint();
                    for (int i = 0; i < 3; ++i) {
                        System.arraycopy(BasicGraphicsEngine.this.axis[i], 0, positions.get(BasicGraphicsEngine.this.position)[i], 0, 3);
                    }
                    BasicGraphicsEngine.savePositions();
                }
            });
            this.getInputMap().put(KeyStroke.getKeyStroke(48 + n, 0), "restore_pos" + n);
            this.getActionMap().put("restore_pos" + n, new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BasicGraphicsEngine.this.position = n2;
                    BasicGraphicsEngine.this.drawPosition = true;
                    BasicGraphicsEngine.this.posTimer.setDelay(1500);
                    if (BasicGraphicsEngine.this.posTimer.isRunning()) {
                        BasicGraphicsEngine.this.posTimer.restart();
                    } else {
                        BasicGraphicsEngine.this.posTimer.start();
                    }
                    BasicGraphicsEngine.this.repaint();
                    for (int i = 0; i < 3; ++i) {
                        System.arraycopy(positions.get(BasicGraphicsEngine.this.position)[i], 0, BasicGraphicsEngine.this.axis[i], 0, 3);
                    }
                }
            });
        }
        this.setPreferredSize(new Dimension(200, 200));
        this.setOpaque(true);
    }

    private double scalarProduct(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    private double vectorAbs(double[] dArray) {
        return Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
    }

    private double vectorCosAngle(double[] dArray, double[] dArray2) {
        return this.scalarProduct(dArray, dArray2) / this.vectorAbs(dArray) / this.vectorAbs(dArray2);
    }

    private void vectorRotX(double[] dArray, double d) {
        double d2 = dArray[1] * Math.cos(d) - dArray[2] * Math.sin(d);
        double d3 = dArray[2] * Math.cos(d) + dArray[1] * Math.sin(d);
        dArray[1] = d2;
        dArray[2] = d3;
    }

    private void vectorRotY(double[] dArray, double d) {
        double d2 = dArray[0] * Math.cos(d) + dArray[2] * Math.sin(d);
        double d3 = dArray[2] * Math.cos(d) - dArray[0] * Math.sin(d);
        dArray[0] = d2;
        dArray[2] = d3;
    }

    private void vectorRotZ(double[] dArray, double d) {
        double d2 = dArray[0] * Math.cos(d) - dArray[1] * Math.sin(d);
        double d3 = dArray[1] * Math.cos(d) + dArray[0] * Math.sin(d);
        dArray[0] = d2;
        dArray[1] = d3;
    }

    private void axisRotX(double d) {
        int n = 0;
        while (n < 3) {
            this.vectorRotX(this.axis[n++], d);
        }
    }

    private void axisRotY(double d) {
        int n = 0;
        while (n < 3) {
            this.vectorRotY(this.axis[n++], d);
        }
    }

    private void axisRotZ(double d) {
        int n = 0;
        while (n < 3) {
            this.vectorRotZ(this.axis[n++], d);
        }
    }

    public void paintComponent(Graphics graphics) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        int[][] nArray = new int[3][9];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < 27; ++n) {
            this.cubies[n].calcDistance();
            if (this.cubies[n].coord[this.axisOfTurn] == -1) {
                nArray[0][n2++] = n;
            }
            if (this.cubies[n].coord[this.axisOfTurn] == 0) {
                nArray[1][n3++] = n;
            }
            if (this.cubies[n].coord[this.axisOfTurn] != 1) continue;
            nArray[2][n4++] = n;
        }
        for (n = 0; n < 3; ++n) {
            for (n2 = 4; n2 > 0; n2 /= 2) {
                for (n3 = n2; n3 < 9; ++n3) {
                    for (n4 = n3 - n2; n4 >= 0 && this.cubies[nArray[n][n4]].distance > this.cubies[nArray[n][n4 + n2]].distance; n4 -= n2) {
                        int n5 = nArray[n][n4];
                        nArray[n][n4] = nArray[n][n4 + n2];
                        nArray[n][n4 + n2] = n5;
                    }
                }
            }
        }
        graphics2D.setPaint(this.colorBg.getColor());
        graphics2D.fillRect(0, 0, this.dim.width, this.dim.height);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.cubies[13].paint(graphics2D);
        if (this.cubies[nArray[0][4]].distance < this.cubies[nArray[2][4]].distance) {
            for (n = 0; n < 9; ++n) {
                this.cubies[nArray[0][n]].paint(graphics2D);
            }
        } else {
            for (n = 0; n < 9; ++n) {
                this.cubies[nArray[2][n]].paint(graphics2D);
            }
        }
        for (n = 1; n < 9; ++n) {
            this.cubies[nArray[1][n]].paint(graphics2D);
        }
        if (this.cubies[nArray[0][4]].distance < this.cubies[nArray[2][4]].distance) {
            for (n = 0; n < 9; ++n) {
                this.cubies[nArray[2][n]].paint(graphics2D);
            }
        } else {
            for (n = 0; n < 9; ++n) {
                this.cubies[nArray[0][n]].paint(graphics2D);
            }
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.drawPosition) {
            graphics2D.setStroke(new BasicStroke(2.0f, 1, 1));
            Font font = new Font("Sans", 1, (int)(Math.sqrt(this.ratioX * this.ratioY) * 12.0 / 100.0));
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            TextLayout textLayout = new TextLayout("( " + this.position + " )", font, fontRenderContext);
            float f = (float)textLayout.getBounds().getWidth();
            float f2 = (float)textLayout.getBounds().getHeight();
            Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance((float)this.centerX - f / 2.0f, (float)this.centerY + f2 / 2.0f));
            graphics2D.setColor(Color.BLACK);
            graphics2D.draw(shape);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(shape);
            graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseButton = mouseEvent.getButton();
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        this.requestFocusInWindow();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this instanceof TurnableGraphicsEngine && ((TurnableGraphicsEngine)this).isBusy()) {
            return;
        }
        if (PatternGrabber.instance.getActive()) {
            PatternGrabber.instance.grab(this.getGraphicsDescriptor());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mouseButton == Preferences.instance.getInt("mouseButtonRotXY")) {
            this.axisRotX(Math.PI * (double)(this.mouseY - mouseEvent.getY()) / (double)this.dim.height);
            this.axisRotY(Math.PI * (double)(mouseEvent.getX() - this.mouseX) / (double)this.dim.width);
        }
        if (this.mouseButton == Preferences.instance.getInt("mouseButtonRotZ")) {
            double d = this.mouseX - this.dim.width / 2;
            double d2 = this.mouseY - this.dim.height / 2;
            double d3 = mouseEvent.getX() - this.dim.width / 2;
            double d4 = mouseEvent.getY() - this.dim.height / 2;
            if (d * d + d2 * d2 > 0.0 && d3 * d3 + d4 * d4 > 0.0) {
                double d5 = Math.acos(d / Math.sqrt(d * d + d2 * d2));
                double d6 = Math.acos(d3 / Math.sqrt(d3 * d3 + d4 * d4));
                if (d2 < 0.0) {
                    d5 = Math.PI * 2 - d5;
                }
                if (d4 < 0.0) {
                    d6 = Math.PI * 2 - d6;
                }
                this.axisRotZ(d6 - d5);
            }
        }
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.dim = this.getSize();
        this.centerX = this.dim.width / 2;
        this.centerY = this.dim.height / 2;
        this.ratioX = (double)(this.dim.width - 10) / Math.sqrt(3.0);
        this.ratioY = (double)(this.dim.height - 10) / Math.sqrt(3.0);
        if (!Preferences.instance.getBoolean("allowDistortion")) {
            this.ratioX = Math.min(this.ratioX, this.ratioY);
            this.ratioY = Math.min(this.ratioX, this.ratioY);
        }
        this.repaint();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void displayPrefChanged() {
        for (int i = 0; i < 6; ++i) {
            faceletColors[i].setColor((Color)Preferences.instance.get("faceletColor" + i));
        }
        if (!Preferences.instance.getBoolean("allowDistortion")) {
            this.ratioX = Math.min(this.ratioX, this.ratioY);
            this.ratioY = Math.min(this.ratioX, this.ratioY);
        } else {
            this.ratioX = (double)(this.dim.width - 10) / Math.sqrt(3.0);
            this.ratioY = (double)(this.dim.height - 10) / Math.sqrt(3.0);
        }
        this.repaint();
    }

    public void consolePrefChanged() {
    }

    public GraphicsDescriptor getGraphicsDescriptor() {
        GraphicsDescriptor graphicsDescriptor = new GraphicsDescriptor();
        for (int i = 0; i < 27; ++i) {
            int n;
            graphicsDescriptor.id[i] = this.cubies[i].id;
            System.arraycopy(this.cubies[i].coord, 0, graphicsDescriptor.coord[i], 0, 3);
            for (n = 0; n < 8; ++n) {
                System.arraycopy(this.cubies[i].vertex[n], 0, graphicsDescriptor.vertex[i][n], 0, 3);
            }
            for (n = 0; n < 6; ++n) {
                System.arraycopy(this.cubies[i].normal[n], 0, graphicsDescriptor.normal[i][n], 0, 3);
            }
            graphicsDescriptor.distance[i] = this.cubies[i].distance;
            System.arraycopy(this.cubies[i].colors, 0, graphicsDescriptor.colors[i], 0, 6);
        }
        return graphicsDescriptor;
    }

    public void setGraphicsDescriptor(GraphicsDescriptor graphicsDescriptor) {
        for (int i = 0; i < 27; ++i) {
            int n;
            this.cubies[i].id = graphicsDescriptor.id[i];
            System.arraycopy(graphicsDescriptor.coord[i], 0, this.cubies[i].coord, 0, 3);
            for (n = 0; n < 8; ++n) {
                System.arraycopy(graphicsDescriptor.vertex[i][n], 0, this.cubies[i].vertex[n], 0, 3);
            }
            for (n = 0; n < 6; ++n) {
                System.arraycopy(graphicsDescriptor.normal[i][n], 0, this.cubies[i].normal[n], 0, 3);
            }
            this.cubies[i].distance = graphicsDescriptor.distance[i];
            System.arraycopy(graphicsDescriptor.colors[i], 0, this.cubies[i].colors, 0, 6);
        }
        this.repaint();
    }

    public Object clone() {
        BasicGraphicsEngine basicGraphicsEngine = new BasicGraphicsEngine();
        basicGraphicsEngine.setGraphicsDescriptor(this.getGraphicsDescriptor());
        return basicGraphicsEngine;
    }

    public boolean verifyPattern() {
        boolean bl = true;
        int[][] nArray = new int[27][6];
        for (int i = 0; i < 27; ++i) {
            System.arraycopy(this.cubies[i].colors, 0, nArray[i], 0, 6);
            Arrays.sort(nArray[i]);
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < 27; ++i) {
            Cubie cubie = new Cubie(i);
            int[] nArray2 = new int[6];
            System.arraycopy(cubie.colors, 0, nArray2, 0, 6);
            Arrays.sort(nArray2);
            for (int j = 0; j < 27; ++j) {
                if (!Arrays.equals(nArray[j], nArray2)) continue;
                this.cubies[j].id = cubie.id;
                if (hashSet.add(new Integer(cubie.id))) continue;
                bl = false;
            }
        }
        if (hashSet.size() != 27) {
            bl = false;
        }
        return bl;
    }

    protected class Cubie {
        protected int id;
        protected int[] coord;
        protected double[][] vertex;
        protected double[][] normal;
        protected double distance;
        protected int[] colors = new int[6];

        protected Cubie(int n) {
            int n2;
            this.id = n;
            this.coord = new int[]{n % 3 - 1, n / 9 - 1, 1 - n / 3 % 3};
            this.normal = new double[][]{{0.0, -1.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 0.0}, {0.0, 0.0, -1.0}, {-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
            this.vertex = new double[][]{{BDR[n % 3], BDR[n / 9], BDR[3 - n / 3 % 3]}, {BDR[n % 3 + 1], BDR[n / 9], BDR[3 - n / 3 % 3]}, {BDR[n % 3 + 1], BDR[n / 9], BDR[2 - n / 3 % 3]}, {BDR[n % 3], BDR[n / 9], BDR[2 - n / 3 % 3]}, {BDR[n % 3], BDR[n / 9 + 1], BDR[3 - n / 3 % 3]}, {BDR[n % 3 + 1], BDR[n / 9 + 1], BDR[3 - n / 3 % 3]}, {BDR[n % 3 + 1], BDR[n / 9 + 1], BDR[2 - n / 3 % 3]}, {BDR[n % 3], BDR[n / 9 + 1], BDR[2 - n / 3 % 3]}};
            for (n2 = 0; n2 < 8; ++n2) {
                double[] dArray = this.vertex[n2];
                dArray[0] = dArray[0] + (double)this.coord[0] * 0.03;
                double[] dArray2 = this.vertex[n2];
                dArray2[1] = dArray2[1] + (double)this.coord[1] * 0.03;
                double[] dArray3 = this.vertex[n2];
                dArray3[2] = dArray3[2] + (double)this.coord[2] * 0.03;
            }
            if (n == 13) {
                for (n2 = 0; n2 < 8; ++n2) {
                    double[] dArray = this.vertex[n2];
                    dArray[0] = dArray[0] * (3.0 / Math.sqrt(2.0));
                    double[] dArray4 = this.vertex[n2];
                    dArray4[1] = dArray4[1] * (3.0 / Math.sqrt(2.0));
                    double[] dArray5 = this.vertex[n2];
                    dArray5[2] = dArray5[2] * (3.0 / Math.sqrt(2.0));
                }
            }
            for (n2 = 0; n2 < 6; ++n2) {
                this.colors[n2] = -1;
                for (int i = 0; i < 9; ++i) {
                    if (this.id != colorIdx[n2][i]) continue;
                    this.colors[n2] = n2;
                }
            }
        }

        protected void calcDistance() {
            this.distance = this.id == 13 ? -1000.0 : ((this.vertex[0][0] + this.vertex[6][0]) * BasicGraphicsEngine.this.axis[0][2] + (this.vertex[0][1] + this.vertex[6][1]) * BasicGraphicsEngine.this.axis[1][2] + (this.vertex[0][2] + this.vertex[6][2]) * BasicGraphicsEngine.this.axis[2][2]) / 2.0;
        }

        protected void turnX(int n) {
            int n2 = 0;
            int n3 = 0;
            switch (n) {
                case -1: {
                    n2 = this.coord[2];
                    n3 = -this.coord[1];
                    break;
                }
                case -2: 
                case 0: 
                case 2: {
                    n2 = -this.coord[1];
                    n3 = -this.coord[2];
                    break;
                }
                case 1: {
                    n2 = -this.coord[2];
                    n3 = this.coord[1];
                }
            }
            this.coord[2] = n3;
            this.coord[1] = n2;
        }

        protected void turnY(int n) {
            int n2 = 0;
            int n3 = 0;
            switch (n) {
                case -1: {
                    n2 = -this.coord[2];
                    n3 = this.coord[0];
                    break;
                }
                case -2: 
                case 0: 
                case 2: {
                    n2 = -this.coord[0];
                    n3 = -this.coord[2];
                    break;
                }
                case 1: {
                    n2 = this.coord[2];
                    n3 = -this.coord[0];
                }
            }
            this.coord[2] = n3;
            this.coord[0] = n2;
        }

        protected void turnZ(int n) {
            int n2 = 0;
            int n3 = 0;
            switch (n) {
                case -1: {
                    n2 = this.coord[1];
                    n3 = -this.coord[0];
                    break;
                }
                case -2: 
                case 0: 
                case 2: {
                    n2 = -this.coord[0];
                    n3 = -this.coord[1];
                    break;
                }
                case 1: {
                    n2 = -this.coord[1];
                    n3 = this.coord[0];
                }
            }
            this.coord[1] = n3;
            this.coord[0] = n2;
        }

        protected void rotX(double d) {
            int n = 0;
            while (n < 8) {
                BasicGraphicsEngine.this.vectorRotX(this.vertex[n++], d);
            }
            n = 0;
            while (n < 6) {
                BasicGraphicsEngine.this.vectorRotX(this.normal[n++], d);
            }
        }

        protected void rotY(double d) {
            int n = 0;
            while (n < 8) {
                BasicGraphicsEngine.this.vectorRotY(this.vertex[n++], d);
            }
            n = 0;
            while (n < 6) {
                BasicGraphicsEngine.this.vectorRotY(this.normal[n++], d);
            }
        }

        protected void rotZ(double d) {
            int n = 0;
            while (n < 8) {
                BasicGraphicsEngine.this.vectorRotZ(this.vertex[n++], d);
            }
            n = 0;
            while (n < 6) {
                BasicGraphicsEngine.this.vectorRotZ(this.normal[n++], d);
            }
        }

        public int transformX(double[] dArray) {
            return (int)((dArray[0] * BasicGraphicsEngine.this.axis[0][0] + dArray[1] * BasicGraphicsEngine.this.axis[1][0] + dArray[2] * BasicGraphicsEngine.this.axis[2][0]) * BasicGraphicsEngine.this.ratioX) + BasicGraphicsEngine.this.centerX;
        }

        public int transformY(double[] dArray) {
            return (int)((dArray[0] * BasicGraphicsEngine.this.axis[0][1] + dArray[1] * BasicGraphicsEngine.this.axis[1][1] + dArray[2] * BasicGraphicsEngine.this.axis[2][1]) * BasicGraphicsEngine.this.ratioY) + BasicGraphicsEngine.this.centerY;
        }

        public boolean contains(int[] nArray, int[] nArray2, double d, double d2) {
            double d3 = nArray[1] * nArray2[0] - nArray[0] * nArray2[1];
            double d4 = nArray[2] * nArray2[1] - nArray[1] * nArray2[2];
            double d5 = nArray[3] * nArray2[2] - nArray[2] * nArray2[3];
            double d6 = nArray[0] * nArray2[3] - nArray[3] * nArray2[0];
            double d7 = d * (double)(nArray2[0] - nArray2[1]) + d2 * (double)(nArray[1] - nArray[0]);
            double d8 = d * (double)(nArray2[1] - nArray2[2]) + d2 * (double)(nArray[2] - nArray[1]);
            double d9 = d * (double)(nArray2[2] - nArray2[3]) + d2 * (double)(nArray[3] - nArray[2]);
            double d10 = d * (double)(nArray2[3] - nArray2[0]) + d2 * (double)(nArray[0] - nArray[3]);
            return (d7 - d3) * (d5 - d9) < 0.0 && (d8 - d4) * (d6 - d10) < 0.0;
        }

        public int colorAtNormal(int n, int n2, int n3) {
            for (int i = 0; i < 6; ++i) {
                if (this.colors[i] == -1 || n != (int)Math.round(this.normal[i][0]) || n2 != (int)Math.round(this.normal[i][1]) || n3 != (int)Math.round(this.normal[i][2])) continue;
                return this.colors[i];
            }
            return -1;
        }

        protected void paint(Graphics2D graphics2D) {
            for (int i = 0; i < 6; ++i) {
                double d = this.normal[i][0] * BasicGraphicsEngine.this.axis[0][2] + this.normal[i][1] * BasicGraphicsEngine.this.axis[1][2] + this.normal[i][2] * BasicGraphicsEngine.this.axis[2][2];
                if (d <= 0.0) continue;
                int[] nArray = new int[]{this.transformX(this.vertex[vtxOfSide[i][0]]), this.transformX(this.vertex[vtxOfSide[i][1]]), this.transformX(this.vertex[vtxOfSide[i][2]]), this.transformX(this.vertex[vtxOfSide[i][3]])};
                int[] nArray2 = new int[]{this.transformY(this.vertex[vtxOfSide[i][0]]), this.transformY(this.vertex[vtxOfSide[i][1]]), this.transformY(this.vertex[vtxOfSide[i][2]]), this.transformY(this.vertex[vtxOfSide[i][3]])};
                double d2 = Preferences.instance.getDouble("blackOut");
                Polygon polygon = new Polygon(nArray, nArray2, nArray.length);
                Color color = this.colors[i] < 0 ? new Color((int)((double)BasicGraphicsEngine.this.colorBlank.getRed() * (1.0 - d2 + d2 * d)), (int)((double)BasicGraphicsEngine.this.colorBlank.getGreen() * (1.0 - d2 + d2 * d)), (int)((double)BasicGraphicsEngine.this.colorBlank.getBlue() * (1.0 - d2 + d2 * d)), BasicGraphicsEngine.this.colorBlank.getAlpha()) : new Color((int)((double)faceletColors[this.colors[i]].getRed() * (1.0 - d2 + d2 * d)), (int)((double)faceletColors[this.colors[i]].getGreen() * (1.0 - d2 + d2 * d)), (int)((double)faceletColors[this.colors[i]].getBlue() * (1.0 - d2 + d2 * d)));
                graphics2D.setPaint(color);
                graphics2D.fill(polygon);
                if (BasicGraphicsEngine.this.highlight && this.colors[i] != -1 && BasicGraphicsEngine.this.mouseButton == Preferences.instance.getInt("mouseButtonTurn") && this.contains(nArray, nArray2, BasicGraphicsEngine.this.mouseX, BasicGraphicsEngine.this.mouseY)) {
                    graphics2D.setPaint(color.brighter());
                    graphics2D.fill(polygon);
                }
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setPaint(BasicGraphicsEngine.this.colorBdr.getColor());
                graphics2D.draw(polygon);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }
    }
}

