/*
 * Decompiled with CFR 0.152.
 */
package arcus.algorithm;

import arcus.algorithm.Algorithm;
import arcus.model.CubeEvent;
import arcus.model.CubeInstance;
import arcus.model.GraphicsDescriptor;
import java.util.Arrays;

public class LayerByLayerAlgorithm
extends Algorithm {
    private CubeInstance instance;
    private GraphicsDescriptor start;
    private GraphicsDescriptor goal;
    private Cubie[] cubies1 = new Cubie[27];
    private Cubie[] cubies2 = new Cubie[27];
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int[] D = new int[]{0, -1, 0};
    public static final int[] F = new int[]{0, 0, 1};
    public static final int[] R = new int[]{1, 0, 0};
    public static final int[] B = new int[]{0, 0, -1};
    public static final int[] L = new int[]{-1, 0, 0};
    public static final int[] U = new int[]{0, 1, 0};

    public LayerByLayerAlgorithm(CubeInstance cubeInstance) {
        this.instance = cubeInstance;
        for (int i = 0; i < 27; ++i) {
            this.cubies1[i] = new Cubie();
            this.cubies2[i] = new Cubie();
        }
    }

    public void init(GraphicsDescriptor graphicsDescriptor, GraphicsDescriptor graphicsDescriptor2) {
        for (int i = 0; i < 27; ++i) {
            this.cubies1[i].id = graphicsDescriptor.id[i];
            System.arraycopy(graphicsDescriptor.coord[i], 0, this.cubies1[i].coord, 0, 3);
            System.arraycopy(graphicsDescriptor.colors[i], 0, this.cubies1[i].colors, 0, 6);
            this.cubies2[i].id = graphicsDescriptor2.id[i];
            System.arraycopy(graphicsDescriptor2.coord[i], 0, this.cubies2[i].coord, 0, 3);
            System.arraycopy(graphicsDescriptor2.colors[i], 0, this.cubies2[i].colors, 0, 6);
            for (int j = 0; j < 6; ++j) {
                ((Cubie)this.cubies1[i]).normal[j][0] = (int)Math.round(graphicsDescriptor.normal[i][j][0]);
                ((Cubie)this.cubies1[i]).normal[j][1] = (int)Math.round(graphicsDescriptor.normal[i][j][1]);
                ((Cubie)this.cubies1[i]).normal[j][2] = (int)Math.round(graphicsDescriptor.normal[i][j][2]);
                ((Cubie)this.cubies2[i]).normal[j][0] = (int)Math.round(graphicsDescriptor2.normal[i][j][0]);
                ((Cubie)this.cubies2[i]).normal[j][1] = (int)Math.round(graphicsDescriptor2.normal[i][j][1]);
                ((Cubie)this.cubies2[i]).normal[j][2] = (int)Math.round(graphicsDescriptor2.normal[i][j][2]);
            }
        }
    }

    public void run() {
        int n;
        this.position();
        for (n = 0; n < 4; ++n) {
            this.firstSideEdge();
            this.turn(1, 1, -1);
            this.turn2(1, 1, -1);
        }
        for (n = 0; n < 4; ++n) {
            this.firstSideCorner();
            this.turn(1, 1, -1);
            this.turn2(1, 1, -1);
        }
        this.turn(2, -1, 0);
        this.turn(2, 0, 0);
        this.turn(2, 1, 0);
        this.turn2(2, -1, 0);
        this.turn2(2, 0, 0);
        this.turn2(2, 1, 0);
        for (n = 0; n < 4; ++n) {
            this.middle();
            this.turn(1, 0, -1);
            this.turn2(1, 0, -1);
        }
        this.lastSidePosition();
        for (n = 0; n < 4; ++n) {
            this.lastSideCorners();
            this.turn(1, 1, -1);
            this.turn2(1, 1, -1);
        }
        for (n = 0; n < 4; ++n) {
            this.lastSideCornerMove();
            this.turn(1, 1, -1);
            this.turn2(1, 1, -1);
        }
        for (n = 0; n < 4; ++n) {
            this.lastSideCornerTwist();
            this.turn(1, 1, -1);
            this.turn2(1, 1, -1);
        }
        for (n = 0; n < 4; ++n) {
            this.lastSideEdges();
            this.turn(1, 1, -1);
            this.turn2(1, 1, -1);
        }
        for (n = 0; n < 4; ++n) {
            this.lastSideEdgeMove();
            this.turn(1, 1, -1);
            this.turn2(1, 1, -1);
        }
        for (n = 0; n < 4; ++n) {
            this.lastSideEdgeTwist();
            this.turn(1, 1, -1);
            this.turn2(1, 1, -1);
        }
        this.turn(2, -1, 0);
        this.turn(2, 0, 0);
        this.turn(2, 1, 0);
        this.turn2(2, -1, 0);
        this.turn2(2, 0, 0);
        this.turn2(2, 1, 0);
        this.instance.optimizeEventQueue();
        this.instance.dispatchNextEvent();
    }

    private void position() {
        int n = this.getIdByCoord(this.cubies2, 0, -1, 0);
        if (n == this.getIdByCoord(this.cubies1, 0, 0, 1)) {
            this.turn(0, 0, 1);
        }
        if (n == this.getIdByCoord(this.cubies1, 1, 0, 0)) {
            this.turn(2, 0, -1);
        }
        if (n == this.getIdByCoord(this.cubies1, 0, 0, -1)) {
            this.turn(0, 0, -1);
        }
        if (n == this.getIdByCoord(this.cubies1, -1, 0, 0)) {
            this.turn(2, 0, 1);
        }
        if (n == this.getIdByCoord(this.cubies1, 0, 1, 0)) {
            this.turn(0, 0, 0);
        }
        if ((n = this.getIdByCoord(this.cubies2, 0, 0, 1)) == this.getIdByCoord(this.cubies1, 1, 0, 0)) {
            this.turn(1, 0, -1);
        }
        if (n == this.getIdByCoord(this.cubies1, 0, 0, -1)) {
            this.turn(1, 0, 0);
        }
        if (n == this.getIdByCoord(this.cubies1, -1, 0, 0)) {
            this.turn(1, 0, 1);
        }
    }

    private void firstSideEdge() {
        int n;
        int n2 = this.getIdByCoord(this.cubies2, 0, 1, 1);
        int n3 = this.getIndexByCoord(this.cubies2, 0, 1, 1);
        int n4 = this.getFacelet(this.cubies2[n3], U);
        for (n = 0; n < 27 && n2 != this.cubies1[n].id; ++n) {
        }
        Cubie cubie = this.cubies1[n];
        if (Arrays.equals(cubie.coord, new int[]{0, -1, 1})) {
            if (n4 == this.getFacelet(cubie, D)) {
                this.turn(2, 1, 0);
            } else {
                this.turn(2, 1, -1);
                this.turn(1, 1, -1);
                this.turn(0, -1, -1);
                this.turn(1, 1, 1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{1, -1, 0})) {
            if (n4 == this.getFacelet(cubie, D)) {
                this.turn(1, -1, -1);
                this.turn(2, 1, 0);
            } else {
                this.turn(0, 1, -1);
                this.turn(2, 1, 1);
                this.turn(0, 1, 1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{0, -1, -1})) {
            if (n4 == this.getFacelet(cubie, D)) {
                this.turn(1, -1, 0);
                this.turn(2, 1, 0);
            } else {
                this.turn(1, -1, -1);
                this.turn(0, 1, -1);
                this.turn(2, 1, 1);
                this.turn(0, 1, 1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{-1, -1, 0})) {
            if (n4 == this.getFacelet(cubie, D)) {
                this.turn(1, -1, 1);
                this.turn(2, 1, 0);
            } else {
                this.turn(0, -1, -1);
                this.turn(2, 1, -1);
                this.turn(0, -1, 1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{-1, 0, 1})) {
            if (n4 == this.getFacelet(cubie, F)) {
                this.turn(1, 1, -1);
                this.turn(0, -1, -1);
                this.turn(1, 1, 1);
            } else {
                this.turn(2, 1, -1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{1, 0, 1})) {
            if (n4 == this.getFacelet(cubie, F)) {
                this.turn(1, 1, 1);
                this.turn(0, 1, -1);
                this.turn(1, 1, -1);
            } else {
                this.turn(2, 1, 1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{1, 0, -1})) {
            if (n4 == this.getFacelet(cubie, B)) {
                this.turn(1, 1, 1);
                this.turn(0, 1, 1);
                this.turn(1, 1, -1);
            } else {
                this.turn(1, 1, 0);
                this.turn(2, -1, 1);
                this.turn(1, 1, 0);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{-1, 0, -1})) {
            if (n4 == this.getFacelet(cubie, B)) {
                this.turn(1, 1, -1);
                this.turn(0, -1, 1);
                this.turn(1, 1, 1);
            } else {
                this.turn(1, 1, 0);
                this.turn(2, -1, -1);
                this.turn(1, 1, 0);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{1, 1, 0})) {
            if (n4 == this.getFacelet(cubie, U)) {
                this.turn(0, 1, 0);
                this.turn(1, -1, -1);
                this.turn(2, 1, 0);
            } else {
                this.turn(0, 1, 1);
                this.turn(2, 1, 1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{0, 1, -1})) {
            if (n4 == this.getFacelet(cubie, U)) {
                this.turn(2, -1, 0);
                this.turn(1, -1, 0);
                this.turn(2, 1, 0);
            } else {
                this.turn(2, -1, 1);
                this.turn(1, 1, -1);
                this.turn(0, -1, 1);
                this.turn(1, 1, 1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{-1, 1, 0})) {
            if (n4 == this.getFacelet(cubie, U)) {
                this.turn(0, -1, 0);
                this.turn(1, -1, 1);
                this.turn(2, 1, 0);
            } else {
                this.turn(0, -1, 1);
                this.turn(2, 1, -1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{0, 1, 1}) && n4 != this.getFacelet(cubie, U)) {
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, 1, 1);
        }
    }

    private void firstSideCorner() {
        int n;
        int n2 = this.getIdByCoord(this.cubies2, -1, 1, 1);
        int n3 = this.getIndexByCoord(this.cubies2, -1, 1, 1);
        int n4 = this.getFacelet(this.cubies2[n3], U);
        for (n = 0; n < 27 && n2 != this.cubies1[n].id; ++n) {
        }
        Cubie cubie = this.cubies1[n];
        if (Arrays.equals(cubie.coord, new int[]{-1, -1, 1})) {
            if (n4 == this.getFacelet(cubie, D)) {
                this.turn(0, -1, 1);
                this.turn(2, 1, -1);
                this.turn(0, -1, 0);
                this.turn(2, 1, 1);
                this.turn(0, -1, -1);
            } else if (n4 == this.getFacelet(cubie, F)) {
                this.turn(1, -1, 1);
                this.turn(0, -1, 1);
                this.turn(1, -1, -1);
                this.turn(0, -1, -1);
            } else {
                this.turn(1, -1, -1);
                this.turn(2, 1, 1);
                this.turn(1, -1, 1);
                this.turn(2, 1, -1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{1, -1, 1})) {
            if (n4 == this.getFacelet(cubie, D)) {
                this.turn(1, -1, -1);
                this.turn(0, -1, 1);
                this.turn(2, 1, -1);
                this.turn(0, -1, 0);
                this.turn(2, 1, 1);
                this.turn(0, -1, -1);
            } else if (n4 == this.getFacelet(cubie, F)) {
                this.turn(1, -1, 0);
                this.turn(2, 1, 1);
                this.turn(1, -1, 1);
                this.turn(2, 1, -1);
            } else {
                this.turn(0, -1, 1);
                this.turn(1, -1, -1);
                this.turn(0, -1, -1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{1, -1, -1})) {
            if (n4 == this.getFacelet(cubie, D)) {
                this.turn(1, -1, 0);
                this.turn(0, -1, 1);
                this.turn(2, 1, -1);
                this.turn(0, -1, 0);
                this.turn(2, 1, 1);
                this.turn(0, -1, -1);
            } else if (n4 == this.getFacelet(cubie, B)) {
                this.turn(1, -1, -1);
                this.turn(0, -1, 1);
                this.turn(1, -1, -1);
                this.turn(0, -1, -1);
            } else {
                this.turn(1, -1, 1);
                this.turn(2, 1, 1);
                this.turn(1, -1, 1);
                this.turn(2, 1, -1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{-1, -1, -1})) {
            if (n4 == this.getFacelet(cubie, D)) {
                this.turn(1, -1, 1);
                this.turn(0, -1, 1);
                this.turn(2, 1, -1);
                this.turn(0, -1, 0);
                this.turn(2, 1, 1);
                this.turn(0, -1, -1);
            } else if (n4 == this.getFacelet(cubie, B)) {
                this.turn(2, 1, 1);
                this.turn(1, -1, 1);
                this.turn(2, 1, -1);
            } else {
                this.turn(1, -1, 0);
                this.turn(0, -1, 1);
                this.turn(1, -1, -1);
                this.turn(0, -1, -1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{-1, 1, 1})) {
            if (n4 == this.getFacelet(cubie, F)) {
                this.turn(0, -1, 1);
                this.turn(1, -1, -1);
                this.turn(0, -1, -1);
                this.turn(1, -1, 1);
                this.turn(0, -1, 1);
                this.turn(1, -1, -1);
                this.turn(0, -1, -1);
            } else if (n4 == this.getFacelet(cubie, L)) {
                this.turn(2, 1, 1);
                this.turn(1, -1, 1);
                this.turn(2, 1, -1);
                this.turn(1, -1, -1);
                this.turn(2, 1, 1);
                this.turn(1, -1, 1);
                this.turn(2, 1, -1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{1, 1, 1})) {
            if (n4 == this.getFacelet(cubie, U)) {
                this.turn(0, 1, 1);
                this.turn(1, -1, 1);
                this.turn(0, 1, -1);
                this.turn(0, -1, 1);
                this.turn(1, -1, -1);
                this.turn(0, -1, -1);
            } else if (n4 == this.getFacelet(cubie, F)) {
                this.turn(0, 1, 1);
                this.turn(1, -1, 1);
                this.turn(0, 1, -1);
                this.turn(1, -1, 0);
                this.turn(2, 1, 1);
                this.turn(1, -1, 1);
                this.turn(2, 1, -1);
            } else {
                this.turn(0, 0, -1);
                this.turn(2, 1, 1);
                this.turn(0, 0, 1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{1, 1, -1})) {
            if (n4 == this.getFacelet(cubie, U)) {
                this.turn(2, -1, -1);
                this.turn(2, 1, 1);
                this.turn(1, -1, 0);
                this.turn(2, 1, -1);
                this.turn(2, -1, 1);
            } else if (n4 == this.getFacelet(cubie, B)) {
                this.turn(2, -1, -1);
                this.turn(0, -1, 1);
                this.turn(1, -1, 0);
                this.turn(0, -1, -1);
                this.turn(2, -1, 1);
            } else {
                this.turn(2, -1, -1);
                this.turn(1, -1, 1);
                this.turn(2, -1, 1);
                this.turn(2, 1, 1);
                this.turn(1, -1, 0);
                this.turn(2, 1, -1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{-1, 1, -1})) {
            if (n4 == this.getFacelet(cubie, U)) {
                this.turn(2, -1, 1);
                this.turn(1, -1, 0);
                this.turn(2, -1, -1);
                this.turn(0, -1, 1);
                this.turn(1, -1, -1);
                this.turn(0, -1, -1);
            } else if (n4 == this.getFacelet(cubie, B)) {
                this.turn(2, 0, -1);
                this.turn(0, -1, 1);
                this.turn(2, 0, 1);
            } else {
                this.turn(2, -1, 1);
                this.turn(1, -1, -1);
                this.turn(2, -1, -1);
                this.turn(1, -1, 0);
                this.turn(0, -1, 1);
                this.turn(1, -1, -1);
                this.turn(0, -1, -1);
            }
        }
    }

    private void middle() {
        int n;
        int n2 = this.getIdByCoord(this.cubies2, -1, 0, 1);
        int n3 = this.getIndexByCoord(this.cubies2, -1, 0, 1);
        int n4 = this.getFacelet(this.cubies2[n3], F);
        for (n = 0; n < 27 && n2 != this.cubies1[n].id; ++n) {
        }
        Cubie cubie = this.cubies1[n];
        if (Arrays.equals(cubie.coord, new int[]{-1, 0, 1}) && n4 != this.getFacelet(cubie, F)) {
            this.turn(2, -1, 1);
            this.turn(0, -1, 0);
            this.turn(1, 1, -1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 1);
            this.turn(0, -1, 0);
            this.turn(2, -1, -1);
            this.turn(0, 1, 1);
            this.turn(2, 1, 0);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, 0);
            this.turn(0, 1, -1);
        }
        if (Arrays.equals(cubie.coord, new int[]{1, 0, 1})) {
            if (n4 == this.getFacelet(cubie, F)) {
                this.turn(2, 1, -1);
                this.turn(0, 0, 1);
                this.turn(2, 1, 0);
                this.turn(0, 0, -1);
                this.turn(2, 1, -1);
            } else {
                this.turn(2, -1, -1);
                this.turn(0, 1, 0);
                this.turn(1, 1, 1);
                this.turn(0, 1, 1);
                this.turn(1, 1, -1);
                this.turn(0, 1, 0);
                this.turn(2, -1, 1);
                this.turn(0, 1, 1);
                this.turn(2, 1, 0);
                this.turn(1, 1, 1);
                this.turn(2, 1, 1);
                this.turn(1, 1, -1);
                this.turn(2, 1, 0);
                this.turn(0, 1, -1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{1, 0, -1})) {
            if (n4 == this.getFacelet(cubie, B)) {
                this.turn(2, 1, -1);
                this.turn(0, 1, 0);
                this.turn(1, 1, -1);
                this.turn(0, 1, -1);
                this.turn(1, 1, 1);
                this.turn(0, 1, 0);
                this.turn(2, 1, 1);
                this.turn(1, 1, 1);
                this.turn(2, -1, 1);
                this.turn(0, -1, 0);
                this.turn(1, 1, -1);
                this.turn(0, -1, 1);
                this.turn(1, 1, 1);
                this.turn(0, -1, 0);
                this.turn(2, -1, -1);
            } else {
                this.turn(2, 1, -1);
                this.turn(0, 1, 0);
                this.turn(1, 1, -1);
                this.turn(0, 1, -1);
                this.turn(1, 1, 1);
                this.turn(0, 1, 0);
                this.turn(2, 1, 1);
                this.turn(1, 1, 0);
                this.turn(0, 1, 1);
                this.turn(2, 1, 0);
                this.turn(1, 1, 1);
                this.turn(2, 1, 1);
                this.turn(1, 1, -1);
                this.turn(2, 1, 0);
                this.turn(0, 1, -1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{-1, 0, -1})) {
            if (n4 == this.getFacelet(cubie, B)) {
                this.turn(0, -1, -1);
                this.turn(2, 0, 1);
                this.turn(0, -1, 0);
                this.turn(2, 0, -1);
                this.turn(0, -1, -1);
            } else {
                this.turn(0, 1, -1);
                this.turn(2, -1, 0);
                this.turn(1, 1, -1);
                this.turn(2, -1, 1);
                this.turn(1, 1, 1);
                this.turn(2, -1, 0);
                this.turn(0, 1, 1);
                this.turn(2, -1, 1);
                this.turn(0, -1, 0);
                this.turn(1, 1, -1);
                this.turn(0, -1, 1);
                this.turn(1, 1, 1);
                this.turn(0, -1, 0);
                this.turn(2, -1, -1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{0, 1, 1})) {
            if (n4 == this.getFacelet(cubie, U)) {
                this.turn(1, 1, -1);
                this.turn(2, -1, 1);
                this.turn(0, -1, 0);
                this.turn(1, 1, -1);
                this.turn(0, -1, 1);
                this.turn(1, 1, 1);
                this.turn(0, -1, 0);
                this.turn(2, -1, -1);
            } else {
                this.turn(0, 1, 1);
                this.turn(2, 1, 0);
                this.turn(1, 1, 1);
                this.turn(2, 1, 1);
                this.turn(1, 1, -1);
                this.turn(2, 1, 0);
                this.turn(0, 1, -1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{1, 1, 0})) {
            if (n4 == this.getFacelet(cubie, U)) {
                this.turn(1, 1, 0);
                this.turn(2, -1, 1);
                this.turn(0, -1, 0);
                this.turn(1, 1, -1);
                this.turn(0, -1, 1);
                this.turn(1, 1, 1);
                this.turn(0, -1, 0);
                this.turn(2, -1, -1);
            } else {
                this.turn(1, 1, -1);
                this.turn(0, 1, 1);
                this.turn(2, 1, 0);
                this.turn(1, 1, 1);
                this.turn(2, 1, 1);
                this.turn(1, 1, -1);
                this.turn(2, 1, 0);
                this.turn(0, 1, -1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{0, 1, -1})) {
            if (n4 == this.getFacelet(cubie, U)) {
                this.turn(1, 1, 1);
                this.turn(2, -1, 1);
                this.turn(0, -1, 0);
                this.turn(1, 1, -1);
                this.turn(0, -1, 1);
                this.turn(1, 1, 1);
                this.turn(0, -1, 0);
                this.turn(2, -1, -1);
            } else {
                this.turn(1, 1, 0);
                this.turn(0, 1, 1);
                this.turn(2, 1, 0);
                this.turn(1, 1, 1);
                this.turn(2, 1, 1);
                this.turn(1, 1, -1);
                this.turn(2, 1, 0);
                this.turn(0, 1, -1);
            }
        }
        if (Arrays.equals(cubie.coord, new int[]{-1, 1, 0})) {
            if (n4 == this.getFacelet(cubie, U)) {
                this.turn(2, -1, 1);
                this.turn(0, -1, 0);
                this.turn(1, 1, -1);
                this.turn(0, -1, 1);
                this.turn(1, 1, 1);
                this.turn(0, -1, 0);
                this.turn(2, -1, -1);
            } else {
                this.turn(1, 1, 1);
                this.turn(0, 1, 1);
                this.turn(2, 1, 0);
                this.turn(1, 1, 1);
                this.turn(2, 1, 1);
                this.turn(1, 1, -1);
                this.turn(2, 1, 0);
                this.turn(0, 1, -1);
            }
        }
    }

    private void lastSidePosition() {
        int n;
        do {
            n = 0;
            if (this.equalCubieIgnoreTwist(-1, 1, 1, -1, 1, 1)) {
                ++n;
            }
            if (this.equalCubieIgnoreTwist(1, 1, 1, 1, 1, 1)) {
                ++n;
            }
            if (this.equalCubieIgnoreTwist(1, 1, -1, 1, 1, -1)) {
                ++n;
            }
            if (this.equalCubieIgnoreTwist(-1, 1, -1, -1, 1, -1)) {
                ++n;
            }
            if (n >= 2) continue;
            this.turn(1, 1, -1);
        } while (n < 2);
    }

    private void lastSideCornerMove() {
        if (this.equalCubieIgnoreTwist(1, 1, 1, -1, 1, -1) && this.equalCubieIgnoreTwist(-1, 1, -1, 1, 1, 1)) {
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
        }
        if (this.equalCubieIgnoreTwist(-1, 1, 1, 1, 1, 1) && this.equalCubieIgnoreTwist(1, 1, 1, -1, 1, 1)) {
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 1);
            this.turn(2, -1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
        }
    }

    private void lastSideCornerTwist() {
        if (this.equalFacelet(1, 1, 1, R, U) && this.equalFacelet(-1, 1, -1, B, U)) {
            this.turn(2, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
        }
        if (this.equalFacelet(-1, 1, 1, F, U) && this.equalFacelet(-1, 1, -1, B, U)) {
            this.turn(2, 1, 0);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, 1);
        }
        if (this.equalFacelet(1, 1, 1, R, U) && this.equalFacelet(1, 1, -1, R, U)) {
            this.turn(2, -1, 1);
            this.turn(2, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, -1, -1);
        }
        if (this.equalFacelet(-1, 1, 1, F, U) && this.equalFacelet(1, 1, 1, R, U) && this.equalFacelet(-1, 1, -1, L, U)) {
            this.turn(2, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, 0);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, 1);
        }
        if (this.equalFacelet(-1, 1, 1, L, U) && this.equalFacelet(1, 1, 1, F, U) && this.equalFacelet(-1, 1, -1, B, U)) {
            this.turn(2, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(1, 1, -1);
            this.turn(2, 1, 0);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
        }
    }

    private void lastSideEdgeMove() {
        if (this.equalCubieIgnoreTwist(1, 1, 0, 0, 1, 1) && this.equalCubieIgnoreTwist(-1, 1, 0, 1, 1, 0) && this.equalCubieIgnoreTwist(0, 1, 1, -1, 1, 0)) {
            this.turn(2, 1, 0);
            this.turn(1, 1, -1);
            this.turn(0, 0, -1);
            this.turn(1, 1, 0);
            this.turn(0, 0, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, 0);
        }
        if (this.equalCubieIgnoreTwist(-1, 1, 0, 0, 1, 1) && this.equalCubieIgnoreTwist(0, 1, 1, 1, 1, 0) && this.equalCubieIgnoreTwist(1, 1, 0, -1, 1, 0)) {
            this.turn(2, 1, 0);
            this.turn(1, 1, 1);
            this.turn(0, 0, -1);
            this.turn(1, 1, 0);
            this.turn(0, 0, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 0);
        }
        if (this.equalCubieIgnoreTwist(0, 1, 1, 1, 1, 0) && this.equalCubieIgnoreTwist(1, 1, 0, 0, 1, 1) && this.equalCubieIgnoreTwist(0, 1, -1, -1, 1, 0) && this.equalCubieIgnoreTwist(-1, 1, 0, 0, 1, -1)) {
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 0);
            this.turn(0, -1, -1);
            this.turn(1, 1, 1);
            this.turn(0, -1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, -1);
        }
        if (this.equalCubieIgnoreTwist(0, 1, 1, 0, 1, -1) && this.equalCubieIgnoreTwist(0, 1, -1, 0, 1, 1) && this.equalCubieIgnoreTwist(1, 1, 0, -1, 1, 0) && this.equalCubieIgnoreTwist(-1, 1, 0, 1, 1, 0)) {
            this.turn(0, 1, -1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 0);
            this.turn(0, 1, 1);
            this.turn(0, -1, -1);
            this.turn(2, 1, 1);
            this.turn(2, -1, -1);
            this.turn(1, 1, 0);
            this.turn(2, 1, -1);
            this.turn(2, -1, 1);
        }
    }

    private void lastSideEdgeTwist() {
        if (this.equalFacelet(0, 1, 1, F, U) && this.equalFacelet(1, 1, 0, R, U)) {
            this.turn(0, 1, 1);
            this.turn(1, 1, 0);
            this.turn(0, 1, 0);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(2, 1, 1);
            this.turn(0, -1, -1);
        }
        if (this.equalFacelet(1, 1, 0, R, U) && this.equalFacelet(-1, 1, 0, L, U)) {
            this.turn(1, 1, -1);
            this.turn(2, 0, -1);
            this.turn(1, 1, -1);
            this.turn(2, 0, -1);
            this.turn(1, 1, -1);
            this.turn(2, 0, -1);
            this.turn(1, 1, -1);
            this.turn(2, 0, -1);
            this.turn(1, 1, 1);
            this.turn(2, 0, 1);
            this.turn(1, 1, 1);
            this.turn(2, 0, 1);
            this.turn(1, 1, 1);
            this.turn(2, 0, 1);
            this.turn(1, 1, 1);
            this.turn(2, 0, 1);
        }
    }

    private void lastSideCorners() {
        if (this.equalCubie(1, 1, -1) && this.equalCubie(-1, 1, 1) && this.equalCubieAndFacelet(1, 1, 1, R, U) && this.equalCubieAndFacelet(-1, 1, -1, B, U)) {
            this.turn(2, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
        }
        if (this.equalCubie(-1, 1, 1) && this.equalCubie(-1, 1, -1) && this.equalCubieAndFacelet(1, 1, 1, R, U) && this.equalCubieAndFacelet(1, 1, -1, R, U)) {
            this.turn(2, -1, 1);
            this.turn(1, 1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 0);
            this.turn(2, -1, 0);
            this.turn(1, 1, 1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 1);
            this.turn(2, -1, -1);
            this.turn(1, 1, 0);
            this.turn(2, -1, 1);
        }
        if (this.equalCubie(1, 1, -1) && this.equalCubie(-1, 1, -1) && this.equalCubieAndFacelet(1, 1, 1, R, U) && this.equalCubieAndFacelet(-1, 1, 1, L, U)) {
            this.turn(0, -1, 1);
            this.turn(1, 1, 0);
            this.turn(0, -1, -1);
            this.turn(1, 1, 1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 1);
            this.turn(0, -1, 0);
            this.turn(1, 1, 0);
            this.turn(0, -1, 1);
            this.turn(1, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, 1, -1);
            this.turn(0, -1, 1);
        }
        if (this.equalCubie(1, 1, 1) && this.equalCubieAndFacelet(1, 1, -1, R, U) && this.equalCubieAndFacelet(-1, 1, -1, B, U) && this.equalCubieAndFacelet(-1, 1, 1, L, U)) {
            this.turn(2, -1, 1);
            this.turn(1, 1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 0);
            this.turn(2, -1, -1);
            this.turn(1, 1, 0);
        }
        if (this.equalCubie(1, 1, -1) && this.equalCubieAndFacelet(-1, 1, -1, L, U) && this.equalCubieAndFacelet(-1, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, 1, R, U)) {
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, -1);
            this.turn(1, 1, 0);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, -1, B, U) && this.equalCubieAndFacelet(-1, 1, -1, B, U) && this.equalCubieAndFacelet(-1, 1, 1, F, U)) {
            this.turn(2, -1, 1);
            this.turn(1, 1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 1);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 0);
            this.turn(2, -1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, -1, B, U) && this.equalCubieAndFacelet(-1, 1, -1, L, U) && this.equalCubieAndFacelet(-1, 1, 1, L, U)) {
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
        }
        if (this.equalCubie(1, 1, -1) && this.equalCubie(-1, 1, 1) && this.equalCubieAndFacelet(1, 1, 1, U, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, U, 1, 1, 1, U)) {
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(0, -1, -1);
            this.turn(1, 1, 1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 0);
            this.turn(2, -1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, 0);
            this.turn(0, -1, -1);
        }
        if (this.equalCubie(1, 1, -1) && this.equalCubie(-1, 1, 1) && this.equalCubieAndFacelet(1, 1, 1, R, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, B, 1, 1, 1, U)) {
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(2, 1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(0, -1, 0);
            this.turn(1, 1, -1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 1);
        }
        if (this.equalCubieAndFacelet(-1, 1, -1, B, -1, 1, -1, U) && this.equalCubieAndFacelet(1, 1, 1, R, 1, 1, 1, U) && this.equalCubieAndFacelet(-1, 1, 1, U, 1, 1, -1, U) && this.equalCubieAndFacelet(1, 1, -1, U, -1, 1, 1, U)) {
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(2, 1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(0, -1, 0);
            this.turn(1, 1, -1);
            this.turn(0, -1, 1);
            this.turn(1, 1, -1);
        }
        if (this.equalCubie(1, 1, -1) && this.equalCubieAndFacelet(-1, 1, 1, L, U) && this.equalCubieAndFacelet(1, 1, 1, U, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, L, 1, 1, 1, U)) {
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
        }
        if (this.equalCubie(1, 1, 1) && this.equalCubieAndFacelet(-1, 1, -1, L, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, 1, L, 1, 1, -1, U) && this.equalCubieAndFacelet(1, 1, -1, U, -1, 1, 1, U)) {
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
        }
        if (this.equalCubie(1, 1, -1) && this.equalCubieAndFacelet(-1, 1, 1, L, U) && this.equalCubieAndFacelet(1, 1, 1, R, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, L, 1, 1, 1, U)) {
            this.turn(2, -1, -1);
            this.turn(0, -1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 0);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, 0);
        }
        if (this.equalCubie(-1, 1, -1) && this.equalCubieAndFacelet(1, 1, 1, R, 1, 1, 1, U) && this.equalCubieAndFacelet(-1, 1, 1, L, 1, 1, -1, U) && this.equalCubieAndFacelet(1, 1, -1, U, -1, 1, 1, U)) {
            this.turn(2, -1, -1);
            this.turn(0, -1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 0);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, 0);
            this.turn(1, 1, 0);
        }
        if (this.equalCubieAndFacelet(1, 1, -1, R, U) && this.equalCubieAndFacelet(-1, 1, 1, L, U) && this.equalCubieAndFacelet(1, 1, 1, F, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, U, 1, 1, 1, U)) {
            this.turn(2, -1, 1);
            this.turn(1, 1, -1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 1);
            this.turn(0, -1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 0);
            this.turn(2, -1, -1);
            this.turn(1, 1, 1);
        }
        if (this.equalCubie(-1, 1, -1) && this.equalCubieAndFacelet(1, 1, 1, F, 1, 1, 1, U) && this.equalCubieAndFacelet(-1, 1, 1, L, 1, 1, -1, U) && this.equalCubieAndFacelet(1, 1, -1, R, -1, 1, 1, U)) {
            this.turn(2, -1, 1);
            this.turn(1, 1, -1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 1);
            this.turn(0, -1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 0);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, -1, B, U) && this.equalCubie(-1, 1, 1) && this.equalCubieAndFacelet(1, 1, 1, R, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, L, 1, 1, 1, U)) {
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
            this.turn(0, -1, -1);
            this.turn(1, 1, -1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, -1);
            this.turn(1, 1, 1);
        }
        if (this.equalCubieAndFacelet(-1, 1, -1, L, -1, 1, -1, U) && this.equalCubieAndFacelet(1, 1, 1, R, 1, 1, 1, U) && this.equalCubieAndFacelet(-1, 1, 1, U, 1, 1, -1, U) && this.equalCubieAndFacelet(1, 1, -1, B, -1, 1, 1, U)) {
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
            this.turn(0, -1, -1);
            this.turn(1, 1, -1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, -1);
            this.turn(1, 1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, -1, B, U) && this.equalCubieAndFacelet(-1, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, 1, F, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, B, 1, 1, 1, U)) {
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
        }
        if (this.equalCubieAndFacelet(-1, 1, -1, B, -1, 1, -1, U) && this.equalCubieAndFacelet(1, 1, 1, F, 1, 1, 1, U) && this.equalCubieAndFacelet(-1, 1, 1, F, 1, 1, -1, U) && this.equalCubieAndFacelet(1, 1, -1, B, -1, 1, 1, U)) {
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
        }
        if (this.equalCubieAndFacelet(1, 1, -1, B, U) && this.equalCubieAndFacelet(-1, 1, 1, L, U) && this.equalCubieAndFacelet(1, 1, 1, R, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, B, 1, 1, 1, U)) {
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
        }
        if (this.equalCubieAndFacelet(-1, 1, -1, B, -1, 1, -1, U) && this.equalCubieAndFacelet(1, 1, 1, R, 1, 1, 1, U) && this.equalCubieAndFacelet(-1, 1, 1, L, 1, 1, -1, U) && this.equalCubieAndFacelet(1, 1, -1, B, -1, 1, 1, U)) {
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
        }
        if (this.equalCubie(1, 1, 1) && this.equalCubie(-1, 1, 1) && this.equalCubieAndFacelet(1, 1, -1, U, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, U, 1, 1, -1, U)) {
            this.turn(0, 1, -1);
            this.turn(2, -1, -1);
            this.turn(0, 1, -1);
            this.turn(2, 1, 0);
            this.turn(0, 1, 1);
            this.turn(2, -1, 1);
            this.turn(0, 1, -1);
            this.turn(2, 1, 0);
            this.turn(0, 1, 0);
            this.turn(1, 1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, F, U) && this.equalCubieAndFacelet(-1, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, -1, B, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, B, 1, 1, -1, U)) {
            this.turn(2, -1, 1);
            this.turn(1, 1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, 1);
            this.turn(2, 1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, R, U) && this.equalCubieAndFacelet(-1, 1, 1, L, U) && this.equalCubieAndFacelet(1, 1, -1, B, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, B, 1, 1, -1, U)) {
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 1);
            this.turn(2, -1, -1);
            this.turn(1, 1, 1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 1);
            this.turn(2, -1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, R, U) && this.equalCubieAndFacelet(-1, 1, 1, L, U) && this.equalCubieAndFacelet(1, 1, -1, R, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, L, 1, 1, -1, U)) {
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 0);
            this.turn(2, 1, 1);
            this.turn(0, -1, -1);
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, F, U) && this.equalCubieAndFacelet(-1, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, -1, R, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, L, 1, 1, -1, U)) {
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(0, -1, -1);
            this.turn(2, -1, 1);
            this.turn(0, -1, 1);
            this.turn(2, 1, 0);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, 1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, F, U) && this.equalCubieAndFacelet(-1, 1, 1, L, U) && this.equalCubieAndFacelet(1, 1, -1, B, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, L, 1, 1, -1, U)) {
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 1);
            this.turn(2, -1, 0);
            this.turn(0, 1, 1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 0);
            this.turn(2, -1, 1);
            this.turn(1, 1, 0);
            this.turn(2, -1, -1);
            this.turn(1, 1, 1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, R, U) && this.equalCubieAndFacelet(-1, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, -1, R, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, B, 1, 1, -1, U)) {
            this.turn(0, -1, -1);
            this.turn(1, 1, 1);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, 0);
            this.turn(0, -1, 1);
            this.turn(2, -1, -1);
            this.turn(1, 1, 0);
            this.turn(2, -1, -1);
            this.turn(1, 1, 0);
            this.turn(2, -1, 1);
            this.turn(1, 1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, U, U) && this.equalCubieAndFacelet(-1, 1, 1, L, U) && this.equalCubieAndFacelet(1, 1, -1, B, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, U, 1, 1, -1, U)) {
            this.turn(0, 1, 1);
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(0, 1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, R, U) && this.equalCubieAndFacelet(-1, 1, 1, U, U) && this.equalCubieAndFacelet(1, 1, -1, U, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, B, 1, 1, -1, U)) {
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(0, -1, -1);
            this.turn(1, 1, 1);
            this.turn(0, -1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 1);
            this.turn(0, -1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, U, U) && this.equalCubieAndFacelet(-1, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, -1, U, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, B, 1, 1, -1, U)) {
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, 1);
            this.turn(0, 1, 1);
            this.turn(2, 1, 1);
            this.turn(0, 1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, F, U) && this.equalCubieAndFacelet(-1, 1, 1, U, U) && this.equalCubieAndFacelet(1, 1, -1, B, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, U, 1, 1, -1, U)) {
            this.turn(0, -1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
            this.turn(0, -1, -1);
            this.turn(1, 1, -1);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(0, -1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, U, U) && this.equalCubieAndFacelet(-1, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, -1, R, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, U, 1, 1, -1, U)) {
            this.turn(0, 1, -1);
            this.turn(1, 1, 0);
            this.turn(0, 1, -1);
            this.turn(1, -1, 1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 0);
            this.turn(0, 1, -1);
            this.turn(1, -1, -1);
            this.turn(0, 1, 0);
            this.turn(1, 1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, R, U) && this.equalCubieAndFacelet(-1, 1, 1, U, U) && this.equalCubieAndFacelet(1, 1, -1, U, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, L, 1, 1, -1, U)) {
            this.turn(0, -1, -1);
            this.turn(1, 1, 0);
            this.turn(0, -1, -1);
            this.turn(1, -1, -1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 0);
            this.turn(0, -1, -1);
            this.turn(1, -1, 1);
            this.turn(0, -1, 0);
            this.turn(1, 1, 1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, U, U) && this.equalCubieAndFacelet(-1, 1, 1, L, U) && this.equalCubieAndFacelet(1, 1, -1, U, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, L, 1, 1, -1, U)) {
            this.turn(2, 1, 0);
            this.turn(1, -1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, -1);
            this.turn(1, -1, -1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, R, U) && this.equalCubieAndFacelet(-1, 1, 1, U, U) && this.equalCubieAndFacelet(1, 1, -1, R, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, U, 1, 1, -1, U)) {
            this.turn(2, 1, 0);
            this.turn(1, -1, -1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 0);
            this.turn(2, 1, 1);
            this.turn(1, -1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 0);
            this.turn(2, 1, -1);
            this.turn(1, 1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, U, U) && this.equalCubieAndFacelet(-1, 1, 1, U, U) && this.equalCubieAndFacelet(1, 1, -1, B, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, B, 1, 1, -1, U)) {
            this.turn(2, -1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, 0);
            this.turn(0, -1, -1);
            this.turn(1, 1, -1);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 0);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, U, U) && this.equalCubieAndFacelet(-1, 1, 1, U, U) && this.equalCubieAndFacelet(1, 1, -1, R, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, L, 1, 1, -1, U)) {
            this.turn(0, 1, 1);
            this.turn(1, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, 1, 1);
            this.turn(0, 1, -1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 0);
            this.turn(0, -1, -1);
            this.turn(1, 1, 1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 0);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, R, U) && this.equalCubieAndFacelet(-1, 1, 1, L, U) && this.equalCubieAndFacelet(1, 1, -1, U, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, U, 1, 1, -1, U)) {
            this.turn(2, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, -1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, 0);
            this.turn(0, 1, 1);
            this.turn(1, -1, 1);
            this.turn(0, 1, -1);
            this.turn(1, 1, 0);
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, F, U) && this.equalCubieAndFacelet(-1, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, -1, U, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, U, 1, 1, -1, U)) {
            this.turn(0, 1, -1);
            this.turn(1, 1, 0);
            this.turn(2, -1, -1);
            this.turn(1, -1, -1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 0);
            this.turn(2, -1, -1);
            this.turn(1, -1, 1);
            this.turn(2, -1, 1);
            this.turn(0, 1, 1);
            this.turn(1, 1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, R, U) && this.equalCubieAndFacelet(-1, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, -1, U, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, L, 1, 1, -1, U)) {
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, 0);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, F, U) && this.equalCubieAndFacelet(-1, 1, 1, L, U) && this.equalCubieAndFacelet(1, 1, -1, R, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, U, 1, 1, -1, U)) {
            this.turn(2, 1, -1);
            this.turn(1, 1, 1);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 0);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, F, U) && this.equalCubieAndFacelet(-1, 1, 1, L, U) && this.equalCubieAndFacelet(1, 1, -1, U, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, B, 1, 1, -1, U)) {
            this.turn(0, 1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, 0);
            this.turn(2, -1, 1);
            this.turn(0, 1, 1);
            this.turn(2, -1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, 0);
            this.turn(0, 1, 1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, R, U) && this.equalCubieAndFacelet(-1, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, -1, B, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, U, 1, 1, -1, U)) {
            this.turn(0, -1, -1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 0);
            this.turn(2, -1, -1);
            this.turn(0, -1, 1);
            this.turn(2, -1, 1);
            this.turn(0, -1, -1);
            this.turn(1, 1, 0);
            this.turn(0, -1, 1);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, U, U) && this.equalCubieAndFacelet(-1, 1, 1, L, U) && this.equalCubieAndFacelet(1, 1, -1, R, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, B, 1, 1, -1, U)) {
            this.turn(0, 1, -1);
            this.turn(2, -1, -1);
            this.turn(0, 1, 1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 0);
            this.turn(2, -1, 1);
            this.turn(1, 1, 0);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, R, U) && this.equalCubieAndFacelet(-1, 1, 1, U, U) && this.equalCubieAndFacelet(1, 1, -1, B, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, L, 1, 1, -1, U)) {
            this.turn(0, -1, -1);
            this.turn(2, -1, 1);
            this.turn(0, -1, 1);
            this.turn(2, -1, -1);
            this.turn(1, 1, 0);
            this.turn(2, -1, -1);
            this.turn(1, 1, 0);
            this.turn(2, -1, 1);
            this.turn(1, 1, 1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, U, U) && this.equalCubieAndFacelet(-1, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, -1, B, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, L, 1, 1, -1, U)) {
            this.turn(0, 1, -1);
            this.turn(1, 1, 0);
            this.turn(0, 1, 1);
            this.turn(1, 1, 0);
            this.turn(0, 1, 1);
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
        }
        if (this.equalCubieAndFacelet(1, 1, 1, F, U) && this.equalCubieAndFacelet(-1, 1, 1, U, U) && this.equalCubieAndFacelet(1, 1, -1, R, -1, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, -1, B, 1, 1, -1, U)) {
            this.turn(0, -1, -1);
            this.turn(1, 1, 0);
            this.turn(0, -1, 1);
            this.turn(1, 1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, 1);
            this.turn(0, -1, -1);
            this.turn(2, 1, -1);
            this.turn(1, 1, -1);
        }
    }

    private void lastSideEdges() {
        if (this.equalCubie(0, 1, -1) && this.equalCubie(0, 1, 1) && this.equalCubieAndFacelet(1, 1, 0, R, U) && this.equalCubieAndFacelet(-1, 1, 0, L, U)) {
            this.turn(2, 1, -1);
            this.turn(2, -1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, 1);
            this.turn(0, 1, -1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(2, -1, 1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, -1);
            this.turn(0, -1, -1);
            this.turn(1, 1, -1);
        }
        if (this.equalCubie(0, 1, -1) && this.equalCubie(-1, 1, 0) && this.equalCubieAndFacelet(1, 1, 0, R, U) && this.equalCubieAndFacelet(0, 1, 1, F, U)) {
            this.turn(0, 1, 1);
            this.turn(1, 1, 0);
            this.turn(0, 1, 0);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(2, 1, 1);
            this.turn(0, -1, -1);
        }
        if (this.equalCubieAndFacelet(0, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, 0, R, U) && this.equalCubieAndFacelet(0, 1, -1, B, U) && this.equalCubieAndFacelet(-1, 1, 0, L, U)) {
            this.turn(0, 1, 0);
            this.turn(0, -1, 0);
            this.turn(2, -1, 0);
            this.turn(0, 1, 1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 0);
            this.turn(2, -1, -1);
            this.turn(1, 1, 0);
            this.turn(0, 1, -1);
            this.turn(0, -1, -1);
            this.turn(2, -1, 0);
            this.turn(0, 1, 0);
            this.turn(0, -1, 0);
            this.turn(1, 1, -1);
        }
        if (this.equalCubieAndFacelet(0, 1, -1, U, 0, 1, 1, U) && this.equalCubieAndFacelet(0, 1, 1, U, 0, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, 0, U, 1, 1, 0, U) && this.equalCubieAndFacelet(1, 1, 0, U, -1, 1, 0, U)) {
            this.turn(0, 1, -1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 0);
            this.turn(0, 1, 1);
            this.turn(0, -1, -1);
            this.turn(2, 1, 1);
            this.turn(2, -1, -1);
            this.turn(1, 1, 0);
            this.turn(2, 1, -1);
            this.turn(2, -1, 1);
        }
        if (this.equalCubieAndFacelet(0, 1, -1, U, 0, 1, 1, U) && this.equalCubieAndFacelet(0, 1, 1, U, 0, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, 0, L, 1, 1, 0, U) && this.equalCubieAndFacelet(1, 1, 0, R, -1, 1, 0, U)) {
            this.turn(0, 1, 1);
            this.turn(1, 1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 0);
            this.turn(1, 1, 0);
            this.turn(0, 1, 0);
            this.turn(1, 1, 0);
            this.turn(0, 1, 0);
            this.turn(1, 1, -1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 1);
            this.turn(0, 1, -1);
        }
        if (this.equalCubieAndFacelet(0, 1, -1, B, 0, 1, 1, U) && this.equalCubieAndFacelet(0, 1, 1, F, 0, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, 0, L, 1, 1, 0, U) && this.equalCubieAndFacelet(1, 1, 0, R, -1, 1, 0, U)) {
            this.turn(2, -1, 1);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, -1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
            this.turn(0, -1, -1);
        }
        if (this.equalCubieAndFacelet(0, 1, -1, B, 0, 1, 1, U) && this.equalCubieAndFacelet(0, 1, 1, U, 0, 1, -1, U) && this.equalCubieAndFacelet(-1, 1, 0, U, 1, 1, 0, U) && this.equalCubieAndFacelet(1, 1, 0, R, -1, 1, 0, U)) {
            this.turn(2, 1, -1);
            this.turn(1, 1, 0);
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, 0);
            this.turn(2, -1, 1);
            this.turn(1, 1, -1);
            this.turn(0, -1, 1);
        }
        if (this.equalCubieAndFacelet(0, 1, 1, U, 1, 1, 0, U) && this.equalCubieAndFacelet(1, 1, 0, U, 0, 1, 1, U) && this.equalCubieAndFacelet(-1, 1, 0, U, 0, 1, -1, U) && this.equalCubieAndFacelet(0, 1, -1, U, -1, 1, 0, U)) {
            this.turn(2, 1, 0);
            this.turn(2, -1, 0);
            this.turn(1, 1, -1);
            this.turn(2, 1, 0);
            this.turn(0, 1, 0);
            this.turn(0, -1, 0);
            this.turn(2, -1, 0);
            this.turn(0, 1, 0);
            this.turn(0, -1, 0);
            this.turn(1, 1, 1);
            this.turn(2, 1, 0);
            this.turn(2, -1, 0);
        }
        if (this.equalCubieAndFacelet(0, 1, 1, F, 1, 1, 0, U) && this.equalCubieAndFacelet(1, 1, 0, R, 0, 1, 1, U) && this.equalCubieAndFacelet(-1, 1, 0, U, 0, 1, -1, U) && this.equalCubieAndFacelet(0, 1, -1, U, -1, 1, 0, U)) {
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 0);
            this.turn(0, -1, -1);
            this.turn(1, 1, 1);
            this.turn(0, -1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, -1);
        }
        if (this.equalCubieAndFacelet(0, 1, 1, F, 1, 1, 0, U) && this.equalCubieAndFacelet(1, 1, 0, R, 0, 1, 1, U) && this.equalCubieAndFacelet(-1, 1, 0, L, 0, 1, -1, U) && this.equalCubieAndFacelet(0, 1, -1, B, -1, 1, 0, U)) {
            this.turn(0, 1, -1);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 0);
            this.turn(0, 1, 0);
            this.turn(1, 1, 0);
            this.turn(0, 1, 0);
            this.turn(1, 1, 0);
            this.turn(0, 1, 0);
            this.turn(2, 1, 1);
            this.turn(0, 1, 1);
            this.turn(0, -1, -1);
        }
        if (this.equalCubieAndFacelet(0, 1, 1, U, 1, 1, 0, U) && this.equalCubieAndFacelet(1, 1, 0, R, 0, 1, 1, U) && this.equalCubieAndFacelet(-1, 1, 0, L, 0, 1, -1, U) && this.equalCubieAndFacelet(0, 1, -1, U, -1, 1, 0, U)) {
            this.turn(0, 0, 1);
            this.turn(1, 1, -1);
            this.turn(0, 0, -1);
            this.turn(1, 1, -1);
            this.turn(0, 0, 1);
            this.turn(1, 1, 1);
            this.turn(0, 0, -1);
            this.turn(1, 1, -1);
            this.turn(0, 0, 1);
            this.turn(1, 1, -1);
            this.turn(0, 0, -1);
            this.turn(1, 1, -1);
        }
        if (this.equalCubieAndFacelet(0, 1, 1, U, -1, 1, 0, U) && this.equalCubieAndFacelet(-1, 1, 0, L, 0, 1, 1, U) && this.equalCubieAndFacelet(1, 1, 0, R, 0, 1, -1, U) && this.equalCubieAndFacelet(0, 1, -1, U, 1, 1, 0, U)) {
            this.turn(0, 0, 1);
            this.turn(1, 1, 1);
            this.turn(0, 0, -1);
            this.turn(1, 1, 1);
            this.turn(0, 0, 1);
            this.turn(1, 1, -1);
            this.turn(0, 0, -1);
            this.turn(1, 1, 1);
            this.turn(0, 0, 1);
            this.turn(1, 1, 1);
            this.turn(0, 0, -1);
            this.turn(1, 1, 1);
        }
        if (this.equalCubieAndFacelet(0, 1, 1, U, -1, 1, 0, U) && this.equalCubieAndFacelet(-1, 1, 0, L, 0, 1, 1, U) && this.equalCubieAndFacelet(1, 1, 0, U, 0, 1, -1, U) && this.equalCubieAndFacelet(0, 1, -1, B, 1, 1, 0, U)) {
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, -1);
            this.turn(0, 1, -1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 0);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, 1);
            this.turn(0, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 0);
        }
        if (this.equalCubie(0, 1, -1) && this.equalCubieAndFacelet(-1, 1, 0, U, 1, 1, 0, U) && this.equalCubieAndFacelet(1, 1, 0, U, 0, 1, 1, U) && this.equalCubieAndFacelet(0, 1, 1, U, -1, 1, 0, U)) {
            this.turn(2, 1, 0);
            this.turn(1, 1, -1);
            this.turn(0, 0, -1);
            this.turn(1, 1, 0);
            this.turn(0, 0, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, 0);
        }
        if (this.equalCubie(0, 1, -1) && this.equalCubieAndFacelet(1, 1, 0, U, -1, 1, 0, U) && this.equalCubieAndFacelet(-1, 1, 0, U, 0, 1, 1, U) && this.equalCubieAndFacelet(0, 1, 1, U, 1, 1, 0, U)) {
            this.turn(2, 1, 0);
            this.turn(1, 1, 1);
            this.turn(0, 0, -1);
            this.turn(1, 1, 0);
            this.turn(0, 0, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 0);
        }
        if (this.equalCubie(0, 1, -1) && this.equalCubieAndFacelet(-1, 1, 0, U, 1, 1, 0, U) && this.equalCubieAndFacelet(1, 1, 0, R, 0, 1, 1, U) && this.equalCubieAndFacelet(0, 1, 1, F, -1, 1, 0, U)) {
            this.turn(0, 0, 1);
            this.turn(1, 1, -1);
            this.turn(0, 0, -1);
            this.turn(1, 1, 0);
            this.turn(0, 0, 1);
            this.turn(1, 1, -1);
            this.turn(0, 0, -1);
        }
        if (this.equalCubie(0, 1, -1) && this.equalCubieAndFacelet(1, 1, 0, U, -1, 1, 0, U) && this.equalCubieAndFacelet(-1, 1, 0, L, 0, 1, 1, U) && this.equalCubieAndFacelet(0, 1, 1, F, 1, 1, 0, U)) {
            this.turn(0, 0, 1);
            this.turn(1, 1, 1);
            this.turn(0, 0, -1);
            this.turn(1, 1, 0);
            this.turn(0, 0, 1);
            this.turn(1, 1, 1);
            this.turn(0, 0, -1);
        }
        if (this.equalCubie(-1, 1, 0) && this.equalCubieAndFacelet(0, 1, 1, F, 0, 1, -1, U) && this.equalCubieAndFacelet(0, 1, -1, U, 1, 1, 0, U) && this.equalCubieAndFacelet(1, 1, 0, R, 0, 1, 1, U)) {
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, -1);
            this.turn(2, 1, 1);
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(0, 1, -1);
            this.turn(2, -1, 1);
        }
        if (this.equalCubie(0, 1, -1) && this.equalCubieAndFacelet(-1, 1, 0, L, 1, 1, 0, U) && this.equalCubieAndFacelet(1, 1, 0, R, 0, 1, 1, U) && this.equalCubieAndFacelet(0, 1, 1, U, -1, 1, 0, U)) {
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, -1);
            this.turn(0, 1, -1);
            this.turn(2, -1, 1);
        }
        if (this.equalCubie(1, 1, 0) && this.equalCubieAndFacelet(0, 1, 1, F, 0, 1, -1, U) && this.equalCubieAndFacelet(0, 1, -1, U, -1, 1, 0, U) && this.equalCubieAndFacelet(-1, 1, 0, L, 0, 1, 1, F)) {
            this.turn(0, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(2, -1, 1);
            this.turn(0, -1, 1);
            this.turn(1, 1, -1);
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
        }
        if (this.equalCubie(0, 1, -1) && this.equalCubieAndFacelet(1, 1, 0, R, -1, 1, 0, U) && this.equalCubieAndFacelet(-1, 1, 0, L, 0, 1, 1, U) && this.equalCubieAndFacelet(0, 1, 1, U, 1, 1, 0, U)) {
            this.turn(0, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(2, -1, 1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 1);
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
        }
        if (this.equalCubieAndFacelet(0, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, 0, R, -1, 1, 0, U) && this.equalCubieAndFacelet(-1, 1, 0, U, 0, 1, -1, U) && this.equalCubieAndFacelet(0, 1, -1, U, 1, 1, 0, U)) {
            this.turn(2, -1, 1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, -1);
            this.turn(2, 1, 1);
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
        }
        if (this.equalCubieAndFacelet(0, 1, 1, F, U) && this.equalCubieAndFacelet(-1, 1, 0, U, 1, 1, 0, U) && this.equalCubieAndFacelet(1, 1, 0, R, 0, 1, -1, U) && this.equalCubieAndFacelet(0, 1, -1, U, -1, 1, 0, U)) {
            this.turn(2, -1, 1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, -1);
            this.turn(2, 1, 1);
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
            this.turn(2, 1, 1);
            this.turn(0, -1, -1);
            this.turn(1, 1, -1);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, 1);
            this.turn(0, 1, 1);
        }
        if (this.equalCubieAndFacelet(1, 1, 0, R, U) && this.equalCubieAndFacelet(0, 1, 1, F, 0, 1, -1, U) && this.equalCubieAndFacelet(0, 1, -1, U, -1, 1, 0, U) && this.equalCubieAndFacelet(-1, 1, 0, U, 0, 1, 1, U)) {
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(0, 1, -1);
            this.turn(2, -1, 1);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, 1);
            this.turn(0, 1, 1);
            this.turn(2, 1, 1);
        }
        if (this.equalCubieAndFacelet(1, 1, 0, R, U) && this.equalCubieAndFacelet(0, 1, -1, U, 0, 1, 1, U) && this.equalCubieAndFacelet(0, 1, 1, F, -1, 1, 0, U) && this.equalCubieAndFacelet(-1, 1, 0, U, 0, 1, -1, U)) {
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(0, 1, -1);
            this.turn(2, -1, 1);
            this.turn(0, -1, 1);
            this.turn(0, 1, -1);
            this.turn(2, -1, 1);
            this.turn(1, 1, 1);
            this.turn(2, -1, -1);
            this.turn(0, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, -1);
        }
        if (this.equalCubieAndFacelet(0, 1, 1, F, U) && this.equalCubieAndFacelet(1, 1, 0, U, -1, 1, 0, U) && this.equalCubieAndFacelet(-1, 1, 0, U, 0, 1, -1, U) && this.equalCubieAndFacelet(0, 1, -1, B, 1, 1, 0, U)) {
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(2, 1, 1);
            this.turn(0, -1, -1);
            this.turn(1, 1, 1);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(2, -1, 1);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
        }
        if (this.equalCubieAndFacelet(0, 1, 1, F, U) && this.equalCubieAndFacelet(-1, 1, 0, U, 1, 1, 0, U) && this.equalCubieAndFacelet(1, 1, 0, U, 0, 1, -1, U) && this.equalCubieAndFacelet(0, 1, -1, B, -1, 1, 0, U)) {
            this.turn(0, -1, -1);
            this.turn(1, 1, 1);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(2, 1, 1);
            this.turn(2, -1, -1);
            this.turn(0, 1, 1);
            this.turn(2, 1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, -1);
            this.turn(1, 1, 1);
            this.turn(0, 1, -1);
            this.turn(2, -1, 1);
        }
        if (this.equalCubieAndFacelet(0, 1, -1, B, U) && this.equalCubieAndFacelet(-1, 1, 0, L, 1, 1, 0, U) && this.equalCubieAndFacelet(1, 1, 0, R, 0, 1, 1, U) && this.equalCubieAndFacelet(0, 1, 1, F, -1, 1, 0, U)) {
            this.turn(0, 1, -1);
            this.turn(2, -1, 1);
            this.turn(0, -1, 1);
            this.turn(1, 1, 1);
            this.turn(0, -1, -1);
            this.turn(1, 1, -1);
            this.turn(2, -1, -1);
            this.turn(0, 1, 1);
            this.turn(2, 1, 1);
            this.turn(0, -1, -1);
            this.turn(1, 1, 1);
            this.turn(0, -1, 1);
            this.turn(1, 1, -1);
            this.turn(2, 1, -1);
        }
        if (this.equalCubieAndFacelet(0, 1, -1, B, U) && this.equalCubieAndFacelet(1, 1, 0, R, -1, 1, 0, U) && this.equalCubieAndFacelet(-1, 1, 0, L, 0, 1, 1, U) && this.equalCubieAndFacelet(0, 1, 1, F, 1, 1, 0, U)) {
            this.turn(0, -1, -1);
            this.turn(2, -1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, 1);
            this.turn(2, -1, 1);
            this.turn(0, -1, 1);
            this.turn(2, 1, -1);
            this.turn(0, 1, -1);
            this.turn(1, 1, -1);
            this.turn(0, 1, 1);
            this.turn(1, 1, 1);
            this.turn(2, 1, 1);
        }
    }

    private int getIdByCoord(Cubie[] cubieArray, int n, int n2, int n3) {
        for (int i = 0; i < 27; ++i) {
            if (cubieArray[i].coord[0] != n || cubieArray[i].coord[1] != n2 || cubieArray[i].coord[2] != n3) continue;
            return cubieArray[i].id;
        }
        return 0;
    }

    private int getIndexByCoord(Cubie[] cubieArray, int n, int n2, int n3) {
        for (int i = 0; i < 27; ++i) {
            if (cubieArray[i].coord[0] != n || cubieArray[i].coord[1] != n2 || cubieArray[i].coord[2] != n3) continue;
            return i;
        }
        return 0;
    }

    private int getFacelet(Cubie cubie, int[] nArray) {
        for (int i = 0; i < 6; ++i) {
            if (!Arrays.equals(nArray, cubie.normal[i])) continue;
            return cubie.colors[i];
        }
        return 0;
    }

    private boolean equalCubieIgnoreTwist(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.getIdByCoord(this.cubies1, n, n2, n3) == this.getIdByCoord(this.cubies2, n4, n5, n6);
    }

    private boolean equalCubieIgnoreTwist(int n, int n2, int n3) {
        return this.getIdByCoord(this.cubies1, n, n2, n3) == this.getIdByCoord(this.cubies2, n, n2, n3);
    }

    private boolean equalCubie(int n, int n2, int n3) {
        return this.equalCubieIgnoreTwist(n, n2, n3, n, n2, n3) && this.equalFacelet(n, n2, n3, U, U) && this.equalFacelet(n, n2, n3, D, D) && this.equalFacelet(n, n2, n3, F, F) && this.equalFacelet(n, n2, n3, B, B) && this.equalFacelet(n, n2, n3, R, R) && this.equalFacelet(n, n2, n3, L, L);
    }

    private boolean equalFacelet(int n, int n2, int n3, int[] nArray, int n4, int n5, int n6, int[] nArray2) {
        int n7 = this.getIndexByCoord(this.cubies1, n, n2, n3);
        int n8 = this.getIndexByCoord(this.cubies2, n4, n5, n6);
        return this.getFacelet(this.cubies1[n7], nArray) == this.getFacelet(this.cubies2[n8], nArray2);
    }

    private boolean equalFacelet(int n, int n2, int n3, int[] nArray, int[] nArray2) {
        int n4 = this.getIndexByCoord(this.cubies1, n, n2, n3);
        int n5 = this.getIndexByCoord(this.cubies2, n, n2, n3);
        return this.getFacelet(this.cubies1[n4], nArray) == this.getFacelet(this.cubies2[n5], nArray2);
    }

    private boolean equalCubieAndFacelet(int n, int n2, int n3, int[] nArray, int n4, int n5, int n6, int[] nArray2) {
        return this.equalCubieIgnoreTwist(n, n2, n3, n4, n5, n6) && this.equalFacelet(n, n2, n3, nArray, n4, n5, n6, nArray2);
    }

    private boolean equalCubieAndFacelet(int n, int n2, int n3, int[] nArray, int[] nArray2) {
        return this.equalCubieIgnoreTwist(n, n2, n3, n, n2, n3) && this.equalFacelet(n, n2, n3, nArray, nArray2);
    }

    private void turn(int n, int n2, int n3) {
        block5: for (int i = 0; i < 27; ++i) {
            if (this.cubies1[i].coord[n] != n2) continue;
            switch (n) {
                case 0: {
                    this.cubies1[i].turnX(n3);
                    continue block5;
                }
                case 1: {
                    this.cubies1[i].turnY(n3);
                    continue block5;
                }
                case 2: {
                    this.cubies1[i].turnZ(n3);
                }
            }
        }
        this.instance.storeEvent(new CubeEvent(n, n2, n3, 2));
    }

    private void turn2(int n, int n2, int n3) {
        block5: for (int i = 0; i < 27; ++i) {
            if (this.cubies2[i].coord[n] != n2) continue;
            switch (n) {
                case 0: {
                    this.cubies2[i].turnX(n3);
                    continue block5;
                }
                case 1: {
                    this.cubies2[i].turnY(n3);
                    continue block5;
                }
                case 2: {
                    this.cubies2[i].turnZ(n3);
                }
            }
        }
    }

    private class Cubie {
        private int id;
        private int[] coord = new int[3];
        private int[] colors = new int[6];
        private int[][] normal = new int[6][3];

        private Cubie() {
        }

        private void vectorTurnX(int[] nArray, int n) {
            int n2 = 0;
            int n3 = 0;
            switch (n) {
                case -1: {
                    n2 = nArray[2];
                    n3 = -nArray[1];
                    break;
                }
                case 0: {
                    n2 = -nArray[1];
                    n3 = -nArray[2];
                    break;
                }
                case 1: {
                    n2 = -nArray[2];
                    n3 = nArray[1];
                }
            }
            nArray[2] = n3;
            nArray[1] = n2;
        }

        private void vectorTurnY(int[] nArray, int n) {
            int n2 = 0;
            int n3 = 0;
            switch (n) {
                case -1: {
                    n2 = -nArray[2];
                    n3 = nArray[0];
                    break;
                }
                case 0: {
                    n2 = -nArray[0];
                    n3 = -nArray[2];
                    break;
                }
                case 1: {
                    n2 = nArray[2];
                    n3 = -nArray[0];
                }
            }
            nArray[2] = n3;
            nArray[0] = n2;
        }

        private void vectorTurnZ(int[] nArray, int n) {
            int n2 = 0;
            int n3 = 0;
            switch (n) {
                case -1: {
                    n2 = nArray[1];
                    n3 = -nArray[0];
                    break;
                }
                case 0: {
                    n2 = -nArray[0];
                    n3 = -nArray[1];
                    break;
                }
                case 1: {
                    n2 = -nArray[1];
                    n3 = nArray[0];
                }
            }
            nArray[1] = n3;
            nArray[0] = n2;
        }

        private void turnX(int n) {
            this.vectorTurnX(this.coord, n);
            int n2 = 0;
            while (n2 < 6) {
                this.vectorTurnX(this.normal[n2++], n);
            }
        }

        private void turnY(int n) {
            this.vectorTurnY(this.coord, n);
            int n2 = 0;
            while (n2 < 6) {
                this.vectorTurnY(this.normal[n2++], n);
            }
        }

        private void turnZ(int n) {
            this.vectorTurnZ(this.coord, n);
            int n2 = 0;
            while (n2 < 6) {
                this.vectorTurnZ(this.normal[n2++], n);
            }
        }
    }
}

