/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import java.io.File;
import java.io.FileInputStream;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.common.Board;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Game;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.Pilot;
import megamek.common.Player;

public class ScenarioLoader {
    private File m_scenFile;
    private static final String[] FACING = new String[]{"N", "NE", "SE", "S", "SW", "NW"};
    private static final String[] DIRS = new String[]{"NW", "N", "NE", "E", "SE", "S", "SW", "W", "C"};
    private boolean[] m_baTakenDirs = new boolean[DIRS.length];

    public ScenarioLoader(File file) {
        this.m_scenFile = file;
    }

    public Game createGame() throws Exception {
        System.out.println("Loading scenario from " + this.m_scenFile);
        Properties properties = this.loadProperties();
        String string = properties.getProperty("MMSVersion");
        if (string == null) {
            throw new Exception("Not a valid MMS file.  No MMSVersion.");
        }
        Game game = new Game();
        game.board = this.createBoard(properties);
        Player[] playerArray = this.createPlayers(properties);
        int n = 0;
        while (n < playerArray.length) {
            game.addPlayer(n, playerArray[n]);
            ++n;
        }
        int n2 = 0;
        Coords coords = new Coords(game.board.width / 2, game.board.height / 2);
        int n3 = 0;
        while (n3 < playerArray.length) {
            Entity[] entityArray = this.buildFactionEntities(properties, playerArray[n3].getName());
            int n4 = 0;
            while (n4 < entityArray.length) {
                entityArray[n4].setOwner(playerArray[n3]);
                entityArray[n4].setId(n2++);
                game.addEntity(entityArray[n4].getId(), entityArray[n4]);
                if (entityArray[n4].getPosition() == null || entityArray[n4].getFacing() == -1) {
                    this.placeEntity(entityArray[n4], game);
                }
                ++n4;
            }
            ++n3;
        }
        game.getOptions().initialize();
        game.setHasDeployed(true);
        game.phase = 4;
        return game;
    }

    private void placeEntity(Entity entity, Game game) {
        if (entity.getPosition() == null) {
            Coords coords = this.getStartingCoords(game, entity.getOwner().getStartingPos());
            entity.setPosition(this.getCoordsAround(coords, game));
        }
        if (entity.getFacing() == -1) {
            int n = entity.getPosition().direction(this.getStartingCoords(game, 8));
            entity.setFacing(n);
            entity.setSecondaryFacing(n);
        }
    }

    private Coords getCoordsAround(Coords coords, Game game) {
        if (game.board.contains(coords) && game.getFirstEntity(coords) == null) {
            return coords;
        }
        int n = 0;
        while (n < 6) {
            Coords coords2 = coords.translated(n);
            if (game.board.contains(coords2) && game.getFirstEntity(coords2) == null) {
                return coords2;
            }
            ++n;
        }
        return this.getCoordsAround(coords.translated(Compute.random.nextInt(6)), game);
    }

    private Coords getStartingCoords(Game game, int n) {
        switch (n) {
            default: {
                return new Coords(1, 1);
            }
            case 1: {
                return new Coords(game.board.width / 2, 1);
            }
            case 2: {
                return new Coords(game.board.width - 2, 1);
            }
            case 3: {
                return new Coords(game.board.width - 2, game.board.height / 2);
            }
            case 4: {
                return new Coords(game.board.width - 2, game.board.height - 2);
            }
            case 5: {
                return new Coords(game.board.width / 2, game.board.height - 2);
            }
            case 6: {
                return new Coords(1, game.board.height - 2);
            }
            case 7: {
                return new Coords(1, game.board.height / 2);
            }
            case 8: 
        }
        return new Coords(game.board.width / 2, game.board.height / 2);
    }

    private Entity[] buildFactionEntities(Properties properties, String string) throws Exception {
        Vector<Entity> vector = new Vector<Entity>();
        int n = 1;
        while (true) {
            String string2;
            if ((string2 = properties.getProperty("Unit_" + string + "_" + n)) == null) {
                Object[] objectArray = new Entity[vector.size()];
                vector.copyInto(objectArray);
                return objectArray;
            }
            vector.addElement(this.parseEntityLine(string2));
            ++n;
        }
    }

    private Entity parseEntityLine(String string) throws Exception {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = stringTokenizer.nextToken();
            MechSummary mechSummary = MechSummaryCache.getInstance().getMech(string2);
            if (mechSummary == null) {
                throw new Exception("Scenario requires missing entity: " + string2);
            }
            System.out.println("Loading " + mechSummary.getName());
            Entity entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
            entity.setCrew(new Pilot(stringTokenizer.nextToken(), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken())));
            int n = -1;
            if (stringTokenizer.hasMoreTokens()) {
                n = this.findIndex(FACING, stringTokenizer.nextToken());
            }
            entity.setFacing(n);
            entity.setSecondaryFacing(n);
            if (stringTokenizer.hasMoreTokens()) {
                entity.setPosition(new Coords(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken())));
            } else {
                entity.setPosition(null);
            }
            return entity;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw new Exception("Unparseable entity line: " + string);
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            throw new Exception("Unparseable entity line: " + string);
        }
    }

    private int findIndex(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private Player[] createPlayers(Properties properties) throws Exception {
        String string = properties.getProperty("Factions");
        if (string == null) {
            throw new Exception("Not a valid MMS file.  No Factions");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Player[] playerArray = new Player[stringTokenizer.countTokens()];
        int n = 0;
        while (n < playerArray.length) {
            playerArray[n] = new Player(n, stringTokenizer.nextToken());
            playerArray[n].setGhost(true);
            String string2 = properties.getProperty("Location_" + playerArray[n].getName());
            if (string2 == null) {
                string2 = "R";
            }
            int n2 = -1;
            if (!string2.equals("R")) {
                n2 = this.findIndex(DIRS, string2);
            }
            if (n2 == -1) {
                n2 = this.getRandomStartingPos();
            }
            playerArray[n].setStartingPos(n2);
            this.m_baTakenDirs[n2] = true;
            ++n;
        }
        return playerArray;
    }

    private int getRandomStartingPos() {
        boolean bl = true;
        int n = 0;
        while (n < this.m_baTakenDirs.length) {
            if (!this.m_baTakenDirs[n]) {
                bl = false;
                break;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 200) {
            int n3 = Compute.random.nextInt(DIRS.length);
            if (bl || !this.m_baTakenDirs[n3]) {
                this.m_baTakenDirs[n3] = true;
                return n3;
            }
            ++n2;
        }
        System.out.println("Warning! getRandomStartingPos looped 200 times, but not all taken");
        return Compute.random.nextInt(DIRS.length);
    }

    private Board createBoard(Properties properties) throws Exception {
        int n = 1;
        int n2 = 1;
        if (properties.getProperty("BoardWidth") == null) {
            System.out.println("No board width specified.  Using 1");
        } else {
            n = Integer.parseInt(properties.getProperty("BoardWidth"));
        }
        if (properties.getProperty("BoardHeight") == null) {
            System.out.println("No board height specified.  Using 1");
        } else {
            n2 = Integer.parseInt(properties.getProperty("BoardHeight"));
        }
        System.out.println("Constructing " + n + " by " + n2 + " board.");
        Vector<String> vector = new Vector<String>();
        File file = new File("data/boards");
        String[] stringArray = file.list();
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].endsWith(".board")) {
                vector.addElement(stringArray[n3].substring(0, stringArray[n3].lastIndexOf(".board")));
            }
            ++n3;
        }
        Board[] boardArray = new Board[n * n2];
        StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty("Maps"), ",");
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = n5 * n + n4;
                String string = "RANDOM";
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                }
                System.out.println("(" + n4 + "," + n5 + ")" + string);
                String string2 = string.equals("RANDOM") ? (String)vector.elementAt(Compute.random.nextInt(vector.size())) + ".board" : string + ".board";
                File file2 = new File(file, string2);
                if (!file2.exists()) {
                    throw new Exception("Scenario requires nonexistant board: " + string);
                }
                boardArray[n6] = new Board();
                boardArray[n6].load(string2);
                ++n5;
            }
            ++n4;
        }
        Board board = new Board();
        board.combine(16, 17, n, n2, boardArray);
        return board;
    }

    private Properties loadProperties() throws Exception {
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(this.m_scenFile);
        properties.load(fileInputStream);
        fileInputStream.close();
        return properties;
    }

    public static void main(String[] stringArray) throws Exception {
        ScenarioLoader scenarioLoader = new ScenarioLoader(new File(stringArray[0]));
        Game game = scenarioLoader.createGame();
        System.out.println("Successfully loaded.");
    }
}

