/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.Hex;
import megamek.common.HitData;
import megamek.common.Mounted;
import megamek.common.PilotingRollData;
import megamek.common.WeaponType;

public class Tank
extends Entity
implements Serializable {
    private boolean m_bHasTurret = false;
    private boolean m_bTurretLocked = false;
    private int m_nTurretOffset = 0;
    private int m_nStunnedTurns = 0;
    private Mounted m_jammedGun = null;
    private boolean m_bImmobile = false;
    private boolean m_bImmobileHit = false;
    public static final int LOC_BODY = 0;
    public static final int LOC_FRONT = 1;
    public static final int LOC_RIGHT = 2;
    public static final int LOC_LEFT = 3;
    public static final int LOC_REAR = 4;
    public static final int LOC_TURRET = 5;
    private static final int[] NUM_OF_SLOTS = new int[]{0, 0, 0, 0, 0, 0};
    private static final String[] LOCATION_ABBRS = new String[]{"BD", "FR", "RT", "LT", "RR", "TU"};
    private static final String[] LOCATION_NAMES = new String[]{"Body", "Front", "Right", "Left", "Rear", "Turret"};

    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public boolean hasTurret() {
        return this.m_bHasTurret;
    }

    public void setHasTurret(boolean bl) {
        this.m_bHasTurret = bl;
    }

    public int locations() {
        return 6;
    }

    public boolean canChangeSecondaryFacing() {
        return this.m_bHasTurret && !this.m_bTurretLocked;
    }

    public boolean isValidSecondaryFacing(int n) {
        return !this.m_bTurretLocked;
    }

    public int clipSecondaryFacing(int n) {
        return n;
    }

    public void setSecondaryFacing(int n) {
        if (!this.m_bTurretLocked) {
            super.setSecondaryFacing(n);
            if (this.m_bHasTurret) {
                this.m_nTurretOffset = n - this.getFacing();
            }
        }
    }

    public void setFacing(int n) {
        super.setFacing(n);
        if (this.m_bTurretLocked) {
            int n2 = (n + this.m_nTurretOffset + 6) % 6;
            super.setSecondaryFacing(n2);
        }
    }

    public void immobilize() {
        this.m_bImmobileHit = true;
        this.setOriginalWalkMP(0);
    }

    public boolean isImmobile() {
        if (this.game.getOptions().booleanOption("no_immobile_vehicles")) {
            return super.isImmobile();
        }
        return super.isImmobile() || this.m_bImmobile;
    }

    public int elevationOccupied(Hex hex) {
        if (this.movementType == 5 && hex.contains(4)) {
            return hex.surface();
        }
        return hex.floor();
    }

    public boolean isHexProhibited(Hex hex) {
        switch (this.movementType) {
            case 3: {
                return hex.levelOf(1) > 1 || hex.levelOf(4) > 0;
            }
            case 4: {
                return hex.contains(1) || hex.contains(2) || hex.levelOf(4) > 0 || hex.contains(3);
            }
            case 5: {
                return hex.contains(1);
            }
        }
        return false;
    }

    public void lockTurret() {
        this.m_bTurretLocked = true;
    }

    public void stunCrew() {
        this.m_nStunnedTurns = 3;
        this.crew.setUnconcious(true);
    }

    public void setJammedWeapon(Mounted mounted) {
        this.m_jammedGun = mounted;
        this.m_jammedGun.setHit(true);
    }

    public void applyDamage() {
        this.m_bImmobile |= this.m_bImmobileHit;
    }

    public void newRound() {
        super.newRound();
        if (this.m_nStunnedTurns > 0) {
            --this.m_nStunnedTurns;
            if (this.m_nStunnedTurns == 0) {
                this.crew.setUnconcious(false);
            }
        }
        if (this.m_jammedGun != null) {
            this.m_jammedGun.setHit(false);
            this.m_jammedGun = null;
        }
        if (!this.m_bTurretLocked) {
            this.setSecondaryFacing(this.getFacing());
        }
    }

    public Mounted getMainWeapon() {
        double d = -1.0;
        Mounted mounted = null;
        Enumeration enumeration = this.getWeapons();
        while (enumeration.hasMoreElements()) {
            double d2;
            Mounted mounted2 = (Mounted)enumeration.nextElement();
            if (mounted2.isDestroyed() || !((d2 = mounted2.getType().getBV(this)) > d)) continue;
            d = d2;
            mounted = mounted2;
        }
        return mounted;
    }

    public String getMovementString(int n) {
        switch (n) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Cruised";
            }
            case 2: {
                return "Flanked";
            }
            case 3: {
                return "Jumped";
            }
        }
        return "Unknown!";
    }

    public String getMovementAbbr(int n) {
        switch (n) {
            case 0: {
                return "N";
            }
            case 1: {
                return "C";
            }
            case 2: {
                return "F";
            }
            case 3: {
                return "J";
            }
        }
        return "?";
    }

    public boolean hasRearArmor(int n) {
        return false;
    }

    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        Mounted mounted2 = this.getEquipment(n);
        if (mounted2.getLocation() == 1) {
            return 1;
        }
        if (mounted2.getLocation() == 2) {
            return 6;
        }
        if (mounted2.getLocation() == 3) {
            return 5;
        }
        if (mounted2.getLocation() == 4) {
            return 4;
        }
        if (mounted2.getLocation() == 5) {
            return 1;
        }
        return 0;
    }

    public boolean isSecondaryArcWeapon(int n) {
        return this.getEquipment(n).getLocation() == 5;
    }

    public HitData rollHitLocation(int n, int n2) {
        int n3 = 1;
        boolean bl = false;
        if (n2 == 2) {
            n3 = 3;
            bl = true;
        } else if (n2 == 3) {
            n3 = 2;
            bl = true;
        } else if (n2 == 1) {
            n3 = 4;
        }
        switch (Compute.d6(2)) {
            case 2: {
                return new HitData(n3, false, 1);
            }
            case 3: {
                return new HitData(n3, false, 2);
            }
            case 4: {
                return new HitData(n3, false, 3);
            }
            case 5: {
                if (bl || this.getMovementType() == 5) {
                    return new HitData(n3, false, 3);
                }
                return new HitData(n3);
            }
            case 6: 
            case 7: 
            case 8: {
                return new HitData(n3);
            }
            case 9: {
                if (bl && this.getMovementType() == 5) {
                    return new HitData(n3, false, 3);
                }
                return new HitData(n3);
            }
            case 10: {
                if (!this.m_bHasTurret) {
                    return new HitData(n3);
                }
                return new HitData(5);
            }
            case 11: {
                if (!this.m_bHasTurret) {
                    return new HitData(n3);
                }
                return new HitData(5, false, 4);
            }
            case 12: {
                if (!this.m_bHasTurret || bl) {
                    return new HitData(n3, false, 1);
                }
                return new HitData(5, false, 1);
            }
        }
        return null;
    }

    public HitData getTransferLocation(HitData hitData) {
        return new HitData(-2);
    }

    public int getDependentLocation(int n) {
        return -1;
    }

    public int calculateBattleValue() {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        d2 += (double)this.getTotalArmor();
        d2 += (double)(this.getTotalInternal() * 2);
        switch (this.getMovementType()) {
            case 3: {
                d = 0.8;
                break;
            }
            case 4: {
                d = 0.7;
                break;
            }
            case 5: {
                d = 0.6;
                break;
            }
            default: {
                d = 0.5;
            }
        }
        d2 *= d;
        int n = Compute.getTargetMovementModifier(this.getRunMP(), false).getValue();
        if (n > 5) {
            n = 5;
        }
        double[] dArray = new double[]{1.0, 1.1, 1.2, 1.3, 1.4, 1.5};
        d2 *= dArray[n];
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        Enumeration enumeration = this.weaponList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (mounted.getLocation() == 4) {
                d6 += weaponType.getBV(this);
                continue;
            }
            d5 += weaponType.getBV(this);
        }
        if (d5 > d6) {
            d4 += d5;
            d4 += d6 * 0.5;
        } else {
            d4 += d6;
            d4 += d5 * 0.5;
        }
        double d7 = 0.0;
        Enumeration enumeration2 = this.ammoList.elements();
        while (enumeration2.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration2.nextElement();
            AmmoType ammoType = (AmmoType)mounted.getType();
            d7 += ammoType.getBV(this);
        }
        d4 += d7;
        double d8 = this.getRunMP() - 5;
        d8 /= 10.0;
        d8 += 1.0;
        d8 = Math.pow(d8, 1.2);
        d8 = (double)Math.round(d8 * 100.0) / 100.0;
        d3 = d4 * d8;
        double d9 = this.crew.getBVSkillMultiplier();
        return (int)Math.round((d2 + d3) * d9);
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        return pilotingRollData;
    }

    public String victoryReport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDisplayName());
        stringBuffer.append('\n');
        stringBuffer.append("Driver : " + this.crew.getDesc());
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    public int getHeatCapacity() {
        return 999;
    }

    public int getHeatCapacityWithWater() {
        return this.getHeatCapacity();
    }

    public void autoSetInternal() {
        int n = (int)Math.round((double)this.weight / 10.0);
        int n2 = 1;
        while (n2 < this.locations()) {
            this.initializeInternal(n, n2);
            ++n2;
        }
    }

    public int getMaxElevationChange() {
        return 1;
    }
}

