/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.CriticalSlot;
import megamek.common.Mech;
import megamek.common.PilotingRollData;

public class QuadMech
extends Mech {
    private static final String[] LOCATION_NAMES = new String[]{"Head", "Center Torso", "Right Torso", "Left Torso", "Front Right Leg", "Front Left Leg", "Rear Right Leg", "Rear Left Leg"};
    private static final String[] LOCATION_ABBRS = new String[]{"HD", "CT", "RT", "LT", "FRL", "FLL", "RRL", "RLL"};
    private static final int[] NUM_OF_SLOTS = new int[]{6, 12, 12, 12, 6, 6, 6, 6};

    public QuadMech() {
        this.movementType = 2;
        this.setCritical(4, 0, new CriticalSlot(0, 11));
        this.setCritical(4, 1, new CriticalSlot(0, 12));
        this.setCritical(4, 2, new CriticalSlot(0, 13));
        this.setCritical(4, 3, new CriticalSlot(0, 14));
        this.setCritical(5, 0, new CriticalSlot(0, 11));
        this.setCritical(5, 1, new CriticalSlot(0, 12));
        this.setCritical(5, 2, new CriticalSlot(0, 13));
        this.setCritical(5, 3, new CriticalSlot(0, 14));
    }

    public int getWalkMP() {
        int n = this.getOriginalWalkMP();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.locations()) {
            if (this.locationIsLeg(n5)) {
                if (!this.isLocationDestroyed(n5)) {
                    if (this.legHasHipCrit(n5)) {
                        ++n3;
                    } else {
                        n4 += this.countLegActuatorCrits(n5);
                    }
                } else {
                    ++n2;
                }
            }
            ++n5;
        }
        if (n2 > 0) {
            n = n2 == 1 ? --n : (n2 == 2 ? 1 : 0);
        }
        if (n > 0) {
            int n6 = 0;
            while (n6 < n3) {
                n = (int)Math.ceil((double)n / 2.0);
                ++n6;
            }
            n -= n4;
        }
        n = Math.max(0, n);
        n = Math.max(n - this.heat / 5, 0);
        if (this.heat >= 9 && this.hasTSM()) {
            n = this.heat == 9 ? (n += 2) : ++n;
        }
        return n;
    }

    public int getRunMP() {
        int n = this.countDestroyedLegs();
        if (this.countDestroyedLegs() <= 1) {
            return super.getRunMP();
        }
        return this.getWalkMP();
    }

    public boolean canChangeSecondaryFacing() {
        return false;
    }

    public boolean locationIsLeg(int n) {
        return n == 6 || n == 7 || n == 4 || n == 5;
    }

    public void setInternal(int n, int n2, int n3, int n4, int n5) {
        this.initializeInternal(n, 0);
        this.initializeInternal(n2, 1);
        this.initializeInternal(n3, 2);
        this.initializeInternal(n3, 3);
        this.initializeInternal(n5, 4);
        this.initializeInternal(n5, 5);
        this.initializeInternal(n5, 6);
        this.initializeInternal(n5, 7);
    }

    public boolean needsRollToStand() {
        return this.countDestroyedLegs() != 0;
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        int[] nArray = new int[4];
        int n = 0;
        nArray = new int[]{6, 7, 4, 5};
        n = this.countDestroyedLegs();
        if (n == 0) {
            pilotingRollData.addModifier(-2, "Quad bonus");
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            if (this.isLocationDestroyed(n3)) {
                if (n > 1) {
                    pilotingRollData.addModifier(5, this.getLocationName(n3) + " destroyed");
                }
            } else if (this.getDestroyedCriticals(0, 11, n3) > 0) {
                pilotingRollData.addModifier(2, this.getLocationName(n3) + " Hip Actuator destroyed");
            } else {
                if (this.getDestroyedCriticals(0, 12, n3) > 0) {
                    pilotingRollData.addModifier(1, this.getLocationName(n3) + " Upper Leg Actuator destroyed");
                }
                if (this.getDestroyedCriticals(0, 13, n3) > 0) {
                    pilotingRollData.addModifier(1, this.getLocationName(n3) + " Lower Leg Actuator destroyed");
                }
                if (this.getDestroyedCriticals(0, 14, n3) > 0) {
                    pilotingRollData.addModifier(1, this.getLocationName(n3) + " Foot Actuator destroyed");
                }
            }
            ++n2;
        }
        return super.addEntityBonuses(pilotingRollData);
    }

    protected int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    protected String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    protected String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }
}

