/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipFile;
import megamek.common.BLKInfantryFile;
import megamek.common.BLKMechFile;
import megamek.common.BLKTankFile;
import megamek.common.Entity;
import megamek.common.EntityLoadingException;
import megamek.common.Mech;
import megamek.common.MepFile;
import megamek.common.Mounted;
import megamek.common.MtfFile;
import megamek.common.WeaponType;
import megamek.common.util.BuildingBlock;

public class MechFileParser {
    private Entity m_entity = null;

    public MechFileParser(File file) throws EntityLoadingException {
        this(file, null);
    }

    public MechFileParser(File file, String string) throws EntityLoadingException {
        if (string == null) {
            try {
                this.parse(new FileInputStream(file), file.getName());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new EntityLoadingException(fileNotFoundException.getMessage());
            }
        }
        try {
            ZipFile zipFile = new ZipFile(file);
            this.parse(zipFile.getInputStream(zipFile.getEntry(string)), string);
        }
        catch (Exception exception) {
            throw new EntityLoadingException(exception.getMessage());
        }
    }

    public MechFileParser(InputStream inputStream, String string) throws EntityLoadingException {
        this.parse(inputStream, string);
    }

    public Entity getEntity() {
        return this.m_entity;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(InputStream inputStream, String string) throws EntityLoadingException {
        void var4_10;
        String string2 = string.toLowerCase();
        if (string2.endsWith(".mep")) {
            MepFile mepFile = new MepFile(inputStream);
        } else if (string2.endsWith(".mtf")) {
            MtfFile mtfFile = new MtfFile(inputStream);
        } else {
            if (!string2.endsWith(".blk")) throw new EntityLoadingException("Unsupported file suffix");
            BuildingBlock buildingBlock = new BuildingBlock(inputStream);
            if (buildingBlock.exists("UnitType")) {
                String string3 = buildingBlock.getDataAsString("UnitType")[0];
                if (string3.equals("Tank")) {
                    BLKTankFile bLKTankFile = new BLKTankFile(buildingBlock);
                } else if (string3.equals("Infantry")) {
                    BLKInfantryFile bLKInfantryFile = new BLKInfantryFile(buildingBlock);
                } else {
                    if (!string3.equals("Mech")) throw new EntityLoadingException("Unknown UnitType: " + string3);
                    BLKMechFile bLKMechFile = new BLKMechFile(buildingBlock);
                }
            } else {
                BLKMechFile bLKMechFile = new BLKMechFile(buildingBlock);
            }
        }
        this.m_entity = var4_10.getEntity();
        this.postLoadInit(this.m_entity);
    }

    private void postLoadInit(Entity entity) throws EntityLoadingException {
        Enumeration enumeration = entity.getMisc();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!mounted.getType().hasFlag(4096) || mounted.getLinked() != null) continue;
            Enumeration enumeration2 = entity.getWeapons();
            while (enumeration2.hasMoreElements()) {
                Mounted mounted2 = (Mounted)enumeration2.nextElement();
                WeaponType weaponType = (WeaponType)mounted2.getType();
                if (weaponType.getAmmoType() != 7 && weaponType.getAmmoType() != 9 || mounted2.getLinkedBy() != null) continue;
                if (mounted2.getLocation() == mounted.getLocation()) {
                    mounted.setLinked(mounted2);
                    break;
                }
                if (!(entity instanceof Mech) || mounted.getLocation() != 0 || mounted2.getLocation() != 1) continue;
                mounted.setLinked(mounted2);
                break;
            }
            if (mounted.getLinked() != null) continue;
            throw new EntityLoadingException("Unable to match Artemis to launcher");
        }
    }
}

