/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.Entity;
import megamek.common.Hex;
import megamek.common.HitData;
import megamek.common.LocationFullException;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.PilotingRollData;
import megamek.common.WeaponType;

public class Infantry
extends Entity
implements Serializable {
    private int menStarting = 0;
    private int menShooting = 0;
    private int men = 0;
    private int movePoints = 0;
    private int weapons = 1;
    private int[] damage = new int[29];
    private static final int[] NUM_OF_SLOTS = new int[]{0};
    private static final String[] LOCATION_ABBRS = new String[]{"Men"};
    private static final String[] LOCATION_NAMES = new String[]{"Men"};
    public static final int INF_PLT_MAX_MEN = 28;
    public static final int INF_PLT_JUMP_MAX_MEN = 21;
    public static final int INF_PLT_CLAN_LEG_MAX_MEN = 25;
    public static final int INF_LEG = 1;
    public static final int INF_MOTORIZED = 4;
    public static final int INF_JUMP = 5;
    public static final int INF_RIFLE = 1;
    public static final int INF_MG = 3;
    public static final int INF_FLAMER = 2;
    public static final int INF_LASER = 4;
    public static final int INF_SRM = 9;
    public static final int INF_LRM = 7;
    public static final int LOC_INFANTRY = 0;

    private void setDamage(int n) {
        double d;
        this.damage[0] = 0;
        switch (n) {
            case 1: {
                d = 4.0;
                break;
            }
            case 2: 
            case 3: {
                d = 3.0;
                break;
            }
            case 4: 
            case 9: {
                d = 2.0;
                break;
            }
            case 7: {
                d = 4.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown infantry weapon: " + n);
            }
        }
        int n2 = 1;
        int n3 = 1;
        while (n2 <= 28) {
            this.damage[n2] = (int)Math.ceil((double)n3 / d);
            if (1 == n2 && (3 == n || 2 == n)) {
                --n3;
            }
            ++n2;
            ++n3;
        }
        if (3 == n || 2 == n) {
            this.damage[28] = (int)Math.ceil(28.0 / d);
        }
    }

    private void setMovePoints(int n, int n2) {
        switch (n2) {
            case 1: {
                if (1 == n) {
                    this.movePoints = 1;
                    break;
                }
                if (4 == n) {
                    this.movePoints = 3;
                    break;
                }
                if (5 == n) {
                    this.movePoints = 3;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + n);
            }
            case 2: 
            case 3: {
                if (1 == n) {
                    this.movePoints = 1;
                    break;
                }
                if (4 == n) {
                    this.movePoints = 3;
                    break;
                }
                if (5 == n) {
                    this.movePoints = 3;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + n);
            }
            case 4: 
            case 9: {
                if (1 == n) {
                    this.movePoints = 1;
                    break;
                }
                if (4 == n) {
                    this.movePoints = 2;
                    break;
                }
                if (5 == n) {
                    this.movePoints = 2;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + n);
            }
            case 7: {
                if (1 == n) {
                    this.movePoints = 1;
                    break;
                }
                if (4 == n) {
                    this.movePoints = 2;
                    break;
                }
                if (5 == n) {
                    this.movePoints = 3;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + n);
            }
            default: {
                throw new IllegalArgumentException("Unknown infantry weapon: " + n2);
            }
        }
    }

    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public int locations() {
        return 1;
    }

    public Infantry() {
        this.setMovementType(1);
        this.setDamage(this.weapons);
        this.setMovePoints(this.getMovementType(), this.weapons);
    }

    public int getSecondaryFacing() {
        return -1;
    }

    public boolean canChangeSecondaryFacing() {
        return false;
    }

    public boolean isValidSecondaryFacing(int n) {
        return false;
    }

    public int clipSecondaryFacing(int n) {
        return -1;
    }

    public void setCrew(Pilot pilot) {
        super.setCrew(new Pilot(pilot.getName(), pilot.getGunnery(), 5));
    }

    public int getWalkMP() {
        return 5 == this.getMovementType() ? 1 : this.movePoints;
    }

    public int getOriginalWalkMP() {
        return 5 == this.getMovementType() ? 1 : this.movePoints;
    }

    public int getRunMP() {
        return 5 == this.getMovementType() ? 1 : this.movePoints;
    }

    protected int getOriginalRunMP() {
        return 5 == this.getMovementType() ? 1 : this.movePoints;
    }

    public int getJumpMP() {
        return 5 == this.getMovementType() ? this.movePoints : 0;
    }

    protected int getOriginalJumpMP() {
        return 5 == this.getMovementType() ? this.movePoints : 0;
    }

    public int getJumpMPWithTerrain() {
        return 5 == this.getMovementType() ? this.movePoints : 0;
    }

    public boolean isHexProhibited(Hex hex) {
        return hex.levelOf(4) > 0;
    }

    public String getMovementString(int n) {
        switch (n) {
            case 0: {
                return "None";
            }
            case 1: 
            case 2: 
            case 3: {
                switch (this.getMovementType()) {
                    case 1: {
                        return "Walked";
                    }
                    case 4: {
                        return "Biked";
                    }
                    case 5: {
                        return "Jumped";
                    }
                }
                return "Unknown!";
            }
        }
        return "Unknown!";
    }

    public String getMovementAbbr(int n) {
        switch (n) {
            case 0: {
                return "N";
            }
            case 1: 
            case 2: 
            case 3: {
                switch (this.getMovementType()) {
                    case 1: {
                        return "W";
                    }
                    case 4: {
                        return "B";
                    }
                    case 5: {
                        return "J";
                    }
                }
                return "?";
            }
        }
        return "?";
    }

    public HitData rollHitLocation(int n, int n2) {
        return new HitData(0);
    }

    public HitData getTransferLocation(HitData hitData) {
        return new HitData(-2);
    }

    public int getDependentLocation(int n) {
        return -1;
    }

    public boolean hasRearArmor(int n) {
        return false;
    }

    public int getArmor(int n, boolean bl) {
        return -1;
    }

    public int getOArmor(int n, boolean bl) {
        return -1;
    }

    public double getArmorRemainingPercent() {
        return 0.0;
    }

    public int getInternal(int n, boolean bl) {
        return this.men > 0 ? this.men : -3;
    }

    public int getOInternal(int n, boolean bl) {
        return this.menStarting;
    }

    public void setInternal(int n, int n2) {
        super.setInternal(n, n2);
        this.men = n;
    }

    public double getInternalRemainingPercent() {
        int n = this.men > 0 ? this.men : 0;
        return (double)n / (double)this.menStarting;
    }

    public void initializeInternal(int n, int n2) {
        this.menStarting = n;
        this.menShooting = n;
        this.setInternal(n, n2);
    }

    public void autoSetInternal() {
        if (this.isClan()) {
            this.initializeInternal(25, 0);
            return;
        }
        switch (this.getMovementType()) {
            case 1: 
            case 4: {
                this.initializeInternal(28, 0);
                break;
            }
            case 5: {
                this.initializeInternal(21, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementType());
            }
        }
    }

    protected void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        if (!(mounted.getType() instanceof WeaponType)) {
            throw new LocationFullException("Infantry can not be equiped with a " + mounted.getName());
        }
        WeaponType weaponType = (WeaponType)mounted.getType();
        if ((weaponType.getFlags() & 0xF00) != 3840) {
            throw new LocationFullException("A " + weaponType.getName() + " is too big for infantry");
        }
        if (this.getEquipment().hasMoreElements()) {
            weaponType = (WeaponType)this.getEquipment(0).getType();
            throw new LocationFullException("Platoon is already equiped with an " + weaponType.getName() + " and does not need a " + mounted.getType().getName());
        }
        int n2 = weaponType.getAmmoType() != -1 ? weaponType.getAmmoType() : weaponType.getFlags() & 6;
        this.weapons = n2;
        this.setDamage(n2);
        this.setMovePoints(this.getMovementType(), n2);
        super.addEquipment(mounted, n, bl);
    }

    public int getWeaponArc(int n) {
        return 0;
    }

    public boolean isSecondaryArcWeapon(int n) {
        return false;
    }

    public int getHeatCapacity() {
        return 999;
    }

    public int getHeatCapacityWithWater() {
        return this.getHeatCapacity();
    }

    protected int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    public int calculateBattleValue() {
        int n = 0;
        switch (this.weapons) {
            case 1: {
                if (1 == this.getMovementType()) {
                    n = 23;
                    break;
                }
                if (4 == this.getMovementType()) {
                    n = 28;
                    break;
                }
                if (5 == this.getMovementType()) {
                    n = 29;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementType());
            }
            case 3: {
                if (1 == this.getMovementType()) {
                    n = 31;
                    break;
                }
                if (4 == this.getMovementType()) {
                    n = 39;
                    break;
                }
                if (5 == this.getMovementType()) {
                    n = 37;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementType());
            }
            case 2: {
                if (1 == this.getMovementType()) {
                    n = 28;
                    break;
                }
                if (4 == this.getMovementType()) {
                    n = 35;
                    break;
                }
                if (5 == this.getMovementType()) {
                    n = 32;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementType());
            }
            case 4: {
                if (1 == this.getMovementType()) {
                    n = 37;
                    break;
                }
                if (4 == this.getMovementType()) {
                    n = 42;
                    break;
                }
                if (5 == this.getMovementType()) {
                    n = 41;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementType());
            }
            case 9: {
                if (1 == this.getMovementType()) {
                    n = 60;
                    break;
                }
                if (4 == this.getMovementType()) {
                    n = 70;
                    break;
                }
                if (5 == this.getMovementType()) {
                    n = 71;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementType());
            }
            case 7: {
                if (1 == this.getMovementType()) {
                    n = 56;
                    break;
                }
                if (4 == this.getMovementType()) {
                    n = 75;
                    break;
                }
                if (5 == this.getMovementType()) {
                    n = 87;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementType());
            }
            default: {
                throw new IllegalArgumentException("Unknown infantry weapon: " + this.weapons);
            }
        }
        double d = this.crew.getBVSkillMultiplier();
        return (int)(d * (double)n);
    }

    public String victoryReport() {
        return this.getDisplayName();
    }

    public void setMovementType(int n) {
        super.setMovementType(n);
        this.setMovePoints(this.getMovementType(), this.weapons);
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        return pilotingRollData;
    }

    public int getMaxElevationChange() {
        return 1;
    }

    public void applyDamage() {
        this.menShooting = this.men;
    }

    public int getDamage(int n) {
        return this.damage[n];
    }

    public int getShootingStrength() {
        return this.menShooting;
    }
}

