/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import com.sun.java.util.collections.List;
import java.awt.Image;
import java.io.Serializable;
import java.util.StringTokenizer;
import megamek.common.Terrain;

public class Hex
implements Serializable,
Cloneable {
    private int elevation;
    private Terrain[] terrains;
    private String theme;
    private transient Image base = null;
    private transient List supers = null;

    public Hex() {
        this(0);
    }

    public Hex(int n) {
        this(n, new Terrain[Terrain.SIZE], null);
    }

    public Hex(int n, Terrain[] terrainArray, String string) {
        this.elevation = n;
        this.terrains = terrainArray;
        this.theme = string == null || string.length() > 0 ? string : null;
    }

    public Hex(int n, String string, String string2) {
        this(n, new Terrain[Terrain.SIZE], string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            this.addTerrain(new Terrain(stringTokenizer.nextToken()));
        }
    }

    public int getElevation() {
        return this.elevation;
    }

    public void setElevation(int n) {
        this.elevation = n;
        this.invalidateCache();
    }

    private void invalidateCache() {
        this.base = null;
        this.supers = null;
    }

    public String getTheme() {
        return this.theme;
    }

    public Image getBase() {
        return this.base;
    }

    public void setBase(Image image) {
        this.base = image;
    }

    public void setSupers(List list) {
        this.supers = list;
    }

    public List getSupers() {
        return this.supers;
    }

    public void clearExits() {
        int n = 0;
        while (n < Terrain.SIZE) {
            Terrain terrain = this.getTerrain(n);
            if (terrain != null && !terrain.hasExitsSpecified()) {
                terrain.setExits(0);
            }
            ++n;
        }
        this.invalidateCache();
    }

    public void setExits(Hex hex, int n) {
        int n2 = 0;
        while (n2 < Terrain.SIZE) {
            Terrain terrain = this.getTerrain(n2);
            if (terrain != null && !terrain.hasExitsSpecified()) {
                Terrain terrain2 = hex != null ? hex.getTerrain(n2) : null;
                terrain.setExit(n, terrain.exitsTo(terrain2));
            }
            ++n2;
        }
        this.invalidateCache();
    }

    public int ceiling() {
        return this.elevation;
    }

    public int surface() {
        return this.elevation;
    }

    public int floor() {
        return this.elevation - this.depth();
    }

    public int depth() {
        int n = 0;
        Terrain terrain = this.getTerrain(4);
        Terrain terrain2 = this.getTerrain(13);
        if (terrain != null) {
            n += terrain.getLevel();
        }
        if (terrain2 != null) {
            n += terrain2.getLevel();
        }
        return n;
    }

    public boolean contains(int n) {
        return this.getTerrain(n) != null;
    }

    public boolean contains(int n, int n2) {
        Terrain terrain = this.getTerrain(n);
        if (terrain != null) {
            return terrain.getLevel() == n2;
        }
        return false;
    }

    public int levelOf(int n) {
        Terrain terrain = this.getTerrain(n);
        if (terrain != null) {
            return terrain.getLevel();
        }
        return Integer.MIN_VALUE;
    }

    public Terrain getTerrain(int n) {
        return this.terrains[n];
    }

    public void addTerrain(Terrain terrain) {
        this.terrains[terrain.getType()] = terrain;
        this.invalidateCache();
    }

    public void removeTerrain(int n) {
        this.terrains[n] = null;
        this.invalidateCache();
    }

    public int terrainsPresent() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.terrains.length) {
            if (this.terrains[n2] != null) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public Object clone() {
        Terrain[] terrainArray = new Terrain[this.terrains.length];
        int n = 0;
        while (n < this.terrains.length) {
            if (this.terrains[n] != null) {
                terrainArray[n] = new Terrain(this.terrains[n]);
            }
            ++n;
        }
        return new Hex(this.elevation, terrainArray, this.theme);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Hex hex = (Hex)object;
        return false;
    }
}

