/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import com.sun.java.util.collections.Random;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BipedMech;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Game;
import megamek.common.Hex;
import megamek.common.HexEntity;
import megamek.common.IdealHex;
import megamek.common.Infantry;
import megamek.common.LosEffects;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.MovementData;
import megamek.common.PilotingRollData;
import megamek.common.QuadMech;
import megamek.common.Tank;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.AbstractEntityAction;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.WeaponAttackAction;

public class Compute {
    public static final int ARC_360 = 0;
    public static final int ARC_FORWARD = 1;
    public static final int ARC_LEFTARM = 2;
    public static final int ARC_RIGHTARM = 3;
    public static final int ARC_REAR = 4;
    public static final int ARC_LEFTSIDE = 5;
    public static final int ARC_RIGHTSIDE = 6;
    public static final int GEAR_LAND = 0;
    public static final int GEAR_BACKUP = 1;
    public static final int GEAR_JUMP = 2;
    public static final int GEAR_CHARGE = 3;
    public static final int GEAR_DFA = 4;
    public static final int GEAR_TURN = 5;
    public static final Random random = new Random();
    private static float[] expectedHitsByRackSize = new float[]{0.0f, 1.0f, 1.58f, 2.0f, 2.63f, 3.17f, 4.0f, 0.0f, 0.0f, 5.47f, 6.31f, 0.0f, 8.14f, 0.0f, 0.0f, 9.5f, 0.0f, 0.0f, 0.0f, 0.0f, 12.7f};

    public static int d6(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += random.nextInt(6) + 1;
            ++n3;
        }
        return n2;
    }

    public static int d6() {
        return Compute.d6(1);
    }

    public static double oddsAbove(int n) {
        if (n <= 2) {
            return 100.0;
        }
        if (n > 12) {
            return 0.0;
        }
        double[] dArray = new double[]{100.0, 100.0, 100.0, 97.2, 91.6, 83.3, 72.2, 58.3, 41.6, 27.7, 16.6, 8.3, 2.78, 0.0};
        return dArray[n];
    }

    public static double oddsOf(int n) {
        switch (n) {
            case 2: {
                return 0.027777777777777776;
            }
            case 3: {
                return 0.05555555555555555;
            }
            case 4: {
                return 0.08333333333333333;
            }
            case 5: {
                return 0.1111111111111111;
            }
            case 6: {
                return 0.1388888888888889;
            }
            case 7: {
                return 0.16666666666666666;
            }
            case 8: {
                return 0.1388888888888889;
            }
            case 9: {
                return 0.1111111111111111;
            }
            case 10: {
                return 0.08333333333333333;
            }
            case 11: {
                return 0.05555555555555555;
            }
            case 12: {
                return 0.027777777777777776;
            }
        }
        return 0.0;
    }

    public static MovementData rotatePathfinder(Game game, int n, int n2) {
        Entity entity = game.getEntity(n);
        return Compute.rotatePathfinder(entity.getFacing(), n2);
    }

    public static MovementData rotatePathfinder(int n, int n2) {
        MovementData movementData = new MovementData();
        while (n != n2) {
            int n3 = MovementData.getDirection(n, n2);
            movementData.addStep(n3);
            n = MovementData.getAdjustedFacing(n, n3);
        }
        return movementData;
    }

    public static MovementData lazyPathfinder(Game game, int n, Coords coords) {
        Entity entity = game.getEntity(n);
        return Compute.lazyPathfinder(entity.getPosition(), entity.getFacing(), coords);
    }

    public static MovementData lazyPathfinder(Coords coords, int n, Coords coords2) {
        MovementData movementData = new MovementData();
        int n2 = n;
        Coords coords3 = new Coords(coords);
        while (!coords3.equals(coords2)) {
            movementData.append(Compute.rotatePathfinder(n2, coords3.direction1(coords2)));
            movementData.addStep(1);
            n2 = coords3.direction1(coords2);
            coords3 = coords3.translated(n2);
        }
        return movementData;
    }

    public static MovementData backwardsLazyPathfinder(Coords coords, int n, Coords coords2) {
        MovementData movementData = new MovementData();
        int n2 = n;
        Coords coords3 = new Coords(coords);
        while (!coords3.equals(coords2)) {
            int n3 = (coords3.direction1(coords2) + 3) % 6;
            movementData.append(Compute.rotatePathfinder(n2, n3));
            movementData.addStep(2);
            n2 = n3;
            coords3 = coords3.translated((n3 + 3) % 6);
        }
        return movementData;
    }

    public static MovementData chargeLazyPathfinder(Coords coords, int n, Coords coords2) {
        MovementData movementData = new MovementData();
        int n2 = n;
        Coords coords3 = new Coords(coords);
        Coords coords4 = coords2.translated(coords2.direction1(coords));
        while (!coords3.equals(coords4)) {
            movementData.append(Compute.rotatePathfinder(n2, coords3.direction1(coords4)));
            movementData.addStep(1);
            n2 = coords3.direction1(coords4);
            coords3 = coords3.translated(n2);
        }
        movementData.append(Compute.rotatePathfinder(n2, coords3.direction1(coords2)));
        movementData.addStep(8);
        return movementData;
    }

    public static MovementData dfaLazyPathfinder(Coords coords, int n, Coords coords2) {
        MovementData movementData = new MovementData();
        int n2 = n;
        Coords coords3 = new Coords(coords);
        Coords coords4 = coords2.translated(coords2.direction1(coords));
        while (!coords3.equals(coords4)) {
            movementData.append(Compute.rotatePathfinder(n2, coords3.direction1(coords4)));
            movementData.addStep(1);
            n2 = coords3.direction1(coords4);
            coords3 = coords3.translated(n2);
        }
        movementData.append(Compute.rotatePathfinder(n2, coords3.direction1(coords2)));
        movementData.addStep(9);
        return movementData;
    }

    public static void compile(Game game, int n, MovementData movementData) {
        Entity entity = game.getEntity(n);
        int n2 = entity.getFacing();
        Coords coords = new Coords(entity.getPosition());
        int n3 = entity.mpUsed;
        int n4 = entity.delta_distance;
        boolean bl = entity.isProne();
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        int n5 = 1;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = entity instanceof Infantry;
        Object var18_17 = null;
        if (movementData.contains(7)) {
            n5 = 3;
            bl6 = true;
        }
        if (entity instanceof QuadMech && !bl6) {
            movementData.transformLateralShifts();
            movementData.transformLateralShiftsBackwards();
        }
        if (movementData.contains(2) || movementData.contains(13) || movementData.contains(14)) {
            bl7 = true;
        }
        Enumeration enumeration = movementData.getSteps();
        while (enumeration.hasMoreElements()) {
            MovementData.Step step = (MovementData.Step)enumeration.nextElement();
            int n6 = 0;
            Coords coords2 = new Coords(coords);
            switch (step.getType()) {
                case 3: 
                case 4: {
                    n6 = bl6 || bl2 || bl8 ? 0 : 1;
                    n2 = MovementData.getAdjustedFacing(n2, step.getType());
                    break;
                }
                case 1: 
                case 2: 
                case 8: 
                case 9: {
                    if (step.getType() == 2) {
                        coords = coords.translated((n2 + 3) % 6);
                        bl5 = true;
                    } else {
                        coords = coords.translated(n2);
                        bl5 = false;
                    }
                    n6 = Compute.getMovementCostFor(game, n, coords2, coords, n5);
                    if (game.board.getHex(coords).levelOf(4) > 0 && entity.getMovementType() != 5) {
                        bl7 = true;
                    }
                    bl2 = false;
                    if (bl4 != bl5) {
                        n4 = 0;
                    }
                    ++n4;
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    if (step.getType() == 13 || step.getType() == 14) {
                        coords = coords.translated((MovementData.getAdjustedFacing(n2, MovementData.turnForLateralShiftBackwards(step.getType())) + 3) % 6);
                        bl5 = true;
                    } else {
                        coords = coords.translated(MovementData.getAdjustedFacing(n2, MovementData.turnForLateralShift(step.getType())));
                        bl5 = false;
                    }
                    n6 = Compute.getMovementCostFor(game, n, coords2, coords, n5) + 1;
                    if (game.board.getHex(coords).levelOf(4) > 0) {
                        bl7 = true;
                    }
                    bl2 = false;
                    if (bl4 != bl5) {
                        n4 = 0;
                    }
                    ++n4;
                    break;
                }
                case 5: {
                    n6 = entity.getWalkMP() == 1 ? 1 : 2;
                    bl2 = true;
                    break;
                }
                default: {
                    n6 = 0;
                }
            }
            if (n5 == 1 && (n3 += n6) > entity.getWalkMP()) {
                n5 = 2;
            }
            step.setPosition(coords);
            step.setFacing(n2);
            step.setMpUsed(n3);
            step.setDistance(n4);
            bl4 = bl5;
        }
        if (!bl7 && n5 == 2 && (entity.getDestroyedCriticals(0, 4, 1) > 0 || entity.hasHipCrit())) {
            movementData.getStep(0).setDanger(true);
        }
        Compute.compileIllegal(game, n, movementData, n5, bl7);
        Compute.compileLastStep(game, n, movementData);
        if (bl6) {
            Compute.compileJumpCheck(game, n, movementData);
        }
        movementData.setCompiled(true);
    }

    private static void compileIllegal(Game game, int n, MovementData movementData, int n2, boolean bl) {
        Entity entity = game.getEntity(n);
        Coords coords = new Coords(entity.getPosition());
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = entity instanceof Infantry;
        MovementData.Step step = null;
        Enumeration enumeration = movementData.getSteps();
        while (enumeration.hasMoreElements()) {
            MovementData.Step step2 = (MovementData.Step)enumeration.nextElement();
            Coords coords2 = new Coords(coords);
            coords = step2.getPosition();
            int n3 = -1;
            if (n2 == 3 && step2.getMpUsed() <= entity.getJumpMPWithTerrain() && !entity.isProne()) {
                n3 = 3;
            }
            if (!(n2 != 1 && n2 != 2 || entity.isProne() && !movementData.contains(5) && step2.getType() != 3 && step2.getType() != 4)) {
                if (step2.getMpUsed() <= entity.getWalkMP()) {
                    n3 = 1;
                } else if (step2.getMpUsed() <= entity.getRunMP() && !bl) {
                    n3 = 2;
                }
            }
            if (step2.getType() == 5 && entity.getWalkMP() == 1) {
                n3 = 2;
            }
            if (bl5 && n3 == -1 && entity.getWalkMP() > 0 && !entity.isProne() && step2.getType() == 1) {
                n3 = 2;
            }
            if (!Compute.isMovementPossible(game, n, coords2, coords, n3, step2.getType(), bl5)) {
                n3 = -1;
            }
            if (n3 == -1) {
                bl2 = false;
            }
            bl3 = step2.isDanger();
            bl3 |= Compute.isPilotingSkillNeeded(game, n, coords2, coords, n3, step, n2);
            if (step2.getType() == 5) {
                bl3 = true;
            }
            step2.setDanger(bl3);
            step2.setPastDanger(bl4);
            step2.setMovementType(bl2 ? n3 : -1);
            bl4 |= bl3;
            bl5 = false;
            if (bl6 && step2.getMpUsed() == 0) {
                bl5 = true;
            }
            step = step2;
        }
    }

    private static void compileLastStep(Game game, int n, MovementData movementData) {
        Entity entity = game.getEntity(n);
        int n2 = movementData.length() - 1;
        while (n2 >= 0) {
            MovementData.Step step = movementData.getStep(n2);
            Hex hex = game.board.getHex(step.getPosition());
            if (step.getMovementType() != -1) {
                Entity entity2 = Compute.stackingViolation(game, n, step.getPosition());
                if (entity2 != null && step.getType() != 8 && step.getType() != 9) {
                    step.setMovementType(-1);
                } else {
                    if (!entity.isHexProhibited(hex)) break;
                    step.setMovementType(-1);
                }
            }
            --n2;
        }
    }

    public static Entity stackingViolation(Game game, int n, Coords coords) {
        Entity entity = game.getEntity(n);
        boolean bl = entity instanceof Infantry;
        boolean bl2 = entity instanceof Mech;
        Entity entity2 = null;
        Enumeration enumeration = game.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            Entity entity3 = (Entity)enumeration.nextElement();
            if (null == entity3) {
                System.out.println("getEntities( Coords ) returns an enumeration with null values");
            }
            if (entity3.equals(entity)) continue;
            if (bl2 && entity3 instanceof Mech) {
                return entity3;
            }
            if (entity3.getOwner().isEnemyOf(entity.getOwner())) continue;
            if (entity2 == null) {
                entity2 = entity3;
                continue;
            }
            return Compute.d6() > 3 ? entity2 : entity3;
        }
        return null;
    }

    private static void compileJumpCheck(Game game, int n, MovementData movementData) {
        Entity entity = game.getEntity(n);
        Coords coords = entity.getPosition();
        Coords coords2 = movementData.getStep(movementData.length() - 1).getPosition();
        int n2 = coords.distance(coords2);
        int n3 = movementData.getStep(movementData.length() - 1).getMpUsed();
        if (n2 < 1 || n3 > n2) {
            Enumeration enumeration = movementData.getSteps();
            while (enumeration.hasMoreElements()) {
                MovementData.Step step = (MovementData.Step)enumeration.nextElement();
                step.setMovementType(-1);
            }
        }
    }

    public static int getMovementCostFor(Game game, int n, Coords coords, Coords coords2, int n2) {
        Entity entity = game.getEntity(n);
        int n3 = entity.getMovementType();
        Hex hex = game.board.getHex(coords);
        Hex hex2 = game.board.getHex(coords2);
        boolean bl = entity instanceof Infantry;
        if (entity == null) {
            throw new IllegalArgumentException("Entity invalid.");
        }
        if (coords.distance(coords2) > 1) {
            throw new IllegalArgumentException("Coordinates must be adjacent.");
        }
        if (hex == null || hex2 == null) {
            throw new IllegalArgumentException("Coordinates must be on the board.");
        }
        if (n2 == 3) {
            return 1;
        }
        int n4 = 1;
        if (hex2.levelOf(2) > 0) {
            ++n4;
        }
        if (hex2.levelOf(3) > 0) {
            ++n4;
        }
        if (hex2.levelOf(1) == 1) {
            ++n4;
        } else if (hex2.levelOf(1) > 1) {
            n4 += 2;
        }
        if (n3 != 5) {
            if (hex2.levelOf(4) == 1) {
                ++n4;
            } else if (hex2.levelOf(4) > 1) {
                n4 += 3;
            }
        }
        int n5 = entity.elevationOccupied(hex);
        int n6 = entity.elevationOccupied(hex2);
        int n7 = entity.getMovementType();
        if (n5 != n6) {
            int n8 = Math.abs(n5 - n6);
            if (!(bl || n7 != 3 && n7 != 4 && n7 != 5)) {
                n8 *= 2;
            }
            n4 += n8;
        }
        return n4;
    }

    public static boolean isMovementPossible(Game game, int n, Coords coords, Coords coords2, int n2, int n3, boolean bl) {
        Entity entity = game.getEntity(n);
        Hex hex = game.board.getHex(coords);
        Hex hex2 = game.board.getHex(coords2);
        if (entity == null) {
            throw new IllegalArgumentException("Entity invalid.");
        }
        if (coords.distance(coords2) > 1) {
            throw new IllegalArgumentException("Coordinates must be adjacent.");
        }
        if (n2 == -1) {
            return false;
        }
        if (!game.board.contains(coords2)) {
            return false;
        }
        boolean bl2 = false;
        Enumeration enumeration = entity.getAmmo();
        while (enumeration.hasMoreElements()) {
            if (!((Mounted)enumeration.nextElement()).isDumping()) continue;
            bl2 = true;
            break;
        }
        if (bl2 && n2 == 2) {
            return false;
        }
        int n4 = entity.elevationOccupied(hex);
        int n5 = entity.elevationOccupied(hex2);
        int n6 = entity.getMovementType();
        if (n2 != 3 && Math.abs(n4 - n5) > entity.getMaxElevationChange()) {
            return false;
        }
        if ((n3 == 2 || n3 == 13 || n3 == 14) && n4 != n5) {
            return false;
        }
        if (n2 == 2 && n6 != 5 && hex2.levelOf(4) > 0 && !bl) {
            return false;
        }
        if (n2 != 3 && n3 != 8 && n3 != 9) {
            if (entity instanceof Mech && Compute.isEnemyMechIn(game, n, coords2)) {
                return false;
            }
            if (!coords.equals(entity.getPosition()) && Compute.isEnemyUnitIn(game, n, coords)) {
                return false;
            }
        }
        if (n2 == 3 && hex2.getElevation() > entity.elevation() + entity.getJumpMPWithTerrain()) {
            return false;
        }
        return n2 == 3 || !entity.isHexProhibited(hex2);
    }

    public static boolean isEnemyMechIn(Game game, int n, Coords coords) {
        Entity entity = game.getEntity(n);
        Enumeration enumeration = game.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            Entity entity2 = (Entity)enumeration.nextElement();
            if (!(entity2 instanceof Mech) || !entity2.getOwner().isEnemyOf(entity.getOwner())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnemyUnitIn(Game game, int n, Coords coords) {
        Entity entity = game.getEntity(n);
        Enumeration enumeration = game.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            Entity entity2 = (Entity)enumeration.nextElement();
            if (!entity2.getOwner().isEnemyOf(entity.getOwner())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPilotingSkillNeeded(Game game, int n, Coords coords, Coords coords2, int n2, MovementData.Step step, int n3) {
        Entity entity = game.getEntity(n);
        Hex hex = game.board.getHex(coords);
        Hex hex2 = game.board.getHex(coords2);
        boolean bl = entity instanceof Infantry;
        if (entity == null) {
            throw new IllegalArgumentException("Entity invalid.");
        }
        if (coords.distance(coords2) > 1) {
            throw new IllegalArgumentException("Coordinates must be adjacent.");
        }
        if (coords.equals(coords2)) {
            return false;
        }
        if (n2 != 3 && hex2.levelOf(3) > 0 && !bl) {
            return true;
        }
        if (n2 != 3 && entity.getMovementType() != 5 && hex2.levelOf(4) > 0) {
            return true;
        }
        return n2 != 3 && hex.contains(5) && n3 == 2 && step != null && (step.getType() == 3 || step.getType() == 4) && !bl;
    }

    public static boolean isValidDisplacement(Game game, int n, Coords coords, int n2) {
        return Compute.isValidDisplacement(game, n, coords, coords.translated(n2));
    }

    public static boolean isValidDisplacement(Game game, int n, Coords coords, Coords coords2) {
        Serializable serializable;
        Entity entity = game.getEntity(n);
        Hex hex = game.board.getHex(coords);
        Hex hex2 = game.board.getHex(coords2);
        Coords[] coordsArray = Compute.intervening(coords, coords2);
        int n2 = coords.direction(coords2);
        if (entity == null) {
            throw new IllegalArgumentException("Entity invalid.");
        }
        if (!game.board.contains(coords2)) {
            return false;
        }
        if (entity.isHexProhibited(hex2)) {
            return false;
        }
        int n3 = 0;
        while (n3 < coordsArray.length) {
            serializable = game.board.getHex(coordsArray[n3]);
            int n4 = entity.elevationOccupied((Hex)serializable) - entity.elevationOccupied(hex);
            if (n4 > entity.getMaxElevationChange()) {
                return false;
            }
            ++n3;
        }
        serializable = Compute.stackingViolation(game, n, coords2);
        if (serializable != null) {
            return Compute.isValidDisplacement(game, ((Entity)serializable).getId(), ((Entity)serializable).getPosition(), n2);
        }
        return true;
    }

    public static Coords getValidDisplacement(Game game, int n, Coords coords, int n2) {
        Entity entity = game.getEntity(n);
        if (Compute.isValidDisplacement(game, n, coords, n2)) {
            return coords.translated(n2);
        }
        if (Compute.isValidDisplacement(game, n, coords, (n2 + 1) % 6)) {
            return coords.translated((n2 + 1) % 6);
        }
        if (Compute.isValidDisplacement(game, n, coords, (n2 + 5) % 6)) {
            return coords.translated((n2 + 5) % 6);
        }
        if (Compute.isValidDisplacement(game, n, coords, (n2 + 2) % 6)) {
            return coords.translated((n2 + 2) % 6);
        }
        if (Compute.isValidDisplacement(game, n, coords, (n2 + 4) % 6)) {
            return coords.translated((n2 + 4) % 6);
        }
        if (Compute.isValidDisplacement(game, n, coords, (n2 + 3) % 6)) {
            return coords.translated((n2 + 3) % 6);
        }
        return null;
    }

    public static Coords getPreferredDisplacement(Game game, int n, Coords coords, int n2) {
        Entity entity = game.getEntity(n);
        if (Compute.isValidDisplacement(game, n, coords, n2)) {
            return coords.translated(n2);
        }
        if (Compute.isValidDisplacement(game, n, coords, (n2 + 1) % 6)) {
            return coords.translated((n2 + 1) % 6);
        }
        if (Compute.isValidDisplacement(game, n, coords, (n2 + 5) % 6)) {
            return coords.translated((n2 + 5) % 6);
        }
        if (Compute.isValidDisplacement(game, n, coords, (n2 + 2) % 6)) {
            return coords.translated((n2 + 2) % 6);
        }
        if (Compute.isValidDisplacement(game, n, coords, (n2 + 4) % 6)) {
            return coords.translated((n2 + 4) % 6);
        }
        if (Compute.isValidDisplacement(game, n, coords, (n2 + 3) % 6)) {
            return coords.translated((n2 + 3) % 6);
        }
        return null;
    }

    public static Coords getMissedChargeDisplacement(Game game, int n, Coords coords, int n2) {
        Coords coords2 = coords.translated((n2 + 1) % 6);
        Coords coords3 = coords.translated((n2 + 5) % 6);
        Hex hex = game.board.getHex(coords2);
        Hex hex2 = game.board.getHex(coords3);
        Entity entity = game.getEntity(n);
        if (hex != null && hex2 != null && entity.elevationOccupied(hex) <= entity.elevationOccupied(hex2)) {
            if (entity.elevationOccupied(hex) < entity.elevationOccupied(hex2)) {
                Coords coords4 = coords2;
                coords2 = coords3;
                coords3 = coords4;
            } else if ((double)random.nextFloat() > 0.5) {
                Coords coords5 = coords2;
                coords2 = coords3;
                coords3 = coords5;
            }
        }
        if (Compute.isValidDisplacement(game, n, coords, coords.direction(coords2))) {
            return coords2;
        }
        if (Compute.isValidDisplacement(game, n, coords, coords.direction(coords3))) {
            return coords3;
        }
        return coords;
    }

    public static PilotingRollData getBasePilotingRoll(Game game, int n) {
        Entity entity = game.getEntity(n);
        if (entity.getDestroyedCriticals(0, 4, 1) > 1) {
            return new PilotingRollData(n, 0x7FFFFFFE, 3, "Gyro destroyed");
        }
        if (entity instanceof BipedMech) {
            if (((BipedMech)entity).countDestroyedLegs() == 2) {
                return new PilotingRollData(n, 0x7FFFFFFE, 10, "Both legs destroyed");
            }
        } else if (entity instanceof QuadMech && ((QuadMech)entity).countDestroyedLegs() >= 3) {
            return new PilotingRollData(n, 0x7FFFFFFE, 10, ((Mech)entity).countDestroyedLegs() + " legs destroyed");
        }
        if (entity.isShutDown()) {
            return new PilotingRollData(n, 0x7FFFFFFE, 3, "Reactor shut down");
        }
        if (!entity.getCrew().isActive()) {
            return new PilotingRollData(n, Integer.MAX_VALUE, "Pilot unconcious");
        }
        PilotingRollData pilotingRollData = new PilotingRollData(n, entity.getCrew().getPiloting(), "Base piloting skill");
        pilotingRollData = entity.addEntityBonuses(pilotingRollData);
        return pilotingRollData;
    }

    public static ToHitData toHitWeapon(Game game, WeaponAttackAction weaponAttackAction, Vector vector) {
        return Compute.toHitWeapon(game, weaponAttackAction.getEntityId(), weaponAttackAction.getTargetId(), weaponAttackAction.getWeaponId(), vector);
    }

    public static ToHitData toHitWeapon(Game game, int n, int n2, int n3, Vector vector) {
        Object object;
        Object object2;
        int n4;
        Serializable serializable;
        Object object3;
        int n5;
        boolean bl;
        Entity entity = game.getEntity(n);
        Entity entity2 = game.getEntity(n2);
        Mounted mounted = entity.getEquipment(n3);
        WeaponType weaponType = (WeaponType)mounted.getType();
        Coords[] coordsArray = Compute.intervening(entity.getPosition(), entity2.getPosition());
        boolean bl2 = bl = entity instanceof Infantry;
        boolean bl3 = weaponType.getAmmoType() != -1 && !bl2;
        Mounted mounted2 = bl3 ? mounted.getLinked() : null;
        AmmoType ammoType = mounted2 == null ? null : (AmmoType)mounted2.getType();
        boolean bl4 = false;
        boolean bl5 = false;
        if (mounted.isDestroyed()) {
            return new ToHitData(Integer.MAX_VALUE, "Weapon not operational.");
        }
        if (bl3 && (mounted2 == null || mounted2.getShotsLeft() == 0)) {
            return new ToHitData(Integer.MAX_VALUE, "Weapon out of ammo.");
        }
        int n6 = entity.getDestroyedCriticals(0, 1, 0);
        if (n6 > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker sensors destroyed.");
        }
        if (!Compute.isInArc(game, n, n3, n2)) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        int n7 = entity.elevation() + entity.height();
        int n8 = entity2.elevation() + entity2.height();
        LosEffects losEffects = Compute.calculateLos(game, n, n2);
        ToHitData toHitData = Compute.losModifiers(losEffects);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            return toHitData;
        }
        if (losEffects.attackerCover && entity.locationIsLeg(mounted.getLocation())) {
            return new ToHitData(Integer.MAX_VALUE, "Nearby terrain blocks leg weapons");
        }
        ToHitData toHitData2 = new ToHitData(entity.crew.getGunnery(), "gunnery skill");
        int n9 = n5 = entity.getPosition().distance(entity2.getPosition());
        Entity entity3 = entity;
        if (entity.hasC3() || entity.hasC3i()) {
            object3 = game.getEntities();
            while (object3.hasMoreElements()) {
                serializable = (Entity)object3.nextElement();
                if (!entity.onSameC3NetworkAs((Entity)serializable) || !Compute.canSee(game, (Entity)serializable, entity2) || (n4 = ((Entity)serializable).getPosition().distance(entity2.getPosition())) >= n9) continue;
                n9 = n4;
                entity3 = serializable;
            }
        }
        if (n5 > weaponType.getLongRange()) {
            return new ToHitData(0x7FFFFFFE, "Target out of range");
        }
        if (n5 > weaponType.getMediumRange()) {
            if (bl && weaponType.getAmmoType() == 7 && n5 == weaponType.getLongRange()) {
                toHitData2.addModifier(5, "infantry LRM maximum range");
            } else {
                toHitData2.addModifier(4, "long range");
            }
            if (n9 <= weaponType.getShortRange()) {
                toHitData2.addModifier(-4, "c3: " + entity3.getDisplayName() + " at short range");
            } else if (n9 <= weaponType.getMediumRange()) {
                toHitData2.addModifier(-2, "c3: " + entity3.getDisplayName() + " at medium range");
            }
        } else if (n5 > weaponType.getShortRange()) {
            toHitData2.addModifier(2, "medium range");
            if (n9 <= weaponType.getShortRange()) {
                toHitData2.addModifier(-2, "c3: " + entity3.getDisplayName() + " at short range");
            }
        } else if (0 == n5) {
            if (!bl) {
                return new ToHitData(Integer.MAX_VALUE, "Only Infantry shoot at zero range");
            }
            if ((weaponType.getFlags() & 2) == 2) {
                toHitData2.addModifier(-1, "infantry flamer assault");
            } else if (weaponType.getAmmoType() == 9) {
                toHitData2.addModifier(-1, "infantry SRM assault");
            } else if (weaponType.getAmmoType() != 7) {
                toHitData2.addModifier(-2, "infantry assault");
            }
        }
        if (n5 <= weaponType.getMinimumRange()) {
            int n10 = weaponType.getMinimumRange() - n5 + 1;
            if (bl && weaponType.getAmmoType() == 7) {
                toHitData2.addModifier(n10 * 2, "infantry LRM minumum range");
            } else {
                toHitData2.addModifier(n10, "minumum range");
            }
        }
        toHitData2.append(Compute.getAttackerMovementModifier(game, n));
        toHitData2.append(Compute.getTargetMovementModifier(game, n2));
        toHitData2.append(Compute.getAttackerTerrainModifier(game, n));
        object3 = game.board.getHex(entity.getPosition());
        if (((Hex)object3).contains(4) && ((Hex)object3).surface() > n7) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker underwater");
        }
        toHitData2.append(Compute.getTargetTerrainModifier(game, n2));
        serializable = game.board.getHex(entity2.getPosition());
        if (((Hex)serializable).contains(4)) {
            if (((Hex)serializable).surface() == n8 && entity2.height() > 0) {
                losEffects.targetCover = true;
                toHitData = Compute.losModifiers(losEffects);
            } else if (((Hex)serializable).surface() > n8) {
                return new ToHitData(Integer.MAX_VALUE, "Target underwater");
            }
        }
        toHitData2.append(toHitData);
        n4 = -1;
        boolean bl6 = Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), entity2.getPosition(), 1);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof WeaponAttackAction) || ((AbstractEntityAction)(object2 = (WeaponAttackAction)e)).getEntityId() != n) continue;
            object = game.getEntity(((AbstractAttackAction)object2).getTargetId());
            if (Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), ((Entity)object).getPosition(), 1)) {
                n4 = ((AbstractAttackAction)object2).getTargetId();
                break;
            }
            if (n4 != -1 || bl6) continue;
            n4 = ((AbstractAttackAction)object2).getTargetId();
        }
        if (n4 != -1 && n4 != n2) {
            if (bl6) {
                toHitData2.addModifier(1, "secondary target modifier");
            } else {
                toHitData2.addModifier(2, "secondary target modifier");
            }
        }
        if (entity.getHeatFiringModifier() != 0) {
            toHitData2.addModifier(entity.getHeatFiringModifier(), "heat");
        }
        if (entity.getDestroyedCriticals(0, 7, mounted.getLocation()) > 0) {
            toHitData2.addModifier(4, "shoulder actuator destroyed");
        } else {
            int n11 = 0;
            if (entity.getDestroyedCriticals(0, 8, mounted.getLocation()) > 0) {
                ++n11;
            }
            if (entity.getDestroyedCriticals(0, 9, mounted.getLocation()) > 0) {
                ++n11;
            }
            if (n11 > 0) {
                toHitData2.addModifier(n11, n11 + " destroyed arm actuators");
            }
        }
        if (n6 > 0) {
            toHitData2.addModifier(2, "attacker sensors damaged");
        }
        if (entity2.isImmobile()) {
            toHitData2.addModifier(-4, "target immobile");
        }
        if (entity.isProne()) {
            if (entity.entityIsQuad()) {
                int n12 = ((Mech)entity).countDestroyedLegs();
                if (n12 == 1 || n12 == 2) {
                    if (entity.isLocationDestroyed(4) && entity.isLocationDestroyed(5)) {
                        return new ToHitData(Integer.MAX_VALUE, "Prone with both front legs destroyed");
                    }
                    if (mounted.getLocation() == 4 || mounted.getLocation() == 5) {
                        int n13 = mounted.getLocation() == 4 ? 5 : 4;
                        object = vector.elements();
                        while (object.hasMoreElements()) {
                            Object e = object.nextElement();
                            if (!(e instanceof WeaponAttackAction)) continue;
                            WeaponAttackAction weaponAttackAction = (WeaponAttackAction)e;
                            if (weaponAttackAction.getEntityId() == n && weaponAttackAction.getWeaponId() == n3) break;
                            if (weaponAttackAction.getEntityId() != n || entity.getEquipment(weaponAttackAction.getWeaponId()).getLocation() != n13) continue;
                            return new ToHitData(Integer.MAX_VALUE, "Prone and firing from other front leg already");
                        }
                    }
                    if (mounted.getLocation() == 7 || mounted.getLocation() == 6) {
                        return new ToHitData(Integer.MAX_VALUE, "Can't fire rear leg-mounted weapons while prone with destroyed legs");
                    }
                    toHitData2.addModifier(2, "attacker prone");
                } else if (n12 >= 3) {
                    return new ToHitData(Integer.MAX_VALUE, "Prone with three or more legs destroyed");
                }
            } else {
                if (entity.isLocationDestroyed(4) || entity.isLocationDestroyed(5)) {
                    return new ToHitData(Integer.MAX_VALUE, "Prone with one or both arms destroyed");
                }
                if (mounted.getLocation() == 4 || mounted.getLocation() == 5) {
                    int n14 = mounted.getLocation() == 4 ? 5 : 4;
                    object2 = vector.elements();
                    while (object2.hasMoreElements()) {
                        object = object2.nextElement();
                        if (!(object instanceof WeaponAttackAction)) continue;
                        WeaponAttackAction weaponAttackAction = (WeaponAttackAction)object;
                        if (weaponAttackAction.getEntityId() == n && weaponAttackAction.getWeaponId() == n3) break;
                        if (weaponAttackAction.getEntityId() != n || entity.getEquipment(weaponAttackAction.getWeaponId()).getLocation() != n14) continue;
                        return new ToHitData(Integer.MAX_VALUE, "Prone and firing from other arm already");
                    }
                }
                if (mounted.getLocation() == 7 || mounted.getLocation() == 6) {
                    return new ToHitData(Integer.MAX_VALUE, "Can't fire leg-mounted weapons while prone");
                }
                toHitData2.addModifier(2, "attacker prone");
            }
        }
        if (entity2.isProne()) {
            if (n5 == 1) {
                toHitData2.addModifier(-2, "target prone and adjacent");
            }
            if (n5 > 1) {
                toHitData2.addModifier(1, "target prone and at range");
            }
        }
        if (weaponType.getToHitModifier() != 0) {
            toHitData2.addModifier(weaponType.getToHitModifier(), "weapon to-hit modifier");
        }
        if (bl3 && ammoType.getToHitModifier() != 0) {
            toHitData2.addModifier(ammoType.getToHitModifier(), "ammunition to-hit modifier");
        }
        if (entity.hasTargComp() && weaponType.hasFlag(1)) {
            toHitData2.addModifier(-1, "targeting computer");
        }
        if (losEffects.targetCover) {
            toHitData2.setHitTable(1);
        }
        if (bl && 0 == n5) {
            toHitData2.setSideTable(0);
        } else {
            toHitData2.setSideTable(Compute.targetSideTable(entity, entity2));
        }
        return toHitData2;
    }

    public static ToHitData losModifiers(LosEffects losEffects) {
        ToHitData toHitData = new ToHitData();
        if (losEffects.blocked) {
            return new ToHitData(Integer.MAX_VALUE, "LOS blocked by terrain");
        }
        if (losEffects.lightWoods + losEffects.heavyWoods * 2 > 2) {
            return new ToHitData(Integer.MAX_VALUE, "LOS blocked by woods");
        }
        if (losEffects.smoke > 1) {
            return new ToHitData(Integer.MAX_VALUE, "LOS blocked by smoke");
        }
        if (losEffects.smoke == 1) {
            if (losEffects.lightWoods + losEffects.heavyWoods > 0) {
                return new ToHitData(Integer.MAX_VALUE, "LOS blocked by smoke and woods");
            }
            toHitData.addModifier(2, "intervening smoke");
        }
        if (losEffects.lightWoods > 0) {
            toHitData.addModifier(losEffects.lightWoods, losEffects.lightWoods + " intervening light woods");
        }
        if (losEffects.heavyWoods > 0) {
            toHitData.addModifier(losEffects.heavyWoods * 2, losEffects.heavyWoods + " intervening heavy woods");
        }
        if (losEffects.targetCover) {
            toHitData.addModifier(3, "target has partial cover");
        }
        return toHitData;
    }

    public static LosEffects calculateLos(Game game, int n, int n2) {
        Entity entity = game.getEntity(n);
        Entity entity2 = game.getEntity(n2);
        if (null == entity.getPosition() || null == entity2.getPosition()) {
            LosEffects losEffects = new LosEffects();
            losEffects.blocked = true;
            return losEffects;
        }
        double d = entity.getPosition().degree(entity2.getPosition());
        if (d % 60.0 == 30.0) {
            return Compute.losDivided(game, n, n2);
        }
        return Compute.losStraight(game, n, n2);
    }

    public static LosEffects losStraight(Game game, int n, int n2) {
        Entity entity = game.getEntity(n);
        Entity entity2 = game.getEntity(n2);
        Coords[] coordsArray = Compute.intervening(entity.getPosition(), entity2.getPosition());
        LosEffects losEffects = new LosEffects();
        int n3 = 0;
        while (n3 < coordsArray.length) {
            losEffects.add(Compute.losForCoords(game, n, n2, coordsArray[n3]));
            ++n3;
        }
        return losEffects;
    }

    public static LosEffects losDivided(Game game, int n, int n2) {
        Entity entity = game.getEntity(n);
        Entity entity2 = game.getEntity(n2);
        Coords[] coordsArray = Compute.intervening(entity.getPosition(), entity2.getPosition());
        LosEffects losEffects = new LosEffects();
        int n3 = 3;
        while (n3 < coordsArray.length - 2) {
            losEffects.add(Compute.losForCoords(game, n, n2, coordsArray[n3]));
            n3 += 3;
        }
        if (Compute.losModifiers(losEffects).getValue() == Integer.MAX_VALUE) {
            return losEffects;
        }
        int n4 = 1;
        while (n4 < coordsArray.length - 2) {
            LosEffects losEffects2 = Compute.losForCoords(game, n, n2, coordsArray[n4]);
            LosEffects losEffects3 = Compute.losForCoords(game, n, n2, coordsArray[n4 + 1]);
            losEffects2.add(losEffects);
            losEffects3.add(losEffects);
            losEffects = Compute.losModifiers(losEffects2).getValue() > Compute.losModifiers(losEffects3).getValue() ? losEffects2 : losEffects3;
            n4 += 3;
        }
        return losEffects;
    }

    public static LosEffects losForCoords(Game game, int n, int n2, Coords coords) {
        LosEffects losEffects = new LosEffects();
        if (!game.board.contains(coords)) {
            return losEffects;
        }
        Entity entity = game.getEntity(n);
        Entity entity2 = game.getEntity(n2);
        if (coords.equals(entity.getPosition()) || coords.equals(entity2.getPosition())) {
            return losEffects;
        }
        int n3 = entity.elevation() + entity.height();
        int n4 = entity2.elevation() + entity2.height();
        Hex hex = game.board.getHex(coords);
        int n5 = hex.surface();
        if (n5 > n3 && n5 > n4 || n5 > n3 && entity.getPosition().distance(coords) == 1 || n5 > n4 && entity2.getPosition().distance(coords) == 1) {
            losEffects.blocked = true;
        }
        if (n5 + 2 > n3 && n5 + 2 > n4 || n5 + 2 > n3 && entity.getPosition().distance(coords) == 1 || n5 + 2 > n4 && entity2.getPosition().distance(coords) == 1) {
            if (hex.contains(8)) {
                ++losEffects.smoke;
            } else if (hex.levelOf(1) == 1) {
                ++losEffects.lightWoods;
            } else if (hex.levelOf(1) > 1) {
                ++losEffects.heavyWoods;
            }
        }
        if (entity2.getPosition().distance(coords) == 1 && n5 == n4 && n3 <= n4 && entity2.height() > 0) {
            losEffects.targetCover = true;
        }
        if (entity.getPosition().distance(coords) == 1 && n5 == n3 && n3 >= n4 && entity.height() > 0) {
            losEffects.attackerCover = true;
        }
        return losEffects;
    }

    public static ToHitData toHitPunch(Game game, PunchAttackAction punchAttackAction) {
        return Compute.toHitPunch(game, punchAttackAction.getEntityId(), punchAttackAction.getTargetId(), punchAttackAction.getArm());
    }

    public static ToHitData toHitPunch(Game game, int n, int n2, int n3) {
        int n4;
        Entity entity = game.getEntity(n);
        Entity entity2 = game.getEntity(n2);
        int n5 = entity.absHeight();
        int n6 = entity2.absHeight();
        int n7 = entity2.elevation();
        int n8 = n3 == 2 ? 4 : 5;
        int n9 = n4 = n3 == 2 ? 3 : 2;
        if (!(entity instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Non-mechs can't punch");
        }
        if (n3 != 2 && n3 != 1) {
            throw new IllegalArgumentException("Arm must be LEFT or RIGHT");
        }
        if (entity == null || entity2 == null) {
            throw new IllegalArgumentException("Attacker or target id not valid");
        }
        if (entity.entityIsQuad()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is a quad");
        }
        if (entity.getArmsFlipped()) {
            return new ToHitData(Integer.MAX_VALUE, "Arms are flipped to the rear. Can not punch.");
        }
        if (entity.isLocationDestroyed(n8)) {
            return new ToHitData(Integer.MAX_VALUE, "Arm missing");
        }
        if (!entity.hasWorkingSystem(7, n8)) {
            return new ToHitData(Integer.MAX_VALUE, "Shoulder destroyed");
        }
        if (entity.weaponFiredFrom(n8)) {
            return new ToHitData(Integer.MAX_VALUE, "Weapons fired from arm this turn");
        }
        if (entity.getPosition().distance(entity2.getPosition()) > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (n5 < n7 || n5 > n6) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        if (entity2.isMakingDfa()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is making a DFA attack");
        }
        if (!Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), entity2.getPosition(), n4)) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        ToHitData toHitData = new ToHitData(4, "base");
        toHitData.append(Compute.getAttackerMovementModifier(game, n));
        toHitData.append(Compute.getTargetMovementModifier(game, n2));
        toHitData.append(Compute.getAttackerTerrainModifier(game, n));
        toHitData.append(Compute.getTargetTerrainModifier(game, n2));
        if (!entity.hasWorkingSystem(8, n8)) {
            toHitData.addModifier(2, "Upper arm actuator destroyed");
        }
        if (!entity.hasWorkingSystem(9, n8)) {
            toHitData.addModifier(2, "Lower arm actuator missing or destroyed");
        }
        if (!entity.hasWorkingSystem(10, n8)) {
            toHitData.addModifier(1, "Hand actuator missing or destroyed");
        }
        if (entity2.isProne()) {
            toHitData.addModifier(-2, "target prone and adjacent");
        }
        Hex hex = game.board.getHex(entity2.getPosition());
        if (entity2.height() > 0 && hex.levelOf(4) == entity2.height()) {
            toHitData.addModifier(3, "target has partial cover");
        }
        if (entity2.isImmobile()) {
            toHitData.addModifier(-4, "target immobile");
        }
        if (n5 == n7) {
            if (entity2.height() == 0) {
                toHitData.setHitTable(0);
            } else {
                toHitData.setHitTable(2);
            }
        } else {
            toHitData.setHitTable(1);
        }
        toHitData.setSideTable(Compute.targetSideTable(entity, entity2));
        return toHitData;
    }

    public static int getPunchDamageFor(Entity entity, int n) {
        int n2 = n == 2 ? 4 : 5;
        int n3 = (int)Math.ceil((double)entity.getWeight() / 10.0);
        float f = 1.0f;
        if (!entity.hasWorkingSystem(8, n2)) {
            f /= 2.0f;
        }
        if (!entity.hasWorkingSystem(9, n2)) {
            f /= 2.0f;
        }
        if (!entity.hasWorkingSystem(7, n2)) {
            n3 = 0;
        }
        if (entity.heat >= 9 && ((Mech)entity).hasTSM()) {
            f *= 2.0f;
        }
        return (int)Math.floor((float)n3 * f);
    }

    public static ToHitData toHitKick(Game game, KickAttackAction kickAttackAction) {
        return Compute.toHitKick(game, kickAttackAction.getEntityId(), kickAttackAction.getTargetId(), kickAttackAction.getLeg());
    }

    public static ToHitData toHitKick(Game game, int n, int n2, int n3) {
        int n4;
        Entity entity = game.getEntity(n);
        Entity entity2 = game.getEntity(n2);
        int n5 = entity.elevation();
        int n6 = entity2.absHeight();
        int n7 = entity2.elevation();
        int[] nArray = new int[2];
        if (!(entity instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Non-mechs can't kick");
        }
        if (entity.entityIsQuad()) {
            nArray[0] = 4;
            nArray[1] = 5;
        } else {
            nArray[0] = 6;
            nArray[1] = 7;
        }
        int n8 = n4 = n3 == 2 ? nArray[0] : nArray[1];
        if (n3 != 2 && n3 != 1) {
            throw new IllegalArgumentException("Leg must be LEFT or RIGHT");
        }
        if (entity == null || entity2 == null) {
            throw new IllegalArgumentException("Attacker or target id not valid");
        }
        if (entity.isLocationDestroyed(nArray[0]) || entity.isLocationDestroyed(nArray[1])) {
            return new ToHitData(Integer.MAX_VALUE, "Leg missing");
        }
        if (!entity.hasWorkingSystem(11, nArray[0]) || !entity.hasWorkingSystem(11, nArray[1])) {
            return new ToHitData(Integer.MAX_VALUE, "Hip destroyed");
        }
        Enumeration enumeration = entity.getWeapons();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!mounted.isUsedThisRound() || mounted.getLocation() != n4) continue;
            return new ToHitData(Integer.MAX_VALUE, "Weapons fired from leg this turn");
        }
        int n9 = entity.getPosition().distance(entity2.getPosition());
        if (n9 > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (n5 < n7 || n5 > n6) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        if (entity2.isMakingDfa()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is making a DFA attack");
        }
        if (0 != n9 && !Compute.isInArc(entity.getPosition(), entity.getFacing(), entity2.getPosition(), 1)) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        ToHitData toHitData = new ToHitData(3, "base");
        if (0 == n9 && entity2 instanceof Infantry) {
            toHitData.addModifier(3, "Stomping Infantry");
        }
        toHitData.append(Compute.getAttackerMovementModifier(game, n));
        toHitData.append(Compute.getTargetMovementModifier(game, n2));
        toHitData.append(Compute.getAttackerTerrainModifier(game, n));
        toHitData.append(Compute.getTargetTerrainModifier(game, n2));
        if (!entity.hasWorkingSystem(12, n4)) {
            toHitData.addModifier(2, "Upper leg actuator destroyed");
        }
        if (!entity.hasWorkingSystem(13, n4)) {
            toHitData.addModifier(2, "Lower leg actuator destroyed");
        }
        if (!entity.hasWorkingSystem(14, n4)) {
            toHitData.addModifier(1, "Foot actuator destroyed");
        }
        if (entity2.isProne()) {
            toHitData.addModifier(-2, "target prone and adjacent");
        }
        Hex hex = game.board.getHex(entity2.getPosition());
        if (entity2.height() > 0 && hex.levelOf(4) == entity2.height()) {
            toHitData.addModifier(3, "target has partial cover");
        }
        if (entity2.isImmobile()) {
            toHitData.addModifier(-4, "target immobile");
        }
        if (n5 < n6) {
            toHitData.setHitTable(2);
        } else if (entity2.height() > 0) {
            toHitData.setHitTable(1);
        } else {
            toHitData.setHitTable(0);
        }
        toHitData.setSideTable(Compute.targetSideTable(entity, entity2));
        if (0 == n9 && entity2 instanceof Tank) {
            toHitData.setSideTable(random.nextInt(4));
        }
        return toHitData;
    }

    public static int getKickDamageFor(Entity entity, int n) {
        int[] nArray = new int[2];
        if (entity.entityIsQuad()) {
            nArray[0] = 4;
            nArray[1] = 5;
        } else {
            nArray[0] = 6;
            nArray[1] = 7;
        }
        int n2 = n == 2 ? nArray[0] : nArray[1];
        int n3 = (int)Math.floor((double)entity.getWeight() / 5.0);
        float f = 1.0f;
        if (!entity.hasWorkingSystem(12, n2)) {
            f /= 2.0f;
        }
        if (!entity.hasWorkingSystem(13, n2)) {
            f /= 2.0f;
        }
        if (!entity.hasWorkingSystem(11, n2)) {
            n3 = 0;
        }
        if (entity.heat >= 9 && ((Mech)entity).hasTSM()) {
            f *= 2.0f;
        }
        return (int)Math.floor((float)n3 * f);
    }

    public static ToHitData toHitClub(Game game, ClubAttackAction clubAttackAction) {
        return Compute.toHitClub(game, clubAttackAction.getEntityId(), clubAttackAction.getTargetId(), clubAttackAction.getClub());
    }

    public static ToHitData toHitClub(Game game, int n, int n2, Mounted mounted) {
        int n3;
        Entity entity = game.getEntity(n);
        Entity entity2 = game.getEntity(n2);
        int n4 = entity.elevation();
        int n5 = entity.absHeight();
        int n6 = entity2.absHeight();
        int n7 = entity2.elevation();
        boolean bl = mounted.getType().hasFlag(8);
        if (entity == null || entity2 == null) {
            throw new IllegalArgumentException("Attacker or target id not valid");
        }
        if (!(entity instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Non-mechs can't club");
        }
        if (entity.entityIsQuad()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is a quad");
        }
        if (bl) {
            if (entity.isLocationDestroyed(4) || entity.isLocationDestroyed(5)) {
                return new ToHitData(Integer.MAX_VALUE, "Arm missing");
            }
            if (entity.weaponFiredFrom(4) || entity.weaponFiredFrom(5)) {
                return new ToHitData(Integer.MAX_VALUE, "Weapons fired from arm this turn");
            }
            if (!entity.hasWorkingSystem(7, 4) || !entity.hasWorkingSystem(7, 5)) {
                return new ToHitData(Integer.MAX_VALUE, "Shoulder actuator destroyed");
            }
            if (!entity.hasWorkingSystem(10, 4) || !entity.hasWorkingSystem(10, 5)) {
                return new ToHitData(Integer.MAX_VALUE, "Hand actuator destroyed");
            }
        } else {
            if (entity.isLocationDestroyed(mounted.getLocation())) {
                return new ToHitData(Integer.MAX_VALUE, "Arm missing");
            }
            if (entity.weaponFiredFrom(mounted.getLocation())) {
                return new ToHitData(Integer.MAX_VALUE, "Weapons fired from arm this turn");
            }
            if (!entity.hasWorkingSystem(7, mounted.getLocation())) {
                return new ToHitData(Integer.MAX_VALUE, "Shoulder actuator destroyed");
            }
            if (!entity.hasWorkingSystem(10, mounted.getLocation())) {
                return new ToHitData(Integer.MAX_VALUE, "Hand actuator destroyed");
            }
        }
        if (entity.getDestroyedCriticals(1, entity.getEquipmentNum(mounted), mounted.getLocation()) > 0) {
            return new ToHitData(Integer.MAX_VALUE, "Club is damaged");
        }
        if (entity.getPosition().distance(entity2.getPosition()) > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (n6 < n4 || n7 > n5) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        if (entity2.isMakingDfa()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is making a DFA attack");
        }
        int n8 = bl ? 1 : (n3 = mounted.getLocation() == 5 ? 2 : 3);
        if (!Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), entity2.getPosition(), n3)) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        ToHitData toHitData = new ToHitData(4, "base");
        toHitData.append(Compute.getAttackerMovementModifier(game, n));
        toHitData.append(Compute.getTargetMovementModifier(game, n2));
        toHitData.append(Compute.getAttackerTerrainModifier(game, n));
        toHitData.append(Compute.getTargetTerrainModifier(game, n2));
        if (bl) {
            if (!entity.hasWorkingSystem(8, 4)) {
                toHitData.addModifier(2, "Upper arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(8, 5)) {
                toHitData.addModifier(2, "Upper arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(9, 4)) {
                toHitData.addModifier(2, "Lower arm actuator missing or destroyed");
            }
            if (!entity.hasWorkingSystem(9, 5)) {
                toHitData.addModifier(2, "Lower arm actuator missing or destroyed");
            }
        } else {
            if (!entity.hasWorkingSystem(8, mounted.getLocation())) {
                toHitData.addModifier(2, "Upper arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(9, mounted.getLocation())) {
                toHitData.addModifier(2, "Lower arm actuator missing or destroyed");
            }
        }
        if (entity2.isProne()) {
            toHitData.addModifier(-2, "target prone and adjacent");
        }
        Hex hex = game.board.getHex(entity2.getPosition());
        if (entity2.height() > 0 && hex.levelOf(4) == entity2.height()) {
            toHitData.addModifier(3, "target has partial cover");
        }
        if (entity2.isImmobile()) {
            toHitData.addModifier(-4, "target immobile");
        }
        if (n4 == n7) {
            toHitData.setHitTable(0);
        } else if (n4 < n7) {
            if (entity2.height() == 0) {
                toHitData.setHitTable(0);
            } else {
                toHitData.setHitTable(2);
            }
        } else {
            toHitData.setHitTable(1);
        }
        toHitData.setSideTable(Compute.targetSideTable(entity, entity2));
        return toHitData;
    }

    public static int getClubDamageFor(Entity entity, Mounted mounted) {
        int n = (int)Math.floor((double)entity.getWeight() / 5.0);
        if (entity.heat >= 9 && ((Mech)entity).hasTSM()) {
            n *= 2;
        }
        return n;
    }

    public static ToHitData toHitPush(Game game, PushAttackAction pushAttackAction) {
        return Compute.toHitPush(game, pushAttackAction.getEntityId(), pushAttackAction.getTargetId());
    }

    public static ToHitData toHitPush(Game game, int n, int n2) {
        Entity entity = game.getEntity(n);
        Entity entity2 = game.getEntity(n2);
        int n3 = entity.elevation();
        int n4 = entity2.elevation();
        ToHitData toHitData = null;
        if (entity == null || entity2 == null || entity == entity2) {
            throw new IllegalArgumentException("Attacker or target id not valid");
        }
        if (!(entity instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Non-mechs can't push");
        }
        if (entity.entityIsQuad()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is a quad");
        }
        if (!(entity2 instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Target is not a mech");
        }
        if (entity.getArmsFlipped()) {
            return new ToHitData(Integer.MAX_VALUE, "Arms are flipped to the rear. Can not push.");
        }
        if (entity.isLocationDestroyed(4) || entity.isLocationDestroyed(5)) {
            return new ToHitData(Integer.MAX_VALUE, "Arm missing");
        }
        if (entity.weaponFiredFrom(4) || entity.weaponFiredFrom(5)) {
            return new ToHitData(Integer.MAX_VALUE, "Weapons fired from arm this turn");
        }
        if (entity.getPosition().distance(entity2.getPosition()) > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (n3 != n4) {
            return new ToHitData(Integer.MAX_VALUE, "Target not at same elevation");
        }
        if (entity2.hasDisplacementAttack() && !entity2.isPushing()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is making a charge/DFA attack");
        }
        if (entity2.isPushing() && entity2.getDisplacementAttack().getTargetId() != entity.getId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is pushing another mech");
        }
        if (entity.isTargetOfDisplacementAttack() && entity.findTargetedDisplacement().getEntityId() != entity2.getId()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is the target of another push/charge/DFA");
        }
        if (entity2.isTargetOfDisplacementAttack() && entity2.findTargetedDisplacement().getEntityId() != entity.getId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is the target of another push/charge/DFA");
        }
        if (!entity2.getPosition().equals(entity.getPosition().translated(entity.getFacing()))) {
            return new ToHitData(Integer.MAX_VALUE, "Target not directly ahead of feet");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        if (entity2.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is prone");
        }
        toHitData = new ToHitData(4, "base");
        toHitData.append(Compute.getAttackerMovementModifier(game, n));
        toHitData.append(Compute.getTargetMovementModifier(game, n2));
        toHitData.append(Compute.getAttackerTerrainModifier(game, n));
        toHitData.append(Compute.getTargetTerrainModifier(game, n2));
        if (!entity.hasWorkingSystem(7, 4)) {
            toHitData.addModifier(2, "Right Shoulder destroyed");
        }
        if (!entity.hasWorkingSystem(7, 5)) {
            toHitData.addModifier(2, "Left Shoulder destroyed");
        }
        Hex hex = game.board.getHex(entity2.getPosition());
        if (entity2.height() > 0 && hex.levelOf(4) == entity2.height()) {
            toHitData.addModifier(3, "target has partial cover");
        }
        if (entity2.isImmobile()) {
            toHitData.addModifier(-4, "target immobile");
        }
        return toHitData;
    }

    public static ToHitData toHitCharge(Game game, int n, int n2, MovementData movementData) {
        int n3 = 1;
        if (movementData.getMpUsed() > game.getEntity((int)n).walkMP) {
            n3 = 2;
        }
        if (movementData.contains(7)) {
            n3 = 3;
        }
        return Compute.toHitCharge(game, n, n2, movementData, n3);
    }

    public static ToHitData toHitCharge(Game game, int n, int n2, MovementData movementData, int n3) {
        Entity entity = game.getEntity(n);
        Entity entity2 = game.getEntity(n2);
        Coords coords = entity.getPosition();
        MovementData.Step step = null;
        if (entity instanceof Infantry) {
            return new ToHitData(Integer.MAX_VALUE, "Infantry can't charge");
        }
        if (!movementData.contains(8)) {
            return new ToHitData(Integer.MAX_VALUE, "Charge action not found in movment path");
        }
        if (movementData.contains(7)) {
            return new ToHitData(Integer.MAX_VALUE, "No jumping allowed while charging");
        }
        if (movementData.contains(2) || movementData.contains(13) || movementData.contains(14)) {
            return new ToHitData(Integer.MAX_VALUE, "No backwards movement allowed while charging");
        }
        Compute.compile(game, n, movementData);
        Enumeration enumeration = movementData.getSteps();
        while (enumeration.hasMoreElements()) {
            MovementData.Step step2 = (MovementData.Step)enumeration.nextElement();
            if (step2.getMovementType() == -1) break;
            if (step2.getType() == 8) {
                step = step2;
                continue;
            }
            coords = step2.getPosition();
        }
        if (step == null || !entity2.getPosition().equals(step.getPosition())) {
            return new ToHitData(Integer.MAX_VALUE, "Could not reach target with movement");
        }
        if (entity2.ready) {
            return new ToHitData(Integer.MAX_VALUE, "Target must be done with movement");
        }
        return Compute.toHitCharge(game, n, n2, coords, n3);
    }

    public static ToHitData toHitCharge(Game game, ChargeAttackAction chargeAttackAction) {
        Entity entity = game.getEntity(chargeAttackAction.getEntityId());
        return Compute.toHitCharge(game, chargeAttackAction.getEntityId(), chargeAttackAction.getTargetId(), entity.getPosition(), entity.moved);
    }

    public static ToHitData toHitCharge(Game game, int n, int n2, Coords coords, int n3) {
        Entity entity = game.getEntity(n);
        Entity entity2 = game.getEntity(n2);
        int n4 = entity.elevationOccupied(game.board.getHex(coords));
        int n5 = n4 + entity.height();
        int n6 = entity2.elevation();
        int n7 = entity2.absHeight();
        ToHitData toHitData = null;
        if (entity == null || entity2 == null || entity == entity2) {
            throw new IllegalArgumentException("Attacker or target id not valid");
        }
        if (entity instanceof Infantry) {
            return new ToHitData(Integer.MAX_VALUE, "Infantry can't charge");
        }
        if (coords.distance(entity2.getPosition()) > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (entity instanceof Mech) {
            if (!(entity2 instanceof Mech)) {
                return new ToHitData(Integer.MAX_VALUE, "Target is not a mech");
            }
            if (entity2.isProne()) {
                return new ToHitData(Integer.MAX_VALUE, "Target is prone");
            }
        }
        if (n4 > n7 || n5 < n6) {
            return new ToHitData(Integer.MAX_VALUE, "Target must be within 1 elevation level");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        if (entity2.hasDisplacementAttack()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is already making a charge/DFA attack");
        }
        if (entity2.isTargetOfDisplacementAttack()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is the target of another charge/DFA");
        }
        toHitData = new ToHitData(5, "base");
        toHitData.append(Compute.getAttackerMovementModifier(game, n, n3));
        toHitData.append(Compute.getTargetMovementModifier(game, n2));
        toHitData.append(Compute.getAttackerTerrainModifier(game, n));
        toHitData.append(Compute.getTargetTerrainModifier(game, n2));
        if (entity.getCrew().getPiloting() != entity2.getCrew().getPiloting()) {
            toHitData.addModifier(entity.getCrew().getPiloting() - entity2.getCrew().getPiloting(), "piloting skill differential");
        }
        if (entity2.isProne()) {
            toHitData.addModifier(-2, "target prone and adjacent");
        }
        Hex hex = game.board.getHex(entity2.getPosition());
        if (entity2.height() > 0 && hex.levelOf(4) == entity2.height()) {
            toHitData.addModifier(3, "target has partial cover");
        }
        if (entity2.isImmobile()) {
            toHitData.addModifier(-4, "target immobile");
        }
        toHitData.setSideTable(Compute.targetSideTable(coords, entity2.getPosition(), entity2.getFacing(), entity2 instanceof Tank));
        if (n5 == n7 || entity2.isProne()) {
            toHitData.setHitTable(0);
        } else if (n5 < n7) {
            toHitData.setHitTable(2);
        } else {
            toHitData.setHitTable(1);
        }
        return toHitData;
    }

    public static int getChargeDamageFor(Entity entity) {
        return Compute.getChargeDamageFor(entity, entity.delta_distance);
    }

    public static int getChargeDamageFor(Entity entity, int n) {
        return (int)Math.ceil((double)entity.getWeight() / 10.0 * (double)(n - 1));
    }

    public static int getChargeDamageTakenBy(Entity entity, Entity entity2) {
        return (int)Math.ceil((double)entity2.getWeight() / 10.0);
    }

    public static ToHitData toHitDfa(Game game, int n, int n2, MovementData movementData) {
        Entity entity = game.getEntity(n);
        Entity entity2 = game.getEntity(n2);
        Coords coords = entity.getPosition();
        MovementData.Step step = null;
        if (entity instanceof Infantry) {
            return new ToHitData(Integer.MAX_VALUE, "Infantry can't D.F.A.");
        }
        if (!movementData.contains(9)) {
            return new ToHitData(Integer.MAX_VALUE, "D.F.A. action not found in movment path");
        }
        if (!movementData.contains(7)) {
            return new ToHitData(Integer.MAX_VALUE, "D.F.A. must involve jumping");
        }
        Compute.compile(game, n, movementData);
        Enumeration enumeration = movementData.getSteps();
        while (enumeration.hasMoreElements()) {
            MovementData.Step step2 = (MovementData.Step)enumeration.nextElement();
            if (step2.getMovementType() == -1) break;
            if (step2.getType() == 9) {
                step = step2;
                continue;
            }
            coords = step2.getPosition();
        }
        if (step == null || !entity2.getPosition().equals(step.getPosition())) {
            return new ToHitData(Integer.MAX_VALUE, "Could not reach target with movement");
        }
        if (entity2.ready) {
            return new ToHitData(Integer.MAX_VALUE, "Target must be done with movement");
        }
        return Compute.toHitDfa(game, n, n2, coords);
    }

    public static ToHitData toHitDfa(Game game, DfaAttackAction dfaAttackAction) {
        Entity entity = game.getEntity(dfaAttackAction.getEntityId());
        return Compute.toHitDfa(game, dfaAttackAction.getEntityId(), dfaAttackAction.getTargetId(), entity.getPosition());
    }

    public static ToHitData toHitDfa(Game game, int n, int n2, Coords coords) {
        Entity entity = game.getEntity(n);
        Entity entity2 = game.getEntity(n2);
        ToHitData toHitData = null;
        if (entity == null || entity2 == null || entity == entity2) {
            throw new IllegalArgumentException("Attacker or target id not valid");
        }
        if (entity instanceof Infantry) {
            return new ToHitData(Integer.MAX_VALUE, "Infantry can't dfa");
        }
        if (coords.distance(entity2.getPosition()) > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        if (entity2.hasDisplacementAttack()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is already making a charge/DFA attack");
        }
        if (entity2.isTargetOfDisplacementAttack()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is the target of another charge/DFA");
        }
        toHitData = new ToHitData(5, "base");
        toHitData.append(Compute.getAttackerMovementModifier(game, n, 3));
        toHitData.append(Compute.getTargetMovementModifier(game, n2));
        if (entity.getCrew().getPiloting() != entity2.getCrew().getPiloting()) {
            toHitData.addModifier(entity.getCrew().getPiloting() - entity2.getCrew().getPiloting(), "piloting skill differential");
        }
        if (entity2.isProne()) {
            toHitData.addModifier(-2, "target prone and adjacent");
        }
        Hex hex = game.board.getHex(entity2.getPosition());
        if (entity2.height() > 0 && hex.levelOf(4) == entity2.height()) {
            toHitData.addModifier(3, "target has partial cover");
        }
        if (entity2.isImmobile()) {
            toHitData.addModifier(-4, "target immobile");
        }
        if (entity2 instanceof Tank) {
            toHitData.setSideTable(0);
            toHitData.setHitTable(0);
        } else if (entity2.isProne()) {
            toHitData.setSideTable(1);
            toHitData.setHitTable(0);
        } else {
            toHitData.setSideTable(Compute.targetSideTable(coords, entity2.getPosition(), entity2.getFacing(), entity2 instanceof Tank));
            toHitData.setHitTable(1);
        }
        return toHitData;
    }

    public static int getDfaDamageFor(Entity entity) {
        return (int)Math.ceil((double)entity.getWeight() / 10.0 * 3.0);
    }

    public static int getDfaDamageTakenBy(Entity entity) {
        return (int)Math.ceil((double)entity.getWeight() / 5.0);
    }

    public static ToHitData getAttackerMovementModifier(Game game, int n) {
        return Compute.getAttackerMovementModifier(game, n, game.getEntity((int)n).moved);
    }

    public static ToHitData getAttackerMovementModifier(Game game, int n, int n2) {
        Entity entity = game.getEntity(n);
        ToHitData toHitData = new ToHitData();
        if (entity instanceof Infantry) {
            return toHitData;
        }
        if (n2 == 1) {
            toHitData.addModifier(1, "attacker walked");
        } else if (n2 == 2) {
            toHitData.addModifier(2, "attacker ran");
        } else if (n2 == 3) {
            toHitData.addModifier(3, "attacker jumped");
        }
        return toHitData;
    }

    public static ToHitData getTargetMovementModifier(Game game, int n) {
        Entity entity = game.getEntity(n);
        return Compute.getTargetMovementModifier(entity.delta_distance, entity.moved == 3);
    }

    public static ToHitData getTargetMovementModifier(int n, boolean bl) {
        ToHitData toHitData = new ToHitData();
        if (n >= 3 && n <= 4) {
            toHitData.addModifier(1, "target moved 3-4 hexes");
        } else if (n >= 5 && n <= 6) {
            toHitData.addModifier(2, "target moved 5-6 hexes");
        } else if (n >= 7 && n <= 9) {
            toHitData.addModifier(3, "target moved 7-9 hexes");
        } else if (n >= 10) {
            toHitData.addModifier(4, "target moved 10+ hexes");
        }
        if (bl) {
            toHitData.addModifier(1, "target jumped");
        }
        return toHitData;
    }

    public static ToHitData getAttackerTerrainModifier(Game game, int n) {
        Entity entity = game.getEntity(n);
        Hex hex = game.board.getHex(entity.getPosition());
        ToHitData toHitData = new ToHitData();
        if (hex.levelOf(4) > 0 && entity.getMovementType() != 5) {
            toHitData.addModifier(1, "attacker in water");
        }
        return toHitData;
    }

    public static ToHitData getTargetTerrainModifier(Game game, int n) {
        Entity entity = game.getEntity(n);
        Hex hex = game.board.getHex(entity.getPosition());
        if (entity.isMakingDfa()) {
            return new ToHitData();
        }
        ToHitData toHitData = new ToHitData();
        if (entity instanceof HexEntity) {
            if (hex.contains(8)) {
                toHitData.addModifier(2, "target in smoke");
            }
            return toHitData;
        }
        if (hex.levelOf(4) > 0 && entity.getMovementType() != 5) {
            toHitData.addModifier(-1, "target in water");
        }
        if (hex.contains(8)) {
            toHitData.addModifier(2, "target in smoke");
        } else if (hex.levelOf(1) == 1) {
            toHitData.addModifier(1, "target in light woods");
        } else if (hex.levelOf(1) > 1) {
            toHitData.addModifier(2, "target in heavy woods");
        }
        return toHitData;
    }

    public static WeaponAttackAction getHighestExpectedDamage(Game game, Vector vector, Vector vector2) {
        float f = -1.0f;
        WeaponAttackAction weaponAttackAction = null;
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            WeaponAttackAction weaponAttackAction2 = (WeaponAttackAction)vector.elementAt(n);
            float f2 = Compute.getExpectedDamage(game, weaponAttackAction2, vector2);
            if (f2 > f) {
                f = f2;
                weaponAttackAction = weaponAttackAction2;
            }
            ++n;
        }
        return weaponAttackAction;
    }

    public static float getExpectedDamage(Game game, WeaponAttackAction weaponAttackAction, Vector vector) {
        Entity entity = game.getEntity(weaponAttackAction.getEntityId());
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        System.out.println("Computing expected damage for " + entity.getShortName() + " " + mounted.getName());
        ToHitData toHitData = Compute.toHitWeapon(game, weaponAttackAction, vector);
        if (toHitData.getValue() == Integer.MAX_VALUE || toHitData.getValue() == 0x7FFFFFFE) {
            return 0.0f;
        }
        float f = 0.0f;
        f = toHitData.getValue() == Integer.MIN_VALUE ? 1.0f : (float)Compute.oddsAbove(toHitData.getValue()) / 100.0f;
        System.out.println("\tHit Chance: " + f);
        float f2 = 0.0f;
        WeaponType weaponType = (WeaponType)mounted.getType();
        if (weaponType.getDamage() == -2) {
            if (mounted.getLinked() == null) {
                return 0.0f;
            }
            AmmoType ammoType = (AmmoType)mounted.getLinked().getType();
            float f3 = 0.0f;
            f3 = weaponType.getAmmoType() == 11 ? (float)weaponType.getRackSize() : (weaponType.getRackSize() == 40 || weaponType.getRackSize() == 30 ? 2.0f * expectedHitsByRackSize[weaponType.getRackSize() / 2] : expectedHitsByRackSize[weaponType.getRackSize()]);
            Vector vector2 = weaponAttackAction.getCounterEquipment();
            if (vector2 != null) {
                int n = 0;
                while (n < vector2.size()) {
                    Mounted mounted2 = (Mounted)vector2.elementAt(n);
                    if (mounted2.getType() instanceof WeaponType && ((WeaponType)mounted2.getType()).getAmmoType() == 14) {
                        float f4 = 3.5f * (float)((WeaponType)mounted2.getType()).getDamage();
                        f3 = Math.max(0.0f, f3 - f4);
                    }
                    ++n;
                }
            }
            System.out.println("\tExpected Hits: " + f3);
            f2 = f3 * (float)ammoType.getDamagePerShot();
        } else {
            f2 = weaponType.getDamage();
        }
        System.out.println("\tExpected Damage: " + (f2 *= f));
        return f2;
    }

    public static boolean isInArc(Game game, int n, int n2, int n3) {
        Entity entity = game.getEntity(n);
        Entity entity2 = game.getEntity(n3);
        int n4 = entity.isSecondaryArcWeapon(n2) ? entity.getSecondaryFacing() : entity.getFacing();
        return Compute.isInArc(entity.getPosition(), n4, entity2.getPosition(), entity.getWeaponArc(n2));
    }

    public static boolean isInArc(Coords coords, int n, Coords coords2, int n2) {
        int n3 = coords.degree(coords2) - n * 60;
        if (n3 < 0) {
            n3 += 360;
        }
        switch (n2) {
            case 1: {
                return n3 >= 300 || n3 <= 60;
            }
            case 3: {
                return n3 >= 300 || n3 <= 120;
            }
            case 2: {
                return n3 >= 240 || n3 <= 60;
            }
            case 4: {
                return n3 > 120 && n3 < 240;
            }
            case 6: {
                return n3 > 60 && n3 <= 120;
            }
            case 5: {
                return n3 < 300 && n3 >= 240;
            }
            case 0: {
                return true;
            }
        }
        return false;
    }

    public static boolean canSee(Game game, Entity entity, Entity entity2) {
        LosEffects losEffects = Compute.calculateLos(game, entity.getId(), entity2.getId());
        return !losEffects.blocked && losEffects.lightWoods + (losEffects.heavyWoods + losEffects.smoke) * 2 < 3;
    }

    public static Coords[] intervening(Coords coords, Coords coords2) {
        IdealHex idealHex = new IdealHex(coords);
        IdealHex idealHex2 = new IdealHex(coords2);
        int[] nArray = new int[3];
        nArray[2] = (int)Math.round((double)coords.degree(coords2) / 60.0) % 6;
        nArray[1] = (nArray[2] + 5) % 6;
        nArray[0] = (nArray[2] + 1) % 6;
        Vector<Coords> vector = new Vector<Coords>();
        Coords coords3 = coords;
        vector.addElement(coords3);
        while (!coords2.equals(coords3)) {
            coords3 = Compute.nextHex(coords3, coords, idealHex, idealHex2, nArray);
            vector.addElement(coords3);
        }
        Object[] objectArray = new Coords[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Coords nextHex(Coords coords, Coords coords2, IdealHex idealHex, IdealHex idealHex2, int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            Coords coords3 = coords.translated(nArray[n]);
            if (new IdealHex(coords3).isIntersectedBy(idealHex.cx, idealHex.cy, idealHex2.cx, idealHex2.cy)) {
                return coords3;
            }
            ++n;
        }
        throw new RuntimeException("Couldn't find the next hex!");
    }

    public static int targetSideTable(Entity entity, Entity entity2) {
        return Compute.targetSideTable(entity.getPosition(), entity2.getPosition(), entity2.getFacing(), entity2 instanceof Tank);
    }

    public static int targetSideTable(Coords coords, Coords coords2, int n, boolean bl) {
        int n2 = (coords2.degree(coords) + (6 - n) * 60) % 360;
        if (bl) {
            if (n2 > 30 && n2 <= 150) {
                return 3;
            }
            if (n2 > 150 && n2 < 210) {
                return 1;
            }
            if (n2 >= 210 && n2 < 330) {
                return 2;
            }
            return 0;
        }
        if (n2 > 90 && n2 <= 150) {
            return 3;
        }
        if (n2 > 150 && n2 < 210) {
            return 1;
        }
        if (n2 >= 210 && n2 < 270) {
            return 2;
        }
        return 0;
    }

    public static boolean canMechFindClub(Game game, int n) {
        Entity entity = game.getEntity(n);
        Hex hex = game.board.getHex(entity.getPosition());
        if (entity.getMovementType() != 1) {
            return false;
        }
        if (hex.levelOf(1) < 1) {
            return false;
        }
        if (!(entity.hasWorkingSystem(7, 4) && entity.hasWorkingSystem(7, 5) && entity.hasWorkingSystem(10, 4) && entity.hasWorkingSystem(10, 5))) {
            return false;
        }
        return Compute.clubMechHas(entity) == null;
    }

    public static Mounted clubMechHas(Entity entity) {
        Enumeration enumeration = entity.getMisc();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!mounted.getType().hasFlag(8) && !mounted.getType().hasFlag(16)) continue;
            return mounted;
        }
        return null;
    }

    public static boolean canEntityFlee(Game game, int n) {
        Entity entity = game.getEntity(n);
        Coords coords = entity.getPosition();
        return entity.getWalkMP() > 0 && !entity.isProne() && (coords.x == 0 || coords.x == game.board.width - 1 || coords.y == 0 || coords.y == game.board.height - 1);
    }

    public static int missilesHit(int n) {
        return Compute.missilesHit(n, 0);
    }

    public static int missilesHit(int n, int n2) {
        int n3 = Compute.d6(2) + n2;
        n3 = Math.min(Math.max(n3, 2), 12);
        if (n == 2) {
            switch (n3) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return 1;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    return 2;
                }
            }
        }
        if (n == 4) {
            switch (n3) {
                case 2: {
                    return 1;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return 2;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return 3;
                }
                case 11: 
                case 12: {
                    return 4;
                }
            }
        }
        if (n == 5) {
            switch (n3) {
                case 2: {
                    return 1;
                }
                case 3: 
                case 4: {
                    return 2;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return 3;
                }
                case 9: 
                case 10: {
                    return 4;
                }
                case 11: 
                case 12: {
                    return 5;
                }
            }
        }
        if (n == 6) {
            switch (n3) {
                case 2: 
                case 3: {
                    return 2;
                }
                case 4: 
                case 5: {
                    return 3;
                }
                case 6: 
                case 7: 
                case 8: {
                    return 4;
                }
                case 9: 
                case 10: {
                    return 5;
                }
                case 11: 
                case 12: {
                    return 6;
                }
            }
        }
        if (n == 10) {
            switch (n3) {
                case 2: 
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return 6;
                }
                case 9: 
                case 10: {
                    return 8;
                }
                case 11: 
                case 12: {
                    return 10;
                }
            }
        }
        if (n == 15) {
            switch (n3) {
                case 2: 
                case 3: {
                    return 5;
                }
                case 4: {
                    return 6;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return 9;
                }
                case 9: 
                case 10: {
                    return 12;
                }
                case 11: 
                case 12: {
                    return 15;
                }
            }
        }
        if (n == 20) {
            switch (n3) {
                case 2: 
                case 3: {
                    return 6;
                }
                case 4: {
                    return 9;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return 12;
                }
                case 9: 
                case 10: {
                    return 16;
                }
                case 11: 
                case 12: {
                    return 20;
                }
            }
        }
        return 0;
    }

    public static int getConciousnessNumber(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 11;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static boolean isAffectedByECM(Entity entity, Coords coords, Coords coords2) {
        Coords[] coordsArray;
        if (coords == null || coords2 == null) {
            return false;
        }
        Vector<Coords> vector = new Vector<Coords>(16);
        Enumeration enumeration = entity.game.getEntities();
        while (enumeration.hasMoreElements()) {
            coordsArray = (Coords[])enumeration.nextElement();
            if (!coordsArray.isEnemyOf(entity) || !coordsArray.hasActiveECM() || coordsArray.getPosition() == null) continue;
            vector.addElement(coordsArray.getPosition());
        }
        if (vector.size() == 0) {
            return false;
        }
        coordsArray = Compute.intervening(coords, coords2);
        boolean bl = coords.degree(coords2) % 60 == 30;
        Enumeration enumeration2 = vector.elements();
        block1: while (enumeration2.hasMoreElements()) {
            Coords coords3 = (Coords)enumeration2.nextElement();
            int n = -1;
            int n2 = 0;
            while (n2 < coordsArray.length) {
                int n3 = coords3.distance(coordsArray[n2]);
                if (n3 <= 6) {
                    return true;
                }
                if (!bl || n2 % 3 == 0) {
                    if (n == -1) {
                        n = n3;
                    } else if (n3 > n) continue block1;
                }
                ++n2;
            }
        }
        return false;
    }
}

