/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.util;

import java.awt.image.ColorModel;
import java.awt.image.RGBImageFilter;

public class RotateFilter
extends RGBImageFilter {
    private static final int ALPHA_CLIP = 144;
    private double angle;
    private double sin;
    private double cos;
    private int width;
    private int height;
    private double cx;
    private double cy;
    private int[] raster;
    private int count = 0;

    public RotateFilter(double d) {
        this.angle = d;
        this.sin = Math.sin(d);
        this.cos = Math.cos(d);
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.cx = (double)n / 2.0;
        this.cy = (double)n2 / 2.0;
        this.raster = new int[n * n2];
        this.consumer.setDimensions(n, n2);
    }

    public int filterRGB(int n, int n2, int n3) {
        this.raster[n2 * this.width + n] = n3;
        return n3;
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        this.rotate();
        this.consumer.setPixels(0, 0, this.width, this.height, ColorModel.getRGBdefault(), this.raster, 0, this.width);
        this.consumer.imageComplete(n);
    }

    private void rotate() {
        int[] nArray = new int[this.width * this.height];
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                nArray[n * this.width + n2] = this.rotatedPixel(n2, n);
                ++n2;
            }
            ++n;
        }
        this.raster = nArray;
    }

    private final int rotatedPixel(int n, int n2) {
        double d = -(this.cx - (double)n);
        double d2 = -(this.cy - (double)n2);
        double d3 = this.cos * d - this.sin * d2;
        double d4 = this.cos * d2 + this.sin * d;
        return this.pixelBilinear(d3 + this.cx, d4 + this.cy);
    }

    private final int pixel(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return 0;
        }
        return this.raster[n2 * this.width + n];
    }

    private final int alpha(int n) {
        return n >> 24 & 0xFF;
    }

    private final int blue(int n) {
        return n & 0xFF;
    }

    private final int combine(int n, int n2, int n3, int n4) {
        return (n > 144 ? -16777216 : 0) | n2 << 16 | n3 << 8 | n4;
    }

    private int pixelNear(double d, double d2) {
        return this.pixel((int)Math.round(d), (int)Math.round(d2));
    }

    private int pixelBilinear(double d, double d2) {
        int n = (int)Math.floor(d);
        int n2 = (int)Math.floor(d2);
        int n3 = this.alpha(this.pixel(n, n2));
        int n4 = this.alpha(this.pixel(n + 1, n2));
        int n5 = this.alpha(this.pixel(n, n2 + 1));
        int n6 = this.alpha(this.pixel(n + 1, n2 + 1));
        if (n3 == 0 && n4 == 0 && n5 == 0 && n6 == 0) {
            return 0;
        }
        int n7 = this.blue(this.pixel(n, n2));
        int n8 = this.blue(this.pixel(n + 1, n2));
        int n9 = this.blue(this.pixel(n, n2 + 1));
        int n10 = this.blue(this.pixel(n + 1, n2 + 1));
        double d3 = d - (double)n;
        double d4 = d2 - (double)n2;
        double d5 = (1.0 - d3) * (1.0 - d4);
        double d6 = d3 * (1.0 - d4);
        double d7 = (1.0 - d3) * d4;
        double d8 = d3 * d4;
        int n11 = (int)Math.round(d5 * (double)n3 + d6 * (double)n4 + d7 * (double)n5 + d8 * (double)n6);
        int n12 = (int)Math.round(d5 * (double)n7 + d6 * (double)n8 + d7 * (double)n9 + d8 * (double)n10);
        return this.combine(n11, n12, n12, n12);
    }

    private int pixelBicubic(double d, double d2) {
        return 0;
    }
}

