/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Comparable;
import com.sun.java.util.collections.Hashtable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Vector;
import java.util.Enumeration;
import megamek.client.bot.CEntity;
import megamek.client.bot.Compute;
import megamek.client.bot.TestBot;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Game;
import megamek.common.Hex;
import megamek.common.MovementData;
import megamek.common.ToHitData;

public class EntityState
extends MovementData
implements Comparable {
    public static Game game;
    public static TestBot tb;
    public static final int ATTACK_MOD = 0;
    public static final int DEFENCE_MOD = 1;
    public static final int ATTACK_PC = 2;
    public static final int DEFENCE_PC = 3;
    CEntity centity = null;
    Entity entity = null;
    Vector Steps = new Vector();
    int mpUsed = 0;
    Coords curPos = null;
    int curFacing;
    boolean isProne;
    boolean isJumping = false;
    boolean isRunProhibited = false;
    boolean isMovementLegal = true;
    boolean isDanger = false;
    int overallMoveType = 0;
    boolean hasJustStood = false;
    boolean firstStep = true;
    double threat = 0.0;
    boolean inDanger = false;
    boolean Doomed = false;
    double self_threat = 0.0;
    double movement_threat = 0.0;
    double self_damage = 0.0;
    double damage = 0.0;
    double[] threats;
    double[] damages;
    double[] max_threats;
    double[] min_damages;
    int delta_distance = 0;
    int heatBuildup;
    CEntity PhysicalTarget;
    boolean isPhysical = false;
    Vector tv = new Vector();

    public EntityState(EntityState entityState) {
        super(entityState);
        this.Steps = new Vector((Collection)entityState.Steps);
        this.centity = entityState.centity;
        this.entity = entityState.entity;
        this.isProne = entityState.isProne;
        this.mpUsed = entityState.mpUsed;
        this.curPos = new Coords(entityState.curPos);
        this.curFacing = entityState.curFacing;
        this.isJumping = entityState.isJumping;
        this.isRunProhibited = entityState.isRunProhibited;
        this.isMovementLegal = entityState.isMovementLegal;
        this.isDanger = entityState.isDanger;
        this.overallMoveType = entityState.overallMoveType;
        this.hasJustStood = entityState.hasJustStood;
        this.firstStep = entityState.firstStep;
        this.delta_distance = entityState.delta_distance;
        this.heatBuildup = entityState.heatBuildup;
        this.threat = entityState.threat;
        this.damage = entityState.damage;
        this.movement_threat = entityState.movement_threat;
        this.tv = new Vector((Collection)entityState.tv);
        if (entityState.damages != null) {
            this.damages = new double[entityState.damages.length];
            System.arraycopy(entityState.damages, 0, this.damages, 0, entityState.damages.length);
        }
        if (entityState.threats != null) {
            this.threats = new double[entityState.threats.length];
            System.arraycopy(entityState.threats, 0, this.threats, 0, entityState.threats.length);
        }
        if (entityState.min_damages != null) {
            this.min_damages = new double[entityState.threats.length];
            System.arraycopy(entityState.min_damages, 0, this.min_damages, 0, entityState.threats.length);
        }
        if (entityState.max_threats != null) {
            this.max_threats = new double[entityState.max_threats.length];
            System.arraycopy(entityState.max_threats, 0, this.max_threats, 0, entityState.threats.length);
        }
        this.self_threat = entityState.self_threat;
        this.inDanger = entityState.inDanger;
        this.Doomed = entityState.Doomed;
        this.isPhysical = entityState.isPhysical;
        this.PhysicalTarget = entityState.PhysicalTarget;
        this.self_damage = entityState.self_damage;
    }

    public EntityState(CEntity cEntity) {
        this.centity = cEntity;
        this.entity = this.centity.entity;
        this.curPos = new Coords(this.entity.getPosition());
        this.curFacing = this.entity.getFacing();
        this.isProne = this.entity.isProne();
        this.mpUsed = this.entity.mpUsed;
        this.heatBuildup = this.entity.heatBuildup;
    }

    public void addStep(int n) {
        try {
            if (this.firstStep && n == 7) {
                this.overallMoveType = 3;
                this.isJumping = true;
            }
            if (!this.firstStep && n == 7) {
                this.overallMoveType = -1;
            }
            super.addStep(n);
            this.Steps.add((Object)new Integer(n));
            int n2 = this.entity.getId();
            Coords coords = new Coords(this.curPos);
            int n3 = 0;
            switch (n) {
                case 3: 
                case 4: {
                    n3 = this.isJumping || this.hasJustStood ? 0 : 1;
                    this.curFacing = MovementData.getAdjustedFacing(this.curFacing, n);
                    break;
                }
                case 2: {
                    this.isRunProhibited = true;
                }
                case 1: 
                case 8: 
                case 9: {
                    this.curPos = n == 2 ? this.curPos.translated((this.curFacing + 3) % 6) : this.curPos.translated(this.curFacing);
                    if (EntityState.game.board.getHex(this.curPos) == null) {
                        this.overallMoveType = -1;
                        return;
                    }
                    n3 = megamek.common.Compute.getMovementCostFor(game, this.entity.getId(), coords, this.curPos, this.overallMoveType);
                    if (EntityState.game.board.getHex(this.curPos).contains(4)) {
                        this.isRunProhibited = true;
                    }
                    this.hasJustStood = false;
                    break;
                }
                case 5: {
                    n3 = this.entity.getWalkMP() == 1 ? 1 : 2;
                    ++this.heatBuildup;
                    this.hasJustStood = true;
                    this.isProne = false;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            this.isDanger = false;
            boolean bl = false;
            this.mpUsed += n3;
            if (this.overallMoveType == 1 && this.mpUsed > this.entity.getWalkMP()) {
                this.overallMoveType = 2;
                if (!(this.isRunProhibited || this.entity.getDestroyedCriticals(0, 4, 1) <= 0 && this.entity.getDestroyedCriticals(0, 11, 6) <= 0 && this.entity.getDestroyedCriticals(0, 11, 7) <= 0)) {
                    this.isDanger = true;
                    bl = true;
                }
            } else if (this.overallMoveType != 3 && this.overallMoveType != -1) {
                this.overallMoveType = 1;
            }
            int n4 = -1;
            if (this.overallMoveType == 3 && this.mpUsed <= this.entity.getJumpMP() && !this.isProne) {
                n4 = 3;
            }
            if (!(this.overallMoveType != 1 && this.overallMoveType != 2 || this.isProne && n != 3 && n != 4)) {
                if (this.mpUsed <= this.entity.getWalkMP()) {
                    n4 = 1;
                } else if (this.mpUsed <= this.entity.getRunMP() && !this.isRunProhibited) {
                    n4 = 2;
                }
            }
            if (n == 5 && this.entity.getWalkMP() == 1) {
                n4 = 2;
            }
            if (this.firstStep && n4 == -1 && this.entity.getWalkMP() > 0 && !this.entity.isProne() && n == 1) {
                n4 = 2;
            }
            if (!EntityState.isMovementPossible(game, this.entity.getId(), coords, this.curPos, n4, n)) {
                n4 = -1;
            }
            if (n4 == -1 || this.overallMoveType == -1) {
                this.isMovementLegal = false;
            }
            MovementData.Step step = null;
            if (this.length() > 1) {
                step = this.getStep(this.length() - 1);
            }
            boolean bl2 = this.isDanger = megamek.common.Compute.isPilotingSkillNeeded(game, n2, coords, this.curPos, n4, step, this.overallMoveType) || n == 5;
            if (this.isDanger) {
                double d = 1.0;
                if (this.centity.base_psr_odds < 0.1) {
                    n4 = -1;
                } else if (bl) {
                    if (this.centity.base_psr_odds < 0.5) {
                        n4 = -1;
                    } else {
                        d = 5.0;
                    }
                } else {
                    double d2 = d * this.centity.getThreatUtility(0.2 * (double)this.entity.getWeight(), 1) * (1.0 - Math.pow(this.centity.base_psr_odds, 2.0));
                    this.movement_threat += d2;
                    this.tv.add((Object)(d2 + " Movement Threat \n"));
                }
            }
            this.overallMoveType = this.isMovementLegal ? n4 : -1;
            this.firstStep = false;
            this.delta_distance = this.curPos.distance(this.entity.getPosition());
        }
        catch (Exception exception) {
            this.overallMoveType = -1;
        }
    }

    public int getMovementheatBuildup() {
        if (this.overallMoveType == 0) {
            return 0;
        }
        if (this.overallMoveType == 1) {
            return 1;
        }
        if (this.overallMoveType == 2) {
            return 2;
        }
        if (this.overallMoveType == 3) {
            return Math.max(3, this.mpUsed);
        }
        return 1000;
    }

    public int getheatBuildup() {
        return this.getMovementheatBuildup() + this.heatBuildup;
    }

    public boolean changeToPhysical() {
        boolean bl = false;
        if (this.getLastStep() != null && this.getLastStep().getType() == 2) {
            return false;
        }
        if (this.overallMoveType != -1) {
            Enumeration enumeration = game.getEntities();
            while (enumeration.hasMoreElements() && !bl) {
                Entity entity = (Entity)enumeration.nextElement();
                CEntity cEntity = TestBot.enemies.get(entity);
                if (entity.isSelectable() || !this.curPos.equals(entity.getPosition()) || !entity.isEnemyOf(this.entity)) continue;
                bl = true;
                this.PhysicalTarget = cEntity;
            }
        }
        if (bl) {
            this.isPhysical = true;
            this.Steps.remove(this.Steps.size() - 1);
            if (this.overallMoveType == 3) {
                this.Steps.add((Object)new Integer(9));
            } else {
                this.Steps.add((Object)new Integer(8));
            }
            this.curPos = this.curPos.translated((this.curFacing + 3) % 6);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.Steps.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(new MovementData.Step((MovementData)this, (Integer)enumeration.nextElement()));
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public boolean isMoveLegal() {
        this.isMovementLegal = false;
        if (this.overallMoveType != -1) {
            boolean bl = false;
            Enumeration enumeration = game.getEntities();
            while (enumeration.hasMoreElements()) {
                Entity entity = (Entity)enumeration.nextElement();
                CEntity cEntity = TestBot.enemies.get(entity);
                if (!this.curPos.equals(cEntity.old.curPos) || entity.getId() == this.entity.getId()) continue;
                bl = true;
            }
            if (!bl) {
                this.isMovementLegal = true;
            }
        }
        return this.isMovementLegal;
    }

    public boolean isStepLegal() {
        if (!EntityState.game.board.contains(this.curPos)) {
            return false;
        }
        if (this.overallMoveType != 3 && game.getEntity(this.curPos) != null && this.entity.isEnemyOf(game.getEntity(this.curPos))) {
            return false;
        }
        return this.overallMoveType != -1;
    }

    public MovementData.Step getLastStep() {
        int n = this.Steps.size();
        if (n <= 0) {
            return null;
        }
        return new MovementData.Step((MovementData)this, (Integer)this.Steps.elementAt(n - 1));
    }

    public String getKey() {
        if (this.isJumping) {
            return this.curPos.toString();
        }
        return new String(this.curPos.toString() + " " + this.curFacing);
    }

    public void setState() {
        this.entity = this.centity.entity;
        this.entity.setPosition(this.curPos);
        this.entity.setFacing(this.curFacing);
        this.entity.setSecondaryFacing(this.curFacing);
        this.entity.moved = this.overallMoveType;
        this.entity.heatBuildup = this.getheatBuildup();
        this.entity.setProne(this.isProne);
        this.entity.delta_distance = this.delta_distance;
    }

    /*
     * Unable to fully structure code
     */
    public int[] getModifiers(Entity var1_1) {
        block43: {
            var2_2 = this.entity;
            var3_3 = var2_2.isProne() != false ? 0 : 1;
            var4_4 = var1_1.isProne() != false ? 0 : 1;
            var5_5 = 0;
            var6_6 = 0;
            var5_5 = var2_2.elevation() + var3_3;
            var6_6 = var1_1.elevation() + var4_4;
            var7_7 = 0;
            var8_8 = 0;
            var9_9 = megamek.common.Compute.intervening(this.curPos, var1_1.getPosition());
            var10_10 = false;
            var11_11 = false;
            var12_12 = new ToHitData();
            var13_13 = new ToHitData();
            var12_12.append(megamek.common.Compute.getAttackerMovementModifier(EntityState.game, var2_2.getId()));
            var12_12.append(megamek.common.Compute.getTargetMovementModifier(EntityState.game, var1_1.getId()));
            var12_12.append(megamek.common.Compute.getTargetTerrainModifier(EntityState.game, var1_1.getId()));
            var12_12.append(megamek.common.Compute.getAttackerTerrainModifier(EntityState.game, var2_2.getId()));
            var13_13.append(megamek.common.Compute.getAttackerMovementModifier(EntityState.game, var1_1.getId()));
            var13_13.append(megamek.common.Compute.getTargetMovementModifier(EntityState.game, var2_2.getId()));
            if (!this.isPhysical || !this.isJumping) {
                var13_13.append(megamek.common.Compute.getTargetTerrainModifier(EntityState.game, var2_2.getId()));
            }
            var13_13.append(megamek.common.Compute.getAttackerTerrainModifier(EntityState.game, var1_1.getId()));
            var14_14 = EntityState.game.board.getHex(var2_2.getPosition());
            if (var14_14.contains(4) && var14_14.surface() > var5_5) {
                var12_12.addModifier(0x7FFFFFFF, "Attacker in depth 2+ water");
                var13_13.addModifier(0x7FFFFFFF, "Defender in depth 2+ water");
            } else if (var14_14.surface() == var5_5 && var2_2.height() > 0) {
                var11_11 = true;
            }
            var15_15 = EntityState.game.board.getHex(var1_1.getPosition());
            if (var15_15.contains(4)) {
                if (var15_15.surface() == var6_6 && var1_1.height() > 0) {
                    var10_10 = true;
                } else if (var15_15.surface() > var6_6) {
                    var12_12.addModifier(0x7FFFFFFF, "Attacker in depth 2+ water");
                    var13_13.addModifier(0x7FFFFFFF, "Defender in depth 2+ water");
                }
            }
            if ((var16_16 = (double)var2_2.getPosition().degree(var1_1.getPosition())) > 180.0) {
                var16_16 = (var16_16 + 180.0) % 360.0;
            }
            if (var16_16 != 30.0 && var16_16 != 90.0 && var16_16 != 150.0) break block43;
            var18_17 = new Vector();
            var18_17.addElement((Object)var9_9[0]);
            var19_19 = 0;
            var20_22 = 1;
            while (var20_22 < var9_9.length - 2 && var12_12.getValue() != 0x7FFFFFFF) {
                block45: {
                    block48: {
                        block47: {
                            block46: {
                                block44: {
                                    var21_23 = var9_9[var20_22];
                                    var22_24 = var9_9[var20_22 + 1];
                                    var18_17.addElement(var9_9[var20_22 + 2]);
                                    if (EntityState.game.board.contains(var21_23)) break block44;
                                    var18_17.addElement(var22_24);
                                    break block45;
                                }
                                if (EntityState.game.board.contains((Coords)var22_24)) break block46;
                                var18_17.addElement((Object)var21_23);
                                break block45;
                            }
                            var23_25 = EntityState.game.board.getHex(var21_23);
                            var24_26 = var23_25.floor();
                            var25_27 = EntityState.game.board.getHex((Coords)var22_24);
                            var26_28 = var25_27.floor();
                            var27_29 = 0;
                            var28_30 = 0;
                            if (!(var24_26 > var5_5 && var24_26 > var6_6 || var20_22 == 1 && var24_26 > var5_5) && (var20_22 != var9_9.length - 3 || var24_26 <= var6_6)) break block47;
                            var12_12.addModifier(0x7FFFFFFF, "");
                            var13_13.addModifier(0x7FFFFFFF, "");
                            break block45;
                        }
                        if (!(var26_28 > var5_5 && var26_28 > var6_6 || var20_22 == 1 && var26_28 > var5_5) && (var20_22 != var9_9.length - 3 || var26_28 <= var6_6)) break block48;
                        var12_12.addModifier(0x7FFFFFFF, "");
                        var13_13.addModifier(0x7FFFFFFF, "");
                        break block45;
                    }
                    if (var23_25.levelOf(1) > 0 && (var24_26 + 2 > var5_5 && var24_26 + 2 > var6_6 || var20_22 == 1 && var24_26 + 2 > var5_5 || var20_22 == var9_9.length - 3 && var24_26 + 2 > var6_6)) {
                        v0 = var27_29 = var23_25.levelOf(1) == 1 ? 1 : 2;
                    }
                    if (var25_27.levelOf(1) > 0 && (var26_28 + 2 > var5_5 && var26_28 + 2 > var6_6 || var20_22 == 1 && var26_28 + 2 > var5_5 || var20_22 == var9_9.length - 3 && var26_28 + 2 > var6_6)) {
                        v1 = var28_30 = var25_27.levelOf(1) == 1 ? 1 : 2;
                    }
                    if (var20_22 != var9_9.length - 3) ** GOTO lbl-1000
                    if (var28_30 + var19_19 > 2) {
                        var18_17.addElement(var22_24);
                        var12_12.addModifier(0x7FFFFFFF, "");
                        var13_13.addModifier(0x7FFFFFFF, "");
                    } else if (var27_29 + var19_19 > 2) {
                        var18_17.addElement((Object)var21_23);
                        var12_12.addModifier(0x7FFFFFFF, "");
                        var13_13.addModifier(0x7FFFFFFF, "");
                    } else if (var24_26 == var6_6 && var5_5 <= var6_6 && var1_1.height() > 0) {
                        var18_17.addElement((Object)var21_23);
                    } else if (var26_28 == var6_6 && var5_5 <= var6_6 && var1_1.height() > 0) {
                        var18_17.addElement(var22_24);
                    } else if (var28_30 > var27_29) {
                        var18_17.addElement(var22_24);
                        var19_19 += var28_30;
                    } else {
                        var18_17.addElement((Object)var21_23);
                        var19_19 += var27_29;
                    }
                }
                var20_22 += 3;
            }
            var9_9 = new Coords[var18_17.size()];
            var18_17.copyInto(var9_9);
        }
        var18_18 = 0;
        while (var18_18 < var9_9.length && var12_12.getValue() != 0x7FFFFFFF) {
            if (!var9_9[var18_18].equals(this.curPos) && !var9_9[var18_18].equals(var1_1.getPosition()) && (var19_20 = EntityState.game.board.getHex((Coords)var9_9[var18_18])) != null) {
                var20_22 = var19_20.getElevation();
                if (var20_22 > var5_5 && var20_22 > var6_6 || var20_22 > var5_5 && this.curPos.distance((Coords)var9_9[var18_18]) <= 1 || var20_22 > var6_6 && var1_1.getPosition().distance((Coords)var9_9[var18_18]) <= 1) {
                    var12_12.addModifier(0x7FFFFFFF, "Terrain");
                    var13_13.addModifier(0x7FFFFFFF, "Terrain");
                }
                if (var19_20.levelOf(1) > 0 && (var20_22 + 2 > var5_5 && var20_22 + 2 > var6_6 || var20_22 + 2 > var5_5 && var2_2.getPosition().distance((Coords)var9_9[var18_18]) <= 1 || var20_22 + 2 > var6_6 && var1_1.getPosition().distance((Coords)var9_9[var18_18]) <= 1)) {
                    var7_7 += var19_20.levelOf(1) == 1 ? 1 : 0;
                    var8_8 += var19_20.levelOf(1) > 1 ? 1 : 0;
                }
                if (var1_1.getPosition().distance((Coords)var9_9[var18_18]) <= 1 && var20_22 == var6_6 && var5_5 <= var6_6 && var4_4 > 0) {
                    var10_10 = true;
                }
                if (this.curPos.distance((Coords)var9_9[var18_18]) <= 1 && var20_22 == var5_5 && var5_5 >= var6_6 && var3_3 > 0) {
                    var11_11 = true;
                }
            }
            ++var18_18;
        }
        if (var7_7 + var8_8 * 2 >= 3) {
            var12_12.addModifier(0x7FFFFFFF, "Terrain");
            var13_13.addModifier(0x7FFFFFFF, "Terrain");
        }
        if (var10_10) {
            var12_12.addModifier(3, "target has partial cover");
        }
        if (var11_11) {
            var13_13.addModifier(3, "attacker has partial cover");
        }
        if (var7_7 > 0) {
            var12_12.addModifier(var7_7, var7_7 + " light woods intervening");
            var13_13.addModifier(var7_7, var7_7 + " light woods intervening");
        }
        if (var8_8 > 0) {
            var12_12.addModifier(var8_8 * 2, var8_8 + " heavy woods intervening");
            var13_13.addModifier(var8_8 * 2, var8_8 + " heavy woods intervening");
        }
        if (var2_2.getHeatFiringModifier() != 0) {
            var12_12.addModifier(var2_2.getHeatFiringModifier(), "heatBuildup");
        }
        if (var1_1.getHeatFiringModifier() != 0) {
            var13_13.addModifier(var1_1.getHeatFiringModifier(), "heatBuildup");
        }
        if (var1_1.isImmobile()) {
            var12_12.addModifier(-4, "target immobile");
        }
        if (var2_2.isImmobile()) {
            var13_13.addModifier(-4, "target immobile");
        }
        var19_21 = var2_2.getPosition().distance(var1_1.getPosition());
        if (var1_1.isProne()) {
            if (var19_21 == 1) {
                var12_12.addModifier(-2, "target prone and adjacent");
            }
            if (var19_21 > 1) {
                var12_12.addModifier(1, "target prone and at range");
            }
        }
        if (var2_2.isProne()) {
            if (var19_21 == 1) {
                var13_13.addModifier(-2, "target prone and adjacent");
            }
            if (var19_21 > 1) {
                var13_13.addModifier(1, "target prone and at range");
            }
        }
        return new int[]{var12_12.getValue(), var13_13.getValue(), var11_11 != false ? 1 : 0, var10_10 != false ? 1 : 0};
    }

    public MovementData getMovementData() {
        MovementData movementData = new MovementData();
        int n = 0;
        while (n < this.Steps.size()) {
            movementData.addStep((Integer)this.Steps.elementAt(n));
            ++n;
        }
        return movementData;
    }

    public double getUtility() {
        double d = (this.threat + this.movement_threat + this.self_threat + (double)this.getMovementheatBuildup() / 20.0) / this.centity.strategy.attack;
        double d2 = (this.damage + this.self_damage) * this.centity.strategy.attack;
        if (this.threat + this.movement_threat > 4.0 * this.centity.avg_armor) {
            double d3 = (this.threat + this.movement_threat) / (this.centity.avg_armor + 0.25 * this.centity.avg_iarmor);
            if (d3 > 2.0) {
                d += (double)this.centity.bv / 15.0;
                this.Doomed = true;
                this.inDanger = true;
            } else if (d3 > 1.0) {
                d += (double)this.centity.bv / 30.0;
                this.inDanger = true;
            } else {
                d += (double)this.centity.bv / 75.0;
                this.inDanger = true;
            }
        } else if (this.threat + this.movement_threat > 30.0) {
            d += (double)this.centity.entity.getWeight();
        }
        return d - d2;
    }

    public int compareTo(Object object) {
        if (this.getUtility() < ((EntityState)object).getUtility()) {
            return -1;
        }
        if (this.getUtility() == ((EntityState)object).getUtility() && this.damage < ((EntityState)object).damage) {
            return -1;
        }
        return 1;
    }

    public double getMaxModifiedDamage(EntityState entityState, CEntity cEntity, int n, int n2) {
        double d = 0.0;
        int n3 = this.curPos.distance(entityState.curPos);
        double d2 = 1.0;
        if (entityState.isJumping || entityState.entity.heat + entityState.entity.heatBuildup > 4) {
            d2 = cEntity.overheat == 1 ? 0.75 : (cEntity.overheat == 2 ? 0.5 : 0.9);
        }
        int n4 = Compute.getThreatHitArc(this.curPos, this.curFacing, entityState.curPos);
        int[] nArray = new int[3];
        int n5 = 0;
        while (n5 < 3) {
            nArray[n5] = Compute.getThreatHitArc(entityState.curPos, Compute.getAdjustedFacing(entityState.curFacing, n5), this.curPos);
            ++n5;
        }
        d = cEntity.getModifiedDamage(n2 == 1 ? 4 : nArray[0], n3, n);
        d = nArray[1] == 0 ? Math.max(d, cEntity.getModifiedDamage(4, n3, n)) : Math.max(d, cEntity.getModifiedDamage(nArray[1], n3, n));
        d = nArray[2] == 0 ? Math.max(d, cEntity.getModifiedDamage(4, n3, n)) : Math.max(d, cEntity.getModifiedDamage(nArray[2], n3, n));
        d *= d2;
        if (!entityState.isProne && n3 == 1 && nArray[0] != 1) {
            Hex hex = EntityState.game.board.getHex(this.curPos);
            Hex hex2 = EntityState.game.board.getHex(entityState.curPos);
            if (Math.abs(hex.getElevation() - hex2.getElevation()) < 2) {
                d += (double)(hex2.getElevation() - hex.getElevation() == 1 || this.isProne ? 5 : 1) * (nArray[0] == 0 ? 0.2 : 0.05) * (double)cEntity.entity.getWeight() * megamek.common.Compute.oddsAbove(3 + n) / 100.0 + (1.0 - entityState.centity.base_psr_odds) * (double)entityState.entity.getWeight() / 10.0;
            }
        }
        return d;
    }

    public static boolean isMovementPossible(Game game, int n, Coords coords, Coords coords2, int n2, int n3) {
        Entity entity = game.getEntity(n);
        Hex hex = game.board.getHex(coords);
        Hex hex2 = game.board.getHex(coords2);
        if (entity == null) {
            throw new IllegalArgumentException("Entity invalid.");
        }
        if (game.board.getHex(coords2) == null) {
            return false;
        }
        if (game.board.getHex(coords) == null) {
            return false;
        }
        if (coords.distance(coords2) > 1) {
            throw new IllegalArgumentException("Coordinates must be adjacent.");
        }
        if (n2 == -1) {
            return false;
        }
        if (!game.board.contains(coords2)) {
            return false;
        }
        if (n2 != 3 && Math.abs(hex.floor() - hex2.getElevation()) > 2) {
            return false;
        }
        if (n3 == 2 && hex.floor() != hex2.floor()) {
            return false;
        }
        if (n2 == 2 && hex2.levelOf(4) > 0) {
            return false;
        }
        if (n2 == 3 && entity.getPosition().equals(coords) && hex.levelOf(4) > 0) {
            return false;
        }
        return n2 != 3 || hex2.getElevation() <= entity.elevation() + entity.getJumpMP();
    }

    static class Table
    extends Hashtable {
        Table() {
        }

        public void put(EntityState entityState) {
            this.put(entityState.getKey(), entityState);
        }

        public EntityState get(EntityState entityState) {
            return (EntityState)super.get((Object)entityState.getKey());
        }

        public EntityState remove(EntityState entityState) {
            return (EntityState)super.remove((Object)entityState.getKey());
        }

        public EntityState extractMin() {
            Iterator iterator = this.values().iterator();
            EntityState entityState = (EntityState)iterator.next();
            EntityState entityState2 = null;
            while (iterator.hasNext()) {
                entityState2 = (EntityState)iterator.next();
                if (!((double)entityState2.mpUsed + entityState2.movement_threat * 100.0 / (double)entityState2.centity.bv < (double)entityState.mpUsed + entityState.movement_threat * 100.0 / (double)entityState.centity.bv)) continue;
                entityState = entityState2;
            }
            return this.remove(entityState);
        }

        public void update(EntityState entityState) {
            this.remove(entityState);
            this.put(entityState);
        }
    }
}

