/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import java.awt.Frame;
import megamek.client.GameEvent;
import megamek.client.bot.BotClient;
import megamek.common.Packet;
import megamek.common.actions.AttackAction;
import megamek.common.actions.FlipArmsAction;
import megamek.common.actions.TorsoTwistAction;

public abstract class BotClientWrapper
extends BotClient {
    public int winner = 0;

    public BotClientWrapper(Frame frame, String string) {
        super(frame, string);
    }

    public BotClientWrapper(String string) {
        super(string);
    }

    protected void changePhase(int n) {
        super.changePhase(n);
        switch (n) {
            case 1: {
                this.initialize();
                break;
            }
            case 5: {
                if (this.game.getEntitiesOwnedBy(this.getLocalPlayer()) == 0) {
                    this.winner = -1;
                    this.sendChat("How about a nice game of chess?");
                    this.die();
                }
                if (!this.game.getOptions().booleanOption("double_blind") && this.game.getEntitiesOwnedBy(this.getLocalPlayer()) - this.game.getNoOfEntities() == 0) {
                    this.winner = 1;
                    this.die();
                }
                this.initMovement();
                break;
            }
            case 7: {
                this.initFiring();
                break;
            }
            case 9: {
                break;
            }
        }
    }

    protected void processGameEvent(GameEvent gameEvent) {
        super.processGameEvent(gameEvent);
        switch (gameEvent.getType()) {
            case 3: {
                this.processChat(gameEvent);
            }
        }
    }

    public abstract void initialize();

    protected abstract void initMovement();

    protected abstract void initFiring();

    protected abstract void processChat(GameEvent var1);

    protected void receiveAttack(Packet packet) {
        Object object = packet.getObject(0);
        if (object instanceof TorsoTwistAction) {
            TorsoTwistAction torsoTwistAction = (TorsoTwistAction)object;
            if (this.game.getEntity(torsoTwistAction.getEntityId()) != null) {
                this.game.getEntity(torsoTwistAction.getEntityId()).setSecondaryFacing(torsoTwistAction.getFacing());
            }
        } else if (object instanceof FlipArmsAction) {
            FlipArmsAction flipArmsAction = (FlipArmsAction)object;
            if (this.game.getEntity(flipArmsAction.getEntityId()) != null) {
                this.game.getEntity(flipArmsAction.getEntityId()).setArmsFlipped(flipArmsAction.getIsFlipped());
            }
        } else if (object instanceof AttackAction) {
            // empty if block
        }
    }

    public void retrieveServerInfo() {
        super.retrieveServerInfo();
        this.initialize();
    }
}

