/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import java.awt.Button;
import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import megamek.client.Client;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.Mounted;

class SystemPanel
extends Panel
implements ItemListener,
ActionListener {
    private static Object SYSTEM = new Object();
    public Label locLabel;
    public Label slotLabel;
    public List slotList;
    public List locList;
    private Vector vEquipment = new Vector(16);
    public Choice m_chMode;
    public Button m_bDumpAmmo;
    public Label modeLabel;
    private Client client;
    Entity en;

    public SystemPanel(Client client) {
        this.client = client;
        this.locLabel = new Label("Location", 1);
        this.slotLabel = new Label("Slot", 1);
        this.locList = new List(8, false);
        this.locList.addItemListener(this);
        this.slotList = new List(12, false);
        this.slotList.addItemListener(this);
        this.m_chMode = new Choice();
        this.m_chMode.add("   ");
        this.m_chMode.setEnabled(false);
        this.m_chMode.addItemListener(this);
        this.m_bDumpAmmo = new Button("Dump");
        this.m_bDumpAmmo.setEnabled(false);
        this.m_bDumpAmmo.setActionCommand("dump");
        this.m_bDumpAmmo.addActionListener(this);
        this.modeLabel = new Label("Mode", 1);
        this.modeLabel.setEnabled(false);
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.modeLabel, gridBagConstraints);
        panel.add(this.modeLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.m_chMode, gridBagConstraints);
        panel.add(this.m_chMode);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.m_bDumpAmmo, gridBagConstraints);
        panel.add(this.m_bDumpAmmo);
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.locLabel, gridBagConstraints);
        this.add(this.locLabel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.slotLabel, gridBagConstraints);
        this.add(this.slotLabel);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(this.locList, gridBagConstraints);
        this.add(this.locList);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.8;
        gridBagLayout.setConstraints(this.slotList, gridBagConstraints);
        this.add(this.slotList);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
    }

    public int getSelectedLocation() {
        return this.locList.getSelectedIndex();
    }

    public Mounted getSelectedEquipment() {
        int n = this.slotList.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        Object e = this.vEquipment.elementAt(n);
        if (e == SYSTEM) {
            return null;
        }
        return (Mounted)e;
    }

    public void displayMech(Entity entity) {
        this.en = entity;
        this.locList.removeAll();
        int n = 0;
        while (n < entity.locations()) {
            if (entity.getNumberOfCriticals(n) > 0) {
                this.locList.add(entity.getLocationName(n), n);
            }
            ++n;
        }
        this.locList.select(0);
        this.displaySlots();
    }

    public void displaySlots() {
        int n = this.locList.getSelectedIndex();
        this.slotList.removeAll();
        this.vEquipment = new Vector(16);
        int n2 = 0;
        while (n2 < this.en.getNumberOfCriticals(n)) {
            CriticalSlot criticalSlot = this.en.getCritical(n, n2);
            StringBuffer stringBuffer = new StringBuffer(32);
            if (criticalSlot == null) {
                stringBuffer.append("---");
            } else {
                switch (criticalSlot.getType()) {
                    case 0: {
                        stringBuffer.append(criticalSlot.isDestroyed() ? "*" : "").append(Mech.systemNames[criticalSlot.getIndex()]);
                        this.vEquipment.addElement(SYSTEM);
                        break;
                    }
                    case 1: {
                        Mounted mounted = this.en.getEquipment(criticalSlot.getIndex());
                        stringBuffer.append(criticalSlot.isDestroyed() ? "*" : "").append(mounted.getDesc());
                        if (mounted.getType().hasModes()) {
                            stringBuffer.append(" (").append(mounted.curMode()).append(")");
                        }
                        this.vEquipment.addElement(mounted);
                    }
                }
            }
            this.slotList.add(stringBuffer.toString());
            ++n2;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Mounted mounted;
        if (itemEvent.getItemSelectable() == this.locList) {
            this.displaySlots();
        } else if (itemEvent.getItemSelectable() == this.slotList) {
            boolean bl;
            this.m_bDumpAmmo.setEnabled(false);
            this.m_chMode.setEnabled(false);
            this.modeLabel.setEnabled(false);
            Mounted mounted2 = this.getSelectedEquipment();
            boolean bl2 = bl = this.client.getLocalPlayer() == this.en.getOwner();
            if (mounted2 != null && bl && mounted2.getType() instanceof AmmoType && mounted2.getShotsLeft() > 0 && !mounted2.isDumping()) {
                this.m_bDumpAmmo.setEnabled(true);
            } else if (mounted2 != null && bl && mounted2.getType().hasModes()) {
                this.m_chMode.setEnabled(true);
                this.modeLabel.setEnabled(true);
                this.m_chMode.removeAll();
                String[] stringArray = mounted2.getType().getModes();
                int n = 0;
                while (n < stringArray.length) {
                    this.m_chMode.add(stringArray[n]);
                    ++n;
                }
            }
        } else if (itemEvent.getItemSelectable() == this.m_chMode && (mounted = this.getSelectedEquipment()) != null && mounted.getType().hasModes()) {
            int n = mounted.setMode(this.m_chMode.getSelectedItem());
            this.client.sendModeChange(this.en.getId(), this.en.getEquipmentNum(mounted), n);
            if (mounted.getType().hasInstantModeSwitch()) {
                this.client.cb.systemMessage("Switched " + mounted.getName() + " to " + mounted.curMode());
            } else {
                this.client.cb.systemMessage(mounted.getName() + " will switch to " + mounted.pendingMode() + " at end of turn.");
            }
            this.displaySlots();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("dump")) {
            boolean bl;
            boolean bl2;
            Mounted mounted = this.getSelectedEquipment();
            boolean bl3 = bl2 = this.client.getLocalPlayer() == this.en.getOwner();
            if (mounted == null || !bl2 || !(mounted.getType() instanceof AmmoType) || mounted.getShotsLeft() <= 0) {
                return;
            }
            if (mounted.isPendingDump()) {
                bl = false;
                this.client.cb.systemMessage(mounted.getName() + " WON'T be dumped next turn.");
            } else {
                bl = true;
                this.client.cb.systemMessage(mounted.getName() + " will be dumped next turn.");
            }
            mounted.setPendingDump(bl);
            this.client.sendModeChange(this.en.getId(), this.en.getEquipmentNum(mounted), bl ? 1 : 0);
        }
    }
}

