/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import megamek.client.AbstractPhaseDisplay;
import megamek.client.Client;
import megamek.client.GameEvent;
import megamek.client.GameListener;
import megamek.common.BoardEvent;
import megamek.common.BoardListener;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.Mounted;
import megamek.common.ToHitData;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;

public class PhysicalDisplay
extends AbstractPhaseDisplay
implements BoardListener,
GameListener,
ActionListener,
KeyListener,
ComponentListener {
    private static final int NUM_BUTTON_LAYOUTS = 1;
    private Client client;
    private Label labStatus;
    private Container panButtons;
    private Button butPunch;
    private Button butKick;
    private Button butPush;
    private Button butClub;
    private Button butSpace;
    private Button butNext;
    private Button butDone;
    private Button butMore;
    private int buttonLayout;
    private int cen;
    private int ten;
    private Vector attacks;

    public PhysicalDisplay(Client client) {
        this.client = client;
        client.addGameListener(this);
        client.game.board.addBoardListener(this);
        this.attacks = new Vector();
        this.labStatus = new Label("Waiting to begin Physical Attack phase...", 1);
        this.butPunch = new Button("Punch");
        this.butPunch.addActionListener(this);
        this.butPunch.setEnabled(false);
        this.butKick = new Button("Kick");
        this.butKick.addActionListener(this);
        this.butKick.setEnabled(false);
        this.butPush = new Button("Push");
        this.butPush.addActionListener(this);
        this.butPush.setEnabled(false);
        this.butClub = new Button("Club");
        this.butClub.addActionListener(this);
        this.butClub.setEnabled(false);
        this.butSpace = new Button(".");
        this.butSpace.setEnabled(false);
        this.butDone = new Button("Done");
        this.butDone.addActionListener(this);
        this.butDone.setEnabled(false);
        this.butNext = new Button(" Next Unit ");
        this.butNext.addActionListener(this);
        this.butNext.setEnabled(false);
        this.butMore = new Button("More...");
        this.butMore.addActionListener(this);
        this.butMore.setEnabled(false);
        this.panButtons = new Panel();
        this.buttonLayout = 0;
        this.setupButtonPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        this.addBag(client.bv, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.labStatus, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(client.cb.getComponent(), gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        this.addKeyListener(this);
        client.frame.addComponentListener(this);
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        component.addKeyListener(this);
    }

    private void setupButtonPanel() {
        this.panButtons.removeAll();
        this.panButtons.setLayout(new GridLayout(2, 4));
        switch (this.buttonLayout) {
            case 0: {
                this.panButtons.add(this.butPunch);
                this.panButtons.add(this.butKick);
                this.panButtons.add(this.butPush);
                this.panButtons.add(this.butNext);
                this.panButtons.add(this.butClub);
                this.panButtons.add(this.butSpace);
                this.panButtons.add(this.butMore);
                this.panButtons.add(this.butDone);
            }
        }
        this.validate();
    }

    public void selectEntity(int n) {
        if (this.client.game.getEntity(n) == null) {
            System.err.println("PhysicalDisplay: tried to select non-existant entity: " + n);
            System.err.println("PhysicalDisplay: sending ready signal...");
            this.client.sendReady(true);
            return;
        }
        this.cen = n;
        this.target(-1);
        this.client.game.board.highlight(this.ce().getPosition());
        this.client.game.board.select(null);
        this.client.game.board.cursor(null);
        this.client.mechD.displayMech(this.ce());
        this.client.mechD.showPanel("movement");
        this.client.bv.centerOnHex(this.ce().getPosition());
        Mounted mounted = Compute.clubMechHas(this.ce());
        if (mounted == null || mounted.getName().endsWith("Club")) {
            this.butClub.setLabel("Club");
        } else {
            this.butClub.setLabel(mounted.getName());
        }
    }

    private void beginMyTurn() {
        this.ten = -1;
        this.butNext.setEnabled(true);
        this.butDone.setEnabled(true);
        ((Component)this.client.mechW).setVisible(true);
        this.moveMechDisplay();
        this.client.game.board.select(null);
        this.client.game.board.highlight(null);
        this.selectEntity(this.client.getFirstEntityNum());
    }

    private void endMyTurn() {
        this.cen = -1;
        this.ten = -1;
        this.target(-1);
        this.client.game.board.select(null);
        this.client.game.board.highlight(null);
        this.client.game.board.cursor(null);
        ((Component)this.client.mechW).setVisible(false);
        this.client.bv.clearMovementData();
        this.disableButtons();
    }

    private void disableButtons() {
        this.butKick.setEnabled(false);
        this.butPunch.setEnabled(false);
        this.butPush.setEnabled(false);
        this.butClub.setEnabled(false);
        this.butDone.setEnabled(false);
        this.butNext.setEnabled(false);
    }

    private void ready() {
        this.disableButtons();
        this.client.sendAttackData(this.cen, this.attacks);
        this.attacks.removeAllElements();
        this.client.sendEntityReady(this.cen);
        this.client.sendReady(true);
    }

    private void clearattacks() {
        if (this.attacks.size() > 0) {
            this.attacks.removeAllElements();
        }
        this.client.mechD.wPan.displayMech(this.ce());
        this.updateTarget();
    }

    private void punch() {
        ToHitData toHitData = Compute.toHitPunch(this.client.game, this.cen, this.ten, 1);
        ToHitData toHitData2 = Compute.toHitPunch(this.client.game, this.cen, this.ten, 2);
        if (this.client.doYesNoDialog("Punch " + this.client.game.getEntity(this.ten).getDisplayName() + "?", "To Hit [RA]: " + toHitData2.getValueAsString() + " (" + Compute.oddsAbove(toHitData2.getValue()) + "%)   (" + toHitData2.getDesc() + ")" + "\nDamage [RA]: " + Compute.getPunchDamageFor(this.ce(), 2) + toHitData2.getTableDesc() + "\n   and/or" + "\nTo Hit [LA]: " + toHitData.getValueAsString() + " (" + Compute.oddsAbove(toHitData.getValue()) + "%)   (" + toHitData.getDesc() + ")" + "\nDamage [LA]: " + Compute.getPunchDamageFor(this.ce(), 1) + toHitData.getTableDesc())) {
            this.disableButtons();
            if (toHitData.getValue() != Integer.MAX_VALUE && toHitData2.getValue() != Integer.MAX_VALUE) {
                this.attacks.addElement(new PunchAttackAction(this.cen, this.ten, 0));
            } else if (toHitData.getValue() < toHitData2.getValue()) {
                this.attacks.addElement(new PunchAttackAction(this.cen, this.ten, 1));
            } else {
                this.attacks.addElement(new PunchAttackAction(this.cen, this.ten, 2));
            }
            this.ready();
        }
    }

    private void kick() {
        int n;
        ToHitData toHitData;
        ToHitData toHitData2 = Compute.toHitKick(this.client.game, this.cen, this.ten, 1);
        ToHitData toHitData3 = Compute.toHitKick(this.client.game, this.cen, this.ten, 2);
        if (toHitData2.getValue() < toHitData3.getValue()) {
            toHitData = toHitData2;
            n = 1;
        } else {
            toHitData = toHitData3;
            n = 2;
        }
        if (this.client.doYesNoDialog("Kick " + this.client.game.getEntity(this.ten).getDisplayName() + "?", "To Hit: " + toHitData.getValueAsString() + " (" + Compute.oddsAbove(toHitData.getValue()) + "%)   (" + toHitData.getDesc() + ")" + "\nDamage: " + Compute.getKickDamageFor(this.ce(), n) + toHitData.getTableDesc())) {
            this.disableButtons();
            this.attacks.addElement(new KickAttackAction(this.cen, this.ten, n));
            this.ready();
        }
    }

    private void push() {
        ToHitData toHitData = Compute.toHitPush(this.client.game, this.cen, this.ten);
        if (this.client.doYesNoDialog("Push " + this.client.game.getEntity(this.ten).getDisplayName() + "?", "To Hit: " + toHitData.getValueAsString() + " (" + Compute.oddsAbove(toHitData.getValue()) + "%)   (" + toHitData.getDesc() + ")")) {
            this.disableButtons();
            this.attacks.addElement(new PushAttackAction(this.cen, this.ten, this.te().getPosition()));
            this.ready();
        }
    }

    private void club() {
        Mounted mounted = Compute.clubMechHas(this.ce());
        ToHitData toHitData = Compute.toHitClub(this.client.game, new ClubAttackAction(this.cen, this.ten, mounted));
        if (this.client.doYesNoDialog("Club " + this.client.game.getEntity(this.ten).getDisplayName() + "?", "To Hit: " + toHitData.getValueAsString() + " (" + Compute.oddsAbove(toHitData.getValue()) + "%)   (" + toHitData.getDesc() + ")" + "\nDamage: " + Compute.getClubDamageFor(this.ce(), mounted) + toHitData.getTableDesc())) {
            this.disableButtons();
            this.attacks.addElement(new ClubAttackAction(this.cen, this.ten, mounted));
            this.ready();
        }
    }

    void target(int n) {
        this.ten = n;
        this.updateTarget();
    }

    private void updateTarget() {
        if (this.cen != -1 && this.ten != -1) {
            ToHitData toHitData = Compute.toHitPunch(this.client.game, this.cen, this.ten, 1);
            ToHitData toHitData2 = Compute.toHitPunch(this.client.game, this.cen, this.ten, 2);
            boolean bl = toHitData.getValue() != Integer.MAX_VALUE || toHitData2.getValue() != Integer.MAX_VALUE;
            this.butPunch.setEnabled(bl);
            ToHitData toHitData3 = Compute.toHitKick(this.client.game, this.cen, this.ten, 1);
            ToHitData toHitData4 = Compute.toHitKick(this.client.game, this.cen, this.ten, 2);
            boolean bl2 = toHitData3.getValue() != Integer.MAX_VALUE || toHitData4.getValue() != Integer.MAX_VALUE;
            this.butKick.setEnabled(bl2);
            ToHitData toHitData5 = Compute.toHitPush(this.client.game, this.cen, this.ten);
            this.butPush.setEnabled(toHitData5.getValue() != Integer.MAX_VALUE);
            Mounted mounted = Compute.clubMechHas(this.ce());
            if (mounted != null) {
                ToHitData toHitData6 = Compute.toHitClub(this.client.game, this.cen, this.ten, mounted);
                this.butClub.setEnabled(toHitData6.getValue() != Integer.MAX_VALUE);
            } else {
                this.butClub.setEnabled(false);
            }
        } else {
            this.butPunch.setEnabled(false);
            this.butPush.setEnabled(false);
            this.butKick.setEnabled(false);
            this.butClub.setEnabled(false);
        }
    }

    private Entity ce() {
        return this.client.game.getEntity(this.cen);
    }

    private Entity te() {
        return this.client.game.getEntity(this.ten);
    }

    private void moveMechDisplay() {
        if (this.client.bv.isShowing()) {
            ((Component)this.client.mechW).setLocation(this.client.bv.getLocationOnScreen().x + this.client.bv.getSize().width - this.client.mechD.getSize().width - 20, this.client.bv.getLocationOnScreen().y + 20);
        }
    }

    public void boardHexMoused(BoardEvent boardEvent) {
        if (this.client.isMyTurn() && (boardEvent.getModifiers() & 0x10) != 0) {
            if (boardEvent.getType() == 2) {
                if (!boardEvent.getCoords().equals(this.client.game.board.lastCursor)) {
                    this.client.game.board.cursor(boardEvent.getCoords());
                }
            } else if (boardEvent.getType() == 0) {
                this.client.game.board.select(boardEvent.getCoords());
            }
        }
    }

    public void boardHexSelected(BoardEvent boardEvent) {
        if (this.client.isMyTurn() && boardEvent.getCoords() != null && this.ce() != null) {
            if (this.client.game.getEntity(boardEvent.getCoords()) != null && this.client.game.getEntity(boardEvent.getCoords()).isTargetable() && !boardEvent.getCoords().equals(this.ce().getPosition())) {
                this.target(this.client.game.getEntity(boardEvent.getCoords()).getId());
            } else {
                this.target(-1);
            }
        }
    }

    public void gameTurnChange(GameEvent gameEvent) {
        if (this.client.game.phase == 9) {
            this.endMyTurn();
            if (this.client.isMyTurn()) {
                this.beginMyTurn();
                this.labStatus.setText("It's your turn to declare physical attacks.");
            } else {
                this.labStatus.setText("It's " + gameEvent.getPlayer().getName() + "'s turn to declare physical attacks.");
            }
        } else {
            System.err.println("PhysicalDisplay: got turnchange event when it's not the physical attacks phase");
        }
    }

    public void gamePhaseChange(GameEvent gameEvent) {
        if (this.client.isMyTurn() && this.client.game.phase != 9) {
            this.endMyTurn();
        }
        if (this.client.game.phase != 9) {
            this.client.bv.clearAllAttacks();
            this.client.removeGameListener(this);
            this.client.game.board.removeBoardListener(this);
            this.client.frame.removeComponentListener(this);
            this.client.bv.removeKeyListener(this);
            this.client.cb.getComponent().removeKeyListener(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.client.isMyTurn()) {
            return;
        }
        if (actionEvent.getSource() == this.butDone) {
            this.ready();
        } else if (actionEvent.getSource() == this.butPunch) {
            this.punch();
        } else if (actionEvent.getSource() == this.butKick) {
            this.kick();
        } else if (actionEvent.getSource() == this.butPush) {
            this.push();
        } else if (actionEvent.getSource() == this.butClub) {
            this.club();
        } else if (actionEvent.getSource() == this.butNext) {
            this.selectEntity(this.client.getNextEntityNum(this.cen));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.clearattacks();
        } else if (keyEvent.getKeyCode() != 10 || !keyEvent.isControlDown() || this.client.isMyTurn()) {
            // empty if block
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
        ((Component)this.client.mechW).setVisible(false);
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.moveMechDisplay();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.moveMechDisplay();
    }

    public void componentShown(ComponentEvent componentEvent) {
        ((Component)this.client.mechW).setVisible(false);
        this.moveMechDisplay();
    }
}

