/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import megamek.client.AbstractPhaseDisplay;
import megamek.client.Client;
import megamek.client.GameEvent;
import megamek.client.GameListener;
import megamek.common.BoardEvent;
import megamek.common.BoardListener;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.MovementData;
import megamek.common.ToHitData;

public class MovementDisplay
extends AbstractPhaseDisplay
implements BoardListener,
ActionListener,
KeyListener,
ComponentListener,
MouseListener,
GameListener {
    private static final int NUM_BUTTON_LAYOUTS = 2;
    public Client client;
    private Label statusL;
    private Panel panButtons;
    private Button butWalk;
    private Button butJump;
    private Button butBackup;
    private Button butTurn;
    private Button butUp;
    private Button butDown;
    private Button butCharge;
    private Button butDfa;
    private Button butFlee;
    private Button butRAC;
    private Button butSpace;
    private Button butNext;
    private Button butDone;
    private Button butMore;
    private int buttonLayout;
    private int cen;
    private MovementData md;
    private MovementData cmd;
    private int gear;
    private boolean mouseheld;
    private boolean shiftheld;
    private int turnInfMoved = 0;

    public MovementDisplay(Client client) {
        this.client = client;
        client.addGameListener(this);
        this.gear = 0;
        this.shiftheld = false;
        client.game.board.addBoardListener(this);
        this.statusL = new Label("Waiting to begin Movement phase...", 1);
        this.butWalk = new Button("Walk");
        this.butWalk.addActionListener(this);
        this.butWalk.setEnabled(false);
        this.butJump = new Button("Jump");
        this.butJump.addActionListener(this);
        this.butJump.setEnabled(false);
        this.butBackup = new Button("Back Up");
        this.butBackup.addActionListener(this);
        this.butBackup.setEnabled(false);
        this.butTurn = new Button("Turn");
        this.butTurn.addActionListener(this);
        this.butTurn.setEnabled(false);
        this.butUp = new Button("Get Up");
        this.butUp.addActionListener(this);
        this.butUp.setEnabled(false);
        this.butDown = new Button("Go Prone");
        this.butDown.addActionListener(this);
        this.butDown.setEnabled(false);
        this.butCharge = new Button("Charge");
        this.butCharge.addActionListener(this);
        this.butCharge.setEnabled(false);
        this.butDfa = new Button("D.F.A.");
        this.butDfa.addActionListener(this);
        this.butDfa.setEnabled(false);
        this.butFlee = new Button("Flee");
        this.butFlee.addActionListener(this);
        this.butFlee.setEnabled(false);
        this.butRAC = new Button(".");
        this.butRAC.addActionListener(this);
        this.butRAC.setEnabled(false);
        this.butMore = new Button("More...");
        this.butMore.addActionListener(this);
        this.butMore.setEnabled(false);
        this.butNext = new Button(" Next Unit ");
        this.butNext.addActionListener(this);
        this.butNext.setEnabled(false);
        this.butDone = new Button("Move");
        this.butDone.addActionListener(this);
        this.butDone.setEnabled(false);
        this.panButtons = new Panel();
        this.buttonLayout = 0;
        this.setupButtonPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        this.addBag(client.bv, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.statusL, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(client.cb.getComponent(), gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        this.addKeyListener(this);
        client.mechD.addMouseListener(this);
        client.frame.addComponentListener(this);
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        component.addKeyListener(this);
    }

    private void setupButtonPanel() {
        this.panButtons.removeAll();
        this.panButtons.setLayout(new GridLayout(2, 4));
        switch (this.buttonLayout) {
            case 0: {
                this.panButtons.add(this.butWalk);
                this.panButtons.add(this.butJump);
                this.panButtons.add(this.butBackup);
                this.panButtons.add(this.butNext);
                this.panButtons.add(this.butTurn);
                this.panButtons.add(this.butRAC);
                this.panButtons.add(this.butMore);
                this.panButtons.add(this.butDone);
                break;
            }
            case 1: {
                this.panButtons.add(this.butUp);
                this.panButtons.add(this.butCharge);
                this.panButtons.add(this.butDfa);
                this.panButtons.add(this.butNext);
                this.panButtons.add(this.butDown);
                this.panButtons.add(this.butFlee);
                this.panButtons.add(this.butMore);
                this.panButtons.add(this.butDone);
                if (this.ce() instanceof Infantry) {
                    this.butDfa.setEnabled(false);
                    this.butCharge.setEnabled(false);
                } else {
                    this.butDfa.setEnabled(true);
                    this.butCharge.setEnabled(true);
                }
                this.UpdateRACButton();
            }
        }
        this.validate();
    }

    public void selectEntity(int n) {
        boolean bl = this.client.game.getOptions().booleanOption("inf_move_last");
        boolean bl2 = this.client.game.getOptions().booleanOption("inf_move_multi");
        if (this.client.game.getEntity(n) == null) {
            System.err.println("MovementDisplay: tried to select non-existant entity: " + n);
            System.err.println("MovementDisplay: sending ready signal...");
            this.client.sendReady(true);
            return;
        }
        this.cen = n;
        boolean bl3 = this.ce() instanceof Infantry;
        if (bl3 && bl && this.turnInfMoved == 0) {
            int n2 = this.client.getNextEntityNum(n);
            while (n2 != n) {
                if (!(this.client.game.getEntity(n2) instanceof Infantry)) {
                    this.cen = n2;
                    bl3 = false;
                    break;
                }
                n2 = this.client.getNextEntityNum(n2);
            }
        } else if (!bl3 && bl2 && this.turnInfMoved % 3 > 0) {
            int n3 = this.client.getNextEntityNum(n);
            while (n3 != n) {
                if (this.client.game.getEntity(n3) instanceof Infantry) {
                    this.cen = n3;
                    bl3 = true;
                    break;
                }
                n3 = this.client.getNextEntityNum(n3);
            }
            if (!bl3) {
                this.turnInfMoved = 0;
            }
        }
        this.md = new MovementData();
        this.cmd = new MovementData();
        this.gear = 0;
        this.butWalk.setEnabled(this.ce().getWalkMP() > 0);
        this.butJump.setEnabled(this.ce().getJumpMP() > 0);
        this.butBackup.setEnabled(this.ce().getWalkMP() > 0);
        if (bl3) {
            this.butCharge.setEnabled(false);
            this.butDfa.setEnabled(false);
        } else {
            this.butCharge.setEnabled(this.ce().getWalkMP() > 0);
            this.butDfa.setEnabled(this.ce().getJumpMP() > 0);
        }
        this.butTurn.setEnabled(this.ce().getWalkMP() > 0 || this.ce().getJumpMP() > 0);
        if (this.ce().isProne()) {
            this.butUp.setEnabled(true);
        } else {
            this.butDown.setEnabled(false);
        }
        this.UpdateRACButton();
        this.butFlee.setEnabled(Compute.canEntityFlee(this.client.game, this.cen));
        this.client.game.board.highlight(this.ce().getPosition());
        this.client.game.board.select(null);
        this.client.game.board.cursor(null);
        this.client.mechD.displayEntity(this.ce());
        this.client.mechD.showPanel("movement");
        this.client.bv.centerOnHex(this.ce().getPosition());
    }

    private void beginMyTurn() {
        this.butDone.setLabel("Done");
        this.butDone.setEnabled(true);
        this.butNext.setEnabled(true);
        this.butMore.setEnabled(true);
        this.moveMechDisplay();
        ((Component)this.client.mechW).setVisible(true);
        this.moveMechDisplay();
        this.selectEntity(this.client.getFirstEntityNum());
    }

    private void endMyTurn() {
        this.disableButtons();
        this.cen = -1;
        this.client.game.board.select(null);
        this.client.game.board.highlight(null);
        this.client.game.board.cursor(null);
        ((Component)this.client.mechW).setVisible(false);
        this.client.bv.clearMovementData();
    }

    private void disableButtons() {
        this.butWalk.setEnabled(false);
        this.butJump.setEnabled(false);
        this.butBackup.setEnabled(false);
        this.butTurn.setEnabled(false);
        this.butFlee.setEnabled(false);
        this.butRAC.setEnabled(false);
        this.butUp.setEnabled(false);
        this.butDown.setEnabled(false);
        this.butCharge.setEnabled(false);
        this.butDfa.setEnabled(false);
        this.butNext.setEnabled(false);
        this.butMore.setEnabled(false);
        this.butDone.setEnabled(false);
    }

    private void clearAllMoves() {
        this.client.game.board.select(null);
        this.client.game.board.cursor(null);
        this.md = new MovementData();
        this.cmd = new MovementData();
        this.client.bv.clearMovementData();
        this.butDone.setLabel("Done");
        this.UpdateRACButton();
    }

    private void moveTo(MovementData movementData) {
        this.disableButtons();
        this.client.bv.clearMovementData();
        this.client.moveEntity(this.cen, movementData);
        if (this.ce() instanceof Infantry) {
            ++this.turnInfMoved;
        }
        this.client.sendReady(true);
    }

    private Entity ce() {
        return this.client.game.getEntity(this.cen);
    }

    private MovementData currentMove(Coords coords, int n, Coords coords2) {
        if (this.shiftheld || this.gear == 5) {
            return Compute.rotatePathfinder(n, coords.direction(coords2));
        }
        if (this.gear == 0 || this.gear == 2) {
            return Compute.lazyPathfinder(coords, n, coords2);
        }
        if (this.gear == 1) {
            return Compute.backwardsLazyPathfinder(coords, n, coords2);
        }
        if (this.gear == 3) {
            return Compute.chargeLazyPathfinder(coords, n, coords2);
        }
        if (this.gear == 4) {
            return Compute.dfaLazyPathfinder(coords, n, coords2);
        }
        return null;
    }

    private void moveMechDisplay() {
        if (!this.client.bv.isShowing()) {
            return;
        }
        ((Component)this.client.mechW).setLocation(this.client.bv.getLocationOnScreen().x + this.client.bv.getSize().width - this.client.mechD.getSize().width - 20, this.client.bv.getLocationOnScreen().y + 20);
    }

    public void boardHexMoused(BoardEvent boardEvent) {
        if (!this.client.isMyTurn() || (boardEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if (this.shiftheld != ((boardEvent.getModifiers() & 1) != 0)) {
            boolean bl = this.shiftheld = (boardEvent.getModifiers() & 1) != 0;
        }
        if (boardEvent.getType() == 2) {
            if (!boardEvent.getCoords().equals(this.client.game.board.lastCursor) || this.shiftheld || this.gear == 5) {
                this.client.game.board.cursor(boardEvent.getCoords());
                this.cmd = this.md.getAppended(this.currentMove(this.md.getFinalCoords(this.ce().getPosition(), this.ce().getFacing()), this.md.getFinalFacing(this.ce().getFacing()), boardEvent.getCoords()));
                this.client.bv.drawMovementData(this.ce(), this.cmd);
            }
        } else if (boardEvent.getType() == 0) {
            Entity entity = this.client.game.getFirstEntity(boardEvent.getCoords());
            Coords coords = boardEvent.getCoords();
            this.client.bv.drawMovementData(this.ce(), this.cmd);
            this.md = new MovementData(this.cmd);
            this.client.game.board.select(boardEvent.getCoords());
            if (this.shiftheld || this.gear == 5) {
                this.butDone.setLabel("Move");
                return;
            }
            if (this.gear == 3) {
                if (entity == null || entity.equals(this.ce())) {
                    this.client.doAlertDialog("Can't perform charge", "No target!");
                    this.clearAllMoves();
                    this.gear = 0;
                    return;
                }
                ToHitData toHitData = Compute.toHitCharge(this.client.game, this.cen, entity.getId(), this.md);
                if (toHitData.getValue() != Integer.MAX_VALUE) {
                    if (this.client.doYesNoDialog("Charge " + entity.getDisplayName() + "?", "To Hit: " + toHitData.getValueAsString() + " (" + Compute.oddsAbove(toHitData.getValue()) + "%)   (" + toHitData.getDesc() + ")" + "\nDamage to Target: " + Compute.getChargeDamageFor(this.ce(), this.md.getHexesMoved()) + " (in 5pt clusters)" + toHitData.getTableDesc() + "\nDamage to Self: " + Compute.getChargeDamageTakenBy(this.ce(), entity) + " (in 5pt clusters)")) {
                        this.moveTo(this.md);
                    } else {
                        this.clearAllMoves();
                    }
                    return;
                }
                this.client.doAlertDialog("Can't perform charge", toHitData.getDesc());
                this.clearAllMoves();
                this.gear = 0;
                return;
            }
            if (this.gear == 4) {
                if (entity == null || entity.equals(this.ce())) {
                    this.client.doAlertDialog("Can't perform D.F.A.", "No target!");
                    this.clearAllMoves();
                    this.gear = 0;
                    return;
                }
                ToHitData toHitData = Compute.toHitDfa(this.client.game, this.cen, entity.getId(), this.md);
                if (toHitData.getValue() != Integer.MAX_VALUE) {
                    if (this.client.doYesNoDialog("D.F.A. " + entity.getDisplayName() + "?", "To Hit: " + toHitData.getValueAsString() + " (" + Compute.oddsAbove(toHitData.getValue()) + "%)   (" + toHitData.getDesc() + ")" + "\nDamage to Target: " + Compute.getDfaDamageFor(this.ce()) + " (in 5pt clusters)" + toHitData.getTableDesc() + "\nDamage to Self: " + Compute.getDfaDamageTakenBy(this.ce()) + " (in 5pt clusters) (using Kick table)")) {
                        this.moveTo(this.md);
                    } else {
                        this.clearAllMoves();
                    }
                    return;
                }
                this.client.doAlertDialog("Can't perform D.F.A.", toHitData.getDesc());
                this.clearAllMoves();
                this.gear = 0;
                return;
            }
            this.butDone.setLabel("Move");
            this.UpdateRACButton();
        }
    }

    private void UpdateRACButton() {
        this.butRAC.setEnabled(this.ce().canUnjamRAC() && (this.gear == 0 || this.gear == 5 || this.gear == 1) && this.md.getMpUsed() <= this.ce().getWalkMP());
        this.butRAC.setLabel(this.ce().hasRAC() ? "Unjam RAC" : ".");
    }

    public void gameTurnChange(GameEvent gameEvent) {
        if (this.client.game.phase != 5) {
            return;
        }
        this.endMyTurn();
        if (this.client.isMyTurn()) {
            this.beginMyTurn();
            this.statusL.setText("It's your turn to move.");
        } else {
            this.statusL.setText("It's " + gameEvent.getPlayer().getName() + "'s turn to move.");
        }
    }

    public void gamePhaseChange(GameEvent gameEvent) {
        if (this.client.isMyTurn() && this.client.game.phase != 5) {
            this.endMyTurn();
        }
        if (this.client.game.phase != 5) {
            this.client.removeGameListener(this);
            this.client.game.board.removeBoardListener(this);
            this.client.bv.removeKeyListener(this);
            this.client.cb.getComponent().removeKeyListener(this);
            this.client.mechD.removeMouseListener(this);
            this.client.frame.removeComponentListener(this);
            this.turnInfMoved = 0;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.client.isMyTurn()) {
            return;
        }
        if (actionEvent.getSource() == this.butDone) {
            this.moveTo(this.md);
        } else if (actionEvent.getSource() == this.butNext) {
            this.clearAllMoves();
            this.selectEntity(this.client.getNextEntityNum(this.cen));
        } else if (actionEvent.getSource() == this.butMore) {
            ++this.buttonLayout;
            this.buttonLayout %= 2;
            this.setupButtonPanel();
        } else if (actionEvent.getSource() == this.butRAC) {
            if (this.gear == 2 || this.gear == 3 || this.gear == 4 || this.md.getMpUsed() > this.ce().getWalkMP()) {
                this.butRAC.setEnabled(false);
            } else {
                this.md.addStep(15);
                this.moveTo(this.md);
            }
        } else if (actionEvent.getSource() == this.butWalk) {
            if (this.gear == 2) {
                this.clearAllMoves();
            }
            this.gear = 0;
        } else if (actionEvent.getSource() == this.butJump) {
            if (this.gear != 2) {
                this.clearAllMoves();
            }
            if (!this.md.contains(7)) {
                this.md.addStep(7);
            }
            this.gear = 2;
        } else if (actionEvent.getSource() == this.butTurn) {
            this.gear = 5;
        } else if (actionEvent.getSource() == this.butBackup) {
            if (this.gear == 2) {
                this.clearAllMoves();
            }
            this.gear = 1;
        } else if (actionEvent.getSource() == this.butCharge) {
            if (this.gear != 0) {
                this.clearAllMoves();
            }
            this.gear = 3;
        } else if (actionEvent.getSource() == this.butDfa) {
            if (this.gear != 2) {
                this.clearAllMoves();
            }
            this.gear = 4;
            if (!this.md.contains(7)) {
                this.md.addStep(7);
            }
        } else if (actionEvent.getSource() == this.butUp) {
            this.clearAllMoves();
            this.gear = 0;
            if (!this.md.contains(5)) {
                this.md.addStep(5);
            }
            this.client.bv.drawMovementData(this.ce(), this.cmd);
            this.butDone.setLabel("Move");
        } else if (actionEvent.getSource() == this.butFlee && this.client.doYesNoDialog("Escape?", "Do you want to flee?")) {
            this.clearAllMoves();
            this.md.addStep(10);
            this.moveTo(this.md);
        }
        this.UpdateRACButton();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.clearAllMoves();
        }
        if (keyEvent.getKeyCode() == 10 && keyEvent.isControlDown() && this.client.isMyTurn()) {
            this.moveTo(this.cmd);
        }
        if (keyEvent.getKeyCode() == 16 && !this.shiftheld) {
            this.shiftheld = true;
            if (this.client.isMyTurn() && this.client.game.board.lastCursor != null && !this.client.game.board.lastCursor.equals(this.client.game.board.selected)) {
                this.cmd = this.md.getAppended(this.currentMove(this.md.getFinalCoords(this.ce().getPosition(), this.ce().getFacing()), this.md.getFinalFacing(this.ce().getFacing()), this.client.game.board.lastCursor));
                this.client.bv.drawMovementData(this.ce(), this.cmd);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16 && this.shiftheld) {
            this.shiftheld = false;
            if (this.client.isMyTurn() && this.client.game.board.lastCursor != null && !this.client.game.board.lastCursor.equals(this.client.game.board.selected)) {
                this.client.bv.clearMovementData();
                this.cmd = this.md.getAppended(this.currentMove(this.md.getFinalCoords(this.ce().getPosition(), this.ce().getFacing()), this.md.getFinalFacing(this.ce().getFacing()), this.client.game.board.lastCursor));
                this.client.bv.drawMovementData(this.ce(), this.cmd);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
        ((Component)this.client.mechW).setVisible(false);
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.moveMechDisplay();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.moveMechDisplay();
    }

    public void componentShown(ComponentEvent componentEvent) {
        ((Component)this.client.mechW).setVisible(false);
        this.moveMechDisplay();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

