/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import megamek.common.Hex;
import megamek.common.Terrain;

public class HexTileset {
    ArrayList bases = new ArrayList();
    ArrayList supers = new ArrayList();
    Image clear;
    Image woods;

    public void assignMatch(Hex hex, Component component) {
        Hex hex2 = (Hex)hex.clone();
        hex.setSupers(this.supersFor(hex2, component));
        hex.setBase(this.baseFor(hex2, component));
    }

    private List supersFor(Hex hex, Component component) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.supers.iterator();
        while (iterator.hasNext()) {
            HexEntry hexEntry = (HexEntry)iterator.next();
            if (!(this.superMatch(hex, hexEntry.getHex()) >= 1.0)) continue;
            arrayList.add((Object)hexEntry.getImage(component));
            int n = 0;
            while (n < Terrain.SIZE) {
                if (hexEntry.getHex().contains(n)) {
                    hex.removeTerrain(n);
                }
                ++n;
            }
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    private Image baseFor(Hex hex, Component component) {
        HexEntry hexEntry = null;
        double d = -1.0;
        Iterator iterator = this.bases.iterator();
        while (iterator.hasNext()) {
            HexEntry hexEntry2 = (HexEntry)iterator.next();
            double d2 = this.baseMatch(hex, hexEntry2.getHex());
            if (d2 == 1.0) {
                hexEntry = hexEntry2;
                break;
            }
            if (!(d2 > d)) continue;
            hexEntry = hexEntry2;
            d = d2;
        }
        return hexEntry.getImage(component);
    }

    public void loadFromFile(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("data/hexes/" + string));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.commentChar(35);
            streamTokenizer.quoteChar(34);
            streamTokenizer.wordChars(95, 95);
            while (streamTokenizer.nextToken() != -1) {
                int n = 0;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equals("base") && !streamTokenizer.sval.equals("super")) continue;
                boolean bl = streamTokenizer.sval.equals("base");
                n = streamTokenizer.nextToken() == -2 ? (int)streamTokenizer.nval : Integer.MAX_VALUE;
                streamTokenizer.nextToken();
                string2 = streamTokenizer.sval;
                streamTokenizer.nextToken();
                string3 = streamTokenizer.sval;
                streamTokenizer.nextToken();
                string4 = streamTokenizer.sval;
                if (bl) {
                    this.bases.add((Object)new HexEntry(new Hex(n, string2, string3), string4));
                    continue;
                }
                this.supers.add((Object)new HexEntry(new Hex(n, string2, string3), string4));
            }
            ((Reader)bufferedReader).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("hexTileset: loaded " + this.bases.size() + " base images");
        System.out.println("hexTileset: loaded " + this.supers.size() + " super images");
    }

    public void loadAllImages(Component component, MediaTracker mediaTracker) {
        Object object;
        Iterator iterator = this.bases.iterator();
        while (iterator.hasNext()) {
            object = (HexEntry)iterator.next();
            if (((HexEntry)object).getImage() == null) {
                ((HexEntry)object).loadImage(component);
            }
            mediaTracker.addImage(((HexEntry)object).getImage(), 1);
        }
        object = this.supers.iterator();
        while (object.hasNext()) {
            HexEntry hexEntry = (HexEntry)object.next();
            if (hexEntry.getImage() == null) {
                hexEntry.loadImage(component);
            }
            mediaTracker.addImage(hexEntry.getImage(), 1);
        }
    }

    private double superMatch(Hex hex, Hex hex2) {
        if (hex2.getElevation() != Integer.MAX_VALUE && hex.getElevation() != hex2.getElevation()) {
            return 0.0;
        }
        int n = 0;
        while (n < Terrain.SIZE) {
            Terrain terrain = hex2.getTerrain(n);
            Terrain terrain2 = hex.getTerrain(n);
            if (terrain != null && (terrain2 == null || terrain.getLevel() != Integer.MAX_VALUE && terrain2.getLevel() != terrain.getLevel() || terrain.hasExitsSpecified() && terrain2.getExits() != terrain.getExits())) {
                return 0.0;
            }
            ++n;
        }
        if (hex2.getTheme() != hex.getTheme() && !hex2.getTheme().equals(hex.getTheme())) {
            return 0.0;
        }
        return 1.0;
    }

    private double baseMatch(Hex hex, Hex hex2) {
        double d = hex2.getElevation() == Integer.MAX_VALUE ? 1.0 : 1.01 / ((double)Math.abs(hex.getElevation() - hex2.getElevation()) + 1.01);
        double d2 = Math.max(hex.terrainsPresent(), hex2.terrainsPresent());
        double d3 = 0.0;
        int n = 0;
        while (n < Terrain.SIZE) {
            Terrain terrain = hex2.getTerrain(n);
            Terrain terrain2 = hex.getTerrain(n);
            if (terrain != null && terrain2 != null) {
                if (terrain.getLevel() == Integer.MAX_VALUE) {
                    d3 += 1.0;
                } else {
                    double d4 = 1.0 / ((double)Math.abs(terrain2.getLevel() - terrain.getLevel()) + 1.0);
                    d3 += d4;
                }
            }
            ++n;
        }
        double d5 = d2 == 0.0 ? 1.0 : d3 / d2;
        double d6 = hex2.getTheme() == hex.getTheme() || hex2.getTheme() != null && hex2.getTheme().equalsIgnoreCase(hex.getTheme()) ? 1.0 : 1.0E-4;
        return d * d5 * d6;
    }

    private class HexEntry {
        private Hex hex;
        private String imageFile;
        private Image image;

        public HexEntry(Hex hex, String string) {
            this.hex = hex;
            this.imageFile = string;
        }

        public Hex getHex() {
            return this.hex;
        }

        public Image getImage() {
            return this.image;
        }

        public Image getImage(Component component) {
            if (this.image == null) {
                this.loadImage(component);
            }
            return this.image;
        }

        public void loadImage(Component component) {
            this.image = component.getToolkit().getImage("data/hexes/" + this.imageFile);
        }
    }
}

