/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.AlertDialog;
import megamek.client.BoardComponent;
import megamek.client.BoardSelectionDialog;
import megamek.client.BoardView1;
import megamek.client.ChatLounge;
import megamek.client.ChatterBox;
import megamek.client.ConfirmDialog;
import megamek.client.DeploymentDisplay;
import megamek.client.FiringDisplay;
import megamek.client.GameEvent;
import megamek.client.GameListener;
import megamek.client.GameOptionsDialog;
import megamek.client.MechDisplay;
import megamek.client.MechSelectorDialog;
import megamek.client.MiniMap;
import megamek.client.MovementDisplay;
import megamek.client.PhysicalDisplay;
import megamek.client.ReportDisplay;
import megamek.client.StartingPositionDialog;
import megamek.common.Board;
import megamek.common.BoardEvent;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Game;
import megamek.common.GameOptions;
import megamek.common.GameTurn;
import megamek.common.Hex;
import megamek.common.MapSettings;
import megamek.common.MovementData;
import megamek.common.Packet;
import megamek.common.Player;
import megamek.common.Settings;
import megamek.common.actions.AttackAction;
import megamek.common.actions.FlipArmsAction;
import megamek.common.actions.TorsoTwistAction;

public class Client
extends Panel
implements Runnable,
MouseListener {
    public Frame frame;
    private boolean standalone;
    private String name;
    Socket socket;
    private ObjectInputStream in = null;
    private ObjectOutputStream out = null;
    private boolean connected = false;
    public int local_pn;
    public Game game;
    private MapSettings mapSettings;
    public String eotr;
    public ChatterBox cb;
    public BoardView1 bv;
    public BoardComponent bc;
    public Dialog mechW;
    public MechDisplay mechD;
    public Dialog minimapW;
    public MiniMap minimap;
    public PopupMenu popup;
    protected Panel curPanel;
    private BoardSelectionDialog boardSelectionDialog;
    private GameOptionsDialog gameOptionsDialog;
    private MechSelectorDialog mechSelectorDialog;
    private StartingPositionDialog startingPositionDialog;
    private Thread pump;
    private Vector gameListeners;

    public Client(String string) {
        this(new Frame("MegaMek Client"), string);
        Settings.load();
        if (Settings.windowSizeHeight != 0) {
            ((Component)this.frame).setLocation(Settings.windowPosX, Settings.windowPosY);
            ((Component)this.frame).setSize(Settings.windowSizeWidth, Settings.windowSizeHeight);
        } else {
            ((Component)this.frame).setSize(800, 600);
        }
        ((Component)this.frame).setBackground(SystemColor.menu);
        this.frame.setForeground(SystemColor.menuText);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Client.this.setVisible(false);
                Settings.windowPosX = Client.this.frame.getLocation().x;
                Settings.windowPosY = Client.this.frame.getLocation().y;
                Settings.windowSizeWidth = Client.this.frame.getSize().width;
                Settings.windowSizeHeight = Client.this.frame.getSize().height;
                Settings.save();
                Client.this.die();
            }
        });
        this.standalone = false;
        ((Component)this.frame).setVisible(true);
    }

    public Client(Frame frame, String string) {
        this.frame = frame;
        this.name = string;
        this.gameListeners = new Vector();
        this.local_pn = -1;
        this.game = new Game();
        this.popup = new PopupMenu("Board Popup...");
        this.bv = new BoardView1(this.game, frame);
        this.bv.addMouseListener(this);
        this.bv.add(this.popup);
        this.cb = new ChatterBox(this);
        this.mechW = new Dialog(frame, "Mech Display", false);
        ((Component)this.mechW).setSize(210, 340);
        this.mechW.setResizable(true);
        this.mechD = new MechDisplay(this);
        this.mechW.add(this.mechD);
        if (Settings.minimapEnabled) {
            this.minimapW = new Dialog(frame, "MiniMap", false);
            ((Component)this.minimapW).setLocation(Settings.minimapPosX, Settings.minimapPosY);
            ((Component)this.minimapW).setSize(Settings.minimapSizeWidth, Settings.minimapSizeHeight);
            this.minimap = new MiniMap(this.minimapW, this, this.bv);
            this.minimapW.add(this.minimap);
        }
        this.mechSelectorDialog = new MechSelectorDialog(this);
        this.changePhase(-1);
        this.setLayout(new BorderLayout());
        frame.setTitle(string + " - MegaMek");
        frame.removeAll();
        frame.setLayout(new BorderLayout());
        frame.add((Component)this, "Center");
        frame.validate();
        this.standalone = true;
    }

    public boolean connect(String string, int n) {
        try {
            this.socket = new Socket(string, n);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        this.pump = new Thread(this);
        this.pump.start();
        return true;
    }

    public void die() {
        this.connected = false;
        this.pump = null;
        try {
            this.socket.close();
            this.in.close();
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.standalone) {
            System.exit(0);
        } else {
            ((Component)this.frame).setVisible(false);
            this.frame.dispose();
        }
    }

    protected void disconnected() {
        AlertDialog alertDialog = new AlertDialog(this.frame, "Disconnected!", "You have become disconnected from the server.");
        alertDialog.show();
        this.die();
    }

    public Enumeration getPlayers() {
        return this.game.getPlayers();
    }

    public int getNoOfPlayers() {
        int n = 0;
        Enumeration enumeration = this.getPlayers();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement() == null) continue;
            ++n;
        }
        return n;
    }

    public Entity getEntity(int n) {
        return this.game.getEntity(n);
    }

    public Player getPlayer(int n) {
        return this.game.getPlayer(n);
    }

    public Player getLocalPlayer() {
        return this.getPlayer(this.local_pn);
    }

    public int getFirstEntityNum() {
        if (this.game.getTurn().getEntityNum() == -1) {
            return this.game.getFirstEntityNum(this.getLocalPlayer());
        }
        return this.game.getTurn().getEntityNum();
    }

    public int getNextEntityNum(int n) {
        if (this.game.getTurn().getEntityNum() == -1) {
            return this.game.getNextEntityNum(this.getLocalPlayer(), n);
        }
        return this.game.getTurn().getEntityNum();
    }

    public Board getBoard() {
        return this.game.board;
    }

    public Enumeration getEntities() {
        return this.game.getEntities();
    }

    public MapSettings getMapSettings() {
        return this.mapSettings;
    }

    public BoardSelectionDialog getBoardSelectionDialog() {
        if (this.boardSelectionDialog == null) {
            this.boardSelectionDialog = new BoardSelectionDialog(this);
        }
        return this.boardSelectionDialog;
    }

    public GameOptionsDialog getGameOptionsDialog() {
        if (this.gameOptionsDialog == null) {
            this.gameOptionsDialog = new GameOptionsDialog(this);
        }
        return this.gameOptionsDialog;
    }

    public MechSelectorDialog getMechSelectorDialog() {
        return this.mechSelectorDialog;
    }

    public StartingPositionDialog getStartingPositionDialog() {
        if (this.startingPositionDialog == null) {
            this.startingPositionDialog = new StartingPositionDialog(this);
        }
        return this.startingPositionDialog;
    }

    protected void changePhase(int n) {
        this.game.phase = n;
        this.bv.hideTooltip();
        this.curPanel = null;
        this.removeAll();
        this.doLayout();
        switch (n) {
            case 1: {
                this.switchPanel(new ChatLounge(this));
                break;
            }
            case 3: {
                this.sendReady(true);
                break;
            }
            case 12: {
                this.switchPanel(new DeploymentDisplay(this));
                break;
            }
            case 5: {
                this.switchPanel(new MovementDisplay(this));
                break;
            }
            case 7: {
                this.switchPanel(new FiringDisplay(this));
                break;
            }
            case 9: {
                this.switchPanel(new PhysicalDisplay(this));
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                this.switchPanel(new ReportDisplay(this));
            }
        }
        this.validate();
        this.doLayout();
        this.cb.moveToEnd();
        this.processGameEvent(new GameEvent(this, 4, null, ""));
    }

    private void switchPanel(Panel panel) {
        this.curPanel = panel;
        this.add(this.curPanel);
        this.curPanel.requestFocus();
    }

    protected void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    protected void showBoardPopup(Point point) {
        this.fillPopup(this.bv.getCoordsAt(point));
        if (this.popup.getItemCount() > 0) {
            this.popup.show(this.bv, point.x, point.y);
        }
    }

    private boolean canTargetEntities() {
        return this.isMyTurn() && (this.curPanel instanceof FiringDisplay || this.curPanel instanceof PhysicalDisplay);
    }

    protected void fillPopup(Coords coords) {
        Object object;
        this.popup.removeAll();
        Enumeration enumeration = this.game.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            object = (Entity)enumeration.nextElement();
            this.popup.add(new ViewMenuItem((Entity)object));
        }
        if (this.canTargetEntities()) {
            if (this.popup.getItemCount() > 0) {
                this.popup.addSeparator();
            }
            object = this.game.getEntities(coords);
            while (object.hasMoreElements()) {
                Entity entity = (Entity)object.nextElement();
                this.popup.add(new TargetMenuItem(entity));
            }
        }
    }

    public void addGameListener(GameListener gameListener) {
        this.gameListeners.addElement(gameListener);
    }

    public void removeGameListener(GameListener gameListener) {
        this.gameListeners.removeElement(gameListener);
    }

    protected void processGameEvent(GameEvent gameEvent) {
        Enumeration enumeration = this.gameListeners.elements();
        while (enumeration.hasMoreElements()) {
            GameListener gameListener = (GameListener)enumeration.nextElement();
            switch (gameEvent.type) {
                case 3: {
                    gameListener.gamePlayerChat(gameEvent);
                    break;
                }
                case 2: {
                    gameListener.gamePlayerStatusChange(gameEvent);
                    break;
                }
                case 4: {
                    gameListener.gamePhaseChange(gameEvent);
                    break;
                }
                case 5: {
                    gameListener.gameTurnChange(gameEvent);
                    break;
                }
                case 6: {
                    gameListener.gameNewEntities(gameEvent);
                    break;
                }
                case 7: {
                    gameListener.gameNewSettings(gameEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveServerInfo() {
        int n = 50;
        while (n-- > 0 && !this.connected) {
            Client client = this;
            synchronized (client) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isMyTurn() {
        return this.game.getTurn() != null && this.game.getTurn().getPlayerNum() == this.local_pn;
    }

    protected void changeTurn(GameTurn gameTurn) {
        this.game.setTurn(gameTurn);
        this.processGameEvent(new GameEvent(this, 5, this.getPlayer(gameTurn.getPlayerNum()), ""));
    }

    public void doAlertDialog(String string, String string2) {
        AlertDialog alertDialog = new AlertDialog(this.frame, string, string2);
        alertDialog.show();
    }

    public boolean doYesNoDialog(String string, String string2) {
        ConfirmDialog confirmDialog = new ConfirmDialog(this.frame, string, string2);
        confirmDialog.show();
        return confirmDialog.getAnswer();
    }

    public void sendModeChange(int n, int n2, int n3) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n3)};
        this.send(new Packet(26, objectArray));
    }

    public void moveEntity(int n, MovementData movementData) {
        Object[] objectArray = new Object[]{new Integer(n), movementData};
        this.send(new Packet(11, objectArray));
    }

    public void deploy(int n, Coords coords, int n2) {
        Object[] objectArray = new Object[]{new Integer(n), coords, new Integer(n2)};
        this.send(new Packet(27, objectArray));
    }

    public void sendAttackData(int n, Vector vector) {
        Object[] objectArray = new Object[]{new Integer(n), vector};
        this.send(new Packet(12, objectArray));
    }

    public void sendGameOptions(String string, Vector vector) {
        Object[] objectArray = new Object[]{string, vector};
        this.send(new Packet(21, objectArray));
    }

    public void sendMapSettings(MapSettings mapSettings) {
        this.send(new Packet(22, mapSettings));
    }

    public void sendMapQuery(MapSettings mapSettings) {
        this.send(new Packet(23, mapSettings));
    }

    public void sendChat(String string) {
        this.send(new Packet(8, string));
    }

    public void sendReady(boolean bl) {
        this.send(new Packet(7, new Boolean(bl)));
    }

    public void sendEntityReady(int n) {
        this.game.getEntity((int)n).ready = false;
        this.send(new Packet(13, new Integer(n)));
    }

    public void sendPlayerInfo() {
        this.send(new Packet(6, this.game.getPlayer(this.local_pn)));
    }

    public void sendAddEntity(Entity entity) {
        this.send(new Packet(9, entity));
    }

    public void sendUpdateEntity(Entity entity) {
        this.send(new Packet(14, entity));
    }

    public void sendDeleteEntity(int n) {
        this.send(new Packet(10, new Integer(n)));
    }

    protected void receivePlayerInfo(Packet packet) {
        int n = packet.getIntValue(0);
        Player player = (Player)packet.getObject(1);
        if (this.getPlayer(player.getId()) == null) {
            this.game.addPlayer(n, player);
        } else {
            this.game.setPlayer(n, player);
        }
        this.processGameEvent(new GameEvent(this, 2, player, ""));
    }

    protected void receiveBoard(Packet packet) {
        Board board = (Board)packet.getObject(0);
        this.game.board.newData(board.width, board.height, board.data);
    }

    protected void receiveEntities(Packet packet) {
        Vector vector = (Vector)packet.getObject(0);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            entity.restore();
            entity.setOwner(this.getPlayer(entity.getOwnerId()));
        }
        this.game.setEntitiesVector(vector);
        this.processGameEvent(new GameEvent(this, 6, null, null));
        this.bv.boardNewEntities(new BoardEvent(this.game.board, null, null, 0, 0));
    }

    protected void receiveEntityUpdate(Packet packet) {
        int n = packet.getIntValue(0);
        Entity entity = (Entity)packet.getObject(1);
        Coords coords = entity.getPosition();
        if (this.game.getEntity(n) != null) {
            coords = this.game.getEntity(n).getPosition();
        }
        entity.restore();
        entity.setOwner(this.getPlayer(entity.getOwnerId()));
        this.game.setEntity(n, entity);
        this.bv.boardChangedEntity(new BoardEvent(this.game.board, coords, entity, 0, 0));
    }

    protected void receiveEntityAdd(Packet packet) {
        int n = packet.getIntValue(0);
        Entity entity = (Entity)packet.getObject(1);
        entity.restore();
        entity.setOwner(this.getPlayer(entity.getOwnerId()));
        this.game.addEntity(n, entity);
        this.processGameEvent(new GameEvent(this, 6, null, null));
        this.bv.boardNewEntities(new BoardEvent(this.game.board, null, null, 0, 0));
    }

    protected void receiveEntityRemove(Packet packet) {
        int n = packet.getIntValue(0);
        this.game.removeEntity(n);
        this.processGameEvent(new GameEvent(this, 6, null, null));
        this.bv.boardNewEntities(new BoardEvent(this.game.board, null, null, 0, 0));
    }

    protected void receiveAttack(Packet packet) {
        Object object = packet.getObject(0);
        if (object instanceof TorsoTwistAction) {
            TorsoTwistAction torsoTwistAction = (TorsoTwistAction)object;
            if (this.game.getEntity(torsoTwistAction.getEntityId()) != null) {
                this.game.getEntity(torsoTwistAction.getEntityId()).setSecondaryFacing(torsoTwistAction.getFacing());
            }
        } else if (object instanceof FlipArmsAction) {
            FlipArmsAction flipArmsAction = (FlipArmsAction)object;
            if (this.game.getEntity(flipArmsAction.getEntityId()) != null) {
                this.game.getEntity(flipArmsAction.getEntityId()).setArmsFlipped(flipArmsAction.getIsFlipped());
            }
        } else if (object instanceof AttackAction) {
            this.bv.addAttack((AttackAction)object);
        }
    }

    private void saveEntityStatus(String string) {
        try {
            FileWriter fileWriter = new FileWriter("entitystatus.txt");
            fileWriter.write(string);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Packet readPacket() {
        try {
            if (this.in == null) {
                this.in = new ObjectInputStream(this.socket.getInputStream());
            }
            Packet packet = (Packet)this.in.readObject();
            return packet;
        }
        catch (IOException iOException) {
            System.err.println("client: IO error reading command:");
            System.err.println(iOException);
            System.err.println(iOException.getMessage());
            this.disconnected();
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("client: class not found error reading command:");
            System.err.println(classNotFoundException);
            System.err.println(classNotFoundException.getMessage());
            this.disconnected();
            return null;
        }
    }

    protected void send(Packet packet) {
        packet.zipData();
        try {
            if (this.out == null) {
                this.out = new ObjectOutputStream(this.socket.getOutputStream());
                this.out.flush();
            }
            this.out.reset();
            this.out.writeObject(packet);
            this.out.flush();
        }
        catch (IOException iOException) {
            System.err.println("client: error sending command.");
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        block23: while (this.pump == thread) {
            Packet packet = this.readPacket();
            if (packet == null) {
                System.out.println("client: got null packet");
                continue;
            }
            switch (packet.getCommand()) {
                case 1: {
                    this.connected = true;
                    this.send(new Packet(2, this.name));
                    break;
                }
                case 3: {
                    this.local_pn = packet.getIntValue(0);
                    break;
                }
                case 6: {
                    this.receivePlayerInfo(packet);
                    break;
                }
                case 7: {
                    this.getPlayer(packet.getIntValue(0)).setReady(packet.getBooleanValue(1));
                    this.processGameEvent(new GameEvent(this, 2, this.getPlayer(packet.getIntValue(0)), ""));
                    break;
                }
                case 4: {
                    this.receivePlayerInfo(packet);
                    break;
                }
                case 5: {
                    this.game.removePlayer(packet.getIntValue(0));
                    this.processGameEvent(new GameEvent(this, 2, this.getPlayer(packet.getIntValue(0)), ""));
                    break;
                }
                case 8: {
                    this.processGameEvent(new GameEvent(this, 3, null, (String)packet.getObject(0)));
                    break;
                }
                case 9: {
                    this.receiveEntityAdd(packet);
                    break;
                }
                case 14: {
                    this.receiveEntityUpdate(packet);
                    break;
                }
                case 10: {
                    this.receiveEntityRemove(packet);
                    break;
                }
                case 25: {
                    this.game.board.setHex((Coords)packet.getObject(0), (Hex)packet.getObject(1));
                    break;
                }
                case 15: {
                    this.changePhase(packet.getIntValue(0));
                    break;
                }
                case 16: {
                    this.changeTurn((GameTurn)packet.getObject(0));
                    break;
                }
                case 17: {
                    this.receiveBoard(packet);
                    break;
                }
                case 18: {
                    this.receiveEntities(packet);
                    break;
                }
                case 20: {
                    this.eotr = (String)packet.getObject(0);
                    break;
                }
                case 12: {
                    this.receiveAttack(packet);
                    break;
                }
                case 21: {
                    this.game.setOptions((GameOptions)packet.getObject(0));
                    if (this.gameOptionsDialog != null && this.gameOptionsDialog.isVisible()) {
                        this.gameOptionsDialog.update(this.game.getOptions());
                    }
                    this.processGameEvent(new GameEvent(this, 7, null, null));
                    break;
                }
                case 22: {
                    this.mapSettings = (MapSettings)packet.getObject(0);
                    if (this.boardSelectionDialog != null && this.boardSelectionDialog.isVisible()) {
                        this.boardSelectionDialog.update((MapSettings)packet.getObject(0), true);
                    }
                    this.processGameEvent(new GameEvent(this, 7, null, null));
                    break;
                }
                case 23: {
                    if (this.boardSelectionDialog == null || !this.boardSelectionDialog.isVisible()) continue block23;
                    this.boardSelectionDialog.update((MapSettings)packet.getObject(0), false);
                    break;
                }
                case 24: {
                    String string = (String)packet.getObject(0);
                    this.saveEntityStatus(string);
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showBoardPopup(mouseEvent.getPoint());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showBoardPopup(mouseEvent.getPoint());
        }
    }

    private class TargetMenuItem
    extends MenuItem
    implements ActionListener {
        Entity entity;

        public TargetMenuItem(Entity entity) {
            super("Target " + entity.getDisplayName());
            this.entity = entity;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Client.this.curPanel instanceof FiringDisplay) {
                ((FiringDisplay)Client.this.curPanel).target(this.entity.getId());
            } else if (Client.this.curPanel instanceof PhysicalDisplay) {
                ((PhysicalDisplay)Client.this.curPanel).target(this.entity.getId());
            }
        }
    }

    private class ViewMenuItem
    extends MenuItem
    implements ActionListener {
        Entity entity;

        public ViewMenuItem(Entity entity) {
            super("View " + entity.getDisplayName());
            this.entity = entity;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Client.this.mechD.displayEntity(this.entity);
        }
    }
}

