/*
 * Decompiled with CFR 0.152.
 */
package ReversiMonitor;

import Common.boardInfo;
import Common.loc;

public class minimax
extends Thread {
    int CUT_OFF;
    int ME;
    boardInfo b;
    public float[] moves;
    String[] possibleMoves;

    public minimax(int iCutOff, int player, boardInfo b, String[] possibleMoves) {
        this.CUT_OFF = iCutOff;
        this.ME = player;
        this.b = b;
        this.possibleMoves = possibleMoves;
        this.moves = new float[possibleMoves.length];
    }

    public float Evaluate(boardInfo bs) {
        int mp = bs.getPieceCount(this.ME);
        int op = 64 - bs.getPieceCount(boardInfo.EMPTY) - mp;
        if (bs.turn == boardInfo.GAME_OVER) {
            if (mp > op) {
                return 100 + mp - op;
            }
            if (mp == op) {
                return 0.0f;
            }
            return -100 + mp - op;
        }
        int OPP = boardInfo.getOpponent(this.ME);
        float eval = bs.countStablePieces(this.ME) - bs.countStablePieces(OPP);
        eval = (float)((double)eval + (double)(bs.countFrontier(OPP) - bs.countFrontier(this.ME)) / 8.0);
        return eval;
    }

    public float MaxValue(boardInfo bs, int n, float alpha, float beta) {
        if (bs.turn == boardInfo.GAME_OVER || n == this.CUT_OFF) {
            return this.Evaluate(bs);
        }
        String poss = bs.getPossibleMoves();
        String[] pl = poss.split(",");
        int i = 0;
        while (i < pl.length) {
            int t = bs.performMove(new loc(pl[i]));
            if (t == 0 || t == 2) {
                alpha = Math.max(alpha, this.MinValue(bs, n + 1, alpha, beta));
            } else if (t == 1) {
                alpha = Math.max(alpha, this.MaxValue(bs, n + 1, alpha, beta));
            }
            bs.takeBackOneMove();
            if (alpha >= beta) {
                return beta;
            }
            ++i;
        }
        return alpha;
    }

    public float MinValue(boardInfo bs, int n, float alpha, float beta) {
        if (bs.turn == boardInfo.GAME_OVER || n == this.CUT_OFF) {
            return this.Evaluate(bs);
        }
        String poss = bs.getPossibleMoves();
        String[] pl = poss.split(",");
        int i = 0;
        while (i < pl.length) {
            int t = bs.performMove(new loc(pl[i]));
            if (t == 0 || t == 2) {
                beta = Math.min(beta, this.MaxValue(bs, n + 1, alpha, beta));
            } else if (t == 1) {
                beta = Math.min(beta, this.MinValue(bs, n + 1, alpha, beta));
            }
            bs.takeBackOneMove();
            if (beta <= alpha) {
                return alpha;
            }
            ++i;
        }
        return beta;
    }

    public void run() {
        System.out.println("Start Running MiniMax Thread...");
        int i = 0;
        while (i < this.possibleMoves.length) {
            this.b.performMove(new loc(this.possibleMoves[i]));
            this.moves[i] = this.MinValue(this.b, 1, -3000.0f, 3000.0f);
            this.b.takeBackOneMove();
            System.out.println("i = " + i + " Eval for " + this.possibleMoves[i] + " : " + this.moves[i]);
            ++i;
        }
        System.out.println("Running MiniMax Thread Finished.");
    }
}

