/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import jchessboard.JChessBoard;
import jchessboard.Move;
import jchessboard.VirtualBoard;

public class Protocol {
    public static final String MOVE_MESSAGE = "move";
    public static final String BATCH_MOVE_MESSAGE = "batch_move";
    public static final String BATCH_FINISHED_MESSAGE = "batch_finished";
    public static final String BATCH_CANCELED_MESSAGE = "batch_canceled";
    public static final String START_UPLOAD_MESSAGE = "start_upload";
    public static final String NEW_GAME_MESSAGE = "new_game";
    public static final String REQUEST_NEW_GAME_MESSAGE = "request_new";
    public static final String NEW_GAME_REJECTED_MESSAGE = "new_rejected";
    public static final String UNDO_MESSAGE = "undo";
    public static final String UNDO_REJECTED_MESSAGE = "undo_rejected";
    public static final String GAME_TIME_MESSAGE = "gametime";
    public static final String PLAYERS_TIME_MESSAGE = "playerstime";
    public static final String REQUEST_UNDO_MESSAGE = "request_undo";
    public static final String REQUEST_CLOCK_CHANGE_MESSAGE = "request_clock_change";
    public static final String CLOCK_CHANGE_REJECTED_MESSAGE = "clock_change_rejected";
    public static final String REQUEST_TOGGLE_CLOCK_MESSAGE = "request_enable_clock";
    public static final String REJECT_TOGGLE_CLOCK_MESSAGE = "reject_enable_clock";
    public static final String ACCEPT_TOGGLE_CLOCK_MESSAGE = "accept_enable_clock";
    public static final String REQUEST_DISABLE_CLOCK_MESSAGE = "request_disable_clock";
    public static final String REJECT_DISABLE_CLOCK_MESSAGE = "reject_disable_clock";
    public static final String ACCEPT_DISABLE_CLOCK_MESSAGE = "accept_disable_clock";
    public static final String OFFER_DRAW_MESSAGE = "offer_draw";
    public static final String DRAW_ACCEPTED_MESSAGE = "draw_accepted";
    public static final String DRAW_REJECTED_MESSAGE = "draw_rejected";
    public static final String REQUEST_SIDE_SWITCH_MESSAGE = "request_side_switch";
    public static final String SIDE_SWITCH_ACCEPTED_MESSAGE = "side_switch_accepted";
    public static final String SIDE_SWITCH_REJECTED_MESSAGE = "side_switch_rejected";
    public static final String REQUEST_UPLOAD_MESSAGE = "request_upload";
    public static final String REJECT_UPLOAD_MESSAGE = "reject_upload";
    public static final String ACCEPT_UPLOAD_MESSAGE = "accept_upload";
    public static final String RESIGNED_MESSAGE = "resign";
    public static final String USER_MESSAGE = "message";
    public static final String RESTART_MESSAGE = "restart";
    public static final String QUIT_MESSAGE = "quit";
    public static final String WELCOME_MESSAGE = "Welcome!";
    public static final String REJECTED_MESSAGE = "Go away!";
    public static final String INIT_FROM_FEN_MESSAGE = "init_from_fen";
    public static final String ERROR_MESSAGE = "error";
    public static final String PLAYER_NAME_MESSAGE = "playername";
    protected LinkedList pendingAcks = new LinkedList();
    protected boolean gameIsLoading = false;
    protected boolean protocolIsConnected = false;
    protected boolean protocolServer = false;
    private JChessBoard jcb;
    private String otherPlayersName = "Opponent";

    public boolean isConnected() {
        return this.protocolIsConnected;
    }

    public void clearPendingAcks() {
        this.pendingAcks.clear();
    }

    public void sendWelcome() {
        this.sendMessage(WELCOME_MESSAGE);
    }

    public void connectionClosed() {
        this.protocolIsConnected = false;
        this.protocolServer = false;
        this.pendingAcks.clear();
    }

    public void connectionEstablished() {
        this.protocolIsConnected = true;
        this.clearPendingAcks();
    }

    public void connecting() {
        this.protocolServer = false;
        this.protocolIsConnected = false;
    }

    public void sendMove(Move move) {
        this.sendMessage(MOVE_MESSAGE, move.toString());
    }

    public void sendBatchMove(Move move) {
        this.sendMessage(BATCH_MOVE_MESSAGE, move.toString());
    }

    public void startUpload() {
        this.sendMessage(START_UPLOAD_MESSAGE);
    }

    public void uploadDone() {
        this.sendMessage(BATCH_FINISHED_MESSAGE);
    }

    public void requestNewGame() {
        this.sendMessage(REQUEST_NEW_GAME_MESSAGE);
    }

    public void offerDraw() {
        this.sendMessage(OFFER_DRAW_MESSAGE);
    }

    public void resigned() {
        this.sendMessage(RESIGNED_MESSAGE);
    }

    public void requestSideSwitch() {
        this.sendMessage(REQUEST_SIDE_SWITCH_MESSAGE);
    }

    public void requestToggleClock() {
        this.sendMessage(REQUEST_TOGGLE_CLOCK_MESSAGE);
    }

    public void sendPlayersTime(long l) {
        this.sendMessage(PLAYERS_TIME_MESSAGE, "" + l);
    }

    public void sendError(String string) {
        this.sendMessage(ERROR_MESSAGE, string);
    }

    public void requestClockChange(long l, long l2) {
        this.sendMessage(REQUEST_CLOCK_CHANGE_MESSAGE, "" + l + " " + l2);
    }

    public void requestUndo() {
        this.sendMessage(REQUEST_UNDO_MESSAGE);
    }

    public void requestUpload() {
        this.sendMessage(REQUEST_UPLOAD_MESSAGE);
    }

    public void initFromFEN(String string) {
        this.sendMessage(INIT_FROM_FEN_MESSAGE, string);
    }

    public void sendPlayerName(String string) {
        this.sendMessage(PLAYER_NAME_MESSAGE, string);
    }

    public void handleInput(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        if (string2 != null) {
            if (string2.equals(QUIT_MESSAGE)) {
                this.jcb.showMessage("Opponent has quit!");
                this.jcb.boardConnector.closeConnection();
                this.jcb.connectionClosed();
            } else if (string2.equals("?")) {
                this.jcb.showMessage("Out of sync! Trying to restart...");
                this.jcb.boardConnector.sendString(RESTART_MESSAGE);
                this.pendingAcks.clear();
                this.jcb.connectionIndicator.setError();
            } else if (string2.equals("OK restart")) {
                this.jcb.newGame();
                this.jcb.connectionIndicator.setReady();
                this.jcb.showMessage("Restarted due to unkown error.");
                this.jcb.beep();
            } else if (string2.equals("OK") && string3 != null && this.pendingAcks.size() > 0) {
                if (string.equals("OK " + (String)this.pendingAcks.get(0))) {
                    this.pendingAcks.remove(0);
                    if (this.pendingAcks.size() == 0) {
                        this.jcb.connectionIndicator.setReady();
                    }
                }
            } else if (string2.equals(WELCOME_MESSAGE)) {
                this.acknowledge(string);
                this.protocolIsConnected = true;
                this.jcb.connectionIndicator.setReady();
                this.jcb.showMessage("Game accepted.");
                this.jcb.connectionEstablished();
            } else if (string2.equals(REJECTED_MESSAGE)) {
                this.jcb.beep();
                this.jcb.showMessage("Other player doesn't want to play.");
                this.jcb.connectionClosed();
            } else if (string2.equals(UNDO_MESSAGE)) {
                this.jcb.undoMove();
                this.jcb.beep();
                this.acknowledge(string);
            } else if (string2.equals(REQUEST_UNDO_MESSAGE)) {
                Object[] objectArray = new Object[]{"Accept", "Reject"};
                int n = JOptionPane.showOptionDialog(null, "Opponent wants to take back the last move.", "Undo request", 0, 3, null, objectArray, objectArray[0]);
                this.acknowledge(string);
                if (n == 0) {
                    this.jcb.undoMove();
                    this.sendMessage(UNDO_MESSAGE);
                } else {
                    this.sendMessage(UNDO_REJECTED_MESSAGE);
                }
            } else if (string2.equals(UNDO_REJECTED_MESSAGE)) {
                this.jcb.showMessage("Undo request rejected.");
                this.acknowledge(string);
            } else if (string2.equals(REQUEST_TOGGLE_CLOCK_MESSAGE)) {
                Object[] objectArray = new Object[]{"Accept", "Reject"};
                int n = JOptionPane.showOptionDialog(null, "Opponent wants to turn " + (this.jcb.getEnableClock() ? "off" : "on") + " the clock", "Clock request", 0, 3, null, objectArray, objectArray[0]);
                this.acknowledge(string);
                if (n == 0) {
                    this.jcb.setEnableClock(!this.jcb.getEnableClock());
                    this.jcb.update();
                    this.jcb.showMessage("Chess clocks " + (this.jcb.getEnableClock() ? "enabled" : "disabled") + ".");
                    this.sendMessage(ACCEPT_TOGGLE_CLOCK_MESSAGE);
                } else {
                    this.sendMessage(REJECT_TOGGLE_CLOCK_MESSAGE);
                }
            } else if (string2.equals(ACCEPT_TOGGLE_CLOCK_MESSAGE)) {
                this.jcb.setEnableClock(!this.jcb.getEnableClock());
                this.jcb.update();
                this.jcb.showMessage("Chess clocks " + (this.jcb.getEnableClock() ? "enabled" : "disabled") + ".");
                this.acknowledge(string);
            } else if (string2.equals(REJECT_TOGGLE_CLOCK_MESSAGE)) {
                this.jcb.showMessage("Your wish to turn " + (this.jcb.getEnableClock() ? "off" : "on") + " the clock was rejected.");
                this.acknowledge(string);
            } else if (string2.equals(OFFER_DRAW_MESSAGE)) {
                Object[] objectArray = new Object[]{"Accept", "Reject"};
                int n = JOptionPane.showOptionDialog(null, "Opponent offers a draw.", "Draw offered", 0, 3, null, objectArray, objectArray[0]);
                this.acknowledge(string);
                if (n == 0) {
                    this.sendMessage(DRAW_ACCEPTED_MESSAGE);
                    this.jcb.showMessage("Draw accepted.");
                    this.jcb.history.setResult("1/2-1/2");
                } else {
                    this.sendMessage(DRAW_REJECTED_MESSAGE);
                }
            } else if (string2.equals(DRAW_ACCEPTED_MESSAGE)) {
                this.jcb.showMessage("Draw accepted.");
                this.jcb.beep();
                this.jcb.history.setResult("1/2-1/2");
                this.acknowledge(string);
            } else if (string2.equals(DRAW_REJECTED_MESSAGE)) {
                this.jcb.showMessage("Draw rejected.");
                this.acknowledge(string);
            } else if (string2.equals(RESIGNED_MESSAGE)) {
                this.acknowledge(string);
                this.jcb.showMessage("Opponent resigned.");
                this.jcb.beep();
                this.jcb.history.setResult(this.jcb.whitePlayer == "Human" ? "1-0" : "0-1");
            } else if (string2.equals(NEW_GAME_MESSAGE)) {
                this.jcb.beep();
                this.jcb.history.clear();
                this.jcb.newGame();
                this.jcb.showMessage("New game.");
                this.acknowledge(string);
            } else if (string2.equals(REQUEST_NEW_GAME_MESSAGE)) {
                this.jcb.beep();
                Object[] objectArray = new Object[]{"Accept", "Reject"};
                int n = JOptionPane.showOptionDialog(null, "Opponent requests a new game.", "New game?", 0, 3, null, objectArray, objectArray[0]);
                this.acknowledge(string);
                if (n == 0) {
                    this.jcb.history.clear();
                    this.jcb.newGame();
                    this.jcb.showMessage("New game.");
                    this.sendMessage(NEW_GAME_MESSAGE);
                } else {
                    this.sendMessage(NEW_GAME_REJECTED_MESSAGE);
                }
            } else if (string2.equals(NEW_GAME_REJECTED_MESSAGE)) {
                this.jcb.showMessage("New game rejected.");
                this.acknowledge(string);
            } else if (string2.equals(REQUEST_CLOCK_CHANGE_MESSAGE)) {
                long l = Long.parseLong(string3);
                long l2 = Long.parseLong(string4);
                Object[] objectArray = new Object[]{"Accept", "Reject"};
                int n = JOptionPane.showOptionDialog(null, "Opponent wants to change the clocks to:\n White: " + this.jcb.chessClock.formatTime(l) + "  Black: " + this.jcb.chessClock.formatTime(l2), "Change clocks?", 0, 3, null, objectArray, objectArray[0]);
                this.acknowledge(string);
                if (n == 0) {
                    this.sendMessage(GAME_TIME_MESSAGE, "" + l + " " + l2);
                    this.jcb.setClocks(l, l2);
                } else {
                    this.sendString(CLOCK_CHANGE_REJECTED_MESSAGE);
                }
            } else if (string2.equals(CLOCK_CHANGE_REJECTED_MESSAGE)) {
                this.jcb.showMessage("Clock change rejected.");
                this.acknowledge(string);
            } else if (string2.equals(GAME_TIME_MESSAGE) && string3 != null && string4 != null) {
                this.jcb.setClocks(Long.parseLong(string3), Long.parseLong(string4));
                this.acknowledge(string);
            } else if (string2.equals(PLAYERS_TIME_MESSAGE) && string3 != null) {
                if (this.jcb.blackPlayer == "Peer") {
                    long l = Long.parseLong(string3);
                    this.jcb.chessClock.setBlackPlayersTime(l);
                    this.jcb.checkFinish();
                } else if (this.jcb.whitePlayer == "Peer") {
                    long l = Long.parseLong(string3);
                    this.jcb.chessClock.setWhitePlayersTime(l);
                    this.jcb.checkFinish();
                }
                this.acknowledge(string);
            } else if (string2.equals(RESTART_MESSAGE)) {
                this.pendingAcks.clear();
                this.jcb.newGame();
                this.jcb.showMessage("Restarted due to unkown error.");
                this.jcb.beep();
                this.acknowledge(string);
            } else if (string2.equals(MOVE_MESSAGE) && string3 != null) {
                this.acknowledge(string);
                this.jcb.makePeersMove(new Move(string3));
            } else if (string2.equals(REQUEST_UPLOAD_MESSAGE)) {
                Object[] objectArray = new Object[]{"Accept", "Reject"};
                int n = JOptionPane.showOptionDialog(null, "Opponent wants to upload a saved game.", "Accept upload?", 0, 3, null, objectArray, objectArray[0]);
                this.acknowledge(string);
                if (n == 0) {
                    this.sendMessage(ACCEPT_UPLOAD_MESSAGE);
                } else {
                    this.sendString(REJECT_UPLOAD_MESSAGE);
                }
            } else if (string2.equals(ACCEPT_UPLOAD_MESSAGE)) {
                this.acknowledge(string);
                this.jcb.showMessage("Upload accepted.");
                this.jcb.uploadGame();
            } else if (string2.equals(REJECT_UPLOAD_MESSAGE)) {
                this.acknowledge(string);
                this.jcb.showMessage("Upload rejected.");
            } else if (string2.equals(START_UPLOAD_MESSAGE)) {
                this.jcb.newGame();
                this.jcb.showMessage("Peer started to upload a game...");
                this.gameIsLoading = true;
                this.jcb.beep();
                this.acknowledge(string);
            } else if (string2.equals(BATCH_MOVE_MESSAGE) && string3 != null) {
                Move move = new Move(string3);
                this.jcb.makeBatchMove(move);
                this.gameIsLoading = true;
                this.acknowledge(string);
            } else if (string2.equals(BATCH_FINISHED_MESSAGE)) {
                this.acknowledge(string);
                this.jcb.showMessage("Game successfully loaded.");
                this.jcb.whitePlayer = "-----";
                this.jcb.blackPlayer = "-----";
                this.jcb.gameTable.setNetworkGameIndex(this.jcb.gameTable.getCurrentGameIndex());
                this.jcb.chessClock.stopClock();
                this.jcb.chessClock.resetClocks();
                this.jcb.update();
                this.jcb.prepareMove();
                this.gameIsLoading = false;
            } else if (string2.equals(BATCH_CANCELED_MESSAGE)) {
                this.acknowledge(string);
                this.jcb.showMessage("Game upload canceled!");
                this.gameIsLoading = false;
            } else if (string2.equals(INIT_FROM_FEN_MESSAGE) && string3 != null) {
                this.acknowledge(string);
                VirtualBoard virtualBoard = new VirtualBoard();
                virtualBoard.initFromFEN(string3);
                this.jcb.newGame(virtualBoard);
                this.jcb.showMessage("Opponent initialized board from FEN.");
            } else if (string2.equals(REQUEST_SIDE_SWITCH_MESSAGE)) {
                this.jcb.beep();
                Object[] objectArray = new Object[]{"Accept", "Reject"};
                int n = JOptionPane.showOptionDialog(null, "Opponents wants to switch sides.", "Switch sides?", 0, 3, null, objectArray, objectArray[0]);
                this.acknowledge(string);
                if (n == 0) {
                    this.jcb.switchSides();
                    this.sendMessage(SIDE_SWITCH_ACCEPTED_MESSAGE);
                } else {
                    this.sendMessage(SIDE_SWITCH_REJECTED_MESSAGE);
                }
            } else if (string2.equals(SIDE_SWITCH_ACCEPTED_MESSAGE)) {
                this.acknowledge(string);
                this.jcb.switchSides();
            } else if (string2.equals(SIDE_SWITCH_REJECTED_MESSAGE)) {
                this.acknowledge(string);
                this.jcb.showMessage("Side switch rejected");
            } else if (string2.equals(USER_MESSAGE) && string3 != null) {
                this.acknowledge(string);
                this.jcb.showMessage(this.otherPlayersName + ": " + Protocol.stripCmd(string), "chatIn");
            } else if (string2.equals(PLAYER_NAME_MESSAGE) && string3 != null) {
                this.acknowledge(string);
                this.otherPlayersName = string3;
                this.jcb.showMessage("Opponent set its name to \"" + string3 + "\".");
                this.jcb.updateSTR();
            } else if (string2.equals(ERROR_MESSAGE)) {
                this.acknowledge(string);
                if (string3 == null) {
                    this.jcb.showMessage("An unspecified error occurred.");
                } else {
                    this.jcb.showMessage("Error message from peer: " + string3);
                }
            } else {
                this.sendString("?\n");
            }
        }
    }

    protected void sendString(String string) {
        this.jcb.connectionIndicator.setWaiting();
        if (this.jcb.settings.debugDumpTraffic) {
            this.jcb.showMessage(">>>" + string, "debug");
        }
        this.pendingAcks.add(string);
        this.jcb.boardConnector.sendString(string);
    }

    public void sendMessage(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.sendString(string + " " + string2);
    }

    public void sendMessage(String string) {
        this.sendString(string);
    }

    protected void acknowledge(String string) {
        if (this.jcb.settings.debugDumpTraffic) {
            this.jcb.showMessage(">>>OK " + string, "debug");
        }
        this.jcb.boardConnector.sendString("OK " + string);
    }

    private static String stripCmd(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            return string.substring(string2.length());
        }
        return "EmptyString";
    }

    public Protocol(JChessBoard jChessBoard) {
        this.jcb = jChessBoard;
    }

    public String getOtherPlayersName() {
        return this.otherPlayersName;
    }

    public void setOtherPlayersName(String string) {
        this.otherPlayersName = string;
    }
}

