/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Keymap;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import jchessboard.GameNode;
import jchessboard.History;
import jchessboard.PGN;

public class Notation
extends JScrollPane {
    private History history;
    private JTextPane notationTextPane;
    private StyledDocument notationDocument;
    private int currentNotationPos = 0;

    public void update() {
        this.currentNotationPos = 0;
        try {
            this.notationDocument.remove(0, this.notationDocument.getLength());
            this.insertNotation(this.history.getTopGameNode(), this.notationDocument, 0);
            this.notationTextPane.setCaretPosition(this.currentNotationPos);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private int insertNotation(GameNode gameNode, StyledDocument styledDocument, int n) {
        Style style;
        Style style2;
        Style style3;
        Style style4;
        Style style5;
        String string = "";
        int n2 = n;
        boolean bl = false;
        Style style6 = this.notationTextPane.getStyle("gray");
        GameNode gameNode2 = this.history.getCurrentGameNode();
        if (gameNode2.isLeaf() && gameNode == gameNode2.getParent() || gameNode == gameNode2) {
            style5 = this.notationTextPane.getStyle("bold");
            style4 = this.notationTextPane.getStyle("regular");
            style3 = this.notationTextPane.getStyle("comment");
            style2 = this.notationTextPane.getStyle("currentNode");
            style = this.notationTextPane.getStyle("nag");
        } else {
            style5 = this.notationTextPane.getStyle("graybold");
            style4 = this.notationTextPane.getStyle("gray");
            style3 = this.notationTextPane.getStyle("gray");
            style2 = this.notationTextPane.getStyle("gray");
            style = this.notationTextPane.getStyle("gray");
        }
        try {
            if (gameNode.getComment().length() > 0) {
                string = gameNode.getComment() + " ";
                style3.addAttribute("gameNode", gameNode);
                styledDocument.insertString(n, string, style3);
                n += string.length();
            }
            for (int i = 0; i < gameNode.getChildCount(); ++i) {
                boolean bl2;
                GameNode gameNode3 = (GameNode)gameNode.getChildAt(i);
                boolean bl3 = bl2 = gameNode3 == gameNode2;
                if (gameNode3.isLeaf()) {
                    Style style7;
                    if (gameNode3.isWhiteMove()) {
                        string = gameNode3.getFullMoveNumber() + ". ";
                        style5.addAttribute("gameNode", gameNode3);
                        styledDocument.insertString(n, string, style5);
                        n += string.length();
                        string = gameNode3.getMove();
                        style7 = bl2 ? style2 : style4;
                        style7.addAttribute("gameNode", gameNode3);
                        styledDocument.insertString(n, string, style7);
                        n += string.length();
                        bl = true;
                    } else if (bl) {
                        string = gameNode3.getMove();
                        style7 = bl2 ? style2 : style4;
                        style7.addAttribute("gameNode", gameNode3);
                        styledDocument.insertString(n, string, style7);
                        n += string.length();
                    } else {
                        bl = true;
                        string = gameNode3.getFullMoveNumber() + "... ";
                        style5.addAttribute("gameNode", gameNode3);
                        styledDocument.insertString(n, string, style5);
                        n += string.length();
                        string = gameNode3.getMove();
                        style7 = bl2 ? style2 : style4;
                        style7.addAttribute("gameNode", gameNode3);
                        styledDocument.insertString(n, string, style7);
                        n += string.length();
                    }
                    if (gameNode3.hasComment()) {
                        for (int j = 0; j < gameNode3.getNags().length; ++j) {
                            string = " " + PGN.NAGStrings[gameNode3.getNags()[j]];
                            style.addAttribute("gameNode", gameNode3);
                            styledDocument.insertString(n, string, style);
                            n += string.length();
                        }
                        if (gameNode3.getComment().length() > 0) {
                            string = " " + gameNode3.getComment();
                            style3.addAttribute("gameNode", gameNode3);
                            styledDocument.insertString(n, string, style3);
                            n += string.length();
                        }
                    }
                    styledDocument.insertString(n++, " ", style4);
                } else {
                    bl = false;
                    if (gameNode3 == gameNode2.getParent() || bl2) {
                        styledDocument.insertString(n++, "(", this.notationTextPane.getStyle("regular"));
                        n += this.insertNotation(gameNode3, styledDocument, n);
                        styledDocument.insertString(n++ - 1, ")", this.notationTextPane.getStyle("regular"));
                    } else {
                        styledDocument.insertString(n++, "(", style6);
                        n += this.insertNotation(gameNode3, styledDocument, n);
                        styledDocument.insertString(n++ - 1, ")", style6);
                    }
                }
                if (!bl2) continue;
                this.currentNotationPos = n;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n - n2;
    }

    public Notation(History history) {
        this.history = history;
        this.notationDocument = new DefaultStyledDocument();
        this.notationTextPane = new JTextPane(this.notationDocument);
        this.notationTextPane.setEditable(false);
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = this.notationTextPane.addStyle("regular", style);
        StyleConstants.setFontFamily(style, "SansSerif");
        Style style3 = this.notationTextPane.addStyle("italic", style2);
        StyleConstants.setItalic(style3, true);
        style3 = this.notationTextPane.addStyle("bold", style2);
        StyleConstants.setBold(style3, true);
        style3 = this.notationTextPane.addStyle("comment", style2);
        StyleConstants.setForeground(style3, new Color(50, 50, 255));
        style3 = this.notationTextPane.addStyle("nag", style2);
        StyleConstants.setForeground(style3, new Color(30, 30, 150));
        style3 = this.notationTextPane.addStyle("currentNode", style2);
        StyleConstants.setBackground(style3, new Color(210, 210, 230));
        style3 = this.notationTextPane.addStyle("gray", style2);
        StyleConstants.setForeground(style3, new Color(150, 200, 150));
        style3 = this.notationTextPane.addStyle("graybold", style2);
        StyleConstants.setForeground(style3, new Color(150, 200, 150));
        StyleConstants.setBold(style3, true);
        this.notationTextPane.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                AttributeSet attributeSet = Notation.this.notationDocument.getCharacterElement(Notation.this.notationTextPane.viewToModel(mouseEvent.getPoint())).getAttributes();
                if (attributeSet.isDefined("gameNode")) {
                    Notation.this.history.gotoGameNode((GameNode)attributeSet.getAttribute("gameNode"));
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }
        });
        Keymap keymap = this.notationTextPane.getKeymap();
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(37, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Notation.this.history.prev();
            }
        });
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(39, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Notation.this.history.next();
            }
        });
        this.getViewport().add(this.notationTextPane);
    }
}

