/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import jchessboard.PGN;

class GameTable
extends JScrollPane {
    private Vector pgnList = new Vector();
    private Vector strList = new Vector();
    private GameTableModel tableModel = new GameTableModel();
    boolean tableChanged = false;
    private JTable jTable = new JTable(this.tableModel);
    private int currentGameIndex = 0;
    private int networkGameIndex = -1;

    public int addGame(String string, PGN.STR sTR) {
        this.pgnList.add(string);
        this.strList.add(sTR);
        this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel));
        int n = this.pgnList.size() - 1;
        this.jTable.setRowSelectionInterval(n, n);
        this.setColumnWidths();
        this.tableChanged = true;
        return n;
    }

    public String getPGN(int n) {
        return (String)this.pgnList.get(n);
    }

    public void setPGN(int n, String string) {
        this.pgnList.set(n, string);
        this.tableChanged = true;
    }

    public PGN.STR getSTR(int n) {
        return (PGN.STR)this.strList.get(n);
    }

    public void setSTR(int n, PGN.STR sTR) {
        this.strList.set(n, sTR);
        this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel));
        this.tableChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        GameTable gameTable = this;
        synchronized (gameTable) {
            this.pgnList.clear();
            this.strList.clear();
            this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel));
            this.tableChanged = false;
        }
        this.setColumnWidths();
    }

    public int getGameCount() {
        return this.pgnList.size();
    }

    public int getSelectedIndex() {
        return this.jTable.getSelectedRow();
    }

    public int getSelectionCount() {
        return this.jTable.getSelectedRowCount();
    }

    public void setSelectedIndex(int n) {
        this.jTable.setRowSelectionInterval(n, n);
        this.jTable.scrollRectToVisible(this.jTable.getCellRect(n, 0, true));
    }

    public void updateRow(int n) {
        this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel, n));
    }

    public void removeGame(int n) {
        this.pgnList.remove(n);
        this.strList.remove(n);
        this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel));
        this.tableChanged = true;
    }

    public int removeSelectedGames() {
        int n = this.getSelectedIndex();
        int n2 = this.getSelectionCount();
        int n3 = this.currentGameIndex;
        for (int i = 0; i < n2; ++i) {
            this.removeGame(n);
            if (n3 < n) continue;
            --n3;
        }
        if (this.getGameCount() == 0) {
            this.addGame("", new PGN.STR());
            return 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    public GameTable() {
        this.jTable.setSelectionMode(1);
        this.setViewportView(this.jTable);
        this.jTable.setFont(new Font("SansSerrif", 0, 10));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (n == GameTable.this.currentGameIndex) {
                    this.setBackground(new Color(200, 200, 200));
                } else if (n == GameTable.this.networkGameIndex) {
                    this.setBackground(new Color(200, 20, 20));
                    bl = false;
                } else {
                    this.setBackground(new Color(255, 255, 255));
                }
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                return this;
            }
        };
        this.jTable.setDefaultRenderer(new Object().getClass(), defaultTableCellRenderer);
        this.jTable.setAutoResizeMode(3);
        this.setColumnWidths();
    }

    private void setColumnWidths() {
        this.jTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.jTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.jTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.jTable.getColumnModel().getColumn(3).setMaxWidth(50);
        this.jTable.getColumnModel().getColumn(4).setPreferredWidth(80);
        this.jTable.getColumnModel().getColumn(7).setMaxWidth(40);
    }

    public int getCurrentGameIndex() {
        return this.currentGameIndex;
    }

    public void setCurrentGameIndex(int n) {
        this.currentGameIndex = n;
    }

    public JTable getJTable() {
        return this.jTable;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.jTable.setEnabled(bl);
    }

    public int getNetworkGameIndex() {
        return this.networkGameIndex;
    }

    public void setNetworkGameIndex(int n) {
        this.networkGameIndex = n;
    }

    class GameTableModel
    extends AbstractTableModel {
        GameTableModel() {
        }

        public int getColumnCount() {
            return 8;
        }

        public int getRowCount() {
            return GameTable.this.strList.size();
        }

        public int getGameCount() {
            return GameTable.this.strList.size();
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "#";
            }
            if (n == 1) {
                return "White";
            }
            if (n == 2) {
                return "Black";
            }
            if (n == 3) {
                return "Res.";
            }
            if (n == 4) {
                return "Date";
            }
            if (n == 5) {
                return "Event";
            }
            if (n == 6) {
                return "Site";
            }
            if (n == 7) {
                return "Rnd.";
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                if (n == GameTable.this.networkGameIndex) {
                    return "Net";
                }
                return n + 1 + "";
            }
            PGN.STR sTR = (PGN.STR)GameTable.this.strList.get(n);
            if (n2 == 1) {
                return sTR.getTag("White");
            }
            if (n2 == 2) {
                return sTR.getTag("Black");
            }
            if (n2 == 3) {
                if (sTR.getTag("Result").equals("1/2-1/2")) {
                    return "\u00bd-\u00bd";
                }
                return sTR.getTag("Result");
            }
            if (n2 == 4) {
                return sTR.getTag("Date");
            }
            if (n2 == 5) {
                return sTR.getTag("Event");
            }
            if (n2 == 6) {
                return sTR.getTag("Site");
            }
            if (n2 == 7) {
                return sTR.getTag("Round");
            }
            return null;
        }
    }
}

