/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.border.LineBorder;

class ConnectionIndicator
extends JLabel {
    private Color noConnectionColor;
    private Color connectedColor;
    private Color waitingColor;
    private Color waitingColor2;
    private Color errorColor;
    private boolean isWaiting = false;
    private boolean i = false;
    private ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ConnectionIndicator.this.toggleColor();
        }
    };
    private Timer toggleTimer = new Timer(250, this.listener);

    public static String getVersion() {
        return "$Id: ConnectionIndicator.java,v 1.12 2004/11/26 00:05:34 cdivossen Exp $";
    }

    private void toggleColor() {
        if (this.i) {
            this.setBackground(this.waitingColor);
        } else {
            this.setBackground(this.waitingColor2);
        }
        this.i = !this.i;
    }

    public void setReady() {
        this.setBackground(this.connectedColor);
        this.setToolTipText("Connected");
        this.toggleTimer.stop();
        this.isWaiting = false;
    }

    public void setError() {
        this.setBackground(this.errorColor);
        this.setToolTipText("Error!");
        this.toggleTimer.stop();
        this.isWaiting = false;
    }

    public void setWaiting() {
        this.setToolTipText("Waiting...");
        this.isWaiting = true;
        this.toggleTimer.start();
    }

    public void setNoConnection() {
        this.setToolTipText("Not connected");
        this.isWaiting = false;
        this.toggleTimer.stop();
        this.setBackground(this.noConnectionColor);
    }

    public boolean isWaiting() {
        return this.isWaiting;
    }

    public ConnectionIndicator() {
        this.setPreferredSize(new Dimension(15, 15));
        this.setOpaque(true);
        this.setBorder(LineBorder.createBlackLineBorder());
        this.noConnectionColor = this.getBackground();
        this.connectedColor = new Color(50, 170, 50);
        this.waitingColor = new Color(255, 255, 80);
        this.waitingColor2 = new Color(180, 180, 50);
        this.errorColor = new Color(170, 50, 50);
        this.setNoConnection();
    }
}

