/*
 * Decompiled with CFR 0.152.
 */
package getfour;

import getfour.AIException;
import getfour.GetFourGUI;
import getfour.GetFourTree;
import getfour.GridCanvas;
import java.util.Hashtable;

public class GetFour {
    private GetFourGUI getFourGUI;
    private GridCanvas gridCanvas;
    private static int[] gridArray;
    private static int nextPlayer;
    private int treeDepth = 5;
    private Hashtable<String, Integer> difficulty = new Hashtable(3);
    static final int numberOfPlaces = 42;

    private GetFour() {
        this.getFourGUI = new GetFourGUI(this);
        gridArray = new int[42];
        this.initGridArray();
        nextPlayer = 1;
        this.difficulty.put("easy", new Integer(5));
        this.difficulty.put("moderate", new Integer(6));
        this.difficulty.put("hard", new Integer(7));
    }

    int getDifficultyValue(String string) {
        Integer n = this.difficulty.get(string);
        return n;
    }

    int getTreeDepth() {
        return this.treeDepth;
    }

    void setTreeDepth(int n) {
        this.treeDepth = n;
    }

    void quit() {
        this.getFourGUI.dispose();
        System.exit(0);
    }

    void newGame() {
        this.initGridArray();
        nextPlayer = 1;
        this.getFourGUI.getGridCanvas().repaint();
        if (this.getFourGUI.getCurrentMode().equals("Computer - Human")) {
            this.gridCanvas.drawDisc(this.ai());
        }
    }

    void initGridArray() {
        for (int i = 0; i < 42; ++i) {
            GetFour.gridArray[i] = 0;
        }
    }

    public int getFreeRow(int n) {
        return GetFour.getFreeRow(gridArray, n);
    }

    static int getFreeRow(int[] nArray, int n) {
        for (int i = 1; i < 7; ++i) {
            if (nArray[41 - (7 * i - n)] != 0) continue;
            return 7 - i;
        }
        return 0;
    }

    void setDisc(int n, int n2) {
        GetFour.gridArray[(n2 - 1) * 7 + n - 1] = nextPlayer;
        this.flipNextPlayer();
    }

    private void flipNextPlayer() {
        nextPlayer = nextPlayer == 1 ? -1 : 1;
    }

    static int getOpponent(int n) {
        if (n == 1) {
            return -1;
        }
        return 1;
    }

    int getNextPlayer() {
        return nextPlayer;
    }

    public boolean hasWon() {
        return GetFour.discsInARow(gridArray, nextPlayer, 4, true);
    }

    static boolean hasWon(int[] nArray) {
        return GetFour.discsInARow(nArray, nextPlayer, 4, true);
    }

    static boolean discsInARow(int[] nArray, int n, int n2, boolean bl) {
        int[] nArray2 = bl ? new int[]{n, GetFour.getOpponent(n)} : new int[]{n};
        for (int i = 0; i < nArray2.length; ++i) {
            int n3;
            int n4;
            int n5;
            int n6;
            n = nArray2[i];
            for (n6 = 0; n6 < 42; n6 += 7) {
                n5 = 0;
                for (n4 = 0; n4 < 7; ++n4) {
                    n5 = nArray[n6 + n4] == n ? (int)((byte)(n5 + 1)) : 0;
                    if (n5 != n2) continue;
                    return true;
                }
            }
            for (n6 = 0; n6 < 7; ++n6) {
                n5 = 0;
                for (n4 = 0; n4 < 42; n4 += 7) {
                    n5 = nArray[n6 + n4] == n ? (int)((byte)(n5 + 1)) : 0;
                    if (n5 != n2) continue;
                    return true;
                }
            }
            for (n6 = 0; n6 < 8 - n2; ++n6) {
                for (n5 = 0; n5 < (7 - n2) * 7; n5 += 7) {
                    n4 = 0;
                    for (n3 = n2 - 1; n3 < (n2 - 1) * 6 + n2; n3 += 6) {
                        n4 = nArray[n6 + n5 + n3] == n ? (int)((byte)(n4 + 1)) : 0;
                        if (n4 != n2) continue;
                        return true;
                    }
                }
            }
            for (n6 = 0; n6 < 8 - n2; ++n6) {
                for (n5 = 0; n5 < (7 - n2) * 7; n5 += 7) {
                    n4 = 0;
                    for (n3 = 0; n3 < (n2 - 1) * 8 + 1; n3 += 8) {
                        n4 = nArray[n6 + n5 + n3] == n ? (int)((byte)(n4 + 1)) : 0;
                        if (n4 != n2) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean isEmpty() {
        for (int i = 0; i < 42; ++i) {
            if (gridArray[i] != 1) {
                if (gridArray[i] != -1) continue;
            }
            return false;
        }
        return true;
    }

    public boolean isFull() {
        return GetFour.isFull(gridArray);
    }

    static boolean isFull(int[] nArray) {
        for (int i = 0; i < 42; ++i) {
            if (nArray[i] != 0) continue;
            return false;
        }
        return true;
    }

    int numberOfDiscs() {
        int n = 0;
        for (int i = 0; i < 42; ++i) {
            if (gridArray[i] != 1) {
                if (gridArray[i] != -1) continue;
            }
            ++n;
        }
        return n;
    }

    int[] getGridArray() {
        return gridArray;
    }

    private int getFreeRandomColumn() {
        double d = Math.random();
        for (double d2 = 1.0; d2 < 8.0; d2 += 1.0) {
            if (!((d2 - 1.0) / 7.0 <= d) || !(d < d2 / 7.0)) continue;
            int n = GetFour.getFreeRow(this.getGridArray(), (int)d2);
            if (n != 0) {
                return (int)d2;
            }
            return this.getFreeRandomColumn();
        }
        return 0;
    }

    int ai() {
        try {
            GetFourTree getFourTree = new GetFourTree(this.treeDepth, this);
            return getFourTree.getBestColumn();
        }
        catch (AIException aIException) {
            System.err.println(aIException.getMessage());
            return this.getFreeRandomColumn();
        }
    }

    public void setGridCanvas(GridCanvas gridCanvas) {
        this.gridCanvas = gridCanvas;
    }

    public static void main(String[] stringArray) {
        GetFour getFour = new GetFour();
    }
}

