/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Game;
import mikera.tyrant.Hero;
import mikera.tyrant.Lib;
import mikera.tyrant.util.LibMetaData;
import mikera.tyrant.util.LibMetaDataHandler;
import mikera.tyrant.util.MetaData;
import mikera.tyrant.util.MetaDataEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PlugInUtility {
    private static final String XML_BEGIN = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>";
    private static final String XML_LIBRARY_STYLESHEET = "<?xml-stylesheet type=\"text/xsl\" href=\"tyrantLibraryItems.xsl\" ?>";
    private static final String XML_SPECIFICATION_STYLESHEET = "<?xml-stylesheet type=\"text/xsl\" href=\"tyrantLibrarySpecification.xsl\" ?>";
    private static final String XML_OPEN_LIBRARY = "<TyrantLibrary ProgramVersion=\"" + Game.VERSION + "\">";
    private static final String XML_CLOSE_LIBRARY = "</TyrantLibrary>";
    private static final String XML_OPEN_SPECIFICATION = "<TyrantLibrarySpecification ProgramVersion=\"" + Game.VERSION + "\">";
    private static final String XML_CLOSE_SPECIFICATION = "</TyrantLibrarySpecification>";
    private static final String XML_OPEN_ITEM = "<Item>";
    private static final String XML_CLOSE_ITEM = "</Item>";
    private static final String XML_OPEN_PROPERTY = "<Property>";
    private static final String XML_CLOSE_PROPERTY = "</Property>";
    private static final String XML_OPEN_NAME = "<Name>";
    private static final String XML_CLOSE_NAME = "</Name>";
    private static final String XML_OPEN_TYPE = "<Type>";
    private static final String XML_CLOSE_TYPE = "</Type>";
    private static final String XML_OPEN_DESCRIPTION = "<Description>";
    private static final String XML_CLOSE_DESCRIPTION = "</Description>";
    private static final String XML_OPEN_VALUE = "<Value>";
    private static final String XML_CLOSE_VALUE = "</Value>";
    private static final String XML_OPEN_METADATA = "<MetaData>";
    private static final String XML_CLOSE_METADATA = "</MetaData>";
    private static final String XML_OPEN_MANDATORY = "<IsMandatory>";
    private static final String XML_CLOSE_MANDATORY = "</IsMandatory>";
    private static final String XML_OPEN_CONDITION = "<ValueCondition>";
    private static final String XML_CLOSE_CONDITION = "</ValueCondition>";
    private static final String XML_OPEN_VALID_VALUES = "<ValidValues>";
    private static final String XML_CLOSE_VALID_VALUES = "</ValidValues>";
    private static final String XML_OPEN_PROPERTY_SPECIFICATION = "<PropertySpecification>";
    private static final String XML_CLOSE_PROPERTY_SPECIFICATION = "</PropertySpecification>";
    private static final String XML_OPEN_ITEM_SPECIFICATION = "<ItemSpecification>";
    private static final String XML_CLOSE_ITEM_SPECIFICATION = "</ItemSpecification>";
    private static final TreeMap LIBMETADATA = LibMetaData.instance().getAll();

    public static void writeLibrary(String string, boolean bl) {
        PlugInUtility.prepareWriteAction(new File(string), bl, false);
    }

    public static void writeSpecification(String string) {
        PlugInUtility.prepareWriteAction(new File(string), true, true);
    }

    public static void readPlugIn(String string) {
        File[] fileArray = null;
        File file = new File(string);
        try {
            if (file.isDirectory()) {
                fileArray = file.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.endsWith(".xml");
                    }
                });
            }
            if (file.isFile()) {
                fileArray = new File[]{file};
            }
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < fileArray.length; ++i) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setIgnoringComments(true);
                documentBuilderFactory.setIgnoringElementContentWhitespace(true);
                Document document = documentBuilderFactory.newDocumentBuilder().parse(new FileInputStream(fileArray[i]));
                NodeList nodeList = document.getElementsByTagName("TyrantPlugIn");
                if (nodeList.getLength() == 0) {
                    System.out.println(fileArray[i] + " doesn't contain any items");
                    continue;
                }
                NodeList nodeList2 = document.getElementsByTagName("Item");
                System.out.println(fileArray[i] + " contains " + nodeList2.getLength() + " items");
                arrayList.addAll(PlugInUtility.readItems(nodeList2));
                System.out.println(arrayList.size() + " items were successful loaded from " + file.getName());
                linkedHashMap.putAll(PlugInUtility.checkItemData(arrayList));
                arrayList.clear();
                LibMetaDataHandler.createLibraryItems(linkedHashMap);
            }
        }
        catch (Exception exception) {
            System.out.println("Error while reading from" + file.toString() + ":");
            System.out.println(exception.getMessage());
        }
    }

    private static ArrayList readItems(NodeList nodeList) {
        ArrayList<TreeMap> arrayList = new ArrayList<TreeMap>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.hasChildNodes()) {
                System.out.println(" Loading item " + (i + 1));
                arrayList.add(PlugInUtility.readItem(node.getChildNodes()));
                continue;
            }
            System.out.println(" Item " + (i + 1) + " contains unvalid data:\n" + node);
        }
        return arrayList;
    }

    private static TreeMap readItem(NodeList nodeList) {
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            treeMap.putAll(PlugInUtility.readProperties(node, false));
        }
        System.out.println(treeMap);
        return treeMap;
    }

    private static TreeMap readProperties(Node node, boolean bl) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        TreeMap treeMap2 = new TreeMap();
        String string = null;
        String string2 = null;
        String string3 = node.getNodeName();
        if (node.getNodeType() == 1 && string3 != null && string3.length() > 0 && string3.indexOf("#") == -1) {
            string = node.getNodeName();
            string2 = node.getFirstChild().getNodeValue();
            if (string2 != null && string2.trim().length() > 0) {
                String string4 = bl ? "   " : "  ";
                System.out.println(string4 + "Property \"" + string + "\" successful loaded");
                treeMap.put(string, string2);
            } else {
                System.out.println("  Loading meta data");
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    treeMap2.putAll(PlugInUtility.readProperties(nodeList.item(i), true));
                }
                if (treeMap2.size() > 0) {
                    System.out.println("  Meta data successful loaded");
                    treeMap.put(string, treeMap2);
                } else {
                    System.out.println("  Missing or unvalid meta data:");
                    System.out.println("  " + treeMap2);
                    return new TreeMap();
                }
            }
        }
        if (treeMap.size() > 0) {
            return treeMap;
        }
        if (treeMap.size() == 0 && !bl) {
            System.out.println("  Missing or unvalid property data:");
            System.out.println("  " + treeMap);
        }
        return new TreeMap();
    }

    private static LinkedHashMap checkItemData(ArrayList arrayList) {
        LibMetaData libMetaData = LibMetaData.instance();
        LinkedHashMap<String, TreeMap> linkedHashMap = new LinkedHashMap<String, TreeMap>();
        Iterator iterator = arrayList.iterator();
        int n = 0;
        System.out.println("Checking " + arrayList.size() + " item(s) for matching library meta data");
        while (iterator.hasNext()) {
            TreeMap treeMap = (TreeMap)iterator.next();
            System.out.println(" Checking item " + ++n);
            String string = libMetaData.describes(treeMap);
            if (string == null) continue;
            linkedHashMap.put(PlugInUtility.getTimeStamp() + "$" + string, treeMap);
        }
        System.out.println(linkedHashMap.size() + " item(s) matched the library meta data");
        if (linkedHashMap.size() != arrayList.size()) {
            System.out.println(arrayList.size() - linkedHashMap.size() + " item(s) didn't match the library meta data");
        }
        return linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prepareWriteAction(File file, boolean bl, boolean bl2) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileOutputStream(file), true);
            if (bl2) {
                PlugInUtility.processLibMetaData(printWriter);
            } else {
                PlugInUtility.processLibrary(printWriter, bl);
            }
        }
        catch (Exception exception) {
            System.out.println("Error while writing to" + file.toString() + ":");
            System.out.println(exception.getMessage());
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private static void processLibrary(PrintWriter printWriter, boolean bl) {
        Hero.createHero("dummy", "human", "sorceror");
        Lib lib = Lib.instance();
        List list = lib.getAll();
        MetaData metaData = null;
        printWriter.println(XML_BEGIN);
        if (bl) {
            printWriter.println(XML_LIBRARY_STYLESHEET);
        }
        printWriter.println(XML_OPEN_LIBRARY);
        for (int i = 0; i < list.size(); ++i) {
            TreeMap treeMap = new TreeMap(((BaseObject)list.get(i)).getCollapsedMap());
            printWriter.println(PlugInUtility.getSpaces(1) + XML_OPEN_ITEM);
            printWriter.println(PlugInUtility.getSpaces(2) + XML_OPEN_NAME + treeMap.remove("Name") + XML_CLOSE_NAME);
            Iterator iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object object = treeMap.get(string);
                if (object != null && object.toString().indexOf("@") > 0 && (metaData = LibMetaDataHandler.createMetaDataFromObject(object)) == null) {
                    object = object.toString().substring(0, object.toString().lastIndexOf("@"));
                }
                if (metaData != null) {
                    TreeMap treeMap2 = metaData.getAll();
                    Iterator iterator2 = treeMap2.keySet().iterator();
                    printWriter.println("<" + PlugInUtility.getValue(object) + ">");
                    printWriter.println(XML_OPEN_METADATA);
                    while (iterator2.hasNext()) {
                        String string2 = (String)iterator2.next();
                        MetaDataEntry metaDataEntry = (MetaDataEntry)treeMap2.get(string2);
                        printWriter.println("<" + string2 + ">" + metaDataEntry.getValue() + "</" + string2 + ">");
                    }
                    printWriter.println(XML_CLOSE_METADATA);
                    printWriter.println("</" + PlugInUtility.getValue(object) + ">");
                    continue;
                }
                printWriter.println(PlugInUtility.getSpaces(2) + "<" + string + ">" + object + "</" + string + ">");
            }
            printWriter.println(PlugInUtility.getSpaces(1) + XML_CLOSE_ITEM);
        }
        printWriter.println(XML_CLOSE_LIBRARY);
    }

    private static void processLibMetaData(PrintWriter printWriter) {
        String string;
        Iterator iterator;
        TreeMap treeMap;
        MetaData metaData;
        String string2;
        TreeMap treeMap2 = new TreeMap();
        TreeMap treeMap3 = LibMetaDataHandler.createPropertyDescriptions();
        Iterator iterator2 = LIBMETADATA.keySet().iterator();
        while (iterator2.hasNext()) {
            string2 = (String)iterator2.next();
            metaData = (MetaData)LIBMETADATA.get(string2);
            treeMap = metaData.getAll();
            iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (treeMap2.containsKey(string)) continue;
                treeMap2.put(string, treeMap.get(string));
            }
        }
        printWriter.println(XML_BEGIN);
        printWriter.println(XML_SPECIFICATION_STYLESHEET);
        printWriter.println(XML_OPEN_SPECIFICATION);
        printWriter.println(PlugInUtility.getSpaces(1) + XML_OPEN_PROPERTY_SPECIFICATION);
        iterator2 = treeMap2.keySet().iterator();
        while (iterator2.hasNext()) {
            string2 = (String)iterator2.next();
            PlugInUtility.processMetaDataEntry(printWriter, false, 2, string2, (MetaDataEntry)treeMap2.get(string2), treeMap3);
        }
        printWriter.println(PlugInUtility.getSpaces(1) + XML_CLOSE_PROPERTY_SPECIFICATION);
        printWriter.println(PlugInUtility.getSpaces(1) + XML_OPEN_ITEM_SPECIFICATION);
        iterator2 = LIBMETADATA.keySet().iterator();
        while (iterator2.hasNext()) {
            string2 = (String)iterator2.next();
            metaData = (MetaData)LIBMETADATA.get(string2);
            treeMap = metaData.getAll();
            printWriter.println(PlugInUtility.getSpaces(2) + XML_OPEN_ITEM);
            printWriter.println(PlugInUtility.getSpaces(3) + XML_OPEN_NAME + string2 + XML_CLOSE_NAME);
            iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                PlugInUtility.processMetaDataEntry(printWriter, true, 4, string, (MetaDataEntry)treeMap.get(string), treeMap3);
            }
            printWriter.println(PlugInUtility.getSpaces(2) + XML_CLOSE_ITEM);
        }
        printWriter.println(PlugInUtility.getSpaces(1) + XML_CLOSE_ITEM_SPECIFICATION);
        printWriter.println(XML_CLOSE_SPECIFICATION);
    }

    private static void processMetaDataEntry(PrintWriter printWriter, boolean bl, int n, String string, MetaDataEntry metaDataEntry, TreeMap treeMap) {
        Object object;
        Iterator<Object> iterator;
        Object object2;
        Object object3 = metaDataEntry.getValue();
        ArrayList arrayList = metaDataEntry.getValidValues();
        printWriter.println(PlugInUtility.getSpaces(n) + XML_OPEN_PROPERTY);
        printWriter.println(PlugInUtility.getSpaces(n) + XML_OPEN_NAME + string + XML_CLOSE_NAME);
        if (bl) {
            printWriter.println(PlugInUtility.getSpaces(n) + XML_OPEN_MANDATORY + metaDataEntry.isMandatory() + XML_CLOSE_MANDATORY);
            printWriter.println(PlugInUtility.getSpaces(n) + XML_OPEN_VALUE + PlugInUtility.getValue(object3) + XML_CLOSE_VALUE);
            printWriter.println(PlugInUtility.getSpaces(n) + XML_OPEN_CONDITION + metaDataEntry.getValueCondition() + XML_CLOSE_CONDITION);
        } else {
            printWriter.println(PlugInUtility.getSpaces(n) + XML_OPEN_TYPE + object3.getClass().getName() + XML_CLOSE_TYPE);
            printWriter.println(PlugInUtility.getSpaces(n) + XML_OPEN_DESCRIPTION + PlugInUtility.getDescription((String)treeMap.get(string)) + XML_CLOSE_DESCRIPTION);
        }
        if (object3 instanceof MetaData && ((TreeMap)(object2 = ((MetaData)object3).getAll())).keySet().size() > 0) {
            if (bl) {
                printWriter.println(PlugInUtility.getSpaces(n + 1) + XML_OPEN_METADATA);
            }
            iterator = ((TreeMap)object2).keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                PlugInUtility.processMetaDataEntry(printWriter, bl, n + 2, (String)object, (MetaDataEntry)((TreeMap)object2).get(object), treeMap);
            }
            if (bl) {
                printWriter.println(PlugInUtility.getSpaces(n + 1) + XML_CLOSE_METADATA);
            }
        }
        if (arrayList != null) {
            object2 = arrayList.iterator();
            printWriter.println(PlugInUtility.getSpaces(n + 1) + XML_OPEN_VALID_VALUES);
            while (object2.hasNext()) {
                iterator = object2.next();
                if (iterator instanceof MetaData) {
                    printWriter.println(PlugInUtility.getSpaces(n + 2) + XML_OPEN_METADATA);
                    object = ((MetaData)((Object)iterator)).getAll();
                    Iterator iterator2 = ((TreeMap)object).keySet().iterator();
                    while (iterator2.hasNext()) {
                        String string2 = (String)iterator2.next();
                        PlugInUtility.processMetaDataEntry(printWriter, bl, n + 3, string2, (MetaDataEntry)((TreeMap)object).get(string2), treeMap);
                    }
                    printWriter.println(PlugInUtility.getSpaces(n + 2) + XML_CLOSE_METADATA);
                    continue;
                }
                printWriter.println(PlugInUtility.getSpaces(n + 2) + XML_OPEN_VALUE + iterator + XML_CLOSE_VALUE);
            }
            printWriter.println(PlugInUtility.getSpaces(n + 1) + XML_CLOSE_VALID_VALUES);
        }
        printWriter.println(PlugInUtility.getSpaces(n) + XML_CLOSE_PROPERTY);
    }

    private static String getValue(Object object) {
        String string = object.getClass().getName();
        String string2 = null;
        if (string.indexOf("mikera.tyrant") >= 0) {
            string2 = string.indexOf("@") >= 0 ? string.substring(string.lastIndexOf("."), string.indexOf("@")) : string.substring(string.lastIndexOf(".") + 1);
        }
        if (string2 != null && string2.indexOf(";") >= 0) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2 != null) {
            return string2;
        }
        return object.toString();
    }

    private static String getDescription(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private static String getSpaces(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append("   ");
        }
        return stringBuffer.toString();
    }

    private static long getTimeStamp() {
        return System.currentTimeMillis();
    }
}

