/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant.author;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Game;
import mikera.tyrant.Map;
import mikera.tyrant.QuestApp;
import mikera.tyrant.TPanel;
import mikera.tyrant.Thing;
import mikera.tyrant.author.Designer;
import mikera.tyrant.author.MapMaker;

public class ThingEditor
implements Runnable {
    private Frame frame;
    private TPanel statusBar;
    private TextField textField;
    private Label textLabel;
    private ActionListener textListener;
    private Container thingPanel;
    private Thing thing;
    private java.util.Map importantAttributes;
    private java.util.Map textFieldMapping = new HashMap();
    private java.util.Map keyTypes = new HashMap();
    private String mapText;
    private TextArea sourceTextArea;
    private Panel sourceStatusBar;
    private Label sourceStatusLabel;
    private Designer designer;

    public void inspect(Thing thing) {
        this.thing = thing;
        this.updateThingPanel();
    }

    public void inspect(Thing[] thingArray) {
        this.inspect(thingArray == null || thingArray.length == 0 ? null : thingArray[0]);
    }

    public void buildUI() {
        Game.loadVersionNumber();
        this.createFrame();
        this.statusBar.setVisible(false);
    }

    public void updateThingPanel() {
        if (this.thingPanel != null && this.thingPanel.isValid()) {
            this.frame.remove(this.thingPanel);
        }
        this.createThingPanel();
        this.thingPanel.getParent().invalidate();
        this.thingPanel.getParent().validate();
    }

    private void createThingPanel() {
        this.thingPanel = new JTabbedPane(1);
        this.frame.add((Component)this.thingPanel, "Center");
        this.createThingTabbs();
        this.thingPanel.setBackground(SystemColor.control);
        ((JTabbedPane)this.thingPanel).addTab("Source", this.createSourcePanel());
    }

    private void createThingTabbs() {
        if (this.thing == null) {
            return;
        }
        BaseObject baseObject = BaseObject.getFlattened(this.thing);
        HashMap hashMap = baseObject.getLocal();
        String[] stringArray = hashMap.keySet().toArray(new String[hashMap.keySet().size()]);
        if (stringArray.length == 0) {
            return;
        }
        this.sortKeys(stringArray);
        int n = 25;
        int n2 = Math.max(1, (int)Math.ceil(hashMap.size() / n));
        char c = 'A';
        for (int i = 0; i < n2; ++i) {
            Panel panel = new Panel(new BorderLayout());
            panel.setBackground(SystemColor.control);
            char c2 = n2 == 1 ? (char)'Z' : (char)stringArray[(i + 1) * n].charAt(0);
            String string = "" + c + "-" + c2;
            c = (char)(c2 + '\u0001');
            ((JTabbedPane)this.thingPanel).addTab(string, panel);
            this.addAttributes2(hashMap, stringArray, panel, i * n, n);
        }
    }

    private Component createSourcePanel() {
        FormLayout formLayout = new FormLayout("fill:pref:grow", "fill:pref:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        this.mapText = new MapMaker().store(this.designer.map);
        this.sourceTextArea = new TextArea(this.mapText, 10, 20);
        defaultFormBuilder.append((Component)this.sourceTextArea);
        defaultFormBuilder.append((Component)this.createSourceButtonPanel());
        defaultFormBuilder.append((Component)this.createSourceStatus());
        Panel panel = new Panel(new BorderLayout());
        panel.add((Component)defaultFormBuilder.getPanel(), "Center");
        return panel;
    }

    private Panel createSourceStatus() {
        this.sourceStatusBar = new Panel(new BorderLayout());
        this.sourceStatusLabel = new Label("Bob", 1);
        this.sourceStatusBar.add((Component)this.sourceStatusLabel, "Center");
        this.sourceStatusBar.setVisible(false);
        return this.sourceStatusBar;
    }

    private Panel createSourceButtonPanel() {
        Panel panel = new Panel(new FlowLayout());
        Button button = new Button("Apply");
        Button button2 = new Button("Revert");
        panel.add(button);
        panel.add(button2);
        button.addActionListener(new SourceOKPressed());
        button2.addActionListener(new SourceRevertPressed());
        return panel;
    }

    private String determineType(String string, Object object) {
        String string2 = null;
        if (object instanceof Integer) {
            string2 = string.startsWith("Is") ? "boolean" : "int";
        } else if (object instanceof Double) {
            string2 = "double";
        } else if (object instanceof String) {
            string2 = "string";
        }
        this.keyTypes.put(string, string2);
        return string2;
    }

    private void sortKeys(String[] stringArray) {
        Arrays.sort(stringArray, new Comparator(){

            public boolean equals(Object object) {
                return false;
            }

            public int compare(Object object, Object object2) {
                String string = (String)object;
                String string2 = (String)object2;
                java.util.Map map = ThingEditor.this.getImportantAttributes();
                Integer n = (Integer)map.get(string);
                Integer n2 = (Integer)map.get(string2);
                if (n == null && n2 == null) {
                    return string.compareTo(string2);
                }
                if (n == null && n2 != null) {
                    return 1;
                }
                if (n != null && n2 == null) {
                    return -1;
                }
                return n - n2;
            }
        });
    }

    protected java.util.Map getImportantAttributes() {
        if (this.importantAttributes == null) {
            this.importantAttributes = new HashMap();
            String[] stringArray = new String[]{"Name", "Number", "Level", "Frequency", "HPS", "UName"};
            for (int i = 0; i < stringArray.length; ++i) {
                this.importantAttributes.put(stringArray[i], new Integer(i));
            }
        }
        return this.importantAttributes;
    }

    private void createFrame() {
        this.frame = new Frame("ThingEditor - v" + Game.VERSION);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ThingEditor.this.frame.setVisible(false);
            }
        });
        this.frame.setBackground(SystemColor.control);
        this.frame.setLayout(new BorderLayout());
        this.statusBar = new TPanel(null);
        this.frame.add((Component)this.statusBar, "South");
        this.textField = new TextField(30);
        this.statusBar.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.textLabel = new Label("Bob:");
        this.textLabel.setForeground(QuestApp.INFOTEXTCOLOUR);
        this.statusBar.add((Component)this.textLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.statusBar.add((Component)this.textField, gridBagConstraints);
        this.textListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThingEditor.this.doTextPerformed(actionEvent);
            }
        };
        this.frame.setSize(640, 800);
        this.frame.setMenuBar(this.createMenuBar());
    }

    protected void doTextPerformed(ActionEvent actionEvent) {
        String string = (String)this.textFieldMapping.get(actionEvent.getSource());
        String string2 = ((TextField)actionEvent.getSource()).getText();
        String string3 = (String)this.keyTypes.get(string);
        Object object = string2;
        if (!string3.equals("string")) {
            if (string3.equals("int")) {
                object = Integer.valueOf(string2);
            } else if (string3.equals("double")) {
                object = Double.valueOf(string2);
            } else if (string3.equals("boolean")) {
                object = Boolean.valueOf(string2);
            }
        }
        this.thing.set(string, object);
        this.updateSourceTab();
    }

    private void updateSourceTab() {
        this.mapText = new MapMaker().store(this.designer.map);
        this.sourceTextArea.setText(this.mapText);
    }

    protected void doCheckboxPerformed(ItemEvent itemEvent) {
        Checkbox checkbox = (Checkbox)itemEvent.getSource();
        String string = checkbox.getLabel();
        Integer n = new Integer(checkbox.getState() ? 1 : 0);
        this.thing.set(string, n);
    }

    private MenuBar createMenuBar() {
        return null;
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public Frame getFrame() {
        return this.frame;
    }

    private void addAttributes2(java.util.Map map, String[] stringArray, Container container, int n, int n2) {
        FormLayout formLayout = new FormLayout("pref, 3dlu, fill:pref:grow(100)", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        n2 = Math.min(stringArray.length, n2);
        for (int i = n; i < n + n2; ++i) {
            Component component;
            String string = stringArray[i];
            if (map.get(string) == null) continue;
            Object v = map.get(string);
            String string2 = this.determineType(string, v);
            if (string2 == null) {
                System.out.println("ignoring " + string + " " + v);
                continue;
            }
            if (string2.equals("boolean")) {
                component = new Checkbox(string, (Integer)v == 1);
                ((Checkbox)component).addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        ThingEditor.this.doCheckboxPerformed(itemEvent);
                    }
                });
                defaultFormBuilder.append("");
                defaultFormBuilder.append(component);
                defaultFormBuilder.nextLine();
                continue;
            }
            defaultFormBuilder.append(string);
            if (string.equals("Message")) {
                component = new TextArea(String.valueOf(v), 1, 30, 1);
                defaultFormBuilder.append(component);
                this.textFieldMapping.put(component, string);
            } else {
                component = new TextField(String.valueOf(v));
                defaultFormBuilder.append(component);
                this.textFieldMapping.put(component, string);
                ((TextField)component).addActionListener(this.textListener);
                if (string.equals("Name")) {
                    ((TextComponent)component).setEditable(false);
                }
            }
            defaultFormBuilder.nextLine();
        }
        container.add((Component)defaultFormBuilder.getPanel(), "Center");
    }

    public void run() {
        try {
            Thread.sleep(6000L);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ThingEditor.this.sourceStatusBar.setVisible(false);
                    ThingEditor.this.sourceStatusLabel.setText("There is an error creating the map");
                    ThingEditor.this.sourceStatusBar.getParent().invalidate();
                    ThingEditor.this.sourceStatusBar.getParent().validate();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void setDesigner(Designer designer) {
        this.designer = designer;
    }

    private final class SourceOKPressed
    implements ActionListener {
        private SourceOKPressed() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ThingEditor.this.sourceTextArea.getText();
            if (string.equals(ThingEditor.this.mapText)) {
                return;
            }
            Map map = new MapMaker().create(string, true);
            if (map == null) {
                ThingEditor.this.sourceStatusBar.setVisible(true);
                ThingEditor.this.sourceStatusLabel.setText("There is an error creating the map");
                ThingEditor.this.sourceStatusBar.getParent().invalidate();
                ThingEditor.this.sourceStatusBar.getParent().validate();
                new Thread(ThingEditor.this).start();
                return;
            }
            if (ThingEditor.this.designer != null) {
                ThingEditor.this.designer.reloadMap(map);
                ThingEditor.this.mapText = new MapMaker().store(map);
                ThingEditor.this.sourceTextArea.setText(ThingEditor.this.mapText);
            }
        }
    }

    private final class SourceRevertPressed
    implements ActionListener {
        private SourceRevertPressed() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ThingEditor.this.sourceTextArea.setText(ThingEditor.this.mapText);
        }
    }
}

