/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.Calendar;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Movement;
import mikera.tyrant.Outdoors;
import mikera.tyrant.Point;
import mikera.tyrant.Portal;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Thing;
import mikera.tyrant.Time;

public class WorldMap {
    protected static int[] terrains = new int[]{19, 19, 20, 21, 22, 25, 29, 25};

    public static Map createWorldMap(int n, int n2) {
        int n3;
        Map map = new Map(n, n2);
        map.set("EnterMessage", "This fertile valley is known as North Karrain");
        map.set("Description", "North Karrain Valley");
        map.set("WanderingRate", 0);
        map.set("IsWorldMap", 1);
        map.set("Level", 1);
        map.set("VisionRange", 7);
        map.set("OnAction", new EncounterAction());
        for (n3 = 0; n3 < n; n3 += 4) {
            map.setTile(n3, 0, 22);
            map.setTile(n3, n2 - 1, 22);
        }
        for (n3 = 0; n3 < n2; n3 += 4) {
            map.setTile(0, n3, 22);
            map.setTile(n - 1, n3, 25);
        }
        for (n3 = 4; n3 < n2 - 4; n3 += 4) {
            for (int i = 4; i < n - 4; i += 4) {
                map.setTile(i, n3, terrains[RPG.r(terrains.length)]);
            }
        }
        map.setTile(16, 8, 20);
        map.setTile(16, 12, 20);
        map.setTile(16, 16, 19);
        map.setTile(12, 12, 20);
        map.setTile(8, 12, 21);
        map.fractalizeBlock(0, 0, n - 1, n2 - 1, 4);
        map.addThing(Portal.create("town"), 16, 16);
        map.addThing(Portal.create("ruin"), 16, 8);
        map.addThing(Portal.create("town"), 0, 0, map.width - 1, map.height - 1);
        map.addThing(Portal.create("town"), 0, 0, map.width - 1, map.height - 1);
        map.addThing(Portal.create("caves"), 0, 0, map.width - 1, map.height - 1);
        map.addThing(Portal.create("graveyard"), 0, 0, map.width - 1, map.height - 1);
        map.addThing(Portal.create("grotto"));
        map.addThing(Portal.create("deep dungeon"), 0, 0, map.width - 1, map.height - 1);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) == 11 && calendar.get(5) == 25) {
            Game.warn("Merry Christmas!!");
            map.addThing(Portal.create("Old Nyck's hut"), 0, 0, map.width - 1, map.height - 1);
        }
        map.addThing(Portal.create("goblin village"), 0, 0, map.width - 1, map.height - 1);
        Point point = null;
        for (int i = 0; i < 1000; ++i) {
            point = map.findFreeSquare();
            if (map.getTile(point.x, point.y) == 20) break;
        }
        map.addThing(Portal.create("dark forest"), point.x, point.y);
        map.addThing(Portal.create("dark tower"));
        return map;
    }

    public static void exitWorldMap(Map map, int n, int n2) {
        Thing thing = Game.hero();
        Time.logTime(Movement.moveCost(map, thing, n, n2));
        Thing thing2 = map.getFlaggedObject(n, n2, "IsPortal");
        if (thing2 != null) {
            Portal.travel(thing2, thing);
        } else {
            Map map2 = WorldMap.createArea(map, n, n2);
            thing2 = Portal.create();
            Thing thing3 = map2.getEntrance();
            Portal.setDestination(thing2, map2, thing3.x, thing3.y);
            Portal.travel(thing2, thing);
        }
    }

    public static void encounter(Map map, int n, int n2) {
        if (RPG.d(20) > 1) {
            return;
        }
        Thing thing = Game.hero();
        Thing[] thingArray = map.getPortals(n, n2);
        if (thingArray.length > 0) {
            return;
        }
        int n3 = map.getTile(n, n2);
        if (n3 == 25) {
            return;
        }
        switch (RPG.d(8)) {
            case 1: {
                Game.message("You see somebody in the distance");
                break;
            }
            case 2: {
                Thing thing2 = Lib.createType("IsHostile", Game.hero().getStat("Level") + RPG.r(6));
                Game.message("You see " + thing2.getAName() + " waiting to ambush travellers");
                Game.message("Do you want to attack? (y/n)");
                if (Game.getOption("yn") == 'y') {
                    Game.message("");
                    Map map2 = WorldMap.createArea(map, n, n2);
                    map2.addThing(Game.hero(), 32, 32);
                    map2.addThing(thing2, 32, 25);
                    if (RPG.d(2) != 1) break;
                    for (int i = RPG.d(6); i > 0; --i) {
                        int n4;
                        int n5 = 28 + RPG.r(9);
                        if (map2.isBlocked(n5, n4 = 18 + RPG.r(7))) continue;
                        map2.addThing(thing2.cloneType(), n5, n4);
                    }
                    if (RPG.d(2) != 1 || map2.isBlocked(32, 20)) break;
                    map2.addThing(Lib.createFoe(Game.hero().getStat("Level") + 1), 32, 20);
                    break;
                }
                Game.message("You avoid the encounter");
                break;
            }
            case 3: {
                Thing thing3 = Lib.createFoe(Game.hero().getStat("Level") + 2);
                Game.message("You see some villagers being attacked by " + thing3.getPluralName());
                Game.message("Do you want to aid them? (y/n)");
                if (Game.getOption("yn") == 'y') {
                    int n6;
                    int n7;
                    int n8;
                    Map map3 = WorldMap.createArea(map, n, n2);
                    map3.addThing(Game.hero(), 32, 32);
                    block14: for (n8 = RPG.d(2, 3); n8 > 0; --n8) {
                        n7 = 29 + RPG.r(7);
                        if (map3.isBlocked(n7, n6 = 28 + RPG.r(7))) continue;
                        switch (RPG.d(3)) {
                            case 1: {
                                map3.addThing(Lib.create("farmer"), n7, n6);
                                continue block14;
                            }
                            case 2: {
                                map3.addThing(Lib.create("village girl"), n7, n6);
                                continue block14;
                            }
                            case 3: {
                                map3.addThing(Lib.create("townswoman"), n7, n6);
                            }
                        }
                    }
                    for (n8 = RPG.d(2, 6); n8 > 0; --n8) {
                        n7 = 28 + RPG.r(9);
                        if (map3.isBlocked(n7, n6 = 21 + RPG.r(7))) continue;
                        map3.addThing(thing3.cloneType(), n7, n6);
                    }
                    map3.addThing(Lib.createFoe(Game.hero().getStat("Level") + 4), 32, 20);
                    break;
                }
                Game.message("You leave them to their fate");
                break;
            }
            case 4: {
                Game.message("You are slowed by bad weather conditions.");
                thing.incStat("APS", -1000);
                break;
            }
            case 5: {
                int n9 = thing.getLevel();
                if (n9 <= 2) break;
                Game.message("You are ambushed by a horde of fearsome monsters!");
                Game.message("[Press space to continue]");
                Game.getOption(" ");
                Map map4 = WorldMap.createArea(map, n, n2);
                map4.set("IsHostile", 1);
                map4.addThing(Game.hero(), 32, 32);
                for (int i = 0; i < 40 + 3 * n9; ++i) {
                    map4.addThing(Lib.createType("IsMonster", n9));
                }
                break;
            }
            case 6: {
                Thing thing4;
                Thing[] thingArray2 = thing.getItems();
                Thing thing5 = thing4 = thingArray2.length > 0 ? thingArray2[RPG.r(thingArray2.length)] : null;
                if (thing4 == null || thing4.getFlag("IsCursed") || Item.value(thing4) <= 0) break;
                Game.message("You encounter a band of nasty goblinoids!");
                Game.message("They demand " + thing4.getYourName() + " as 'tax'");
                Game.message("Do you want to fight them? (y/n)");
                int n10 = Game.getOption("yn");
                while (n10 != 121 && n10 != 110) {
                    n10 = Game.getOption("yn");
                }
                if (n10 == 110) {
                    thing4.remove();
                    if (RPG.d(50) <= thing.getLevel()) {
                        Game.message("They decide to attack you anyway!");
                        n10 = 121;
                    } else {
                        Game.message("They take " + thing4.getYourName() + " and run away gleefully");
                    }
                } else {
                    thing4 = null;
                }
                if (n10 != 121) break;
                Map map5 = WorldMap.createArea(map, n, n2);
                map5.set("IsHostile", 1);
                map5.addThing(Game.hero(), 32, 32);
                map5.addThing(thing4, 32, 36);
                int n11 = thing.getLevel();
                for (int i = 0; i < 2 + n11; ++i) {
                    map5.addThing(Lib.createType("IsGoblinoid", n11), thing.x - 3, thing.y + 1, thing.x + 3, thing.y + 4);
                }
                break;
            }
        }
    }

    private static Map createArea(Map map, int n, int n2) {
        Map map2 = Outdoors.create(map.getTile(n, n2));
        Portal.setDestination(map2.getEntrance(), map, n, n2);
        return map2;
    }

    public static Map createWorld() {
        Map map = Portal.loadFromFile("/maps/world/karrain.txt");
        map.set("EnterMessage", "This fertile valley is known as North Karrain");
        map.set("OnAction", new EncounterAction());
        return map;
    }

    private static class EncounterAction
    extends Script {
        private static final long serialVersionUID = -5212739439548360407L;

        private EncounterAction() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = Game.hero();
            WorldMap.encounter(thing2.getMap(), thing2.x, thing2.y);
            return false;
        }
    }
}

