/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Damage;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Missile;
import mikera.tyrant.Modifier;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Scripts;
import mikera.tyrant.Text;
import mikera.tyrant.Thing;

public class Weapon {
    private static final double WEAPON_DAMAGE_MULTIPLIER = 0.5;
    private static String[] wmat = new String[]{"stone", "iron", "steel", "silver", "elven steel", "mithril", "krithium", "black steel", "blue steel", "red steel", "crystal", "parillite", "sapphire", "emerald"};
    private static String[] umat = new String[]{"heavy", null, null, "silvery", "shining", "silvery", "heavy", "dark", "silvery", null, "shining", "shining", "shimmering blue", "shimmering green"};
    private static int[] levels = new int[]{2, 3, 7, 9, 12, 20, 16, 21, 15, 18, 60, 27, 24, 30};
    private static int[] weights = new int[]{140, 100, 90, 80, 70, 50, 160, 130, 80, 100, 60, 40, 65, 60};
    private static int[] freqs = new int[]{40, 100, 70, 20, 50, 20, 40, 50, 50, 60, 40, 30, 20, 10};
    private static int[] skills = new int[]{80, 100, 105, 100, 120, 140, 80, 100, 150, 110, 140, 170, 190, 210};
    private static int[] strs = new int[]{90, 100, 110, 90, 120, 130, 140, 170, 110, 150, 140, 200, 160, 210};

    public static int attack(Thing thing, Thing thing2, Thing thing3) {
        int n;
        int n2;
        int n3 = Weapon.calcASK(thing, thing2, thing3);
        int n4 = n2 = RPG.test(n3, n = Weapon.calcDSK(thing3), thing2, thing3) ? 1 : 0;
        if (thing3.isVisible(Game.hero()) && n2 == 0) {
            Game.message(Text.capitalise(thing2.getTheName() + (thing2.isHero() ? " miss " : " misses ") + thing3.getTheName()));
        }
        return n2;
    }

    public static double slayingModifier(Thing thing, Thing thing2) {
        if (thing2 == null) {
            return 1.0;
        }
        double d = 1.0;
        String string = thing.getString("SlayingStats");
        if (string != null) {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (stringArray.length <= 0) continue;
                int n = string2.indexOf("*");
                if (n <= 0) {
                    throw new Error("Invalid damage modifier [" + string2 + "]");
                }
                String string3 = string2.substring(0, n).trim();
                if (!thing2.getFlag(string3)) continue;
                d *= Double.parseDouble(string2.substring(n + 1, string2.length()));
            }
        }
        return d;
    }

    public static int hit(Thing thing, Thing thing2, Thing thing3) {
        boolean bl;
        Object object;
        int n = Weapon.calcAST(thing, thing2, thing3);
        double d = 1.0 - (double)RPG.luckRandom(thing2, thing3);
        int n2 = RPG.round((double)n * d * 0.5);
        if (thing2.handles("OnHit")) {
            object = new Event("Hit");
            ((BaseObject)object).set("Wielder", thing2);
            ((BaseObject)object).set("Weapon", thing);
            ((BaseObject)object).set("Target", thing3);
            ((BaseObject)object).set("AST", n);
            if (thing2.handle((Event)object)) {
                return ((BaseObject)object).getStat("Damage");
            }
        }
        if (thing.handles("OnWeaponHit")) {
            object = new Event("WeaponHit");
            ((BaseObject)object).set("Wielder", thing2);
            ((BaseObject)object).set("Target", thing3);
            ((BaseObject)object).set("AST", n);
            if (thing.handle((Event)object)) {
                return ((BaseObject)object).getStat("Damage");
            }
            n2 = ((BaseObject)object).getStat("AST");
        }
        Game.instance().pushMessages();
        object = thing.getString("WeaponDamageType");
        if (object == null) {
            throw new Error(thing.name() + " has no WeaponDamageType!");
        }
        String string = thing2.getTheName();
        String string2 = thing3.getTheName();
        n2 = Damage.inflict(thing3, n2, (String)object);
        int n3 = Weapon.getExtraAST(thing, thing2);
        if (n3 > 0) {
            n3 = Damage.inflict(thing3, n3, thing.getString("ExtraDamageType"));
            n2 += n3;
        }
        Item.touch(thing.getFlag("IsAttack") ? thing2 : thing, thing3);
        String string3 = "";
        if (Game.isDebug()) {
            // empty if block
        }
        String string4 = n2 > 0 ? "causing " + Damage.describeState(thing3) + " damage" : "but fail" + (thing2.isHero() ? "" : "s") + " to do any damage";
        ArrayList arrayList = Game.instance().popMessages();
        Thing thing4 = Game.hero();
        boolean bl2 = bl = thing2.isVisible(thing4) || thing3.isVisible(thing4);
        if (thing2 == thing4 || thing3 == thing4) {
            bl = true;
        }
        if (bl) {
            if (thing3.isDead() && thing3.getFlag("IsBeing")) {
                Game.message(Text.capitalise(string + (thing2.isHero() ? " have slain " : " has slain ") + string2));
            } else {
                Game.message(Text.capitalise(string3 + string + " " + Weapon.hitVerb(thing2, thing) + " " + string2 + " " + string4));
            }
        }
        Game.message(arrayList);
        if (n2 > 0 && thing.handles("OnWeaponDamage")) {
            Event event = new Event("WeaponDamage");
            event.set("Wielder", thing2);
            event.set("Damage", n2);
            event.set("Target", thing3);
            thing.handle(event);
            n2 = thing.getStat("Damage");
        }
        return n2;
    }

    private static String hitVerb(Thing thing, Thing thing2) {
        String string = thing2.getString("HitVerb");
        if (string == null) {
            Game.warn("no hit verb for " + thing2.name());
            string = thing.isHero() ? "hit" : "hits";
        } else {
            String[] stringArray = string.split("/");
            string = thing.isHero() ? stringArray[0] : stringArray[1];
        }
        return string;
    }

    public static int getDSK(Thing thing, Thing thing2) {
        int n = thing2.getStat("SK");
        double d = (0.7 + 0.3 * (double)thing2.getStat("Defence")) * (double)thing.getStat("DSKMul");
        if (thing.getFlag("IsUnarmedWeapon")) {
            d *= 1.0 + 0.3 * (double)thing2.getStat("Unarmed Combat");
        }
        if (thing.getFlag("IsCursed")) {
            d *= 0.6;
        }
        if (thing.getFlag("IsBlessed")) {
            d *= 1.2;
        }
        n = (int)((double)n * d / 100.0);
        return n += thing.getStat("DSKBonus");
    }

    public static int calcASK(Thing thing, Thing thing2, Thing thing3) {
        double d = Weapon.getASK(thing, thing2);
        int n = thing2.getStat("Encumberance");
        if (n > 0) {
            n = RPG.min(100, n);
            d = d * (double)(100 - n) / 100.0;
        }
        return RPG.max(1, (int)Math.round(d *= Weapon.slayingModifier(thing, thing3)));
    }

    public static int getASK(Thing thing, Thing thing2) {
        int n = thing2.getStat("SK");
        double d = (1.0 + 0.3 * (double)thing2.getStat("Attack")) * (double)thing.getStat("ASKMul");
        if (thing.getFlag("IsUnarmedWeapon")) {
            d *= 1.0 + 0.3 * (double)thing2.getStat("Unarmed Combat");
        }
        if (thing.getFlag("IsCursed")) {
            d *= 0.8;
        }
        if (thing.getFlag("IsBlessed")) {
            d *= 1.2;
        }
        n = (int)((double)n * d / 100.0);
        return n += thing.getStat("ASKBonus");
    }

    public static int calcAST(Thing thing, Thing thing2, Thing thing3) {
        double d = (double)Weapon.getAST(thing, thing2) * Weapon.slayingModifier(thing, thing3);
        if (d <= 0.0) {
            return 0;
        }
        return RPG.max(1, (int)d);
    }

    public static int getAST(Thing thing, Thing thing2) {
        double d = thing2.getStat("ST");
        double d2 = (1.0 + 0.1 * (double)thing2.getStat("Attack")) * (double)thing.getStat("ASTMul");
        if (thing.getFlag("IsUnarmedWeapon")) {
            d2 *= 1.0 + 0.1 * (double)thing2.getStat("Unarmed Combat");
        }
        if (thing.getFlag("IsCursed")) {
            d2 *= 0.8;
        }
        if (thing.getFlag("IsBlessed")) {
            d2 *= 1.2;
        }
        d = d * d2 / 100.0;
        return (int)(d += (double)thing.getStat("ASTBonus"));
    }

    public static int getExtraAST(Thing thing, Thing thing2) {
        int n = thing2.getStat("ST");
        n = n * thing.getStat("ExtraASTMultiplier") / 100;
        return n += thing.getStat("ExtraASTBonus");
    }

    public static int calcDSK(Thing thing) {
        BaseObject baseObject;
        int n;
        double d = 0.0;
        Thing[] thingArray = thing.getInventory();
        for (n = 0; n < thingArray.length; ++n) {
            baseObject = thingArray[n];
            if (baseObject == null || ((Thing)baseObject).y <= 0) continue;
            d += (double)Weapon.getDSK((Thing)baseObject, thing);
        }
        d += (double)thing.getStat("AG") * (0.2 + 0.6 * (double)thing.getStat("Dodge"));
        d += (double)(thing.getStat("SK") * thing.getStat("Unarmed Combat")) * 0.2;
        n = thing.getStat("Encumberance");
        if (n > 0) {
            d = d * (double)(100 - n) / 100.0;
        }
        if ((baseObject = thing.getMap()) != null) {
            int n2 = 0;
            Thing[] thingArray2 = ((Map)baseObject).getObjects(thing.x - 1, thing.y - 1, thing.x + 1, thing.y + 1, "IsBeing");
            for (int i = 0; i < thingArray2.length; ++i) {
                if (!thingArray2[i].isHostile(thing)) continue;
                ++n2;
            }
            if ((n2 -= thing.getStat("Bravery")) > 1) {
                d /= (double)n2;
            }
        }
        return RPG.max(0, (int)Math.round(d));
    }

    public static Thing createWeapon(int n) {
        return Lib.createWeapon(n);
    }

    public static void init() {
        Thing thing = Lib.extend("base weapon", "base item");
        thing.set("Image", 2);
        thing.set("IsWeapon", 1);
        thing.set("WieldType", 1);
        thing.set("WeaponDamageType", "normal");
        thing.set("HPS", 40);
        thing.set("ValueBase", 200);
        thing.set("ItemWeight", 6000);
        thing.set("Frequency", 50);
        thing.set("AttackCost", 100);
        thing.set("DamageLevels", 1);
        thing.set("RES:acid", -15);
        thing.set("LevelMin", 1);
        thing.set("HitVerb", "hit/hits");
        thing.set("ASCII", "(");
        Lib.add(thing);
        Weapon.initCrudeWeapons();
        Weapon.initSpears();
        Weapon.initStandardWeapons();
        Weapon.initSpecialWeapons();
        Weapon.initAttacks();
        Weapon.initAlterations();
    }

    public static String statString(Thing thing) {
        int n = thing.getStat("ASKMul") / 10;
        int n2 = thing.getStat("ASTMul") / 10;
        int n3 = thing.getStat("DSKMul") / 10;
        return "[+" + n + " +" + n2 + " +" + n3 + "]";
    }

    private static void initSpears() {
        Thing thing = Lib.extend("spear", "base weapon");
        thing.set("MissileType", "thrown");
        thing.set("IsThrowingWeapon", 1);
        thing.set("MissileRecovery", 95);
        thing.set("Image", 21);
        thing.set("LevelMin", 1);
        thing.set("ItemWeight", 5000);
        thing.set("WeaponDamageType", "piercing");
        thing.set("Frequency", 50);
        Weapon.setStats(thing, 60, 0, 70, 1, 50, 1);
        Missile.setStats(thing, 60, 0, 8, 3);
        Weapon.addWeapon(thing);
    }

    public static void setStats(Thing thing, int n, int n2, int n3, int n4, int n5, int n6) {
        thing.set("ASKMul", n);
        thing.set("ASKBonus", n2);
        thing.set("ASTMul", n3);
        thing.set("ASTBonus", n4);
        thing.set("DSKMul", n5);
        thing.set("DSKBonus", n6);
    }

    public static void addWithVariants(Thing thing) {
        for (int i = 0; i < wmat.length; ++i) {
            Thing thing2 = (Thing)thing.clone();
            String string = thing.getString("Name");
            thing2.set("Name", wmat[i] + " " + string);
            thing2.set("Material", wmat[i]);
            thing2.set("UName", umat[i] == null ? string : umat[i] + " " + string);
            thing2.multiplyStat("ItemWeight", (double)weights[i] / 100.0);
            thing2.set("LevelMin", RPG.max(1, levels[i] + thing.getStat("LevelMin")));
            thing2.multiplyStat("Frequency", (double)freqs[i] / 100.0);
            thing2.multiplyStat("AttackCost", Math.sqrt((double)weights[i] / 100.0));
            thing2.multiplyStat("ASKMul", (double)skills[i] / 100.0);
            thing2.multiplyStat("ASKBonus", (double)skills[i] / 100.0);
            thing2.multiplyStat("DSKMul", (double)skills[i] / 100.0);
            thing2.multiplyStat("DSKBonus", (double)skills[i] / 100.0);
            thing2.multiplyStat("ASTMul", (double)strs[i] / 100.0);
            thing2.multiplyStat("ASTBonus", (double)strs[i] / 100.0);
            thing2.multiplyStat("HPS", Math.pow(80.0, (double)strs[i] / 100.0 - 1.0));
            Weapon.addWeapon(thing2);
        }
    }

    private static void addWeapon(Thing thing) {
        thing.set("LevelMax", thing.getStat("LevelMin") * 3 / 2 + 5);
        Lib.add(thing);
    }

    public static void initStandardWeapons() {
        Thing thing = Lib.extend("base standard weapon", "base weapon");
        thing.set("DefaultThing", "3% [IsWeaponRune],3% [IsWeaponRune]");
        thing.set("ValueBase", 200);
        Lib.add(thing);
        thing = Lib.extend("base sword", "base standard weapon");
        thing.set("IsSword", 1);
        thing.set("ValueBase", 300);
        thing.set("HitVerb", "slash/slashes");
        Lib.add(thing);
        thing = Lib.extend("base dagger", "base sword");
        thing.set("IsSword", 0);
        thing.set("IsDagger", 1);
        thing.set("ValueBase", 100);
        thing.set("HitVerb", "stab/stabs");
        Lib.add(thing);
        thing = Lib.extend("longsword", "base sword");
        thing.set("Image", 3);
        thing.set("LevelMin", 7);
        thing.set("Frequency", 100);
        thing.set("ItemWeight", 8000);
        Weapon.setStats(thing, 80, 0, 80, 0, 40, 0);
        thing.set("ValueBase", 400);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("broadsword", "base sword");
        thing.set("Image", 3);
        thing.set("LevelMin", 6);
        thing.set("Frequency", 60);
        thing.multiplyStat("AttackCost", 1.2);
        thing.set("ItemWeight", 10000);
        thing.set("ValueBase", 400);
        Weapon.setStats(thing, 60, 0, 100, 0, 40, 0);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("scimitar", "base sword");
        thing.set("Image", 61);
        thing.set("LevelMin", 6);
        thing.set("Frequency", 50);
        thing.set("ItemWeight", 7000);
        Weapon.setStats(thing, 80, 1, 90, 1, 30, 1);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("sword", "base sword");
        thing.set("Image", 3);
        thing.set("LevelMin", 5);
        Weapon.setStats(thing, 70, 0, 70, 1, 40, 0);
        thing.set("ItemWeight", 6000);
        thing.set("Frequency", 100);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("short sword", "base sword");
        thing.set("Image", 5);
        thing.set("LevelMin", 4);
        Weapon.setStats(thing, 60, 1, 65, 1, 35, 1);
        thing.set("ItemWeight", 4000);
        thing.set("Frequency", 100);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("dagger", "base dagger");
        thing.set("Image", 2);
        thing.set("LevelMin", 2);
        thing.set("Frequency", 100);
        thing.set("ItemWeight", 2500);
        thing.set("AttackCost", 75);
        Weapon.setStats(thing, 50, 0, 60, 1, 30, 0);
        thing.set("ValueBase", 200);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("knife", "base dagger");
        thing.set("Image", 0);
        thing.set("LevelMin", 0);
        thing.set("Frequency", 100);
        thing.set("ItemWeight", 1500);
        thing.set("AttackCost", 60);
        Weapon.setStats(thing, 50, 0, 50, 1, 20, 1);
        thing.set("ValueBase", 100);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("two-handed sword", "base sword");
        thing.set("Image", 4);
        thing.set("LevelMin", 7);
        thing.set("Frequency", 30);
        thing.set("ItemWeight", 12000);
        Weapon.setStats(thing, 100, 0, 110, 0, 60, 0);
        thing.set("WieldType", 3);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("base hammer", "base standard weapon");
        thing.set("IsHammer", 1);
        thing.set("WeaponDamageType", "impact");
        thing.multiplyStat("AttackCost", 1.2);
        thing.set("HitVerb", "bash/bashes");
        Lib.add(thing);
        thing = Lib.extend("hammer", "base hammer");
        thing.set("Image", 9);
        thing.set("LevelMin", 3);
        thing.set("Frequency", 50);
        thing.set("ItemWeight", 8000);
        Weapon.setStats(thing, 45, 0, 70, 1, 20, 1);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("warhammer", "base hammer");
        thing.set("Image", 10);
        thing.set("LevelMin", 5);
        thing.set("Frequency", 50);
        thing.set("WieldType", 3);
        thing.set("ItemWeight", 16000);
        Weapon.setStats(thing, 60, 0, 150, 5, 5, -4);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("base axe", "base standard weapon");
        thing.set("IsAxe", 1);
        thing.set("Frequency", 50);
        thing.set("HitVerb", "chop/chops");
        Lib.add(thing);
        thing = Lib.extend("battle axe", "base axe");
        thing.set("Image", 11);
        thing.set("LevelMin", 6);
        thing.set("WieldType", 3);
        thing.set("ItemWeight", 14000);
        Weapon.setStats(thing, 70, 0, 140, 5, 20, -2);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("hand axe", "base axe");
        thing.set("Image", 12);
        thing.set("LevelMin", 3);
        thing.set("ItemWeight", 7000);
        Weapon.setStats(thing, 45, 0, 75, 2, 20, 0);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("base polearm", "base standard weapon");
        thing.set("IsPolearm", 1);
        Lib.add(thing);
        thing = Lib.extend("trident", "base polearm");
        thing.set("Image", 23);
        thing.set("IsTrident", 1);
        thing.set("LevelMin", 5);
        thing.set("ItemWeight", 6000);
        thing.set("Frequency", 30);
        Weapon.setStats(thing, 50, 0, 70, 4, 60, 3);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("halberd", "base polearm");
        thing.set("Image", 27);
        thing.set("LevelMin", 6);
        thing.set("ItemWeight", 12000);
        thing.set("WieldType", 3);
        thing.set("Frequency", 30);
        thing.set("IsHalberd", 1);
        Weapon.setStats(thing, 60, 0, 120, 0, 80, 0);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("base mace", "base standard weapon");
        thing.set("IsMace", 1);
        Lib.add(thing);
        thing = Lib.extend("mace", "base mace");
        thing.set("Image", 44);
        thing.set("LevelMin", 4);
        thing.set("ItemWeight", 7000);
        thing.set("Frequency", 50);
        Weapon.setStats(thing, 45, 0, 75, 1, 30, 0);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("two-handed mace", "base mace");
        thing.set("Image", 44);
        thing.set("LevelMin", 5);
        thing.set("ItemWeight", 14000);
        thing.set("WieldType", 3);
        thing.set("Frequency", 30);
        Weapon.setStats(thing, 50, 0, 150, 0, 20, -3);
        Weapon.addWithVariants(thing);
        thing = Lib.extend("morning star", "base mace");
        thing.set("Image", 45);
        thing.set("LevelMin", 4);
        thing.set("ItemWeight", 11000);
        thing.set("WieldType", 3);
        thing.set("Frequency", 20);
        thing.multiplyStat("AttackCost", 1.3);
        Weapon.setStats(thing, 60, -3, 180, -4, 30, 0);
        Weapon.addWithVariants(thing);
    }

    public static void initCrudeWeapons() {
        Thing thing = Lib.extend("stick", "base weapon");
        Weapon.setStats(thing, 50, 1, 20, 2, 30, 3);
        thing.set("Image", 40);
        thing.set("LevelMin", 1);
        thing.set("Frequency", 100);
        thing.set("ItemWeight", 1000);
        thing.set("ValueBase", 30);
        thing.set("Material", "wood");
        thing.set("HitVerb", "strike/strikes");
        Weapon.addWeapon(thing);
        thing = Lib.extend("bone", "stick");
        Weapon.setStats(thing, 40, 2, 15, 3, 15, 3);
        thing.set("IsEdible", 1);
        thing.set("Nutrition", 3);
        thing.set("ItemWeight", 2000);
        thing.set("Frequency", 50);
        thing.set("ValueBase", 20);
        thing.set("WeaponDamageType", "impact");
        thing.set("Material", "bone");
        thing.set("Image", 302);
        Weapon.addWeapon(thing);
        thing = Lib.extend("large bone", "stick");
        Weapon.setStats(thing, 40, 2, 20, 3, 15, 3);
        thing.set("IsEdible", 1);
        thing.set("Nutrition", 3);
        thing.set("ItemWeight", 4000);
        thing.set("Frequency", 30);
        thing.set("ValueBase", 30);
        thing.set("WeaponDamageType", "impact");
        thing.set("Material", "bone");
        thing.set("Image", 302);
        Weapon.addWeapon(thing);
        thing = Lib.extend("huge bone", "bone");
        thing.set("ItemWeight", 7000);
        thing.set("Frequency", 25);
        thing.set("ValueBase", 40);
        thing.set("WieldType", 3);
        thing.set("HitVerb", "bash/bashes");
        Weapon.setStats(thing, 40, 2, 35, 6, 20, 4);
        Weapon.addWeapon(thing);
        thing = Lib.extend("wooden club", "stick");
        thing.set("IsClub", 1);
        Weapon.setStats(thing, 40, 1, 55, 3, 20, 1);
        thing.set("Image", 26);
        thing.set("LevelMin", 1);
        thing.set("ItemWeight", 8000);
        thing.set("Frequency", 50);
        thing.set("WeaponDamageType", "impact");
        thing.set("WieldType", 3);
        thing.set("Material", "wood");
        thing.set("HitVerb", "bash/bashes");
        Weapon.addWeapon(thing);
        thing = Lib.extend("stone club", "wooden club");
        Weapon.setStats(thing, 35, 1, 70, 5, 20, 0);
        thing.set("Image", 25);
        thing.set("ItemWeight", 16000);
        thing.set("LevelMin", 3);
        thing.multiplyStat("AttackCost", 1.3);
        thing.set("Material", "stone");
        Weapon.addWeapon(thing);
        thing = Lib.extend("spiked club", "wooden club");
        Weapon.setStats(thing, 40, 1, 70, 8, 20, 3);
        thing.set("Image", 50);
        thing.set("WeaponDamageType", "piercing");
        thing.set("ItemWeight", 10000);
        thing.set("LevelMin", 5);
        thing.set("Material", "wood");
        Weapon.addWeapon(thing);
        thing = Lib.extend("cudgel", "stick");
        Weapon.setStats(thing, 40, 2, 70, 5, 20, 2);
        thing.set("Image", 260);
        thing.set("ItemWeight", 7000);
        thing.set("LevelMin", 6);
        Weapon.addWeapon(thing);
        thing = Lib.extend("scythe", "stick");
        Weapon.setStats(thing, 60, 0, 100, 0, 50, 0);
        thing.set("WieldType", 3);
        thing.set("WeaponDamageType", "normal");
        thing.set("Image", 49);
        thing.set("ItemWeight", 5000);
        thing.set("LevelMin", 5);
        Weapon.addWeapon(thing);
        thing = Lib.extend("wooden staff", "stick");
        Weapon.setStats(thing, 50, 1, 35, 1, 90, 2);
        thing.set("IsStaff", 1);
        thing.set("Image", 60);
        thing.set("ItemWeight", 4000);
        thing.set("ValueBase", 60);
        thing.multiplyStat("Frequency", 0.5);
        thing.set("WieldType", 3);
        thing.set("WeaponDamageType", "impact");
        thing.set("DefaultThings", "5% [IsWeaponRune]");
        thing.set("LevelMin", 1);
        Weapon.addWeapon(thing);
        thing = Lib.extend("heavy staff", "wooden staff");
        Weapon.setStats(thing, 50, -1, 70, -2, 80, 1);
        thing.set("Image", 60);
        thing.set("ItemWeight", 8000);
        thing.set("WieldType", 3);
        thing.set("WeaponDamageType", "impact");
        thing.set("LevelMin", 3);
        Weapon.addWeapon(thing);
        thing = Lib.extend("wooden log", "stick");
        Weapon.setStats(thing, 40, -5, 120, -5, 0, 0);
        thing.set("Frequency", 5);
        thing.set("Image", 64);
        thing.set("ItemWeight", 30000);
        thing.set("WieldType", 3);
        thing.set("WeaponDamageType", "impact");
        thing.set("LevelMin", 7);
        Weapon.addWeapon(thing);
        thing = Lib.extend("quarterstaff", "wooden staff");
        Weapon.setStats(thing, 50, 0, 50, 0, 120, 2);
        thing.set("Image", 60);
        thing.set("ItemWeight", 6000);
        thing.set("WieldType", 3);
        thing.set("ValueBase", 100);
        thing.set("LevelMin", 5);
        Weapon.addWeapon(thing);
        thing = Lib.extend("magic staff", "quarterstaff");
        thing.set("UName", "quarterstaff");
        thing.set("IsMagicItem", 1);
        thing.set("LevelMin", 7);
        thing.multiplyStat("Frequency", 0.5);
        thing.set("DefaultThings", "[IsWeaponRune],10% [IsWeaponRune]");
        Lib.add(thing);
        thing = Lib.extend("staff of defence", "quarterstaff");
        thing.set("UName", "quarterstaff");
        Weapon.setStats(thing, 65, 0, 40, 0, 160, 20);
        thing.set("Armour", 6);
        thing.set("ItemWeight", 5000);
        thing.set("LevelMin", 9);
        thing.multiplyStat("Frequency", 0.3);
        Weapon.addWeapon(thing);
        thing = Lib.extend("staff of smiting", "quarterstaff");
        thing.set("UName", "quarterstaff");
        Weapon.setStats(thing, 80, 0, 80, 20, 120, 3);
        thing.set("ItemWeight", 7000);
        thing.set("LevelMin", 11);
        thing.multiplyStat("Frequency", 0.3);
        Weapon.addWeapon(thing);
        thing = Lib.extend("staff of cursing", "quarterstaff");
        thing.set("UName", "quarterstaff");
        Weapon.setStats(thing, 80, 0, 80, 0, 120, 3);
        thing.set("ItemWeight", 6000);
        thing.set("LevelMin", 13);
        thing.multiplyStat("Frequency", 0.2);
        thing.set("OnWeaponDamage", Weapon.damageEffect("curse"));
        Weapon.addWeapon(thing);
    }

    public static Script damageEffect(String string) {
        Thing thing = Lib.create(string);
        Script script = Scripts.addEffect("Target", thing);
        return script;
    }

    public static void initAttacks() {
        Thing thing = Lib.extend("base attack", "base weapon");
        thing.set("IsAttack", 1);
        thing.set("IsUnarmedWeapon", 1);
        thing.set("Frequency", 0);
        Weapon.setStats(thing, 40, 0, 40, 0, 20, 0);
        Lib.add(thing);
        thing = Lib.extend("unarmed attack", "base attack");
        thing.set("WeaponDamageType", "unarmed");
        thing.set("HitVerb", "clumsily hit/clumsily hits");
        thing.set("AttackCost", 150);
        Weapon.setStats(thing, 40, 0, 25, 1, 10, 0);
        Lib.add(thing);
        thing = Lib.extend("kick attack", "base attack");
        thing.set("WeaponDamageType", "impact");
        thing.set("HitVerb", "kick/kicks");
        Weapon.setStats(thing, 40, 0, 50, 0, 20, 0);
        Lib.add(thing);
        thing = Lib.extend("bite attack", "base attack");
        thing.set("HitVerb", "bite/bites");
        Weapon.setStats(thing, 50, 0, 70, 0, 20, 0);
        Lib.add(thing);
        thing = Lib.extend("claw attack", "base attack");
        Weapon.setStats(thing, 60, 0, 60, 0, 50, 0);
        thing.set("HitVerb", "claw/claws");
        thing.set("AttackCost", 75);
        Lib.add(thing);
        thing = Lib.extend("razor claw attack", "base attack");
        Weapon.setStats(thing, 60, 0, 100, 0, 50, 0);
        thing.set("HitVerb", "claw/claws");
        thing.set("AttackCost", 75);
        Lib.add(thing);
        thing = Lib.extend("bash attack", "base attack");
        Weapon.setStats(thing, 60, 0, 60, 0, 50, 0);
        thing.set("WeaponDamageType", "impact");
        thing.set("HitVerb", "bash/bashes");
        thing.set("AttackCost", 100);
        Lib.add(thing);
        thing = Lib.extend("poison attack", "base attack");
        Weapon.setStats(thing, 60, 0, 60, 0, 40, 0);
        thing.set("OnWeaponDamage", Weapon.damageEffect("poison"));
        Lib.add(thing);
        thing = Lib.extend("strong poison attack", "base attack");
        Weapon.setStats(thing, 60, 0, 60, 0, 40, 0);
        thing.set("OnWeaponDamage", Weapon.damageEffect("strong poison"));
        Lib.add(thing);
        thing = Lib.extend("poison whip attack", "base attack");
        Weapon.setStats(thing, 60, 0, 60, 0, 40, 0);
        thing.set("HitVerb", "whip/whips");
        thing.set("WeaponDamageType", "poison");
        thing.set("OnWeaponDamage", Weapon.damageEffect("extreme poison"));
        Lib.add(thing);
        thing = Lib.extend("blind attack", "base attack");
        Weapon.setStats(thing, 60, 0, 60, 0, 40, 0);
        thing.set("OnWeaponDamage", Weapon.damageEffect("curse of blindness"));
        Lib.add(thing);
        thing = Lib.extend("curse attack", "base attack");
        Weapon.setStats(thing, 60, 0, 60, 0, 25, 0);
        thing.set("OnWeaponDamage", Weapon.damageEffect("curse"));
        Lib.add(thing);
        thing = Lib.extend("hex attack", "base attack");
        Weapon.setStats(thing, 60, 0, 60, 0, 25, 0);
        thing.set("OnWeaponDamage", Weapon.damageEffect("hex"));
        Lib.add(thing);
        thing = Lib.extend("chill attack", "base attack");
        Weapon.setStats(thing, 60, 0, 60, 0, 40, 0);
        thing.set("WeaponDamageType", "chill");
        Lib.add(thing);
        thing = Lib.extend("ice attack", "base attack");
        Weapon.setStats(thing, 60, 0, 60, 0, 40, 0);
        thing.set("WeaponDamageType", "ice");
        Lib.add(thing);
        thing = Lib.extend("fire attack", "base attack");
        Weapon.setStats(thing, 60, 0, 60, 0, 40, 0);
        thing.set("WeaponDamageType", "fire");
        Lib.add(thing);
        thing = Lib.extend("acid attack", "base attack");
        Weapon.setStats(thing, 60, 0, 60, 0, 25, 0);
        thing.set("WeaponDamageType", "acid");
        Lib.add(thing);
        thing = Lib.extend("drain attack", "base attack");
        Weapon.setStats(thing, 60, 0, 60, 0, 25, 0);
        thing.set("WeaponDamageType", "drain");
        Lib.add(thing);
        thing = Lib.extend("disintegrate attack", "base attack");
        Weapon.setStats(thing, 60, 0, 60, 0, 25, 0);
        thing.set("WeaponDamageType", "disintegrate");
        Lib.add(thing);
    }

    public static void initAlterations() {
        Thing thing = Lib.extend("base weapon alteration", "base thing");
        thing.set("IsAlteration", 1);
        thing.set("NoStack", 1);
        thing.set("LevelMin", 1);
        thing.set("AlterationType", "IsWeapon");
        Lib.add(thing);
        thing = Lib.extend("flaming alteration", "base weapon alteration");
        thing.add("CarriedModifiers", Modifier.constant("Adjective", "flaming"));
        thing.add("CarriedModifiers", Modifier.constant("ExtraDamageType", "fire"));
        thing.add("CarriedModifiers", Modifier.bonus("ExtraASTBonus", RPG.d(3, 6)));
        Lib.add(thing);
        thing = Lib.extend("accuracy alteration", "base weapon alteration");
        thing.add("CarriedModifiers", Modifier.linear("ASKMul", 200, 0));
        Lib.add(thing);
        thing = Lib.extend("smiting alteration", "base weapon alteration");
        thing.add("CarriedModifiers", Modifier.linear("ASTMul", 200, 0));
        Lib.add(thing);
    }

    public static void initSpecialWeapons() {
        Thing thing = Lib.extend("staff of mighty smiting", "quarterstaff");
        thing.multiplyStat("ASTMul", 3.0);
        thing.set("LevelMin", 17);
        Weapon.addWeapon(thing);
        thing = Lib.extend("mace of destruction", "blue steel mace");
        thing.multiplyStat("ASTMul", 2.0);
        thing.set("LevelMin", 20);
        Weapon.addWeapon(thing);
        thing = Lib.extend("sword of death", "krithium sword");
        thing.set("SlayingStats", "IsLiving*1.4");
        thing.set("LevelMin", 23);
        Weapon.addWeapon(thing);
        thing = Lib.extend("axe of slaying", "red steel hand axe");
        thing.set("SlayingStats", "IsLiving*1.7");
        thing.set("LevelMin", 27);
        Weapon.addWeapon(thing);
        thing = Lib.extend("vorpal sword", "black steel sword");
        thing.set("SlayingStats", "IsHumanoid*2.0");
        thing.set("LevelMin", 30);
        Weapon.addWeapon(thing);
        thing = Lib.extend("longsword of light", "elven steel longsword");
        thing.set("SlayingStats", "IsUndead*2.0");
        thing.set("LevelMin", 20);
        Weapon.addWeapon(thing);
        thing = Lib.extend("crystal whirlwind dagger", "crystal dagger");
        thing.multiplyStat("AttackCost", 0.4);
        thing.set("LevelMin", 26);
        Weapon.addWeapon(thing);
    }
}

