/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.Date;
import mikera.tyrant.AI;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Event;
import mikera.tyrant.Fire;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Maze;
import mikera.tyrant.Outdoors;
import mikera.tyrant.Portal;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Scroll;
import mikera.tyrant.Special;
import mikera.tyrant.Thing;

public class Tutorial {
    public static Map buildLoft() {
        Map map = new Map(5, 9);
        map.setTheme("caves");
        map.set("Level", 1);
        map.set("Description", "Small Loft");
        map.fillArea(1, 1, 3, 3, map.floor());
        map.setEntrance(Lib.create("ladder down"));
        map.addThing(map.getEntrance(), 1, 1);
        map.setTile(2, 4, map.floor());
        Thing thing = Lib.create("trapped black door");
        thing.set("KeyName", "inn loft key");
        map.addThing(thing, 2, 4);
        map.addThing(Special.messagePoint("To open the door to the south, you need a key."), 2, 3);
        map.fillArea(1, 5, 3, 7, map.floor());
        map.addThing(Special.messagePoint("To the south of you is a chest. You can try to open it by running into it. It may be locked, in which case you will either need to break it open or find a way to unlock it. If you manage to open it and find an item inside, press \",\" to pick it up."), 2, 6);
        map.addThing(Lib.create("[IsChest]"), 2, 7);
        map.replaceTiles(0, map.wall());
        return map;
    }

    public static Map buildCellar() {
        int n;
        Map map = new Map(25, 25);
        map.setTheme("caves");
        map.set("Level", 1);
        map.set("Description", "The Dark Cellar");
        map.setEntrance(Lib.create("stairs up"));
        map.fillArea(1, 1, 5, 5, 9);
        map.addThing(map.getEntrance(), 2, 2);
        Thing thing = Game.hero();
        if (thing.getFlag("Literacy")) {
            map.addThing(Scroll.note("note", "Rotchy - There are too many rats down here. It is getting dangerous. See if you can find some poison next time you go to the town."), 3, 3);
            map.addThing(Special.messagePoint("There is a note here on the ground. You can pick it up with the \",\" key. Because you are have the Literacy skill, you can then press \"r\" to read it."), 3, 3);
        }
        Maze.buildMaze(map, 6, 0, 12, 12);
        map.setTile(6, 3, 9);
        map.addThing(Lib.create("portcullis"), 6, 3);
        map.addThing(Special.messagePoint("These twisty passages have a strange, almost labyrinthine design. Perhaps this cellar was once an old dungeon."), 6, 3);
        map.fillArea(1, 7, 5, 11, map.floor());
        map.setTile(6, 11, map.floor());
        map.addThing(Lib.create("door"), 6, 11);
        map.addThing(Special.messagePoint("You can hear the scurrying of rats behind this door. Are you ready to fight? To prepare for battle, you can press \"w\" to wield a weapon or wear armour. To attack an opponent, just run into it with the cursor keys."), 7, 11);
        for (n = 0; n < 6; ++n) {
            map.addThing(Lib.create("[IsRat]"), 1, 7, 5, 11);
        }
        map.addThing(Special.messagePoint("Sometimes there are hidden areas within dungeons. Press \"s\" to search your current surroundings."), 1, 11);
        map.addThing(Lib.create("secret door"), 1, 12);
        map.addThing(Special.messagePoint("There is a potion lying here. Potions often have magical properties that can greatly assist you in your adventures. However, it is dangerous to drink unidentified potions because some of them may have nasty side effects. You can quaff a potion by pressing the \"q\" key."), 1, 7);
        map.addThing(Lib.create("[IsPotion]"), 1, 7);
        map.fillArea(1, 13, 5, 17, map.floor());
        map.addThing(Lib.create("rat cave"), 2, 17);
        map.addThing(Lib.create("[IsFood]"), 3, 14);
        map.addThing(Special.messagePoint("If you become hungry during your adventures, you will need to find food. The item here can be eaten by picking it up and pressing \"e\""), 3, 14);
        map.addThing(Lib.create("[IsPotion]"), 4, 14);
        map.addThing(Lib.create("[IsSnake]"), 3, 14);
        map.addThing(Special.messagePoint("This small tunnel is too tight for you to enter. However, you could easily be surprised by rats coming out of it. Be careful!"), 2, 17);
        map.setTile(6, 15, map.floor());
        map.addThing(Lib.create("portcullis"), 6, 15);
        map.fillArea(7, 13, 12, 23, map.floor());
        for (n = 14; n <= 22; n += 2) {
            map.setTile(8, n, map.wall());
            map.setTile(11, n, map.wall());
        }
        map.addThing("bone", 9, 15);
        map.addThing(Special.messagePoint("Many items in Tyrant have multiple uses. A bone for example, can be wielded as a weapon by pressing \"w\". Alternatively, if you are feeling hungry you can eat it by pressing \"e\"."), 9, 15);
        map.setTile(6, 21, map.floor());
        map.addThing(Lib.create("rotten door"), 6, 21);
        map.fillArea(1, 19, 5, 23, map.floor());
        map.addThing(Lib.create("kobold"), 3, 21);
        Thing thing2 = Lib.create("inn loft key");
        map.addThing(thing2, 3, 21);
        map.fillArea(13, 1, 23, 3, map.floor());
        map.setTile(12, 3, map.floor());
        map.addThing("door", 12, 3);
        thing2 = Lib.createType("IsMonster", 2);
        map.addThing(Special.messagePoint("You hear something moving behind this door. Sounds like " + thing2.getAName() + "! If you open the door, be ready to fight. Wield your weapons and wear armour by pressing \"w\". In close combat, you can attack by simply running into the monster."), 11, 3);
        map.addThing(thing2, 15, 3);
        map.addThing(Special.messagePoint("This portcullis (to the south of you) can never be opened. It may be useful though, since you can always get a clear view of the room on the other side! Press \"l\" to look at a distant object."), 14, 3);
        for (int i = 14; i <= 22; i += 4) {
            map.setTile(i, 4, map.floor());
            map.addThing("invincible portcullis", i, 4);
            map.fillArea(i - 1, 5, i + 1, 7, map.floor());
            String string = RPG.pick(new String[]{"[IsChest]", "[IsStoreItem]", "[IsMonster]", "fire snake"});
            map.addThing(string, i, 6);
            if (string.equals("[IsChest]")) {
                map.addThing(Special.messagePoint("To the north of you is a chest. You can try to open it by running into it. It may be locked, in which case you will either need to break it open or find a way to unlock it. If you manage to open it and find an item inside, press \",\" to pick it up."), i, 7);
            }
            map.setTile(i, 8, map.floor());
            map.addThing("door", i, 8);
        }
        map.fillArea(13, 9, 23, 10, map.floor());
        map.makeRandomPath(13, 21, 18, 12, 14, 12, 21, 23, map.floor(), false);
        map.makeRandomPath(18, 12, 21, 23, 14, 12, 21, 23, map.floor(), false);
        map.setTile(14, 21, map.floor());
        map.setTile(23, 23, map.floor());
        map.addThing("[IsTrap]", 23, 23);
        map.addThing("[IsStoreItem]", 23, 23);
        map.setTile(22, 23, map.floor());
        map.addThing(Special.messagePoint("An item lies to the west, but be careful! It looks like a trap has been set. You can search for traps by pressing \"s\". If you have the disarm traps skill, you can attempt to disarm the trap by pressing \"a\" to apply the Disarm Trap skill. Otherwise, you can risk stepping onto the trap if you dare...."), 22, 23);
        map.setTile(18, 11, map.floor());
        map.addThing("locked door", 18, 11);
        map.addThing(Special.messagePoint("Some doors may be locked. You can unlock them if you have keys or lock picks and the Lockpicking skill. Otherwise, your best chance of getting through is kicking them down by pressing \"k\"."), 18, 12);
        map.set("WanderingRate", 0);
        map.replaceTiles(0, 10);
        return map;
    }

    public static Map buildTutorialMap() {
        Map map = new Map(25, 25);
        map.setTheme("village");
        map.set("Description", "The Tradepost Inn");
        map.set("Level", 1);
        Outdoors.buildOutdoors(map, 0, 0, 24, 24, 18);
        map.clearArea(0, 0, 18, 24);
        map.fillArea(6, 6, 14, 14, 10);
        map.fillArea(7, 7, 13, 13, 9);
        map.fillArea(3, 7, 6, 14, 10);
        map.fillArea(4, 8, 5, 13, 9);
        map.setTile(10, 14, 9);
        map.addThing(Fire.create(4), 10, 14);
        int n = 10;
        int n2 = 1;
        map.fillArea(n, n2, n + 4, n2 + 3, map.wall());
        map.fillArea(n + 1, n2 + 1, n + 3, n2 + 2, 5);
        map.setTile(n + 2, n2 + 3, 5);
        map.addThing("ornate door", n + 2, n2 + 3);
        map.addThing("stone altar", n + 2, n2 + 1);
        map.addThing(Special.messagePoint("The people of North Karrain are highly religious, and altars can be found throughout the land. You can pray for divine assistance at any time with the \"_\" key."), n + 2, n2 + 2);
        map.addThing("[IsWell]", 8, 2);
        for (n = 6; n <= 10; ++n) {
            map.addThing("tree", n, 0);
        }
        map.addThing("tree", 2, 0);
        map.addThing("bush", 1, 2);
        map.addThing("tree", 0, 3);
        map.addThing("tree", 0, 1);
        map.addThing("[IsWeapon]", 4, 0);
        map.addThing("tree", 16, 23);
        map.addThing("tree", 14, 23);
        map.addThing("tree", 14, 24);
        map.addThing("tree", 12, 24);
        map.setTile(0, 7, 17);
        map.fillArea(0, 8, 2, 9, 17);
        map.addThing(Special.messagePoint("This small backwater is easily crossable if you have the Swimming skill. Alternatively, you may be able to find a boat."), 1, 7);
        for (n = 20; n <= 23; ++n) {
            for (n2 = 1; n2 <= 5; ++n2) {
                if (RPG.d(2) != 1) continue;
                map.addThing(Lib.createType("IsHerb", RPG.d(6)), n2, n);
            }
        }
        map.addThing(Special.messagePoint("Herbs can be found wherever there is fertile soil. Many herbs are treasured for their magical properties. Masters of the Herb Lore skill are able to use them most effectively. Some herbs may be dangerous, so it is wise to identify them first."), 3, 22);
        n = 2;
        n2 = 1;
        map.fillArea(n, n2, n + 4, n2 + 6, map.wall());
        map.fillArea(n + 1, n2 + 1, n + 3, n2 + 2, 5);
        map.fillArea(n + 1, n2 + 4, n + 3, n2 + 5, 9);
        map.setTile(n + 2, n2 + 3, 5);
        map.setTile(n + 4, n2 + 4, 9);
        map.setTile(n + 0, n2 + 4, 9);
        map.addThing("stable door", n + 2, n2 + 3);
        map.addThing("stable door", n + 4, n2 + 4);
        map.addThing("portcullis", n + 0, n2 + 4);
        Object object = Lib.create("townswoman");
        AI.name((Thing)object, "Burtha");
        AI.setGuard((Thing)object, map, n + 1, n2 + 1);
        map.addThing((Thing)object, n + 1, n2 + 1);
        map.addThing(Lib.create("ham"), n + 1, n2 + 1).set("IsOwned", 1);
        map.addThing(Fire.create(10), n + 3, n2 + 1);
        map.addThing("stone bench", n + 3, n2 + 2);
        ((BaseObject)object).set("OnChat", new BurthaTheTownsWoman());
        map.fillArea(6, 10, 14, 10, 9);
        map.addThing(Lib.create("door"), 14, 10);
        map.addThing(Special.messagePoint("You can open the door automatically by running into it. You can also use the \"o\" key to open or close the door."), 15, 10);
        map.addThing(Lib.create("inn sign"), 15, 9);
        map.addThing(Lib.create("potted flower"), 15, 11);
        map.setTile(10, 6, 9);
        map.addThing(Lib.create("door"), 10, 6);
        map.addThing(Special.messagePoint("You can talk to the people in the inn by standing next to them and pressing \"c\" to chat. Many characters that you meet on your travels will be able to give you useful information or aid you in your quests in some way."), 13, 10);
        map.addThing(Special.messagePoint("The door next to you is locked. You may be able to find a way to open it. You can kick down doors in dungeons with the \"k\" key but the locals won't like you trying that around here!"), 7, 10);
        map.fillBorder(7, 14, 18, 22, 10);
        map.fillArea(8, 15, 9, 21, 9);
        map.fillBorder(7, 14, 10, 22, 10);
        map.fillArea(15, 14, 16, 14, 18);
        map.setTile(10, 14, 9);
        map.setTile(10, 16, 9);
        map.fillArea(9, 15, 11, 15, 10);
        map.addThing(Lib.create("stable door"), 10, 16);
        map.addThing(Special.messagePoint("The stables here are filled with the smell of fresh manure. You spy a ladder going upstairs to some kind of loft. There is also a crude knife on the floor, that seems to have been discarded."), 10, 16);
        map.addThing(Lib.create("stone knife"), 8, 17);
        map.addThing(Special.messagePoint("You can pick up and use this knife as a weapon. Press \",\" (comma) or \"p\" to pick it up. Then press \"w\" to wield it as a weapon."), 8, 17);
        Thing thing = Lib.create("tutorial loft");
        map.addThing(thing, 8, 15);
        map.addThing(Special.messagePoint("Press \"x\" to climb this ladder."), 8, 15);
        map.fillArea(7, 18, 10, 18, 10);
        map.setTile(10, 20, 9);
        map.addThing(Lib.create("secret door"), 7, 19);
        map.addThing(Lib.create("stable door"), 10, 20);
        thing = Lib.create("farmer");
        AI.name(thing, "Rotchy");
        AI.setGuard(thing, map, 13, 18, 17, 22);
        map.addThing(thing, 15, 19);
        map.addThing(Special.messagePoint("There is Rotchy the farmer to the south. You can go to him and chat by pressing \"c\"."), 16, 14);
        thing.set("OnChat", new RotchyTheFarmer());
        map.addBlockingThing(Lib.create("[IsBarrel]"), 13, 18, 17, 22);
        map.addBlockingThing(Lib.create("[IsBarrel]"), 13, 18, 17, 22);
        map.addBlockingThing(Lib.create("[IsBarrel]"), 13, 18, 17, 22);
        map.setTile(13, 15, 10);
        Thing thing2 = Lib.create("tutorial cellar");
        map.addThing(thing2, 12, 15);
        map.addThing(Special.messagePoint("You see some stairs here heading down into a dark cellar. You can hear the sounds of rats scuttling below. Move onto the stairs and press \"x\" if you want to venture into the dark cellar."), 12, 16);
        map.addThing(Lib.create("locked door"), 6, 10);
        map.addThing(Lib.create("fish"), 4, 8);
        map.addThing(Lib.create("salmon"), 5, 8);
        map.addThing(Lib.create("[IsBarrel]"), 4, 13);
        map.addThing(Lib.create("[IsBarrel]"), 5, 13);
        map.setTile(4, 7, 9);
        map.addThing("locked door", 4, 7);
        map.fillArea(2, 9, 4, 9, 17);
        map.addThing("invincible portcullis", 3, 9);
        map.setEntrance(Portal.create("invisible portal"));
        map.addThing(map.getEntrance(), map.width - 2, 10);
        int n3 = RPG.d(3);
        object = RPG.pick(new String[]{"tree", "pine tree", "large tree", "bush"});
        for (int i = 18; i < map.width; i += n3) {
            map.addThing((String)object, i, 8);
            map.addThing((String)object, i, 12);
        }
        map.fillArea(15, 10, map.width - 1, 10, 5);
        map.set("WanderingRate", 0);
        map.set("EnterMessageFirst", "Welcome to Tyrant!\nThe Tradepost Inn lies to your west, where friendly locals will be glad to give novices an introduction to the Tyrant world. If you are already an experienced adventurer, you can leave this area and start adventuring by heading east.\n\nWe hope you enjoy playing Tyrant!");
        Tutorial.addPeople(map);
        return map;
    }

    private static boolean isBusy(double d, int n, int n2) {
        if (!RPG.p(d)) {
            return false;
        }
        if (RPG.test(n, n2)) {
            return false;
        }
        int n3 = (int)(0.8 * (double)n2);
        String[] stringArray = RPG.test(n, n3) ? new String[]{"Sorry, I'm busy; come a little later.", "I'm busy now, sorry; come a little later.", "Sorry, I'm busy now; so come a little later.", "Sorry, I'm busy now; come little later, all right?"} : new String[]{"I'm busy; come a little later.", "I'm busy now; come a little later.", "I'm busy now; so come a little later.", "I'm busy now; come little later, all right?"};
        Game.quotedMessage(RPG.pick(stringArray));
        return true;
    }

    private static void sayName(Thing thing) {
        Game.message("You talk to " + thing.getTheName());
    }

    private static boolean isExoticRace(String string) {
        return !string.equals("human") && !string.equals("hobbit");
    }

    private static boolean isUnpleasantRace(String string) {
        if (string.equals("half orc")) {
            return true;
        }
        return string.equals("half troll");
    }

    private static boolean sayHello(Thing thing, double d, double d2, double d3) {
        String string = thing.getString("Race");
        if (!RPG.p(d)) {
            return false;
        }
        if (Tutorial.isUnpleasantRace(string) && RPG.p(d2) && !RPG.test(thing.getStat("CH"), 3)) {
            String[] stringArray = new String[]{"Oh, you're ", "I see, you're "};
            String[] stringArray2 = new String[]{"But welcome anyway.", "Anyway, welcome.", "Anyway, hello.", "Anyway, hi there."};
            Game.quotedMessage(RPG.pick(stringArray) + string + "...to tell truth, we don't very like 'em here in the village. " + RPG.pick(stringArray2));
            return true;
        }
        if (Tutorial.isExoticRace(string)) {
            if (RPG.p(d2)) {
                String[] stringArray = new String[]{"Oh, you're ", "Ah, you're ", "I see, you're "};
                String[] stringArray3 = new String[]{"...we never saw them here. ", "...we rarely see them here. ", "...we did not see them here yet. "};
                String[] stringArray4 = new String[]{"Hi", "Hi!", "Hello.", "Hello!", "So hi there.", "Welcome!"};
                Game.quotedMessage(RPG.pick(stringArray) + string + RPG.pick(stringArray3) + RPG.pick(stringArray4));
                return true;
            }
            if (RPG.p(d3)) {
                String[] stringArray = new String[]{"Hi, ", "Hello, ", "Welcome, ", "Nice to see you, "};
                Game.quotedMessage(RPG.pick(stringArray) + string + ".");
                return true;
            }
        }
        String[] stringArray = new String[]{"Hi.", "Hi!", "Hi there.", "Hello.", "Hello!", "Nice to see you.", "Welcome!", "Hi, pal.", "Nice to meet you.", "Hi. I see you're traveler like me.", "Hello. I see you're traveler like me."};
        Game.quotedMessage(RPG.pick(stringArray));
        return true;
    }

    private static void addPeople(Map map) {
        Thing thing = Lib.create("blacksmith");
        AI.name(thing, "Silas Innkeep");
        AI.setGuard(thing, map, 6, 7, 8, 9);
        map.addThing(Lib.create("NS table"), 8, 7);
        map.addThing(Lib.create("NS table"), 8, 8);
        map.addThing(Lib.create("NS table"), 8, 9);
        map.addThing(Lib.create("stool"), 9, 7);
        map.addThing(Lib.create("stool"), 9, 9);
        map.addThing(Lib.create("ham"), 8, 7);
        SilasInnkeeper silasInnkeeper = new SilasInnkeeper();
        thing.set("OnChat", silasInnkeeper);
        map.addThing(thing, 7, 8);
        thing = Lib.create("guard");
        AI.name(thing, "Rosco Burrl");
        AI.setGuard(thing, map, 12, 8, 12, 8);
        map.addThing(thing, 12, 8);
        map.addThing(Lib.create("stool"), 12, 8);
        map.addThing(Lib.create("stool"), 11, 7);
        map.addThing(Lib.create("table"), 11, 8);
        RoscoBurrl roscoBurrl = new RoscoBurrl();
        thing.set("OnChat", roscoBurrl);
        thing = Lib.create("village girl");
        AI.setGuard(thing, map, 9, 8, 9, 8);
        map.addThing(thing, 9, 8);
        thing = Lib.create("teacher");
        AI.setGuard(thing, map, 12, 13, 12, 13);
        map.addThing(thing, 12, 13);
        map.addThing(Lib.create("table"), 11, 13);
        map.addThing(Special.messagePoint("The robed gentleman next to you is a learned teacher. You can enhance your skills by training with him assuming that you have gained sufficient experience. If you chat to him with the \"c\" key he will tell you whether you are able to enhance your skills. You can view your character's cureent skills and other useful information at any time by pressing  \"v\"."), 12, 12);
        thing = Lib.create("ranger");
        thing.set("ChatCount", 0);
        AI.name(thing, "Miira");
        AI.setGuard(thing, map, 11, 7, 11, 7);
        map.addThing(thing, 11, 7);
        MiiraTheRanger miiraTheRanger = new MiiraTheRanger();
        thing.set("OnChat", miiraTheRanger);
        silasInnkeeper.setMiira(miiraTheRanger);
        miiraTheRanger.setSilas(silasInnkeeper);
        miiraTheRanger.setRosco(roscoBurrl);
        roscoBurrl.setMiira(miiraTheRanger);
    }

    public static void init() {
        Thing thing = Lib.extend("inn loft key", "iron key");
        thing.set("Frequency", 0);
        Lib.add(thing);
    }

    private static class RotchyTheFarmer
    extends Script {
        private static final long serialVersionUID = 6595782575469702238L;

        private RotchyTheFarmer() {
        }

        public boolean handle(Thing thing, Event event) {
            thing.incStat("ChatCount", 1);
            switch (thing.getStat("ChatCount")) {
                case 1: {
                    Tutorial.sayName(thing);
                    Game.quotedMessage("Hello, Sir. I'm just a farmer. Can I help you?");
                    break;
                }
                case 2: {
                    Tutorial.sayName(thing);
                    Game.quotedMessage("There is nice inn to the north. Visit it if you haven't been there yet.");
                    break;
                }
                case 3: {
                    Tutorial.sayName(thing);
                    Game.quotedMessage("You see stairs down nearby? This is entrance to cellar; but I did not ever dare to go down there.");
                    break;
                }
                default: {
                    Tutorial.sayName(thing);
                    if (RPG.p(0.5)) {
                        Game.quotedMessage("I could just add: beware of monsters!");
                    } else {
                        Game.quotedMessage("I'm afraid, Sir, there is nothing more I can tell you.");
                    }
                    thing.set("ChatCount", 100);
                }
            }
            return false;
        }
    }

    private static class BurthaTheTownsWoman
    extends Script {
        static final long serialVersionUID = -3409510129139664108L;

        private BurthaTheTownsWoman() {
        }

        public boolean handle(Thing thing, Event event) {
            thing.incStat("ChatCount", 1);
            switch (thing.getStat("ChatCount")) {
                case 1: {
                    String[] stringArray = new String[]{"I'm just a townswoman...whatchoo want?", "I'm just a townswoman...what is you wantin'?", "What is you wantin'?", "What is you wantin', pal?", "Whatchoo want, pal?", "What?", "Wassup?", "Wassup, pal?", "Hey, wassup?", "What?", "Wanna somethin'?", "U wanna somethin'?", "Wanna somethin', ah?", "Wanna somethin', pal?"};
                    Tutorial.sayName(thing);
                    Game.quotedMessage(RPG.pick(stringArray));
                    break;
                }
                case 2: {
                    Tutorial.sayName(thing);
                    Game.quotedMessage("See piece of ham in this room? It's MINE!");
                    break;
                }
                default: {
                    Tutorial.sayName(thing);
                    String[] stringArray = new String[]{"I tole you: da piece of ham is MINE! Don't you dare to take it!", "I told you: da piece of ham is MINE! Don't hope i'll give it to you!"};
                    Game.quotedMessage(RPG.pick(stringArray));
                    thing.set("ChatCount", 100);
                }
            }
            return false;
        }
    }

    private static class MiiraTheRanger
    extends Script {
        private SilasInnkeeper silasInnkeeper;
        private RoscoBurrl rosco;
        private boolean chattedToHero = false;
        private static final long serialVersionUID = 4049633512149890352L;
        private Date lastTime = null;
        private static final int TIME_MIN = 60000;
        private static final int TIME_MAX = 120000;

        public final boolean isChattedToHero() {
            return this.chattedToHero;
        }

        public void setRosco(RoscoBurrl roscoBurrl) {
            this.rosco = roscoBurrl;
        }

        public void setSilas(SilasInnkeeper silasInnkeeper) {
            this.silasInnkeeper = silasInnkeeper;
        }

        private boolean isLongTime() {
            long l;
            if (this.lastTime == null) {
                return false;
            }
            long l2 = new Date().getTime() - this.lastTime.getTime();
            return l2 > (l = (long)RPG.r(60000, 120000));
        }

        private void tryToSayHello(Thing thing) {
            Tutorial.sayHello(thing, 0.5, 0.3, 0.3);
        }

        private void sayAboutSilasInnkeeper() {
            String[] stringArray = new String[]{"miser", "skinflint"};
            if (this.silasInnkeeper != null && this.silasInnkeeper.isChattedToHero()) {
                Game.quotedMessage("Ah, you've already talked to Silas Innkeeper in this room. He's just fat " + RPG.pick(stringArray) + ", right?");
                return;
            }
            Game.quotedMessage("You see Silas Innkeeper to the left? He is " + RPG.pick(stringArray) + "; don't even think he will give you somethin' for free.");
        }

        private void sayFinalPhrase() {
            if (RPG.p(0.8) && this.rosco != null && !this.rosco.isChattedToHero()) {
                Game.quotedMessage("See Rosco Burrl in the room? Come to him and chat.");
                return;
            }
            this.sayIamBored();
        }

        private void sayIamBored() {
            String[] stringArray = new String[]{"I\u2019m little bored talking to you.", "I\u2019m little bored talking to you, sorry.", "Sorry, I\u2019m little bored talking to you.", "Sorry pal, I\u2019m little bored talking to you.", "I\u2019m afraid I have nothing more to tell you, sorry.", "I\u2019m afraid I have nothing more to tell you, pal.", "I\u2019m afraid I have nothing more to tell you, my friend.", "I think I have nothing more to tell you, sorry."};
            Game.quotedMessage(RPG.pick(stringArray));
        }

        public boolean handle(Thing thing, Event event) {
            this.chattedToHero = true;
            Thing thing2 = event.getThing("Target");
            thing.incStat("ChatCount", 1);
            switch (thing.getStat("ChatCount")) {
                case 1: {
                    Tutorial.sayName(thing);
                    this.tryToSayHello(thing2);
                    Game.message("You exchange some adventurer banter.");
                    break;
                }
                case 2: {
                    Tutorial.sayName(thing);
                    if (Tutorial.isBusy(0.1, thing2.getStat("CH"), 6)) {
                        thing.set("ChatCount", 2);
                        break;
                    }
                    if (RPG.test(thing2.getStat("CH"), 20)) {
                        Item.identify(Lib.create("kahnflower"));
                        Game.message(thing.getTheName() + " warns you not to pick kahnflowers without wearing gloves.");
                        break;
                    }
                    this.sayAboutSilasInnkeeper();
                    break;
                }
                case 3: {
                    if (RPG.test(thing2.getStat("CH"), 3)) {
                        Tutorial.sayName(thing);
                        if (RPG.p(0.5)) {
                            Game.quotedMessage("Remember: to climb on a mountain, you must have Climbing skill.");
                            break;
                        }
                        Game.quotedMessage("Haven't you still visited the little altar room to the north from here?");
                        break;
                    }
                    Game.message("You chat for a while");
                    if (RPG.test(thing2.getStat("CH"), 3)) break;
                    Game.message(thing.getTheName() + " yawns.");
                    thing.set("ChatCount", 100);
                    break;
                }
                case 4: {
                    Game.message("You talk about how best to defeat " + Lib.createType("IsMonster", RPG.d(16)).getAName() + ".");
                    if (!RPG.test(thing2.getStat("CH"), 13)) break;
                    Game.message(thing.getTheName() + " seems impressed with your insight.");
                    Game.message("She gives you an identify scroll.");
                    Game.quotedMessage("Read this if you need to figure out what a mysterious item does.");
                    Thing thing3 = Lib.create("scroll of Identify");
                    Item.identify(thing3);
                    thing2.addThing(thing3);
                    break;
                }
                default: {
                    Tutorial.sayName(thing);
                    if (this.isLongTime()) {
                        Game.quotedMessage("Ah, this is you again; wassup?");
                    } else {
                        this.sayFinalPhrase();
                    }
                    thing.set("ChatCount", 100);
                }
            }
            this.lastTime = new Date();
            return false;
        }
    }

    private static class SilasInnkeeper
    extends Script {
        private static final long serialVersionUID = 3258939205411305016L;
        private Date lastTime = null;
        private static final int TIME_MIN = 300000;
        private static final int TIME_MAX = 360000;
        private Thing t;
        private boolean chattedToHero = false;
        private MiiraTheRanger miira;

        public void setMiira(MiiraTheRanger miiraTheRanger) {
            this.miira = miiraTheRanger;
        }

        public final boolean isChattedToHero() {
            return this.chattedToHero;
        }

        private boolean isLongTime() {
            long l;
            if (this.lastTime == null) {
                return false;
            }
            long l2 = new Date().getTime() - this.lastTime.getTime();
            return l2 > (l = (long)RPG.r(300000, 360000));
        }

        private void sayYouAgain() {
            String[] stringArray = new String[]{"Ah, this is you again, traveler.", "Ah, this is you again, stranger.", "Ah, this is you again, foreigner.", "Nice to see you again, traveler.", "Nice to see you again, stranger.", "Nice to see you again, foreigner."};
            Game.quotedMessage(RPG.pick(stringArray));
        }

        private void sayHello() {
            Tutorial.sayName(this.t);
            String string = Game.hero().getString("Race");
            if (Tutorial.isExoticRace(string)) {
                if (RPG.p(0.3)) {
                    this.sayHelloNeverSawYouHere(string);
                    return;
                }
                if (RPG.p(0.2)) {
                    this.sayHelloUsingRace(string);
                    return;
                }
            }
            String[] stringArray = new String[]{"Welcome to my inn!", "Travelers are always welcomed in my inn!", "Hi, stranger!", "Hello, stranger!", "Hi, traveler!", "Hello, traveler!", "Welcome to my inn, traveler!", "Welcome to my inn, stranger!", "Nice to see you in my inn!", "Hello, nice to see you in my inn!", "Nice to see an adventurer like you in my inn!", "Nice to see you in my inn, stranger!", "Nice to see you in my inn, traveler!"};
            Game.quotedMessage(RPG.pick(stringArray));
        }

        private void sayHelloNeverSawYouHere(String string) {
            String[] stringArray = new String[]{" Welcome to my inn!", " So welcome to my inn!", " Nice to see you my inn!"};
            String string2 = "Oh, you are " + string + "...we never saw them here." + RPG.pick(stringArray);
            Game.quotedMessage(string2);
        }

        private void sayHelloUsingRace(String string) {
            String[] stringArray = new String[]{"Welcome to my inn, ", "Hi, ", "Hello, ", "Nice to see you in my inn, ", "Hello, nice to see you in my inn, "};
            Game.quotedMessage(RPG.pick(stringArray) + string + "!");
        }

        private void sayAboutMiira() {
            if (this.miira != null && this.miira.isChattedToHero()) {
                Game.quotedMessage("I see you've already talked to Miira the ranger in this room. Cool girl, isn't she?");
                return;
            }
            Game.quotedMessage("There is Miira the ranger in this room. Talk to her: she can say something interesting.");
        }

        public boolean handle(Thing thing, Event event) {
            this.chattedToHero = true;
            this.t = thing;
            Thing thing2 = event.getThing("Target");
            thing.incStat("ChatCount", 1);
            switch (thing.getStat("ChatCount")) {
                case 1: {
                    this.sayHello();
                    break;
                }
                case 2: {
                    if (Tutorial.isBusy(0.1, thing2.getStat("CH"), 6)) {
                        thing.set("ChatCount", 2);
                        break;
                    }
                    Tutorial.sayName(thing);
                    if (this.isLongTime()) {
                        this.sayYouAgain();
                        break;
                    }
                    String[] stringArray = new String[]{"If you're after a job to do, there are some pests down in the cellar that need clearing out.", "Are you after a job to do? There are some pests down in the cellar that need clearing out.", "Are you after a job to do? Some pests down in the cellar need clearing out.", "You know, there are some pests down in the cellar that need clearing out.", "You know, some pests down in the cellar need clearing out.", "Listen, there are some pests down in the cellar that need clearing out.", "You know what? Some pests down in the cellar need clearing out."};
                    String[] stringArray2 = new String[]{" You can help yourself to the funny old potions down there,", " You may be interested in the funny old potions down there,"};
                    String[] stringArray3 = new String[]{" I know you adventurers can always find a use for them.", " you adventurers can always find a use for them.", " adventurers like you can always find a use for them.", " travelers like you can always find a use for them."};
                    Game.quotedMessage(RPG.pick(stringArray) + RPG.pick(stringArray2) + RPG.pick(stringArray3));
                    break;
                }
                default: {
                    Tutorial.sayName(thing);
                    if (this.isLongTime()) {
                        this.sayYouAgain();
                        String[] stringArray = new String[]{"I hope you found something in the cellar.", "I hope you found something in that cellar.", "Well, I hope you found something in the cellar.", "I hope you found something useful in the cellar.", "I hope you already visited the cellar.", "I hope you already visited the cellar I told you about."};
                        Game.quotedMessage(RPG.pick(stringArray));
                    } else if (RPG.test(thing2.getStat("CH"), 3) && RPG.p(0.5)) {
                        this.sayAboutMiira();
                    } else {
                        String[] stringArray = new String[]{"The cellar I told you about is to the south from this room.", "That cellar I told you about is to the south from this room.", "By the way, the cellar I told you about is to the south from this room.", "I told you about a cellar; you can find it to he south from this room.", "I told you about a cellar; it is located to he south from this room."};
                        String[] stringArray4 = new String[]{"", " Be careful there!", " Be careful \u2013 monsters (or something else) can happen there\u2026", " Be careful there \u2013 you know, darkness, monsters and so on\u2026", " Be careful \u2013 monsters can happen there.", " There can be monsters there - so be careful!"};
                        Game.quotedMessage(RPG.pick(stringArray) + RPG.pick(stringArray4));
                    }
                    thing.set("ChatCount", 100);
                }
            }
            this.t = null;
            this.lastTime = new Date();
            return false;
        }
    }

    private static class RoscoBurrl
    extends Script {
        private static final long serialVersionUID = 3258417222518321461L;
        private boolean chattedToHero = false;
        private MiiraTheRanger miira;

        public final boolean isChattedToHero() {
            return this.chattedToHero;
        }

        public void setMiira(MiiraTheRanger miiraTheRanger) {
            this.miira = miiraTheRanger;
        }

        private void tryToSayHello(Thing thing) {
            Tutorial.sayHello(thing, 0.3, 0.1, 0.1);
        }

        public boolean handle(Thing thing, Event event) {
            this.chattedToHero = true;
            Thing thing2 = event.getThing("Target");
            thing.incStat("ChatCount", 1);
            switch (thing.getStat("ChatCount")) {
                case 1: {
                    Tutorial.sayName(thing);
                    this.tryToSayHello(thing2);
                    Game.message("He talks enthusiastically about his latest victory against a marauding " + Lib.createType("IsMonster", RPG.d(16)).getName(Game.hero()) + ".");
                    break;
                }
                case 2: {
                    Tutorial.sayName(thing);
                    Game.quotedMessage("Yer know what? Best way to fite inn't to rush rite in. Yer wanna hold back a bit, let tha critta come to ya. Then ya bash it, afore it knows wats coming!");
                    break;
                }
                case 3: {
                    Tutorial.sayName(thing);
                    Game.quotedMessage("Don't evva let yaself get s'rounded! Stick to tha narra ways where yer can take 'em one by one. Thass wot I do.");
                    break;
                }
                case 4: {
                    Tutorial.sayName(thing);
                    if (RPG.p(0.5)) {
                        Game.quotedMessage("Tha's a narsty goblin by tha name of Borrok. Kilt sum village folk lass year. Ee's built a lair unda tha deep forest ruin. Up North ya know? An 'ero who could beat tha rogue would be right famous!");
                        break;
                    }
                    Game.quotedMessage("Hey pal, listen and advice here. When ya fitin\u2019, best position iz to hold weapon in one hand and shield in another. Got it?");
                    break;
                }
                case 5: {
                    Tutorial.sayName(thing);
                    if (RPG.p(0.5) && this.miira != null && !this.miira.isChattedToHero()) {
                        Game.quotedMessage("Didn't you talk to Miira the ranger (in this room)? You'd try, yeah.");
                        break;
                    }
                    Game.quotedMessage("Yer know what? Do most 'portant ting is nevva to fite on when you is beat. Live ta fite anutha day!");
                    break;
                }
                default: {
                    Game.message(thing.getTheName() + " chats with you for some time.");
                    thing.set("ChatCount", 100);
                }
            }
            return false;
        }
    }
}

