/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import java.util.HashMap;
import mikera.tyrant.Damage;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;

public class Tile {
    public static final int TF_BLOCKED = 65536;
    public static final int TF_TRANSPARENT = 131072;
    public static final int TF_DISCOVERED = 262144;
    public static final int TF_ANTIMAGIC = 524288;
    public static final int TF_VISIBLE = 0x200000;
    public static final int TF_LIT = 0x400000;
    public static final int TF_DIRECTIONBASE = 0x800000;
    public static final int TF_DIRECTION = 0x7800000;
    public static final int TF_ACTIVE = 0x8000000;
    public static final int TF_LOS = 0x10000000;
    public static final int TF_TYPEMASK = 65535;
    public static final int NOTHING = 0;
    public static final int FLOOR = 1;
    public static final int WALL = 2;
    public static final int BRICKWALL = 3;
    public static final int GOLDWALL = 4;
    public static final int STONEFLOOR = 5;
    public static final int STONEWALL = 6;
    public static final int METALFLOOR = 7;
    public static final int METALWALL = 8;
    public static final int CAVEFLOOR = 9;
    public static final int CAVEWALL = 10;
    public static final int ICEFLOOR = 11;
    public static final int ICEWALL = 12;
    public static final int POSHFLOOR = 13;
    public static final int POSHWALL = 14;
    public static final int FORESTFLOOR = 15;
    public static final int TREE = 16;
    public static final int RIVER = 17;
    public static final int GRASS = 18;
    public static final int PLAINS = 19;
    public static final int FORESTS = 20;
    public static final int HILLS = 21;
    public static final int MOUNTAINS = 22;
    public static final int PLAINSROCK = 23;
    public static final int MOREPLAINS = 24;
    public static final int SEA = 25;
    public static final int STREAM = 26;
    public static final int GUNK = 27;
    public static final int POOL = 28;
    public static final int SWAMP = 29;
    public static final int WOODENWALL = 30;
    public static final int WOODENFLOOR = 31;
    public static final int MOSSFLOOR = 32;
    public static final int LAVA = 33;
    public static final int REDWALL = 34;
    public static final int REDFLOOR = 35;
    public static final int MARBLEFLOOR = 36;
    public static final int MUDFLOOR = 37;
    public static final int PARQUETFLOOR = 38;
    public static final int LAVASEA = 39;
    public static final int VOID = 40;
    public static String[] names = null;
    public static int[] images = null;
    public static int[] imagefill = null;
    public static boolean[] filling = null;
    public static int[] borders = null;
    public static int[] movecost = null;
    public static boolean[] active = null;
    public static boolean[] issolid = null;
    public static boolean[] ispassable = null;
    public static int[] mapColours = null;
    public static Thing[] tiles;
    private static java.util.Map tileByName;
    private static java.util.Map nameById;

    public static int getMoveCost(int n) {
        return movecost[n];
    }

    public static int fromName(String string) {
        Integer n;
        if (nameById == null) {
            Tile.createMaps();
        }
        if ((n = (Integer)tileByName.get(string)) != null) {
            return n;
        }
        throw new Error("Tile named [" + string + "] does not exist");
    }

    public static String tileNameFor(int n) {
        String string;
        if (tileByName == null) {
            Tile.createMaps();
        }
        if ((string = (String)nameById.get(new Integer(n))) != null) {
            return string;
        }
        throw new Error("Tile of type [" + n + "] does not exist");
    }

    private static void createMaps() {
        tileByName = new HashMap();
        nameById = new HashMap();
        for (int i = 0; i < names.length; ++i) {
            tileByName.put(names[i], new Integer(i));
            nameById.put(new Integer(i), names[i]);
        }
    }

    public static int getImage(int n) {
        return images[n];
    }

    public static String getASCII(int n) {
        return Tile.get(n).getString("ASCII");
    }

    public static int getFilledImage(int n) {
        return imagefill[n];
    }

    public static boolean isFilling(int n) {
        return filling[n];
    }

    public static void init() {
        Thing thing = Lib.extend("base tile", "base thing");
        thing.set("IsTile", 1);
        thing.set("IsDestructible", 0);
        thing.set("IsDiggable", 0);
        thing.set("ImageSource", "Tiles");
        thing.set("MoveCost", 100);
        thing.set("MapColour", 0x303030);
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("base wall tile", "base tile");
        thing.set("IsViewBlocking", 1);
        thing.set("IsBlocking", 1);
        thing.set("IsWall", 1);
        thing.set("IsSolid", 1);
        thing.set("IsTileFilling", 1);
        thing.set("Image", 20);
        thing.set("IsDiggable", 1);
        thing.set("IsJumpable", 0);
        thing.set("IsPassable", 0);
        thing.set("DigDifficulty", 100);
        thing.set("DigTile", 9);
        thing.set("MapColour", 0x808080);
        thing.set("ImageFill", 1);
        thing.set("ASCII", "#");
        Lib.add(thing);
        thing = Lib.extend("base floor tile", "base tile");
        thing.set("IsViewBlocking", 0);
        thing.set("IsBlocking", 0);
        thing.set("IsDiggable", 1);
        thing.set("IsPassable", 1);
        thing.set("DigDifficulty", 100);
        thing.set("DigTile", 9);
        thing.set("Image", 0);
        thing.set("ASCII", ".");
        Lib.add(thing);
        thing = Lib.extend("base outdoor tile", "base tile");
        thing.set("IsViewBlocking", 0);
        thing.set("IsBlocking", 0);
        thing.set("IsDiggable", 1);
        thing.set("DigDifficulty", 100);
        thing.set("DigTile", 9);
        thing.set("IsOutdoorTile", 1);
        thing.set("IsPassable", 1);
        thing.set("Image", 60);
        thing.set("ASCII", ".");
        Lib.add(thing);
        Tile.initSpecialTiles();
        Tile.initWalls();
        Tile.initSpecialWalls();
        Tile.initFloors();
        Tile.initWater();
        Tile.initLava();
        Tile.initOutdoors();
        Tile.buildTileArrays();
    }

    private static void buildTileArrays() {
        ArrayList arrayList = Lib.instance().getTiles();
        int n = arrayList.size();
        names = new String[n];
        images = new int[n];
        imagefill = new int[n];
        filling = new boolean[n];
        borders = new int[n];
        movecost = new int[n];
        tiles = new Thing[n];
        active = new boolean[n];
        issolid = new boolean[n];
        ispassable = new boolean[n];
        mapColours = new int[n];
        for (int i = 0; i < n; ++i) {
            Thing thing = (Thing)arrayList.get(i);
            if (thing == null) {
                Game.warn("Null in tile list at position " + i);
                continue;
            }
            Tile.names[i] = thing.name();
            Tile.images[i] = thing.getStat("Image");
            Tile.imagefill[i] = thing.getStat("Image") + thing.getStat("ImageFill");
            Tile.filling[i] = thing.getFlag("IsTileFilling");
            Tile.borders[i] = thing.getFlag("IsTileBordered") ? 1 : 0;
            Tile.movecost[i] = thing.getStat("MoveCost");
            Tile.active[i] = thing.getFlag("IsActive");
            Tile.mapColours[i] = thing.getStat("MapColour");
            Tile.issolid[i] = thing.getFlag("IsSolid");
            Tile.ispassable[i] = thing.getFlag("IsPassable");
            Tile.tiles[i] = thing;
        }
    }

    private static Thing get(int n) {
        return tiles[n & 0xFFFF];
    }

    public static void action(Map map, int n, int n2, int n3) {
        int n4 = map.getTile(n, n2);
        Thing thing = Tile.get(n4);
        if (thing.getFlag("IsDamageTile")) {
            Thing[] thingArray = map.getThings(n, n2);
            if (thingArray.length == 0) {
                return;
            }
            int n5 = thing.getStat("Damage");
            if ((n5 *= RPG.round((double)n3 / 100.0)) <= 0) {
                return;
            }
            String string = thing.getString("DamageType");
            for (int i = 0; i < thingArray.length; ++i) {
                Thing thing2 = thingArray[i];
                if (!thing2.getFlag("IsPhysical") || thing2.getFlag("IsFlying")) continue;
                thing2.damage(n5, string);
            }
        }
    }

    public static boolean isDiggable(Map map, int n, int n2) {
        if (n == 0 || n2 == 0 || n == map.width - 1 || n2 == map.height - 1) {
            return false;
        }
        int n3 = map.getTile(n, n2) & 0xFFFF;
        return Tile.isDiggable(Tile.get(n3));
    }

    public static boolean isSolid(Map map, int n, int n2) {
        int n3 = map.getTile(n, n2);
        return issolid[n3];
    }

    public static boolean isPassable(int n) {
        return ispassable[n];
    }

    public static boolean isPassable(Thing thing, Map map, int n, int n2) {
        if (n < 0 || n2 < 0 || n >= map.width || n2 >= map.height) {
            return false;
        }
        int n3 = map.getTile(n, n2);
        Thing thing2 = Tile.get(n3);
        if (thing2.getFlag("IsPassable")) {
            return true;
        }
        if (n == 0 || n2 == 0 || n == map.width - 1 || n2 == map.height - 1) {
            return false;
        }
        if (issolid[n3]) {
            if (thing.getFlag("IsEthereal")) {
                return true;
            }
            return thing.getFlag("IsFlying") && thing2.getFlag("IsJumpable");
        }
        if (thing.getFlag("IsFlying")) {
            return true;
        }
        switch (n3) {
            case 25: {
                Thing[] thingArray = thing.getFlaggedContents("IsBoat");
                return thingArray != null && thingArray.length > 0;
            }
            case 22: {
                return thing.getFlag("Climbing");
            }
        }
        return true;
    }

    public static boolean isSensibleMove(Thing thing, Map map, int n, int n2) {
        if (n < 0 || n2 < 0 || n >= map.width || n2 >= map.height) {
            return false;
        }
        int n3 = map.getTile(n, n2);
        Thing thing2 = Tile.get(n3);
        if (thing2.getFlag("IsPassable")) {
            return true;
        }
        if (issolid[n3]) {
            if (thing.getFlag("IsEthereal")) {
                return true;
            }
            return thing.getFlag("IsFlying") && thing2.getFlag("IsJumpable");
        }
        if (thing.getFlag("IsFlying")) {
            return true;
        }
        switch (n3) {
            case 25: {
                Thing[] thingArray = thing.getFlaggedContents("IsBoat");
                return thingArray != null && thingArray.length > 0;
            }
            case 22: {
                return thing.getFlag("Climbing");
            }
        }
        return false;
    }

    private static boolean isDiggable(Thing thing) {
        return thing.getFlag("IsDiggable");
    }

    public static int digAbility() {
        return 100;
    }

    public static int digCost(Thing thing, Thing thing2) {
        int n = thing.getStat("Mining");
        if (thing.getFlag("Digging")) {
            return 100;
        }
        if (n <= 0) {
            return 0;
        }
        if (thing2 != null && thing2.getFlag("IsDiggingTool")) {
            return thing2.getStat("DigCost") / n;
        }
        return 0;
    }

    public static void kick(Thing thing, Map map, int n, int n2) {
        int n3 = map.getTile(n, n2);
        Thing thing2 = Tile.get(n3);
        if (thing2.getFlag("IsWall")) {
            thing.message("You kick the wall - ouch!");
        } else if (thing2.getFlag("IsWaterTile")) {
            thing.message("Your attempt to kick the water only succeeds in getting you wet!");
        } else {
            thing.message("You kick thin air");
        }
    }

    public static boolean dig(Thing thing, Map map, int n, int n2) {
        int n3 = map.getTile(n, n2);
        Thing thing2 = thing.getWielded(1);
        Thing thing3 = Tile.get(n3);
        if (Tile.isDiggable(map, n, n2)) {
            int n4 = Tile.digCost(thing, thing2);
            if (n4 <= 0) {
                return false;
            }
            int n5 = thing3.getStat("DigDifficulty");
            if (RPG.r(n5) < Tile.digAbility()) {
                if (thing2 != null) {
                    thing2.damage(thing2.getStat("DigDamage"), "special");
                }
                thing.incStat("APS", -n4);
                thing.message("You dig through the " + thing3.name());
                Tile.dig(map, n, n2);
                return true;
            }
            thing.message("You dig furiously at the " + thing3.name());
            return false;
        }
        thing.message("You are unable to dig through " + thing3.getTheName());
        return false;
    }

    public static boolean dig(Map map, int n, int n2) {
        if (!Tile.isDiggable(map, n, n2)) {
            return false;
        }
        Thing thing = Tile.get(map.getTile(n, n2));
        map.setTile(n, n2, thing.getStat("DigTile"));
        return true;
    }

    private static void addTile(int n, Thing thing) {
        thing.set("TileValue", n);
        n &= 0xFFFF;
        ArrayList arrayList = Lib.instance().getTiles();
        while (arrayList.size() <= n) {
            arrayList.add(null);
        }
        if (arrayList.get(n) != null) {
            throw new Error("Tile arraylist already filled at position " + n);
        }
        arrayList.set(n, thing);
        int n2 = 0;
        if (!thing.getFlag("IsViewBlocking")) {
            n2 |= 0x20000;
        }
        if (thing.getFlag("IsBlocking")) {
            n2 |= 0x10000;
        }
        if (thing.getFlag("IsActive")) {
            n2 |= 0x8000000;
        }
        thing.set("TileMask", n2);
        Lib.add(thing);
    }

    public static int getMask(int n) {
        if (n > tiles.length) {
            return 0;
        }
        Thing thing = Tile.get(n);
        return thing.getStat("TileMask");
    }

    private static void initSpecialTiles() {
        Thing thing = Lib.extend("nothing", "base tile");
        thing.set("IsPassable", 1);
        thing.set("ASCII", " ");
        thing.set("Image", 33);
        Tile.addTile(0, thing);
        thing = Lib.extend("void", "base tile");
        thing.set("IsPassable", 0);
        thing.set("ASCII", " ");
        thing.set("IsActive", 1);
        thing.set("IsDamageTile", 1);
        thing.set("DamageType", "disintegrate");
        thing.set("Damage", 400);
        thing.set("Image", 33);
        Tile.addTile(40, thing);
    }

    private static void initWalls() {
        Thing thing = Lib.extend("wall", "base wall tile");
        thing.set("Image", 20);
        Tile.addTile(2, thing);
        thing = Lib.extend("brick wall", "wall");
        thing.set("Image", 20);
        Tile.addTile(3, thing);
        thing = Lib.extend("gold wall", "wall");
        thing.set("Image", 78);
        Tile.addTile(4, thing);
        thing = Lib.extend("stone wall", "base wall tile");
        thing.set("Image", 22);
        Tile.addTile(6, thing);
        thing = Lib.extend("metal wall", "base wall tile");
        thing.set("IsDiggable", 0);
        thing.set("Image", 24);
        Tile.addTile(8, thing);
        thing = Lib.extend("cave wall", "base wall tile");
        thing.set("Image", 26);
        thing.set("IsDiggable", 1);
        Tile.addTile(10, thing);
        thing = Lib.extend("ice wall", "base wall tile");
        thing.set("Image", 28);
        Tile.addTile(12, thing);
        thing = Lib.extend("posh wall", "base wall tile");
        thing.set("Image", 30);
        Tile.addTile(14, thing);
        thing = Lib.extend("wooden wall", "base wall tile");
        thing.set("Image", 38);
        Tile.addTile(30, thing);
        thing = Lib.extend("red wall", "base wall tile");
        thing.set("Image", 36);
        Tile.addTile(34, thing);
    }

    private static void initSpecialWalls() {
        Thing thing = Lib.extend("tree wall", "base wall tile");
        thing.set("Image", 32);
        thing.set("ImageFill", 0);
        thing.set("IsDiggable", 0);
        Tile.addTile(16, thing);
    }

    public static int getMapColour(int n) {
        return mapColours[n];
    }

    public static void enterTrigger(Thing thing, Map map, int n, int n2, boolean bl) {
        int n3 = map.getTile(n, n2);
        if (thing.x != n || thing.y != n2) {
            throw new Error("Tile.enterTrigger wrong place!");
        }
        switch (n3) {
            case 17: 
            case 25: {
                if (!bl || thing.getFlag("Swimming")) break;
                thing.message("You struggle in the water");
                Damage.inflict(thing, 3, "water");
            }
        }
    }

    private static void initFloors() {
        Thing thing = Lib.extend("grass", "base floor tile");
        thing.set("Image", 60);
        thing.set("MapColour", 0x305030);
        Tile.addTile(18, thing);
        thing = Lib.extend("floor", "base floor tile");
        thing.set("Image", 0);
        Tile.addTile(1, thing);
        thing = Lib.extend("stone floor", "base floor tile");
        thing.set("Image", 14);
        Tile.addTile(5, thing);
        thing = Lib.extend("marble floor", "base floor tile");
        thing.set("Image", 164);
        thing.set("IsDiggable", 0);
        Tile.addTile(36, thing);
        thing = Lib.extend("mud floor", "base floor tile");
        thing.set("Image", 162);
        Tile.addTile(37, thing);
        thing = Lib.extend("metal floor", "base floor tile");
        thing.set("Image", 4);
        thing.set("IsDiggable", 0);
        Tile.addTile(7, thing);
        thing = Lib.extend("cave floor", "base floor tile");
        thing.set("Image", 6);
        Tile.addTile(9, thing);
        thing = Lib.extend("ice floor", "base floor tile");
        thing.set("Image", 8);
        Tile.addTile(11, thing);
        thing = Lib.extend("posh floor", "base floor tile");
        thing.set("Image", 10);
        Tile.addTile(13, thing);
        thing = Lib.extend("wooden floor", "base floor tile");
        thing.set("Image", 18);
        Tile.addTile(31, thing);
        thing = Lib.extend("parquet floor", "base floor tile");
        thing.set("Image", 165);
        Tile.addTile(38, thing);
        thing = Lib.extend("forest floor", "base floor tile");
        thing.set("Image", 12);
        Tile.addTile(15, thing);
        thing = Lib.extend("moss floor", "base floor tile");
        thing.set("Image", 13);
        thing.set("MoveCost", 130);
        Tile.addTile(32, thing);
        thing = Lib.extend("red floor", "base floor tile");
        thing.set("Image", 16);
        thing.set("MoveCost", 100);
        Tile.addTile(35, thing);
    }

    private static void initOutdoors() {
        Thing thing = Lib.extend("plains", "base outdoor tile");
        thing.set("Image", 60);
        thing.set("IsOutdoorTile", 1);
        thing.set("MapColour", 2129968);
        Tile.addTile(19, thing);
        thing = Lib.extend("forests", "base outdoor tile");
        thing.set("Image", 61);
        thing.set("MoveCost", 130);
        thing.set("IsViewBlocking", 1);
        thing.set("MapColour", 1069088);
        Tile.addTile(20, thing);
        thing = Lib.extend("hills", "base outdoor tile");
        thing.set("Image", 62);
        thing.set("MoveCost", 150);
        thing.set("ASCII", "^");
        thing.set("MapColour", 0x404040);
        Tile.addTile(21, thing);
        thing = Lib.extend("mountains", "base outdoor tile");
        thing.set("Image", 63);
        thing.set("IsPassable", 0);
        thing.set("IsBlocking", 1);
        thing.set("IsViewBlocking", 1);
        thing.set("MoveCost", 300);
        thing.set("ASCII", "&");
        thing.set("MapColour", 0x606060);
        Tile.addTile(22, thing);
        thing = Lib.extend("rocky plains", "base outdoor tile");
        thing.set("Image", 60);
        thing.set("MoveCost", 130);
        Tile.addTile(23, thing);
        thing = Lib.extend("open plains", "base outdoor tile");
        thing.set("Image", 60);
        Tile.addTile(24, thing);
        thing = Lib.extend("swamps", "base outdoor tile");
        thing.set("Image", 203);
        thing.set("ASCII", "-");
        thing.set("MapColour", 5259312);
        Tile.addTile(29, thing);
        thing = Lib.extend("sea", "base water tile");
        thing.set("Image", 66);
        thing.set("IsOutdoorTile", 1);
        thing.set("IsBlocking", 1);
        thing.set("MoveCost", 300);
        thing.set("MapColour", 1060960);
        Tile.addTile(25, thing);
        thing = Lib.extend("lava sea", "lava");
        thing.set("IsOutdoorTile", 1);
        thing.set("IsBlocking", 1);
        thing.set("MoveCost", 500);
        Tile.addTile(39, thing);
    }

    private static void initWater() {
        Thing thing = Lib.extend("base water tile", "base tile");
        thing.set("IsWaterTile", 1);
        thing.set("IsViewBlocking", 0);
        thing.set("IsBlocking", 0);
        thing.set("Image", 0);
        thing.set("IsTileBordered", 1);
        thing.set("IsPassable", 0);
        thing.set("Image", 181);
        thing.set("ASCII", "~");
        thing.set("MapColour", 4219008);
        Lib.add(thing);
        thing = Lib.extend("river", "base water tile");
        thing.set("IsBlocking", 1);
        thing.set("IsActive", 1);
        thing.set("IsDamageTile", 1);
        thing.set("Damage", 1);
        thing.set("DamageType", "water");
        thing.set("MoveCost", 250);
        Tile.addTile(17, thing);
        thing = Lib.extend("stream", "base water tile");
        thing.set("MoveCost", 150);
        thing.set("IsPassable", 1);
        Tile.addTile(26, thing);
        thing = Lib.extend("gunk", "base water tile");
        thing.set("Image", 202);
        thing.set("IsPassable", 1);
        thing.set("MapColour", 3162144);
        Tile.addTile(27, thing);
        thing = Lib.extend("pool", "base water tile");
        Tile.addTile(28, thing);
    }

    private static void initLava() {
        Thing thing = Lib.extend("lava", "base water tile");
        thing.set("Image", 47);
        thing.set("IsBlocking", 0);
        thing.set("IsLavaTile", 1);
        thing.set("IsActive", 1);
        thing.set("IsDamageTile", 1);
        thing.set("DamageType", "fire");
        thing.set("Damage", 400);
        thing.set("IsPassable", 0);
        thing.set("MapColour", 9465904);
        thing.set("MoveCost", 250);
        Tile.addTile(33, thing);
    }

    static {
        Tile.buildTileArrays();
    }
}

