/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import mikera.tyrant.AI;
import mikera.tyrant.Being;
import mikera.tyrant.Damage;
import mikera.tyrant.Event;
import mikera.tyrant.EventHandler;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Poison;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Spell;
import mikera.tyrant.Thing;

public class Scripts {
    public static Script addThing(String string, String string2) {
        return Scripts.addThing(string, string2, 100);
    }

    public static Script addThing(String string, String string2, int n) {
        AddThingScript addThingScript = new AddThingScript();
        addThingScript.set("TargetProperty", string);
        addThingScript.set("ThingName", string2);
        addThingScript.set("Chance", n);
        return addThingScript;
    }

    public static Script addEffect(String string, Thing thing) {
        return Scripts.addEffect(string, thing, 100);
    }

    public static Script addEffect(String string, String string2) {
        return Scripts.addEffect(string, Lib.create(string2), 100);
    }

    public static Script damage(String string, int n, String string2, int n2) {
        Script script = new Script(){
            private static final long serialVersionUID = 3258130258556696629L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = event.getThing("Target");
                int n = this.getStat("Damage");
                int n2 = this.getStat("DamageProbability");
                if (RPG.r(100) >= n2) {
                    return false;
                }
                String string = this.getString("DamageType");
                String string2 = this.getString("DamageDescription");
                Game.instance().pushMessages();
                n = Damage.inflict(thing2, n, string);
                ArrayList arrayList = Game.instance().popMessages();
                if (n > 0 && string2 != null) {
                    Game.message(thing2.getTheName() + " " + thing2.is() + " " + string2);
                }
                Game.message(arrayList);
                return false;
            }
        };
        script.set("DamageType", string);
        script.set("Damage", n);
        script.set("DamageDescription", string2);
        script.set("DamageProbability", n2);
        return script;
    }

    public static Script areaDamage(String string, int n, int n2, String string2, String string3) {
        Script script = new Script(){
            private static final long serialVersionUID = 3258130258556696629L;

            public boolean handle(Thing thing, Event event) {
                Map map = thing.getMap();
                if (map == null) {
                    return false;
                }
                Thing thing2 = map.getObjects(thing.x, thing.y);
                if (thing2 == thing) {
                    thing2 = thing2.next;
                }
                if (thing2 != null) {
                    String string = this.getString("DamageFlag");
                    while (thing2 != null && (string == null || thing2.getFlag(string))) {
                        int n = RPG.round((double)(this.getStat("DamageRate") * event.getStat("Time")) / 1000000.0);
                        if (n > 0) {
                            int n2 = 0;
                            String string2 = this.getString("DamageType");
                            int n3 = this.getStat("Damage");
                            for (int i = 0; i < n; ++i) {
                                n2 += Damage.inflict(thing2, n3, string2);
                            }
                            if (n2 > 0) {
                                thing2.message(this.getString("DamageDescription"));
                            }
                        }
                        if ((thing2 = thing2.next) != thing) continue;
                        thing2 = thing2.next;
                    }
                }
                return false;
            }
        };
        script.set("DamageType", string);
        script.set("Damage", n);
        script.set("DamageDescription", string2);
        script.set("DamageRate", n2);
        script.set("DamageFlag", string3);
        return script;
    }

    public static Script addEffect(String string, Thing thing, int n) {
        AddEffectScript addEffectScript = new AddEffectScript();
        addEffectScript.set("TargetProperty", string);
        addEffectScript.set("Effect", new Thing(thing));
        addEffectScript.set("Chance", n);
        return addEffectScript;
    }

    public static Script statGain(String string, String string2, int n) {
        return Scripts.statGain(string, string2, n, 100);
    }

    public static Script statGain(String string, String string2, int n, int n2) {
        Script script = new Script(){
            private static final long serialVersionUID = 1L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = (Thing)event.get(this.getString("TargetProperty"));
                if (thing2 == null) {
                    throw new Error("No target for statGain!");
                }
                String string = this.getString("Stats");
                String[] stringArray = string.split(",");
                String string2 = stringArray[RPG.r(stringArray.length)];
                int n = this.getStat("Max");
                if (thing.getFlag("IsBlessed")) {
                    n = n * 3 / 2;
                }
                if (thing.getFlag("IsCursed")) {
                    n /= 2;
                }
                int n2 = Being.averageStat(thing2);
                int n3 = thing2.getStat(string2);
                boolean bl = n > n2;
                int n4 = this.getStat("Chance");
                if ((double)n3 * 100.0 > (double)n * (120.0 + (double)n4)) {
                    bl = false;
                }
                if (bl && RPG.d(100) <= n4) {
                    Being.gainStat(thing2, string2);
                } else if ((thing2.getFlag("Perception") || Item.isIdentified(thing)) && bl) {
                    String string3 = (new String[]{"skill", "strength", "agility", "toughness", "intelligence", "willpower", "charisma", "craft"})[Being.statIndex(string2)];
                    thing2.message("You feel good about your " + string3);
                }
                return false;
            }
        };
        script.set("Stats", string2);
        script.set("Chance", n2);
        script.set("Max", n);
        script.set("TargetProperty", string);
        return script;
    }

    public static Script heal(String string, int n, int n2) {
        Script script = new Script(){
            private static final long serialVersionUID = 1L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = (Thing)event.get(this.getString("TargetProperty"));
                int n = this.getStat("Increment");
                int n2 = this.getStat("Chance");
                if (!thing2.getFlag("IsBeing")) {
                    return false;
                }
                if (RPG.d(100) > n2) {
                    return false;
                }
                if (thing2.getFlag("IsUndead")) {
                    n = -n;
                }
                int n3 = thing2.getStat("HPS");
                int n4 = thing2.getStat("HPSMAX");
                int n5 = RPG.min(n, n4 - n3);
                if (n5 > 0) {
                    if (n5 > n3) {
                        thing2.message("You feel much better!");
                    } else if (n5 + n3 == n4) {
                        thing2.message("You feel superb");
                    } else {
                        thing2.message("You feel better");
                    }
                } else if (n3 == n4) {
                    thing2.message("You couldn't feel any better!");
                } else if (n5 < 0) {
                    thing2.message("You feel strangely worse");
                }
                thing2.incStat("HPS", n5);
                return false;
            }
        };
        script.set("Increment", n);
        script.set("Chance", n2);
        script.set("TargetProperty", string);
        return script;
    }

    public static Script cure(int n) {
        CureScript cureScript = new CureScript();
        cureScript.set("Strength", n);
        return cureScript;
    }

    public static Script incStat(String string, String string2, int n, String string3) {
        Script script = new Script(){
            private static final long serialVersionUID = 3691036565141074487L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = (Thing)event.get(this.getString("TargetProperty"));
                String string = this.getString("Stats");
                String[] stringArray = string.split(",");
                String string2 = stringArray[RPG.r(stringArray.length)];
                thing2.incStat(string2, this.getStat("Increment"));
                thing2.message(this.getString("IncMessage"));
                return false;
            }
        };
        script.set("Stats", string2);
        script.set("Increment", n);
        script.set("IncMessage", string3);
        script.set("TargetProperty", string);
        return script;
    }

    public static Script spellEffect(String string, String string2, int n) {
        Script script = new Script(){
            private static final long serialVersionUID = 3257849865827530038L;

            public boolean handle(Thing thing, Event event) {
                if (RPG.r(100) >= this.getStat("Chance")) {
                    return false;
                }
                Thing thing2 = (Thing)event.get(this.getString("TargetProperty"));
                Thing thing3 = this.getThing("Spell");
                Spell.castAtObject(thing3, null, thing2);
                return false;
            }
        };
        Thing thing = Lib.create(string2);
        script.set("Spell", thing);
        script.set("Chance", n);
        script.set("TargetProperty", string);
        return script;
    }

    public static Script combine(EventHandler eventHandler, EventHandler eventHandler2) {
        if (eventHandler instanceof CombinedScript) {
            CombinedScript combinedScript = (CombinedScript)eventHandler;
            EventHandler[] eventHandlerArray = (EventHandler[])combinedScript.get("Scripts");
            int n = eventHandlerArray.length;
            EventHandler[] eventHandlerArray2 = new EventHandler[n + 1];
            System.arraycopy(eventHandlerArray, 0, eventHandlerArray2, 0, n);
            eventHandlerArray2[n] = eventHandler2;
            CombinedScript combinedScript2 = new CombinedScript();
            combinedScript2.set("Scripts", eventHandlerArray2);
            return combinedScript2;
        }
        EventHandler[] eventHandlerArray = new EventHandler[]{eventHandler, eventHandler2};
        CombinedScript combinedScript = new CombinedScript();
        combinedScript.set("Scripts", eventHandlerArray);
        return combinedScript;
    }

    public static Script generator(String string, int n, int n2) {
        GeneratorScript generatorScript = new GeneratorScript();
        generatorScript.set("GenerationType", string);
        generatorScript.set("GenerationRate", n);
        generatorScript.set("GenerationLevel", n2);
        return generatorScript;
    }

    public static Script generator(String string, int n) {
        GeneratorScript generatorScript = new GeneratorScript();
        generatorScript.set("GenerationType", string);
        generatorScript.set("GenerationRate", n);
        return generatorScript;
    }

    public static Script generatorInPlace(String string, int n) {
        GeneratorScript generatorScript = new GeneratorScript();
        generatorScript.set("GenerationType", string);
        generatorScript.set("GenerationRate", n);
        generatorScript.set("GenerationInPlace", 1);
        return generatorScript;
    }

    public static Script statusSwitch(Script script, Script script2, Script script3) {
        Script script4 = new Script(){
            private static final long serialVersionUID = 3544957670705740086L;

            public boolean handle(Thing thing, Event event) {
                if (thing.getFlag("IsCursed")) {
                    return this.getHandler("WhenCursed").handle(thing, event);
                }
                if (thing.getFlag("IsBlessed")) {
                    return this.getHandler("WhenBlessed").handle(thing, event);
                }
                return this.getHandler("WhenNormal").handle(thing, event);
            }
        };
        script4.set("WhenBlessed", script);
        script4.set("WhenNormal", script2);
        script4.set("WhenCursed", script3);
        return script4;
    }

    public static Script decay() {
        return Scripts.decay(false);
    }

    public static Script die() {
        return new Script(){
            private static final long serialVersionUID = 1L;

            public boolean handle(Thing thing, Event event) {
                thing.die();
                return false;
            }
        };
    }

    public static Script message(String string) {
        Script script = new Script(){
            private static final long serialVersionUID = 1L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = event.getThing("Target");
                thing2.message(this.getString("Message"));
                return false;
            }
        };
        script.set("Message", string);
        return script;
    }

    public static Script decay(boolean bl) {
        DecayScript decayScript = new DecayScript();
        decayScript.set("WhileCarried", bl);
        return decayScript;
    }

    private static class CombinedScript
    extends Script {
        private static final long serialVersionUID = 543897876490907635L;

        private CombinedScript() {
        }

        public boolean handle(Thing thing, Event event) {
            EventHandler[] eventHandlerArray = (EventHandler[])this.get("Scripts");
            for (int i = 0; i < eventHandlerArray.length; ++i) {
                if (eventHandlerArray[i] == null || !eventHandlerArray[i].handle(thing, event)) continue;
                return true;
            }
            return false;
        }
    }

    private static class DecayScript
    extends Script {
        private static final long serialVersionUID = -8785297945265824277L;

        private DecayScript() {
        }

        public boolean handle(Thing thing, Event event) {
            int n;
            int n2 = event.getStat("Time");
            Map map = thing.getMap();
            int n3 = thing.getMapX();
            int n4 = thing.getMapY();
            boolean bl = this.getFlag("WhileCarried");
            if (!bl && map != thing.place) {
                return false;
            }
            if (thing.getFlag("DecayRate")) {
                n = thing.getStat("DecayRate");
                if (RPG.r(1000000) < n * n2) {
                    String string = thing.getString("DecayType");
                    String string2 = thing.getString("DecayMessage");
                    if (string2 != null && thing.isVisible(Game.hero())) {
                        Game.message(thing.getTheName() + " " + string2);
                    }
                    if (string != null) {
                        boolean bl2 = map.isBlocked(n3, n4);
                        Thing thing2 = Lib.create(string);
                        map.addThing(thing2, n3, n4);
                        if (bl2) {
                            thing2.displace();
                        }
                    }
                    thing.die();
                    return true;
                }
            }
            if (thing.getFlag("LifeTime")) {
                n = thing.getStat("LifeTime") - n2;
                thing.set("LifeTime", n);
                if (n <= 0) {
                    thing.remove();
                    return true;
                }
            }
            return false;
        }
    }

    private static class GeneratorScript
    extends Script {
        private static final long serialVersionUID = 7473182575628000762L;

        private GeneratorScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Map map = thing.getMap();
            if (map == null) {
                return false;
            }
            if (map.getFlag("IsWorldMap")) {
                return false;
            }
            int n = this.getStat("GenerationLevel");
            if (n == 0) {
                n = Game.level();
            }
            int n2 = event.getStat("Time");
            int n3 = this.getStat("GenerationRate");
            if (n3 > 0) {
                String string = this.getString("GenerationType");
                int n4 = this.getStat("GenerationInPlace");
                for (int i = RPG.po(n2 * n3, 1000000); i > 0; --i) {
                    Thing thing2;
                    if (string == null) {
                        thing2 = Lib.createMonster(n);
                    } else {
                        String[] stringArray = string.split(",");
                        thing2 = Lib.create(stringArray[RPG.r(stringArray.length)], n);
                    }
                    boolean bl = false;
                    if (n4 > 0) {
                        map.addThing(thing2, thing.getMapX(), thing.getMapY());
                    } else {
                        bl = map.addBlockingThing(thing2, thing.getMapX() - 1, thing.getMapY() - 1, thing.getMapX() + 1, thing.getMapY() + 1);
                    }
                    if (!bl || !thing.getFlag("IsBeing") || !thing2.getFlag("IsBeing") || thing2.getLevel() <= thing.getLevel() - 10) continue;
                    AI.setFollower(thing2, thing);
                }
            }
            return false;
        }
    }

    private static class CureScript
    extends Script {
        private static final long serialVersionUID = 3978138846573377330L;

        private CureScript() {
        }

        public boolean handle(Thing thing, Event event) {
            int n;
            Thing thing2 = event.getThing("Target");
            int n2 = n = event.getStat("Strength");
            Poison.cure(thing2, n2);
            return false;
        }
    }

    private static class AddThingScript
    extends Script {
        private static final long serialVersionUID = 3257004345781465909L;

        private AddThingScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = (Thing)event.get(this.getString("TargetProperty"));
            if (event != null && RPG.r(100) < this.getStat("Chance")) {
                thing2.addThing(Lib.create(this.getString("ThingName")));
            }
            return false;
        }
    }

    private static class AddEffectScript
    extends Script {
        private static final long serialVersionUID = 9106886823123784009L;

        private AddEffectScript() {
        }

        public boolean handle(Thing thing, Event event) {
            int n;
            Thing thing2 = this.getThing("Effect");
            int n2 = this.getStat("Chance");
            Thing thing3 = (Thing)event.get(this.getString("TargetProperty"));
            String string = thing2.getString("ResistStat");
            if (string != null && RPG.test(n = thing3.getStat(string), thing2.getStat("ResistDifficulty"))) {
                thing3.message(thing2.getString("ResistMessage"));
                return false;
            }
            if (event != null && RPG.r(100) < n2) {
                thing3.addAttribute(new Thing(thing2));
            }
            return false;
        }
    }
}

