/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Being;
import mikera.tyrant.Event;
import mikera.tyrant.Fire;
import mikera.tyrant.Game;
import mikera.tyrant.Gods;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Portal;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Scripts;
import mikera.tyrant.Thing;
import mikera.tyrant.Wish;

public class Scenery {
    public static void init() {
        Thing thing = Lib.extendCopy("base scenery", "base thing");
        thing.set("Frequency", 30);
        thing.set("IsScenery", 1);
        thing.set("IsPhysical", 1);
        thing.set("IsDestructible", 1);
        thing.set("IsJumpable", 1);
        thing.set("ImageSource", "Scenery");
        thing.set("IsBlocking", 1);
        thing.set("IsOwned", 1);
        thing.set("MapColour", 9470064);
        thing.set("Z", 19);
        thing.set("ASCII", "#");
        thing.set("HPS", 10);
        Lib.add(thing);
        thing = Lib.extend("sewer", "base scenery");
        thing.set("IsActive", 1);
        thing.set("IsGenerator", 1);
        thing.set("OnAction", Scripts.generator("sewer rat", 10));
        thing.set("LevelMin", 4);
        thing.set("LevelMin", 3);
        thing.set("IsBlocking", 0);
        thing.set("Image", 303);
        Lib.add(thing);
        thing = Lib.extend("rat cave", "base scenery");
        thing.set("IsActive", 1);
        thing.set("IsGenerator", 1);
        thing.set("IsBlocking", 0);
        thing.set("OnAction", Scripts.generator("[IsRat]", 20));
        thing.set("LevelMin", 2);
        thing.set("Image", 303);
        Lib.add(thing);
        thing = Lib.extend("vortex", "base scenery");
        thing.set("IsActive", 1);
        thing.set("IsGenerator", 1);
        thing.addHandler("OnAction", Scripts.generator(null, 500));
        thing.set("LevelMin", 3);
        thing.set("Image", 40);
        Lib.add(thing);
        thing = Lib.extend("demon vortex", "base scenery");
        thing.set("IsActive", 1);
        thing.set("IsGenerator", 1);
        thing.addHandler("OnAction", Scripts.generator("[IsDemonic]", 500, 29));
        thing.set("LevelMin", 31);
        thing.set("Image", 40);
        Lib.add(thing);
        thing = Lib.extend("greater demon vortex", "base scenery");
        thing.set("IsActive", 1);
        thing.set("IsGenerator", 1);
        thing.addHandler("OnAction", Scripts.generator("[IsDemonic]", 500, 36));
        thing.set("LevelMin", 39);
        thing.set("Image", 40);
        Lib.add(thing);
        Fire.init();
        Portal.init();
        Scenery.initTrees();
        Scenery.initFruitTrees();
        Scenery.initBushes();
        Scenery.initSigns();
        Scenery.initPlants();
        Scenery.initFurniture();
        Scenery.initGraveStones();
        Scenery.initWells();
        Scenery.initWebs();
        Scenery.initMasonry();
        Scenery.initFountains();
        Scenery.initFortifications();
        Scenery.initAltars();
    }

    private static void initMasonry() {
        Thing thing = Lib.extend("base masonry", "base scenery");
        thing.set("Material", "stone");
        thing.set("RES:impact", -10);
        Lib.add(thing);
        thing = Lib.extend("stone bench", "base masonry");
        thing.set("Image", 225);
        thing.set("LevelMin", 10);
        thing.set("HPS", 85);
        thing.set("IsBlocking", 0);
        Lib.add(thing);
        thing = Lib.extend("menhir", "base masonry");
        thing.set("Image", 228);
        thing.set("LevelMin", 1);
        thing.set("HPS", 285);
        thing.set("IsBlocking", 1);
        Lib.add(thing);
        thing = Lib.extend("bird bath", "base masonry");
        thing.set("Image", 224);
        thing.set("LevelMin", 7);
        thing.set("HPS", 60);
        thing.set("IsBlocking", 1);
        Lib.add(thing);
    }

    private static void initFurniture() {
        Thing thing = Lib.extend("base furniture", "base scenery");
        thing.set("IsFurniture", 1);
        thing.set("Image", 200);
        thing.set("HPS", 30);
        thing.set("IsBlocking", 1);
        Lib.add(thing);
        thing = Lib.extend("table", "base furniture");
        thing.set("UName", "table");
        thing.set("Image", 200);
        thing.set("LevelMin", 7);
        thing.set("Z", 4);
        Lib.add(thing);
        thing = Lib.extend("NS table", "table");
        thing.set("LevelMin", 7);
        thing.set("Image", 202);
        Lib.add(thing);
        thing = Lib.extend("EW table", "table");
        thing.set("LevelMin", 7);
        thing.set("Image", 201);
        Lib.add(thing);
        thing = Lib.extend("stool", "base furniture");
        thing.set("Image", 203);
        thing.set("HPS", 15);
        thing.set("IsBlocking", 0);
        thing.set("LevelMin", 6);
        Lib.add(thing);
        thing = Lib.extend("tent", "base furniture");
        thing.set("Image", 304);
        thing.set("LevelMin", 8);
        thing.set("IsBlocking", 1);
        Lib.add(thing);
    }

    private static void initWebs() {
        Thing thing = Lib.extend("base web", "base scenery");
        thing.set("IsWeb", 1);
        thing.set("NoStack", 1);
        thing.set("Image", 48);
        thing.set("HPS", 15);
        thing.set("IsBlocking", 0);
        thing.set("IsWarning", 1);
        thing.set("RES:impact", 10);
        thing.set("RES:piercing", 20);
        thing.set("RES:fire", -13);
        thing.set("LevelMin", 1);
        Script script = Scripts.addThing("Target", "web");
        script = Scripts.combine(script, Scripts.die());
        thing.addHandler("OnEnterTrigger", script);
        Lib.add(thing);
        thing = Lib.extend("spider web", "base web");
        thing.set("IsActive", 1);
        thing.set("DecayRate", 20);
        Lib.add(thing);
        thing = Lib.extend("giant spider web", "base web");
        thing.set("HPS", 40);
        Lib.add(thing);
        thing = Lib.extend("spider infested web", "base web");
        thing.set("IsActive", 1);
        thing.set("IsGenerator", 1);
        thing.addHandler("OnAction", Scripts.generator("baby giant spider", 30));
        thing.set("LevelMin", 14);
        thing.set("HPS", 150);
        Lib.add(thing);
    }

    private static void initSigns() {
        Thing thing = Lib.extend("blank sign", "base scenery");
        thing.set("IsSign", 1);
        thing.set("Image", 64);
        thing.set("HPS", 20);
        thing.set("IsBlocking", 0);
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("bank sign", "blank sign");
        thing.set("Image", 67);
        Lib.add(thing);
        thing = Lib.extend("armoury sign", "blank sign");
        thing.set("Image", 63);
        Lib.add(thing);
        thing = Lib.extend("store sign", "blank sign");
        thing.set("Image", 60);
        Lib.add(thing);
        thing = Lib.extend("magic shop sign", "blank sign");
        thing.set("Image", 62);
        Lib.add(thing);
        thing = Lib.extend("smithy sign", "blank sign");
        thing.set("Image", 61);
        Lib.add(thing);
        thing = Lib.extend("food shop sign", "blank sign");
        thing.set("Image", 60);
        Lib.add(thing);
        thing = Lib.extend("inn sign", "blank sign");
        thing.set("Image", 61);
        Lib.add(thing);
    }

    private static void initPlants() {
        Thing thing = Lib.extend("base plant", "base scenery");
        thing.set("IsPlant", 1);
        thing.set("Image", 81);
        thing.set("HPS", 5);
        thing.set("IsViewBlocking", 0);
        thing.set("IsBlocking", 0);
        Lib.add(thing);
        thing = Lib.extend("plant", "base plant");
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("potted plant", "base plant");
        thing.set("Image", 226);
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("potted flower", "base plant");
        thing.set("Image", 227);
        thing.set("LevelMin", 1);
        Lib.add(thing);
    }

    private static void initFountains() {
        Thing thing = Lib.extend("base fountain", "base scenery");
        thing.set("HPS", 200);
        thing.set("IsFountain", 1);
        thing.set("IsBlocking", 1);
        thing.set("Frequency", 30);
        thing.set("LevelMin", 1);
        thing.set("Image", 249);
        thing.set("ASCII", "0");
        Lib.add(thing);
        thing = Lib.extend("fountain", "base fountain");
        thing.set("OnBump", new FountainScript());
        Lib.add(thing);
        thing = Lib.extend("dry fountain", "base fountain");
        thing.set("Image", 250);
        Lib.add(thing);
    }

    private static void initFortifications() {
        Thing thing = Lib.extend("base fortification", "base scenery");
        thing.set("HPS", 100);
        thing.set("IsFortification", 1);
        thing.set("IsBlocking", 1);
        thing.set("Frequency", 30);
        thing.set("LevelMin", 1);
        thing.set("Image", 70);
        thing.set("ASCII", "x");
        Lib.add(thing);
        thing = Lib.extend("barricade", "base fortification");
        Lib.add(thing);
    }

    private static void initAltars() {
        Thing thing = Lib.extend("base altar", "base scenery");
        thing.set("HPS", 200);
        thing.set("IsAltar", 1);
        thing.set("IsBlocking", 1);
        thing.set("Frequency", 30);
        thing.set("LevelMin", 1);
        thing.set("Image", 240);
        thing.set("OnBump", new AltarScript());
        thing.set("ASCII", "_");
        Lib.add(thing);
        thing = Lib.extend("golden altar", "base altar");
        Lib.add(thing);
        thing = Lib.extend("chaos altar", "base altar");
        thing.set("Image", 246);
        Lib.add(thing);
        thing = Lib.extend("stone altar", "base altar");
        thing.set("Image", 245);
        Lib.add(thing);
        thing = Lib.extend("dark altar", "base altar");
        thing.set("Image", 247);
        Lib.add(thing);
    }

    private static void initWells() {
        Thing thing = Lib.extend("base well", "base scenery");
        thing.set("HPS", 200);
        thing.set("IsWell", 1);
        thing.set("IsBlocking", 1);
        thing.set("Frequency", 100);
        thing.set("LevelMin", 1);
        thing.set("OnBump", new WellScript());
        thing.set("Image", 223);
        Lib.add(thing);
        thing = Lib.extend("well", "base well");
        Lib.add(thing);
        thing = Lib.extend("magic well", "base well");
        thing.set("Frequency", 10);
        thing.set("Image", 222);
        thing.set("WishChance", 2);
        thing.set("DeathDecoration", "[IsMagicItem]");
        Lib.add(thing);
        thing = Lib.extend("wishing well", "base well");
        thing.set("Frequency", 1);
        thing.set("WishChance", 100);
        thing.set("IsActive", 1);
        thing.addHandler("OnAction", Scripts.generator("flutterby", 2000));
        thing.set("DeathDecoration", "Ultimate Destruction");
        Lib.add(thing);
    }

    private static void initGraveStones() {
        Thing thing = Lib.extend("base gravestone", "base scenery");
        thing.set("HPS", 50);
        thing.set("IsGravestone", 1);
        thing.set("LevelMin", 1);
        thing.set("IsBlocking", 1);
        thing.set("DeathDecoration", "ghost");
        thing.set("OnBump", new GraveStoneScript());
        thing.set("Image", 220);
        Lib.add(thing);
        thing = Lib.extend("gravestone", "base gravestone");
        Lib.add(thing);
        thing = Lib.extend("small gravestone", "base gravestone");
        thing.set("HPS", 30);
        thing.set("IsBlocking", 1);
        thing.set("DeathDecoration", "[IsUndead]");
        Lib.add(thing);
    }

    private static void initTrees() {
        Thing thing = Lib.extend("base tree", "base scenery");
        thing.set("IsJumpable", 0);
        thing.set("IsBaseTree", 1);
        thing.set("IsTree", 1);
        thing.set("Image", 83);
        thing.set("HPS", 100);
        thing.set("ARM", 4);
        thing.set("IsViewBlocking", 1);
        thing.set("IsBlocking", 1);
        thing.set("DeathDecoration", "wooden log");
        Lib.add(thing);
        thing = Lib.extend("tree", "base tree");
        thing.set("LevelMin", 1);
        thing.set("IsSawable", 1);
        thing.set("SawDifficulty", 30);
        thing.set("IsChopable", 1);
        thing.set("Image", 90);
        Lib.add(thing);
        thing = Lib.extend("pine tree", "base tree");
        thing.set("LevelMin", 1);
        thing.set("IsSawable", 1);
        thing.set("SawDifficulty", 30);
        thing.set("IsChopable", 1);
        thing.set("Image", 94);
        Lib.add(thing);
        thing = Lib.extend("small tree", "tree");
        thing.set("IsViewBlocking", 0);
        thing.set("Image", 90);
        Lib.add(thing);
        thing = Lib.extend("tree stump", "tree");
        thing.set("Z", 6);
        thing.set("IsViewBlocking", 0);
        thing.set("IsBlocking", 0);
        thing.set("IsOwned", 0);
        thing.set("Image", 84);
        Lib.add(thing);
        thing = Lib.extend("withered tree", "tree");
        thing.set("Image", 83);
        thing.set("IsViewBlocking", 0);
        Lib.add(thing);
        thing = Lib.extend("large tree", "tree");
        thing.set("Image", 82);
        thing.set("HPS", 300);
        Lib.add(thing);
    }

    private static void initFruitTrees() {
        Thing thing = Lib.extend("base fruit tree", "tree");
        thing.set("Image", 91);
        thing.set("IsFruitTree", 1);
        thing.set("IsActive", 1);
        Lib.add(thing);
        thing = Lib.extend("apple tree", "base fruit tree");
        thing.set("ViewBlocking", 0);
        thing.addHandler("OnAction", Scripts.generator("apple,cooking apple", 10));
        Lib.add(thing);
        thing = Lib.extend("red apple tree", "apple tree");
        thing.set("Image", 91);
        thing.addHandler("OnAction", Scripts.generator("red apple,juicy apple", 10));
        Lib.add(thing);
        thing = Lib.extend("crab apple tree", "apple tree");
        thing.set("Image", 91);
        thing.set("IsFruitTree", 0);
        thing.addHandler("OnAction", Scripts.generator("crab apple", 15));
        Lib.add(thing);
        thing = Lib.extend("cherry tree", "base fruit tree");
        thing.set("Image", 91);
        thing.addHandler("OnAction", Scripts.generator("cherry", 15));
        thing.set("LevelMin", 7);
        Lib.add(thing);
        thing = Lib.extend("ranier cherry tree", "base fruit tree");
        thing.set("Image", 91);
        thing.set("Frequency", 5);
        thing.addHandler("OnAction", Scripts.generator("ranier cherry", 10));
        thing.set("LevelMin", 17);
        Lib.add(thing);
        thing = Lib.extend("peach tree", "base fruit tree");
        thing.set("Image", 91);
        thing.addHandler("OnAction", Scripts.generator("peach", 15));
        thing.set("LevelMin", 9);
        Lib.add(thing);
        thing = Lib.extend("orange tree", "base fruit tree");
        thing.set("Image", 91);
        thing.addHandler("OnAction", Scripts.generator("orange", 15));
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("lemon tree", "base fruit tree");
        thing.set("Image", 91);
        thing.addHandler("OnAction", Scripts.generator("lemon", 15));
        thing.set("LevelMin", 7);
        Lib.add(thing);
        thing = Lib.extend("plum tree", "base fruit tree");
        thing.set("Image", 91);
        thing.addHandler("OnAction", Scripts.generator("plum", 15));
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("apricot tree", "base fruit tree");
        thing.set("Image", 91);
        thing.addHandler("OnAction", Scripts.generator("apricot", 15));
        thing.set("LevelMin", 12);
        Lib.add(thing);
        thing = Lib.extend("lime tree", "base fruit tree");
        thing.set("Image", 91);
        thing.addHandler("OnAction", Scripts.generator("lime", 15));
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("key lime tree", "base fruit tree");
        thing.set("Image", 91);
        thing.set("Frequency", 5);
        thing.addHandler("OnAction", Scripts.generator("key lime", 10));
        thing.set("LevelMin", 20);
        Lib.add(thing);
    }

    private static void initBushes() {
        Thing thing = Lib.extend("bush", "base tree");
        thing.set("IsViewBlocking", 1);
        thing.set("IsBlocking", 0);
        thing.set("IsBush", 1);
        thing.set("HPS", 10);
        thing.set("ARM", 2);
        thing.set("LevelMin", 1);
        thing.set("Image", 92);
        thing.set("DeathDecoration", "stick");
        Lib.add(thing);
        thing = Lib.extend("small bush", "bush");
        thing.set("IsViewBlocking", 0);
        thing.set("IsBlocking", 0);
        thing.set("Image", 92);
        Lib.add(thing);
        thing = Lib.extend("thick bush", "bush");
        thing.set("IsViewBlocking", 1);
        thing.set("IsBlocking", 1);
        thing.set("HPS", 30);
        thing.set("Image", 80);
        Lib.add(thing);
        thing = Lib.extend("thorny bush", "bush");
        thing.set("IsViewBlocking", 0);
        thing.set("IsBlocking", 1);
        thing.set("Image", 83);
        Lib.add(thing);
        thing = Lib.extend("base berry patch", "bush");
        thing.set("IsViewBlocking", 0);
        thing.set("IsBlocking", 0);
        thing.set("IsBerryBush", 1);
        thing.set("IsFruit", 1);
        thing.set("IsActive", 1);
        thing.set("Image", 92);
        Lib.add(thing);
        thing = Lib.extend("strawberry patch", "base berry patch");
        thing.set("Image", 92);
        thing.addHandler("OnAction", Scripts.generatorInPlace("strawberry", 15));
        Lib.add(thing);
        thing = Lib.extend("raspberry patch", "base berry patch");
        thing.set("Image", 92);
        thing.addHandler("OnAction", Scripts.generatorInPlace("raspberry", 15));
        Lib.add(thing);
        thing = Lib.extend("blueberry bush", "base berry patch");
        thing.set("Image", 92);
        thing.addHandler("OnAction", Scripts.generatorInPlace("blueberry", 15));
        Lib.add(thing);
        thing = Lib.extend("grape vine", "base berry patch");
        thing.set("Image", 92);
        thing.addHandler("OnAction", Scripts.generatorInPlace("grape", 15));
        Lib.add(thing);
    }

    private static class GraveStoneScript
    extends Script {
        private static final long serialVersionUID = -2908356113863537197L;
        private static String[] inscriptions = new String[]{"Justin Tyme", "Yetta Nuther", "Barry D'Alyve", "Dawn Under", "Ted N. Burried", "Yul B. Nechzt", "Bill M. Layder", "Leff B. Hynde", "Kerry M. Off", "Fester N. Rott", "Reid N. Weep", "Sue D'Bum", "Jess Gough", "Barry M. Deep", "U. R. Gonne", "Davy Jones", "Otta B. Alyve", "B. Ware", "Dr. U. Dysoon", "Berry D. Hatchet", "R. U. Next", "Dr. Izzy Gone", "C3PO - Rust in Peace", "R.I.P", "Here Lies Mozart Decomposing", "As you pass by\nAnd cast an eye\nAs you are now\nSo once was I", "Here lies the body of my sweet sister\nShe was just fine 'til Dracula kissed her", "Treasure Hunter Lies Below\nA Ghastly Curse Laid Him Low", "If money thou art in need of any, dig three feet and find a penny!", "Treasure Seeker Dug Deep One Night\nTo His Misfortune, He died Of Fright."};

        private GraveStoneScript() {
        }

        public boolean handle(Thing thing, Event event) {
            int n = thing.x + thing.y * 103 + 10017;
            Thing thing2 = event.getThing("Target");
            if (thing2 != Game.hero()) {
                return false;
            }
            if (thing2.getFlag("Literacy")) {
                Game.message("You read the inscription on " + thing.getTheName() + ":");
                String string = inscriptions[n % inscriptions.length];
                String[] stringArray = string.split("\n");
                for (int i = 0; i < stringArray.length; ++i) {
                    Game.message("  \"" + stringArray[i] + "\"");
                }
            } else {
                Game.message("You notice some inscriptions on " + thing.getTheName());
            }
            return false;
        }
    }

    private static class FountainScript
    extends Script {
        private static final long serialVersionUID = 1L;

        private FountainScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            if (!thing2.isHero()) {
                return false;
            }
            event.set("ActionTaken", 1);
            thing2.message("You drink from the fountain");
            thing2.incStat("APS", -100);
            Being.heal(thing2, 1);
            if (RPG.d(30) == 1) {
                thing2.message(thing.getTheName() + " dries up");
                thing.replace("dry fountain");
            }
            return false;
        }
    }

    private static class AltarScript
    extends Script {
        private static final long serialVersionUID = 1L;

        private AltarScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            if (!thing2.isHero()) {
                return false;
            }
            event.set("ActionTaken", 1);
            String string = thing2.getString("Religion");
            String string2 = thing.getString("Religion");
            if (string2 != null && !string2.equals(string)) {
                thing2.message("This altar is dedicated to " + string2);
                thing2.message("Since you worship " + string + ", you may not make sacrifices here.");
            }
            Thing thing3;
            while ((thing3 = Game.selectItem("Select an item to scrifice to " + string, thing2.getItems())) != null) {
                Gods.sacrifice(thing2, thing3);
            }
            return false;
        }
    }

    private static class WellScript
    extends Script {
        private static final long serialVersionUID = 3832620690351338806L;

        private WellScript() {
        }

        public boolean handle(Thing thing, Event event) {
            int n;
            Thing thing2 = event.getThing("Target");
            if (!thing2.isHero()) {
                return false;
            }
            Thing thing3 = Game.selectItem("Select an item to drop in the well:", thing2);
            if (thing3 == null) {
                Game.message("");
                return false;
            }
            thing3 = thing3.remove(1);
            Game.message("You drop " + thing3.getTheName() + " into " + thing.getTheName());
            Game.message("Splooosh!");
            int n2 = n = Item.value(thing3) > 10000 ? 1 : 0;
            if (thing3.getFlag("IsCoin")) {
                n = 1;
            }
            if (n > 0 && RPG.r(100) < thing.getStat("WishChance")) {
                Wish.doWish();
            }
            thing.set("WishChance", 0);
            return true;
        }
    }
}

