/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Door;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.RPG;
import mikera.tyrant.Theme;

class RogueDungeon {
    protected int bh;
    protected int bw;
    protected int th;
    protected int tw;
    protected static final int LN = 1;
    protected static final int LE = 2;
    protected static final int LS = 4;
    protected static final int LW = 8;
    protected int[][] links;
    protected int[][] linkedzones;
    protected int[][] rx;
    protected int[][] ry;
    protected int[][] rw;
    protected int[][] rh;

    private RogueDungeon(int n, int n2, int n3, int n4) {
        try {
            this.th = n4;
            this.tw = n3;
            this.bw = n;
            this.bh = n2;
            this.rx = new int[n][];
            this.ry = new int[n][];
            this.rw = new int[n][];
            this.rh = new int[n][];
            this.links = new int[n][];
            this.linkedzones = new int[n][];
            for (int i = 0; i < n; ++i) {
                this.rx[i] = new int[n2];
                this.ry[i] = new int[n2];
                this.rw[i] = new int[n2];
                this.rh[i] = new int[n2];
                this.links[i] = new int[n2];
                this.linkedzones[i] = new int[n2];
            }
        }
        catch (Exception exception) {
            Game.message("Failed to construct RogueDungeon");
            Game.message(exception.toString());
        }
    }

    public static Map create(int n, Theme theme) {
        RogueDungeon rogueDungeon = new RogueDungeon(3 + RPG.r(n / 3), 3 + RPG.r(n / 3), 8 + RPG.d(n), 8 + RPG.d(n));
        Map map = new Map(rogueDungeon.bw * rogueDungeon.tw, rogueDungeon.bh * rogueDungeon.th);
        map.setLevel(n);
        map.setTheme(theme);
        rogueDungeon.build(map);
        return map;
    }

    public void replaceLinkedZones(int n, int n2) {
        for (int i = 0; i < this.bw; ++i) {
            for (int j = 0; j < this.bh; ++j) {
                if (this.linkedzones[i][j] != n) continue;
                this.linkedzones[i][j] = n2;
            }
        }
    }

    public void makeLink(int n, int n2, int n3, int n4) {
        if (n3 == 1) {
            int[] nArray = this.links[n];
            int n5 = n2;
            nArray[n5] = nArray[n5] | 2;
            int[] nArray2 = this.links[n + n3];
            int n6 = n2 + n4;
            nArray2[n6] = nArray2[n6] | 8;
        }
        if (n3 == -1) {
            int[] nArray = this.links[n];
            int n7 = n2;
            nArray[n7] = nArray[n7] | 8;
            int[] nArray3 = this.links[n + n3];
            int n8 = n2 + n4;
            nArray3[n8] = nArray3[n8] | 2;
        }
        if (n4 == 1) {
            int[] nArray = this.links[n];
            int n9 = n2;
            nArray[n9] = nArray[n9] | 4;
            int[] nArray4 = this.links[n + n3];
            int n10 = n2 + n4;
            nArray4[n10] = nArray4[n10] | 1;
        }
        if (n4 == -1) {
            int[] nArray = this.links[n];
            int n11 = n2;
            nArray[n11] = nArray[n11] | 1;
            int[] nArray5 = this.links[n + n3];
            int n12 = n2 + n4;
            nArray5[n12] = nArray5[n12] | 4;
        }
        try {
            int n13 = this.linkedzones[n][n2];
            int n14 = this.linkedzones[n + n3][n2 + n4];
            this.replaceLinkedZones(n13, n14);
        }
        catch (Exception exception) {
            Game.message(exception.toString() + " (" + n + "," + n2 + ") (" + (n + n3) + "," + (n2 + n4) + ")");
        }
    }

    public void makeConnected() {
        boolean bl = false;
        for (int i = 0; i < 100000 && !bl; ++i) {
            int n = RPG.r(this.bw);
            int n2 = RPG.r(this.bh);
            int n3 = RPG.r(3) - 1;
            int n4 = RPG.r(3) - 1;
            while (n4 == 0 && n3 == 0 || n3 * n4 != 0 || n + n3 < 0 || n + n3 >= this.bw || n2 + n4 < 0 || n2 + n4 >= this.bh || this.linkedzones[n][n2] == this.linkedzones[n + n3][n2 + n4]) {
                n = RPG.r(this.bw);
                n2 = RPG.r(this.bh);
                n3 = RPG.r(3) - 1;
                n4 = RPG.r(3) - 1;
            }
            this.makeLink(n, n2, n3, n4);
            int n5 = 10000;
            int n6 = 0;
            for (int j = 0; j < this.bw; ++j) {
                for (int k = 0; k < this.bh; ++k) {
                    int n7 = this.linkedzones[j][k];
                    if (n7 < n5) {
                        n5 = n7;
                    }
                    if (n7 <= n6) continue;
                    n6 = n7;
                }
            }
            bl = n5 == n6;
        }
    }

    public void createDoor(Map map, int n, int n2) {
        switch (RPG.d(3)) {
            case 1: {
                map.setTile(n, n2, map.floor());
                break;
            }
            default: {
                map.addThing(Door.createDoor(map.getLevel()), n, n2);
            }
        }
    }

    public void build(Map map) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        for (n7 = 0; n7 < this.bw; ++n7) {
            for (n6 = 0; n6 < this.bh; ++n6) {
                this.linkedzones[n7][n6] = n7 + this.bw * n6;
            }
        }
        this.makeConnected();
        for (n7 = 0; n7 < this.bw; ++n7) {
            for (n6 = 0; n6 < this.bh; ++n6) {
                this.rw[n7][n6] = RPG.rspread(2, this.tw - 3);
                this.rh[n7][n6] = RPG.rspread(2, this.th - 3);
                this.rx[n7][n6] = n7 * this.tw + RPG.d(this.tw - this.rw[n7][n6] - 2);
                this.ry[n7][n6] = n6 * this.th + RPG.d(this.th - this.rh[n7][n6] - 2);
            }
        }
        for (n7 = 0; n7 < this.bw; ++n7) {
            for (n6 = 0; n6 < this.bh; ++n6) {
                this.makeRoom(map, this.rx[n7][n6], this.ry[n7][n6], this.rx[n7][n6] + this.rw[n7][n6] - 1, this.ry[n7][n6] + this.rh[n7][n6] - 1);
            }
        }
        for (n7 = 0; n7 < this.bw - 1; ++n7) {
            for (n6 = 0; n6 < this.bh; ++n6) {
                if ((this.links[n7][n6] & 2) <= 0) continue;
                n5 = this.ry[n7][n6] + RPG.r(this.rh[n7][n6]);
                n4 = this.ry[n7 + 1][n6] + RPG.r(this.rh[n7 + 1][n6]);
                n3 = this.rx[n7][n6] + this.rw[n7][n6] + 1;
                n2 = this.rx[n7 + 1][n6] - 2;
                this.createDoor(map, n3 - 1, n5);
                this.createDoor(map, n2 + 1, n4);
                n = RPG.rspread(n3, n2);
                map.fillArea(n3, n5, n, n5, map.floor());
                map.fillArea(n, n5, n, n4, map.floor());
                map.fillArea(n, n4, n2, n4, map.floor());
            }
        }
        for (n7 = 0; n7 < this.bw; ++n7) {
            for (n6 = 0; n6 < this.bh - 1; ++n6) {
                if ((this.links[n7][n6] & 4) <= 0) continue;
                n5 = this.rx[n7][n6] + RPG.r(this.rw[n7][n6]);
                n4 = this.rx[n7][n6 + 1] + RPG.r(this.rw[n7][n6 + 1]);
                n3 = this.ry[n7][n6] + this.rh[n7][n6] + 1;
                n2 = this.ry[n7][n6 + 1] - 2;
                this.createDoor(map, n5, n3 - 1);
                this.createDoor(map, n4, n2 + 1);
                n = RPG.rspread(n3, n2);
                map.fillArea(n5, n3, n5, n, map.floor());
                map.fillArea(n5, n, n4, n, map.floor());
                map.fillArea(n4, n, n4, n2, map.floor());
            }
        }
        map.replaceTiles(0, map.wall());
    }

    private void makeRoom(Map map, int n, int n2, int n3, int n4) {
        map.fillArea(n, n2, n3, n4, map.floor());
        this.decorateRoom(map, n, n2, n3, n4);
    }

    public void decorateRoom(Map map, int n, int n2, int n3, int n4) {
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        if (n5 < 3 || n6 < 3) {
            return;
        }
        switch (RPG.d(20)) {
            case 1: {
                for (int i = 1; i < n6 - 1; i += 2) {
                    map.setTile(n + 1, n2 + i, map.wall());
                    map.setTile(n3 - 1, n2 + i, map.wall());
                }
                break;
            }
            case 2: {
                for (int i = 1; i < n6 - 1; i += 2) {
                    map.setTile(n + i, n2 + 1, map.wall());
                    map.setTile(n + i, n2 - 1, map.wall());
                }
                break;
            }
            default: {
                this.decorateArea(map, n, n2, n3, n4);
            }
        }
    }

    public void decorateArea(Map map, int n, int n2, int n3, int n4) {
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        if (n5 < 2 || n6 < 2) {
            return;
        }
        switch (RPG.d(10)) {
            case 1: {
                this.decorateArea(map, n + 1, n2 + 1, n3 - 1, n4 - 1);
                break;
            }
            case 2: {
                map.fillArea(n, n2, n3, n4, 1);
                if (n5 < 3 || n6 < 3) break;
                map.fillArea(n + 1, n2 + 1, n3 - 1, n4 - 1, 28);
                break;
            }
            case 3: {
                int n7 = RPG.rspread(n2, n4);
                this.decorateArea(map, n, n3, n2, n7);
                this.decorateArea(map, n, n3, n7 + 1, n4);
            }
            case 4: {
                int n7 = RPG.rspread(n, n3);
                this.decorateArea(map, n, n7, n2, n4);
                this.decorateArea(map, n7 + 1, n3, n2, n4);
            }
            case 5: {
                map.addThing(Lib.createType("IsScenery", map.getLevel()), n, n2, n3, n4);
            }
        }
    }
}

