/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import mikera.tyrant.BaseObject;
import mikera.tyrant.DetailedListScreen;
import mikera.tyrant.Game;
import mikera.tyrant.GameScreen;
import mikera.tyrant.Hero;
import mikera.tyrant.InfoScreen;
import mikera.tyrant.Interface;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.MessagePanel;
import mikera.tyrant.Portal;
import mikera.tyrant.Quest;
import mikera.tyrant.RPG;
import mikera.tyrant.Screen;
import mikera.tyrant.TPanel;
import mikera.tyrant.Thing;
import mikera.tyrant.TitleScreen;
import mikera.tyrant.Wish;
import mikera.tyrant.author.Designer;

public class QuestApp
extends Applet
implements Runnable {
    private static final long serialVersionUID = 3257569503247284020L;
    public static Image tiles;
    public static Image greytiles;
    public static Image scenery;
    public static Image creatures;
    public static Image items;
    public static Image effects;
    public static Image title;
    public static Image paneltexture;
    public static Hashtable images;
    public static Font mainfont;
    public static int charsize;
    public static final Color TEXTCOLOUR;
    public static final Color BACKCOLOUR;
    public static final Color PANELCOLOUR;
    public static final Color PANELHIGHLIGHT;
    public static final Color PANELSHADOW;
    public static final Color INFOSCREENCOLOUR;
    public static final Color INFOTEXTCOLOUR;
    private GameScreen screen;
    private Component mainComponent = null;
    private static QuestApp instance;
    public static boolean isapplet;
    public static String gameFileFromCommandLine;
    public static String fileEncoding;
    public KeyAdapter keyhandler = null;
    public final KeyAdapter keyadapter = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            if (QuestApp.this.keyhandler != null) {
                QuestApp.this.keyhandler.keyPressed(keyEvent);
            } else {
                Game.getUserinterface().go(keyEvent);
            }
        }
    };
    static /* synthetic */ Class class$mikera$tyrant$QuestApp;

    public Dimension getPreferredSize() {
        return new Dimension(695, 630);
    }

    public void stop() {
        super.stop();
        QuestApp.setInstance(null);
        Game.messagepanel = null;
        Game.thread = null;
    }

    public void init(Runnable runnable) {
        QuestApp.setInstance(this);
        Game.setQuestapp(this);
        super.init();
        this.setLayout(new BorderLayout());
        this.setBackground(Color.black);
        this.setFont(mainfont);
        Game.setUserinterface(new Interface());
        Game.thread = new Thread(runnable);
        Game.thread.start();
    }

    public void init() {
        this.init(this);
    }

    public Thing createHero(boolean bl) {
        Serializable serializable;
        Object object;
        long l = System.currentTimeMillis();
        String string = null;
        Object object2 = null;
        if (!bl) {
            string = "human";
            object2 = "fighter";
            Game.setDebug(true);
        }
        String[] stringArray = Hero.heroRaces();
        String[] stringArray2 = Hero.heroRaceDescriptions();
        if (string == null) {
            object = new DetailedListScreen("What race are you?", stringArray, stringArray2);
            ((Component)object).setForeground(new Color(128, 128, 128));
            ((Component)object).setBackground(new Color(0, 0, 0));
            ((DetailedListScreen)object).bottomString = "Press a letter key to select your race";
            this.switchScreen((Component)object);
            while ((string = (String)((DetailedListScreen)object).getObject()) == null && !Game.isDebug()) {
            }
        }
        if (string == null) {
            string = stringArray[RPG.r(stringArray.length)];
            object = Hero.heroProfessions(string);
            object2 = object[RPG.r(((String[])object).length)];
        }
        object = Hero.heroProfessions(string);
        String[] stringArray3 = Hero.heroProfessionDescriptions(string);
        if (object2 == null) {
            serializable = new DetailedListScreen("What is your profession?", (String[])object, stringArray3);
            ((DetailedListScreen)serializable).bottomString = "Press a letter key to select your profession";
            ((Component)serializable).setForeground(new Color(128, 128, 128));
            ((Component)serializable).setBackground(new Color(0, 0, 0));
            this.switchScreen((Component)serializable);
            while (object2 == null) {
                object2 = (String)((DetailedListScreen)serializable).getObject();
            }
        }
        serializable = Hero.createHero(bl ? null : "QuickTester", string, (String)object2);
        String string2 = "QuickTester";
        if (bl) {
            Screen screen = new Screen(this);
            screen.setBackground(new Color(0, 0, 0));
            screen.setLayout(new BorderLayout());
            TPanel tPanel = new InfoScreen(this, ((BaseObject)serializable).getString("HeroHistory"));
            tPanel.setBackground(new Color(0, 0, 0));
            screen.add("Center", tPanel);
            tPanel = new MessagePanel(this);
            Game.messagepanel = tPanel;
            screen.add("South", tPanel);
            this.switchScreen(screen);
            string2 = this.getHeroName(true);
            if (string2 == null) {
                return null;
            }
        }
        Hero.setHeroName((Thing)serializable, string2);
        System.out.println(System.currentTimeMillis() - l + "ms to createHero");
        return serializable;
    }

    public boolean isGameScreen() {
        return this.screen != null && this.mainComponent == this.screen;
    }

    public void switchScreen(Component component) {
        if (component == null) {
            return;
        }
        if (this.mainComponent == component) {
            component.repaint();
            return;
        }
        this.setVisible(false);
        this.removeAll();
        this.add(component);
        if (component instanceof GameScreen) {
            ((GameScreen)component).getMappanel().setPosition(Game.hero().getMap(), Game.hero().x, Game.hero().y);
        }
        this.invalidate();
        this.validate();
        this.setVisible(true);
        component.requestFocus();
        this.mainComponent = component;
    }

    public String getHeroName(boolean bl) {
        String string = null;
        Game.message("");
        while (string == null || string.equals("")) {
            string = Game.getLine("Enter your name: ");
            if (string.equals("ESC")) {
                return null;
            }
            if (bl || string != null && !string.equals("")) continue;
            return null;
        }
        return string;
    }

    public void run() {
        while (true) {
            Thing thing;
            Screen screen = new Screen(this);
            screen.setBackground(new Color(0, 0, 0));
            screen.setLayout(new BorderLayout());
            TPanel tPanel = new TitleScreen(this);
            tPanel.setBackground(new Color(0, 0, 0));
            screen.add("Center", tPanel);
            tPanel = new MessagePanel(this);
            Game.messagepanel = tPanel;
            screen.add("South", tPanel);
            this.switchScreen(screen);
            this.repaint();
            if (!isapplet && gameFileFromCommandLine != null) {
                Game.message("Loading " + gameFileFromCommandLine + " game file...");
                String string = Game.tryToRestore(gameFileFromCommandLine);
                if (string == null) {
                    this.setupScreen();
                    this.getScreen().mainLoop();
                    continue;
                }
                Game.message("Load game failed: " + string);
                Game.message("Press any key (except Tab) to continue");
                Game.getInput(false);
            }
            Game.message("");
            Game.message("Welcome to Tyrant. You are playing version " + Game.VERSION + ". Would you like to:");
            Game.message(" [a] Create a new character");
            Game.message(" [b] Load a previously saved game");
            Game.message(" [c] Play in debug mode");
            Game.message(" [d] QuickStart debug mode");
            Game.message(" [e] Edit a map");
            tPanel.repaint();
            Lib.asynchronousCreate();
            char c = Game.getOption("abcdeQ");
            Game.setDebug(false);
            Game.visuals = true;
            if (c == 'a') {
                Game.create();
                thing = this.createHero(true);
                if (thing == null) continue;
                InfoScreen infoScreen = new InfoScreen(this, "                                 Introduction\n\nTimes are hard for the humble adventurer. Lawlessness has ravaged the land, and few can afford to pay for your services.\n\nAfter many weeks of travel, you find yourself in the valley of North Karrain. This region has suffered less badly from the incursions of evil, and you hear that some small towns are still prosperous. Perhaps here you can find a way to make your fortune.\n\nAfter a long day of travel, you see a small inn to the west. Perhaps this would be a good place to meet some and learn some more about these strange lands.\n\n                           [ Press a key to continue ]\n\n\n\n\n\n");
                infoScreen.setForeground(new Color(192, 160, 64));
                infoScreen.setBackground(new Color(0, 0, 0));
                this.switchScreen(infoScreen);
                Game.getInput();
                this.setupScreen();
                this.gameStart();
                continue;
            }
            if (c == 'b') {
                if (!Game.restore()) continue;
                this.setupScreen();
                this.getScreen().mainLoop();
                continue;
            }
            if (c == 'c') {
                Game.create();
                thing = this.createHero(true);
                if (thing == null) continue;
                Game.setDebug(true);
                this.setupScreen();
                this.gameStart();
                continue;
            }
            if (c == 'e') {
                Game.message("");
                Game.message("Launching Designer...");
                Designer.main(new String[]{"embedded"});
                continue;
            }
            Game.create();
            Game.setDebug(true);
            this.createHero(false);
            this.setupScreen();
            this.gameStart();
        }
    }

    public void setupScreen() {
        if (this.getScreen() == null) {
            this.setScreen(new GameScreen(this));
        } else {
            Game.messagepanel = this.getScreen().messagepanel;
            Game.messagepanel.clear();
        }
        this.switchScreen(this.getScreen());
    }

    private void gameStart(Map map, int n, int n2) {
        Game.enterMap(map, n, n2);
        this.getScreen().mainLoop();
    }

    public void gameStart() {
        Game.setQuestapp(this);
        Thing thing = Game.hero();
        if (thing == null) {
            throw new Error("Hero not created");
        }
        Game.instance().initialize(thing);
        Map map = Game.instance().createWorld();
        Quest.addQuest(thing, Quest.createVisitMapQuest("Vist a town", "town"));
        Thing thing2 = map.find("tutorial inn");
        Map map2 = Portal.getTargetMap(thing2);
        this.gameStart(map2, map2.getEntrance().x, map2.getEntrance().y);
    }

    private String getDeathString(Thing thing) {
        if (thing.getStat("HPS") <= 0) {
            Thing thing2 = thing.getThing("Killer");
            if (thing2 == null) {
                return "Killed by divine power";
            }
            thing2.remove();
            String string = thing2.getAName();
            if (thing2.getFlag("IsEffect")) {
                string = thing2.name();
            }
            if (string.equals("you")) {
                string = "stupidity";
            }
            return "Killed by " + string;
        }
        return "Defeated The Tyrant";
    }

    public void gameOver() {
        String string;
        Wish.makeWish("identification", 100);
        Game.message("");
        Thing thing = Game.hero();
        String string2 = this.getDeathString(thing);
        String string3 = null;
        this.getScreen().getMappanel().repaint();
        String string4 = "No high score available in debug mode";
        int n = thing.getStat("Score");
        String string5 = Integer.toString(n);
        String string6 = Integer.toString(thing.getLevel());
        String string7 = Integer.toString(thing.getStat("Seed"));
        String string8 = thing.getString("HeroName");
        String string9 = thing.getString("Profession");
        String string10 = thing.getString("Race");
        try {
            String string11 = URLEncoder.encode(string2, fileEncoding);
            string = URLEncoder.encode(string8, fileEncoding);
            String string12 = Integer.toString(n + string8.length() * string9.length() * string10.length() ^ 0xBC614E);
            String string13 = "&name=" + string + "&race=" + string10 + "&profession=" + string9 + "&level=" + string6 + "&score=" + string5 + "&check=" + string12 + "&version=" + Game.VERSION + "&seed=" + string7 + "&death=" + string11;
            String string14 = "http://tyrant.sourceforge.net/logscore.php?client=tyrant" + string13;
            Game.warn((Game.isDebug() ? "NOT " : "") + "Sending data:");
            Game.warn(string13);
            if (!Game.isDebug()) {
                URL uRL = new URL(string14);
                InputStream inputStream = uRL.openStream();
                String string15 = "";
                int n2 = inputStream.read();
                while (n2 >= 0) {
                    string15 = string15 + (char)n2;
                    n2 = inputStream.read();
                }
                int n3 = string15.indexOf("OK:");
                if (n3 >= 0) {
                    string4 = "High score logged.\n";
                    string4 = string4 + "You are in position " + string15.substring(n3 + 3).trim();
                } else {
                    string4 = "Failed to log high score";
                    Game.warn(string15);
                }
            }
        }
        catch (Exception exception) {
            Game.warn(exception.getMessage());
            string4 = "High score feature not available";
        }
        if (!thing.isDead()) {
            string3 = "You have defeated The Tyrant!\n\nHaving saved the world from such malevolent evil, you are crowned as the new Emperor of Daedor, greatly beloved by all the people of the Earth.\n\nYou rule an Empire of peace and prosperity, and enjoy a long and happy life.\n\nHurrah for Emperor " + thing.getString("HeroName") + "!!\n";
            if (Game.isDebug()) {
                string3 = "You have defeated The Tyrant in Debug Mode.\n\nNow go and do it the hard way....\n";
            }
        } else {
            string3 = "\nIt's all over...... " + string2 + "\n" + "\n" + "You have failed in your adventures and died a hideous death.\n" + "\n" + "You reached level " + string6 + "\n" + "Your score is " + string5 + "\n" + "\n" + string4 + "\n";
        }
        Game.message("GAME OVER - " + string2);
        Game.message("Would you like to see your final posessions? (y/n)");
        char c = Game.getOption("yn");
        if (c == 'y') {
            Game.selectItem("Your final posessions:", thing);
        }
        Game.scrollTextScreen(string3);
        string = Hero.reportKillData();
        Game.scrollTextScreen(string);
        Game.over = true;
        Lib.clear();
        Lib.asynchronousCreate();
    }

    public void destroy() {
        this.removeAll();
    }

    public static Image getImage(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = null;
        try {
            URL uRL = (class$mikera$tyrant$QuestApp == null ? (class$mikera$tyrant$QuestApp = QuestApp.class$("mikera.tyrant.QuestApp")) : class$mikera$tyrant$QuestApp).getResource(string);
            if (uRL != null) {
                image = toolkit.getImage(uRL);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return image;
    }

    public void setScreen(GameScreen gameScreen) {
        this.screen = gameScreen;
    }

    public GameScreen getScreen() {
        return this.screen;
    }

    public static void setInstance(QuestApp questApp) {
        instance = questApp;
    }

    public static QuestApp getInstance() {
        if (instance == null) {
            instance = new QuestApp();
        }
        return instance;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        images = new Hashtable();
        mainfont = new Font("Monospaced", 0, 12);
        TEXTCOLOUR = new Color(192, 192, 192);
        BACKCOLOUR = new Color(0, 0, 0);
        PANELCOLOUR = new Color(64, 64, 64);
        PANELHIGHLIGHT = new Color(120, 80, 20);
        PANELSHADOW = new Color(40, 20, 5);
        INFOSCREENCOLOUR = new Color(0, 0, 0);
        INFOTEXTCOLOUR = new Color(240, 200, 160);
        isapplet = true;
        fileEncoding = System.getProperty("file.encoding");
        Applet applet = new Applet();
        tiles = QuestApp.getImage("/images/tiles32.png");
        scenery = QuestApp.getImage("/images/scenery32.png");
        creatures = QuestApp.getImage("/images/creature32.png");
        items = QuestApp.getImage("/images/items32.png");
        effects = QuestApp.getImage("/images/effects32.png");
        title = QuestApp.getImage("/images/title.png");
        paneltexture = QuestApp.getImage("/images/texture3.png");
        images.put("Tiles", tiles);
        images.put("Scenery", scenery);
        images.put("Creatures", creatures);
        images.put("Items", items);
        images.put("Effects", effects);
        MediaTracker mediaTracker = new MediaTracker(applet);
        mediaTracker.addImage(tiles, 1);
        mediaTracker.addImage(scenery, 1);
        mediaTracker.addImage(creatures, 1);
        mediaTracker.addImage(items, 1);
        mediaTracker.addImage(effects, 1);
        mediaTracker.addImage(title, 1);
        mediaTracker.addImage(paneltexture, 1);
        GreyFilter greyFilter = new GreyFilter();
        greytiles = applet.createImage(new FilteredImageSource(tiles.getSource(), greyFilter));
        try {
            mediaTracker.waitForID(1);
        }
        catch (Exception exception) {
            System.out.println("Error loading images.");
            exception.printStackTrace();
        }
    }

    static class GreyFilter
    extends RGBImageFilter {
        public GreyFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            return n3 & 0xFF000000 | 65793 * (((n3 & 0xFF0000) >> 18) + ((n3 & 0xFF00) >> 10) + ((n3 & 0xFF) >> 2));
        }
    }
}

