/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Damage;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Modifier;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Scripts;
import mikera.tyrant.Thing;

public class Poison {
    public Thing create(int n) {
        Thing thing = Lib.create("poison");
        thing.set("Damage", n);
        return thing;
    }

    public static void init() {
        Thing thing = Lib.extend("base poison", "temporary effect");
        thing.set("IsActive", 1);
        thing.addHandler("OnAction", new PoisonAction());
        thing.set("IsPoison", 1);
        thing.set("DamageType", "poison");
        thing.set("EffectName", "poisoned");
        thing.set("ResistStat", "TG");
        thing.set("ResistMessage", null);
        thing.set("ResistDifficulty", 10);
        thing.set("CureDifficulty", 5);
        Lib.add(thing);
        thing = Lib.extend("weakening poison", "base poison");
        thing.set("LifeTime", 50000);
        thing.set("EffectName", "poisoned");
        thing.set("Strength", 100);
        thing.set("Damage", 2);
        thing.set("DamageType", "poison");
        thing.set("DamageMessage", "You feel sick...");
        thing.set("ResistMessage", "You manage to shake off a feeling of weakness");
        thing.set("AttributeAddMessage", "You feel weakened!");
        thing.add("CarriedModifiers", Modifier.linear("ST", 90, 0));
        Lib.add(thing);
        thing = Lib.extend("poison", "base poison");
        thing.set("LifeTime", 20000);
        thing.set("Strength", 200);
        thing.set("Damage", 3);
        thing.set("DamageType", "poison");
        thing.set("ResistMessage", "You feel queasy for a moment");
        thing.set("DamageMessage", "You feel the effects of poison...");
        thing.set("AttributeAddMessage", "You feel poisoned!");
        Lib.add(thing);
        thing = Lib.extend("strong poison", "base poison");
        thing.set("LifeTime", 30000);
        thing.set("Strength", 300);
        thing.set("Damage", 6);
        thing.set("DamageType", "poison");
        thing.set("ResistMessage", "You feel very queasy for a moment");
        thing.set("DamageMessage", "You feel the poison weakening you...");
        thing.set("AttributeAddMessage", "You feel badly poisoned!");
        thing.set("CureDifficulty", 15);
        Lib.add(thing);
        thing = Lib.extend("deadly poison", "base poison");
        thing.set("LifeTime", 40000);
        thing.set("Strength", 2000);
        thing.set("Damage", 10);
        thing.set("DamageType", "poison");
        thing.set("ResistMessage", "You feel very queasy for a moment");
        thing.set("DamageMessage", "You feel the poison weakening you...");
        thing.set("AttributeAddMessage", "You feel badly poisoned!");
        thing.set("CureDifficulty", 40);
        Lib.add(thing);
        thing = Lib.extend("extreme poison", "base poison");
        thing.set("LifeTime", 50000);
        thing.set("Strength", 6000);
        thing.set("Damage", 15);
        thing.set("DamageType", "poison");
        thing.set("ResistMessage", "You feel very queasy for a moment");
        thing.set("DamageMessage", "You feel the poison weakening you...");
        thing.set("AttributeAddMessage", "You feel badly poisoned!");
        thing.set("CureDifficulty", 100);
        Lib.add(thing);
        thing = Lib.extend("ultimate poison", "base poison");
        thing.set("LifeTime", 100000);
        thing.set("Strength", 12000);
        thing.set("Damage", 30);
        thing.set("DamageType", "poison");
        thing.set("ResistMessage", "You feel very queasy for a moment");
        thing.set("DamageMessage", "You feel the poison weakening you...");
        thing.set("AttributeAddMessage", "You feel badly poisoned!");
        thing.set("CureDifficulty", 300);
        Lib.add(thing);
        thing = Lib.extend("sickness", "base poison");
        thing.set("LifeTime", 50000);
        thing.set("Strength", 100);
        thing.set("Damage", 2);
        thing.set("DamageType", "poison");
        thing.set("DamageMessage", "You feel sick...");
        thing.set("ResistMessage", "You manage to shake off a feeling of illness");
        thing.set("AttributeAddMessage", "You feel sick!");
        thing.add("CarriedModifiers", Modifier.bonus("ST", -2));
        thing.add("CarriedModifiers", Modifier.bonus("SK", -2));
        thing.set("CureDifficulty", 15);
        Lib.add(thing);
        thing = Lib.extend("pestilence", "poison");
        thing.set("LifeTime", 120000);
        thing.set("Strength", 200);
        thing.set("Damage", 4);
        thing.set("EffectName", "pestilent");
        thing.set("DamageType", "poison");
        thing.set("DamageMessage", "You feel grotty...");
        thing.set("AttributeAddMessage", "You feel the touch of pestilence!");
        thing.set("ResistDifficulty", 20);
        thing.addHandler("OnAction", Scripts.generator("fly swarm", 100));
        thing.set("CureDifficulty", 25);
        Lib.add(thing);
        thing = Lib.extend("plague", "poison");
        thing.set("LifeTime", 100000);
        thing.set("Strength", 200);
        thing.set("Damage", 8);
        thing.set("EffectName", "plague");
        thing.set("DamageType", "poison");
        thing.set("DamageMessage", "You feel sick...");
        thing.set("AttributeAddMessage", "You feel the touch of the plague!");
        thing.set("ResistDifficulty", 20);
        thing.add("CarriedModifiers", Modifier.linear("CH", 100, -10));
        thing.addHandler("OnAction", Scripts.generator("plague cloud", 30));
        thing.set("CureDifficulty", 100);
        Lib.add(thing);
    }

    public static void cure(Thing thing, int n) {
        Thing[] thingArray = thing.getFlaggedContents("IsPoison");
        boolean bl = false;
        for (int i = 0; i < thingArray.length; ++i) {
            Thing thing2 = thingArray[i];
            Game.warn("Poison.cure(): " + n);
            if (!RPG.test(n, thingArray.length * thing2.getStat("CureDifficulty"))) continue;
            thing2.remove();
            bl = true;
        }
        if (bl) {
            thing.message("You feel refreshed");
        }
    }

    public static class PoisonAction
    extends Script {
        private static final long serialVersionUID = 3258410638316287027L;

        public boolean handle(Thing thing, Event event) {
            int n = event.getStat("Time");
            Game.actor = thing;
            Thing thing2 = thing.holder();
            int n2 = 0;
            int n3 = RPG.po(n * thing.getStat("Strength"), 1000000);
            for (int i = 0; i < n3; ++i) {
                n2 += Damage.inflict(thing2, thing.getStat("Damage"), thing.getString("DamageType"));
            }
            if (n2 > 0) {
                thing2.message(thing.getString("DamageMessage"));
            }
            return false;
        }
    }
}

